/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.invoicepool.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizOutTicketEntryCollection;
import com.kingdee.eas.cp.bc.BizOutTicketEntryFactory;
import com.kingdee.eas.cp.bc.BizOutTicketEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizOutTicketEntry;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IPurTicketEntry;
import com.kingdee.eas.cp.bc.ITicketEntry;
import com.kingdee.eas.cp.bc.ITraTicketEntry;
import com.kingdee.eas.cp.bc.InvoiceException;
import com.kingdee.eas.cp.bc.PurTicketEntryCollection;
import com.kingdee.eas.cp.bc.PurTicketEntryFactory;
import com.kingdee.eas.cp.bc.PurTicketEntryInfo;
import com.kingdee.eas.cp.bc.TicketBaseEntryInfo;
import com.kingdee.eas.cp.bc.TicketEntryCollection;
import com.kingdee.eas.cp.bc.TicketEntryFactory;
import com.kingdee.eas.cp.bc.TicketEntryInfo;
import com.kingdee.eas.cp.bc.TraTicketEntryCollection;
import com.kingdee.eas.cp.bc.TraTicketEntryFactory;
import com.kingdee.eas.cp.bc.TraTicketEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.util.InvoiceConfiguration;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceBizParams;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolService;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizInvoicePoolUtil {
    private static Logger logger = Logger.getLogger(BizInvoicePoolUtil.class);
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";

    public static void submitDownLoadInvoice(Context ctx, BizCollBillBaseInfo info, Map paramMap) throws BOSException, EASBizException {
        boolean isApplierCompany;
        CreateInvoiceParams createInvoiceParams = new CreateInvoiceParams();
        ArrayList entryInfoList = new ArrayList();
        String companyId = null;
        boolean bl = isApplierCompany = paramMap != null && paramMap.get("CP03905") != null ? (Boolean)paramMap.get("CP03905") : true;
        if (isApplierCompany) {
            companyId = info.getApplierCompany().getId().toString();
        } else {
            if (BizCollUtil.objectIsNull(info.getCompany())) {
                throw new InvoiceException(InvoiceException.CONPANYANDAPPLIERISNOTNULL);
            }
            companyId = info.getCompany().getId().toString();
        }
        AbstractObjectCollection ticketEntries = (AbstractObjectCollection)info.get("tickeEntries");
        if (ticketEntries.size() == 0) {
            return;
        }
        if (info instanceof BizAccountBillInfo) {
            createInvoiceParams.setBizBillTypeID(PoolConstant.TYPEID_BIZACCOUNT);
        } else if (info instanceof TravelAccountBillInfo) {
            createInvoiceParams.setBizBillTypeID(PoolConstant.TYPEID_TRAVELACCOUNT);
        } else if (info instanceof BizAccountOutBillInfo) {
            createInvoiceParams.setBizBillTypeID(PoolConstant.TYPEID_BIZACCOUNTOUT);
        } else if (info instanceof DailyPurchaseAccountBillInfo) {
            createInvoiceParams.setBizBillTypeID(PoolConstant.TYPEID_DAILYPURCHASEACCOUNT);
        }
        int l = ticketEntries.size();
        for (int i = 0; i < l; ++i) {
            HashMap<String, String> map = new HashMap<String, String>(10);
            TicketBaseEntryInfo ticketEntryinfo = (TicketBaseEntryInfo)ticketEntries.getObject(i);
            map.put("entryID", ticketEntryinfo.getId().toString());
            map.put("serialNo", ticketEntryinfo.getSerialNo());
            map.put("companyID", companyId);
            entryInfoList.add(i, map);
        }
        logger.error((Object)("#####submitDownloadInvoice EntryInfoList is " + ((Object)entryInfoList).toString()));
        createInvoiceParams.setEntryInfoList(entryInfoList);
        Map<String, String> clientMap = InvoiceUtil.getClientIdAndSecretAndRegisteredCode(ctx, info);
        createInvoiceParams.setClientId(clientMap.get(CLIENT_ID));
        createInvoiceParams.setClientSecret(clientMap.get(CLIENT_SECRET));
        InvoiceConfiguration invoice = InvoiceConfiguration.getInstance();
        if (!invoice.isInitialize()) {
            invoice.init();
        }
        createInvoiceParams.setPiaozoneUrl(invoice.getInvoiceUrl());
        createInvoiceParams.setBillNumber(info.getNumber());
        createInvoiceParams.setBizBillID(info.getId().toString());
        InvoicePoolService invoicePoolService = new InvoicePoolService();
        logger.error((Object)("##################cpbc runner submitDownLoadInvoice invoicePoolParams = " + createInvoiceParams.toString()));
        InvoicePoolService.downLoadInvoice((Context)ctx, (CreateInvoiceParams)createInvoiceParams);
    }

    @Deprecated
    public static void submitDownLoadInvoice(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        BizInvoicePoolUtil.submitDownLoadInvoice(ctx, info, null);
    }

    public static void setPassAddIncomeInvoice(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
        invoiceBizParams.setBizBillID(billId.toString());
        logger.error((Object)("##################cpbc runner setPassAddIncomeInvoice invoicePoolParams billId  = " + billId.toString()));
        InvoicePoolService.updateInvoiceInfo((Context)ctx, BizInvoicePoolUtil.getBizParamsLists(ctx, billId, ""));
    }

    public static void updateVoucherInfo(Context ctx, BOSUuid billId, String voucherIds, BizCollBillBaseInfo billInfo, IObjectCollection con, String operation) throws BOSException, EASBizException {
        if (!BizCollUtil.objectIsNull(billInfo) && !BizCollUtil.objectIsNull(billInfo.getApplierCompany()) && BizInvoicePoolUtil.getCpbcParams(ctx, billInfo.getApplierCompany()) && billInfo instanceof ExpenseAccountBillInfo) {
            logger.error((Object)("##################cpbc runner updateVoucherInfo invoicePoolParams billId  = " + billId.toString()));
            logger.error((Object)("##################cpbc runner updateVoucherInfo invoicePoolParams voucherIds  = " + voucherIds));
            InvoicePoolService.updateVoucherInfo((Context)ctx, (String)billId.toString(), (IObjectCollection)con, (String)operation);
        }
    }

    public static boolean getCpbcParams(Context ctx, CompanyOrgUnitInfo applierCompany) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(applierCompany)) {
            return false;
        }
        boolean isTicketinVoice = false;
        boolean isTm = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        paramList.add("CP070");
        IExpenseCommenFacade iExpenseCommenFacade = null;
        iExpenseCommenFacade = BizCollUtil.objectIsNull(ctx) ? ExpenseCommenFacadeFactory.getRemoteInstance() : ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompany.getId().toString());
        isTicketinVoice = new Boolean(paramMap.get("CP039").toString());
        isTm = new Boolean(paramMap.get("CP070").toString());
        return isTicketinVoice && isTm;
    }

    public static boolean getCpbcParams(Context ctx, String id) throws BOSException, EASBizException {
        IExpenseAccountBill iservice = null;
        BOSObjectType bosType = BizCollUtil.getBOSType(id);
        BizCollBillBaseInfo info = null;
        if (bosType.equals((Object)BizCollUtil.bizAccountBillBosType)) {
            info = new BizAccountBillInfo();
            iservice = ctx == null ? BizAccountBillFactory.getRemoteInstance() : BizAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.travelAccountBillBosType)) {
            info = new TravelAccountBillInfo();
            iservice = ctx == null ? TravelAccountBillFactory.getRemoteInstance() : TravelAccountBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.bizAccountOutBillBosType)) {
            info = new BizAccountOutBillInfo();
            iservice = ctx == null ? BizAccountOutBillFactory.getRemoteInstance() : BizAccountOutBillFactory.getLocalInstance(ctx);
        } else if (bosType.equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) {
            info = new DailyPurchaseAccountBillInfo();
            iservice = ctx == null ? DailyPurchaseAccountBillFactory.getRemoteInstance() : DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
        } else {
            return false;
        }
        info = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(id), InvoiceUtil.getBillSic());
        return BizInvoicePoolUtil.getTicketinVoice(ctx, info);
    }

    public static boolean getTicketinVoice(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        boolean isTicketInoice = false;
        boolean isTm = false;
        if (!(info instanceof ExpenseAccountBillInfo)) {
            return false;
        }
        if (info.getCU() == null) {
            if (info.getApplierCompany() != null && info.getApplierCompany().getCU() != null) {
                info.setCU(info.getApplierCompany().getCU());
            } else {
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP039");
        paramList.add("CP070");
        Map paramMap = new HashMap();
        if (ctx != null) {
            paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, info.getApplierCompany().getId().toString());
            isTicketInoice = new Boolean(paramMap.get("CP039").toString());
            isTm = new Boolean(paramMap.get("CP070").toString());
        } else {
            paramMap = ExpenseCommenFacadeFactory.getRemoteInstance().getParamsForCompany(paramList, info.getApplierCompany().getId().toString());
            isTicketInoice = new Boolean(paramMap.get("CP039").toString());
            isTm = new Boolean(paramMap.get("CP070").toString());
        }
        return isTicketInoice && isTm;
    }

    public static List<InvoiceBizParams> getBizParamsLists(Context ctx, BOSUuid billId, String voucherIds) throws BOSException {
        ArrayList<InvoiceBizParams> bizParamsList;
        block17: {
            EntityViewInfo view;
            block19: {
                block18: {
                    block16: {
                        view = new EntityViewInfo();
                        view.getSelector().add(new SelectorItemInfo("id"));
                        view.getSelector().add(new SelectorItemInfo("billID.id"));
                        view.getSelector().add(new SelectorItemInfo("billID.name"));
                        view.getSelector().add(new SelectorItemInfo("billID.number"));
                        view.getSelector().add(new SelectorItemInfo("ticketNumber"));
                        view.getSelector().add(new SelectorItemInfo("ticketCode"));
                        view.getSelector().add(new SelectorItemInfo("amout"));
                        view.getSelector().add(new SelectorItemInfo("taxtax"));
                        view.getSelector().add(new SelectorItemInfo("taxRate"));
                        view.getSelector().add(new SelectorItemInfo("taxClassNumber"));
                        view.getSelector().add(new SelectorItemInfo("serialNo"));
                        view.getSelector().add(new SelectorItemInfo("deductionTax"));
                        view.getSelector().add(new SelectorItemInfo("isDeduction"));
                        view.getSelector().add(new SelectorItemInfo("transferTax"));
                        view.getSelector().add(new SelectorItemInfo("transferCause"));
                        view.getSelector().add(new SelectorItemInfo("receiptsType"));
                        view.getSelector().add(new SelectorItemInfo("receiptsTypeStr"));
                        view.getSelector().add(new SelectorItemInfo("transferCauseStr"));
                        view.getSelector().add(new SelectorItemInfo("ticketTypeId.id"));
                        view.getSelector().add(new SelectorItemInfo("ticketTypeId.name"));
                        view.getSelector().add(new SelectorItemInfo("ticketTypeId.number"));
                        FilterInfo filter = new FilterInfo();
                        FilterItemInfo filterItem = new FilterItemInfo("bill", (Object)billId.toString(), CompareType.EQUALS);
                        filter.getFilterItems().add(filterItem);
                        view.setFilter(filter);
                        bizParamsList = new ArrayList<InvoiceBizParams>();
                        if (BizCollUtil.objectIsNull(billId) || !billId.getType().equals((Object)BizCollUtil.bizAccountBillBosType)) break block16;
                        ITicketEntry iTicketEntry = null;
                        iTicketEntry = BizCollUtil.objectIsNull(ctx) ? TicketEntryFactory.getRemoteInstance() : TicketEntryFactory.getLocalInstance(ctx);
                        TicketEntryCollection ticketEntries = iTicketEntry.getTicketEntryCollection(view);
                        int m = ticketEntries.size();
                        for (int i = 0; i < m; ++i) {
                            TicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                            InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                            invoiceBizParams.setBizBillID(billId.toString());
                            invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                            invoiceBizParams.setVoucherID(voucherIds);
                            if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                                invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                            }
                            invoiceBizParams.setSerialNo(ticketEntryInfo.getSerialNo());
                            invoiceBizParams.setIsDeduct(BizInvoicePoolUtil.adapterInvoiceBizParam(ticketEntryInfo.isIsDeduction()));
                            invoiceBizParams.setDeductTaxAmt(ticketEntryInfo.getDeductionTax());
                            invoiceBizParams.setTransferAmount(ticketEntryInfo.getTransferTax());
                            if (null != ticketEntryInfo && null != ticketEntryInfo.getReceiptsType()) {
                                invoiceBizParams.setIncomeTypeID(ticketEntryInfo.getReceiptsType().toString());
                            }
                            if (null != ticketEntryInfo && null != ticketEntryInfo.getTransferCause()) {
                                invoiceBizParams.setTransferItemID(ticketEntryInfo.getTransferCause().toString());
                            }
                            bizParamsList.add(invoiceBizParams);
                        }
                        break block17;
                    }
                    if (BizCollUtil.objectIsNull(billId) || !billId.getType().equals((Object)BizCollUtil.bizAccountOutBillBosType)) break block18;
                    IBizOutTicketEntry iTicketEntry = null;
                    iTicketEntry = BizCollUtil.objectIsNull(ctx) ? BizOutTicketEntryFactory.getRemoteInstance() : BizOutTicketEntryFactory.getLocalInstance(ctx);
                    BizOutTicketEntryCollection ticketEntries = iTicketEntry.getBizOutTicketEntryCollection(view);
                    int m = ticketEntries.size();
                    for (int i = 0; i < m; ++i) {
                        BizOutTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                        InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                        invoiceBizParams.setBizBillID(billId.toString());
                        invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                        invoiceBizParams.setVoucherID(voucherIds);
                        if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                            invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                        }
                        invoiceBizParams.setSerialNo(ticketEntryInfo.getSerialNo());
                        invoiceBizParams.setIsDeduct(BizInvoicePoolUtil.adapterInvoiceBizParam(ticketEntryInfo.isIsDeduction()));
                        invoiceBizParams.setDeductTaxAmt(ticketEntryInfo.getDeductionTax());
                        invoiceBizParams.setTransferAmount(ticketEntryInfo.getTransferTax());
                        if (null != ticketEntryInfo && null != ticketEntryInfo.getReceiptsType()) {
                            invoiceBizParams.setIncomeTypeID(ticketEntryInfo.getReceiptsType().toString());
                        }
                        if (null != ticketEntryInfo && null != ticketEntryInfo.getTransferCause()) {
                            invoiceBizParams.setTransferItemID(ticketEntryInfo.getTransferCause().toString());
                        }
                        bizParamsList.add(invoiceBizParams);
                    }
                    break block17;
                }
                if (BizCollUtil.objectIsNull(billId) || !billId.getType().equals((Object)BizCollUtil.travelAccountBillBosType)) break block19;
                ITraTicketEntry iTicketEntry = null;
                iTicketEntry = BizCollUtil.objectIsNull(ctx) ? TraTicketEntryFactory.getRemoteInstance() : TraTicketEntryFactory.getLocalInstance(ctx);
                TraTicketEntryCollection ticketEntries = iTicketEntry.getTraTicketEntryCollection(view);
                int m = ticketEntries.size();
                for (int i = 0; i < m; ++i) {
                    TraTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                    InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                    invoiceBizParams.setBizBillID(billId.toString());
                    invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                    invoiceBizParams.setVoucherID(voucherIds);
                    if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                        invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                    }
                    invoiceBizParams.setSerialNo(ticketEntryInfo.getSerialNo());
                    invoiceBizParams.setIsDeduct(BizInvoicePoolUtil.adapterInvoiceBizParam(ticketEntryInfo.isIsDeduction()));
                    invoiceBizParams.setDeductTaxAmt(ticketEntryInfo.getDeductionTax());
                    invoiceBizParams.setTransferAmount(ticketEntryInfo.getTransferTax());
                    if (null != ticketEntryInfo && null != ticketEntryInfo.getReceiptsType()) {
                        invoiceBizParams.setIncomeTypeID(ticketEntryInfo.getReceiptsType().toString());
                    }
                    if (null != ticketEntryInfo && null != ticketEntryInfo.getTransferCause()) {
                        invoiceBizParams.setTransferItemID(ticketEntryInfo.getTransferCause().toString());
                    }
                    bizParamsList.add(invoiceBizParams);
                }
                break block17;
            }
            if (BizCollUtil.objectIsNull(billId) || !billId.getType().equals((Object)BizCollUtil.dailyPurchaseAccountBillBosType)) break block17;
            IPurTicketEntry iTicketEntry = null;
            iTicketEntry = BizCollUtil.objectIsNull(ctx) ? PurTicketEntryFactory.getRemoteInstance() : PurTicketEntryFactory.getLocalInstance(ctx);
            PurTicketEntryCollection ticketEntries = iTicketEntry.getPurTicketEntryCollection(view);
            int m = ticketEntries.size();
            for (int i = 0; i < m; ++i) {
                PurTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                invoiceBizParams.setBizBillID(billId.toString());
                invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                invoiceBizParams.setVoucherID(voucherIds);
                if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                    invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                }
                invoiceBizParams.setSerialNo(ticketEntryInfo.getSerialNo());
                invoiceBizParams.setIsDeduct(BizInvoicePoolUtil.adapterInvoiceBizParam(ticketEntryInfo.isIsDeduction()));
                invoiceBizParams.setDeductTaxAmt(ticketEntryInfo.getDeductionTax());
                invoiceBizParams.setTransferAmount(ticketEntryInfo.getTransferTax());
                if (null != ticketEntryInfo && null != ticketEntryInfo.getReceiptsType()) {
                    invoiceBizParams.setIncomeTypeID(ticketEntryInfo.getReceiptsType().toString());
                }
                if (null != ticketEntryInfo && null != ticketEntryInfo.getTransferCause()) {
                    invoiceBizParams.setTransferItemID(ticketEntryInfo.getTransferCause().toString());
                }
                bizParamsList.add(invoiceBizParams);
            }
        }
        return bizParamsList;
    }

    public static void deleteInvoicePool(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(billId)) {
            return;
        }
        InvoicePoolService invoicePoolService = new InvoicePoolService();
        logger.error((Object)("##################cpbc runner deleteInvoicePool invoicePoolParams billId  = " + billId.toString()));
        InvoicePoolService.deleteInvoicePool((Context)ctx, (String)billId.toString());
    }

    public static String adapterInvoiceBizParam(boolean isDeduction) {
        String deduction = "0";
        if (isDeduction) {
            deduction = "1";
        }
        return deduction;
    }

    public static void updateIspayment(Context ctx, BizCollBillBaseInfo info, Boolean isPayment) throws BOSException {
        if (BizCollUtil.objectIsNull(info.getId())) {
            return;
        }
        String billId = info.getId().toString();
        ArrayList<InvoiceBizParams> bizParamsList = new ArrayList<InvoiceBizParams>();
        if (info instanceof BizAccountBillInfo) {
            BizAccountBillInfo bizAccountBillInfo = (BizAccountBillInfo)info;
            TicketEntryCollection ticketEntries = bizAccountBillInfo.getTickeEntries();
            int m = ticketEntries.size();
            for (int i = 0; i < m; ++i) {
                TicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                invoiceBizParams.setBizBillID(billId);
                if (isPayment.booleanValue()) {
                    invoiceBizParams.setIsPayment("1");
                } else {
                    invoiceBizParams.setIsPayment("0");
                }
                if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                    invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                }
                invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                bizParamsList.add(invoiceBizParams);
            }
        } else if (info instanceof TravelAccountBillInfo) {
            TravelAccountBillInfo travelAccountBillInfo = (TravelAccountBillInfo)info;
            TraTicketEntryCollection ticketEntries = travelAccountBillInfo.getTickeEntries();
            int m = ticketEntries.size();
            for (int i = 0; i < m; ++i) {
                TraTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                invoiceBizParams.setBizBillID(billId);
                if (isPayment.booleanValue()) {
                    invoiceBizParams.setIsPayment("1");
                } else {
                    invoiceBizParams.setIsPayment("0");
                }
                if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                    invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                }
                invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                bizParamsList.add(invoiceBizParams);
            }
        } else if (info instanceof BizAccountOutBillInfo) {
            BizAccountOutBillInfo bizAccountOutBillInfo = (BizAccountOutBillInfo)info;
            BizOutTicketEntryCollection ticketEntries = bizAccountOutBillInfo.getTickeEntries();
            int m = ticketEntries.size();
            for (int i = 0; i < m; ++i) {
                BizOutTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                invoiceBizParams.setBizBillID(billId);
                if (isPayment.booleanValue()) {
                    invoiceBizParams.setIsPayment("1");
                } else {
                    invoiceBizParams.setIsPayment("0");
                }
                if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                    invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                }
                invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                bizParamsList.add(invoiceBizParams);
            }
        } else if (info instanceof DailyPurchaseAccountBillInfo) {
            DailyPurchaseAccountBillInfo dailyPurchaseAccountBillInfo = (DailyPurchaseAccountBillInfo)info;
            PurTicketEntryCollection ticketEntries = dailyPurchaseAccountBillInfo.getTickeEntries();
            int m = ticketEntries.size();
            for (int i = 0; i < m; ++i) {
                PurTicketEntryInfo ticketEntryInfo = ticketEntries.get(i);
                InvoiceBizParams invoiceBizParams = new InvoiceBizParams();
                invoiceBizParams.setBizBillID(billId);
                if (isPayment.booleanValue()) {
                    invoiceBizParams.setIsPayment("1");
                } else {
                    invoiceBizParams.setIsPayment("0");
                }
                if (!BizCollUtil.objectIsNull(ticketEntryInfo.getTicketTypeId())) {
                    invoiceBizParams.setType(ticketEntryInfo.getTicketTypeId().getNumber());
                }
                invoiceBizParams.setEntryID(ticketEntryInfo.getId().toString());
                bizParamsList.add(invoiceBizParams);
            }
        }
        InvoicePoolService.updateInvoiceInfo((Context)ctx, bizParamsList);
    }
}

