/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.openApi;

import com.kingdee.eas.cp.bc.app.openApi.IImporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ImporterHolder {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.openApi.ImporterHolder");
    private Map<String, Class<? extends IImporter>> map;
    private static String path = "com/kingdee/eas/cp/bc/app/cpbcImporterConfig.properties";

    public static ImporterHolder getInstance() {
        return Inner.instance;
    }

    public ImporterHolder() {
        Properties properties = null;
        try {
            properties = this.getProperties();
        }
        catch (IOException e1) {
            logger.error((Object)"cp.bc openapi-error can't load cpbcImporterConfig.properties ");
        }
        if (properties == null) {
            return;
        }
        this.map = new HashMap<String, Class<? extends IImporter>>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Class<?> clazz;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                clazz = Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("cp.bc openapi-error  class not found key=" + key + "   className=" + value));
                clazz = null;
            }
            this.map.put(key, clazz);
        }
    }

    public Class<? extends IImporter> getClassByBosType(String billtype) {
        return this.map.get(billtype);
    }

    public Map<String, Class<? extends IImporter>> getClassCollection() {
        return this.map;
    }

    public Properties getProperties() throws IOException {
        Properties properties = new Properties();
        try (InputStream in = null;){
            in = this.getClass().getClassLoader().getResourceAsStream(path);
            properties.load(in);
        }
        return properties;
    }

    private static class Inner {
        private static final ImporterHolder instance = new ImporterHolder();

        private Inner() {
        }
    }
}

