/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.openApi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.cp.bc.app.openApi.BillResultInfo;
import com.kingdee.eas.cp.bc.app.openApi.DataInfoCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IDataBase;
import java.util.Enumeration;

public class OpenApiUtil {
    public static void buildInfoByNumber(Context ctx, CoreBaseInfo info, BillResultInfo result) throws BOSException {
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = info.get(key);
            if (obj != null && obj instanceof DataBaseInfo) {
                OpenApiUtil.setDataBaseInfo(ctx, info, result, key, obj);
                continue;
            }
            if (obj != null && obj instanceof CoreBillBaseInfo) {
                OpenApiUtil.setCoreBillInfo(ctx, info, result, key, obj);
                continue;
            }
            if (obj != null && obj instanceof UserInfo) {
                OpenApiUtil.setUserInfo(ctx, info, result, key, obj);
                continue;
            }
            if (obj == null || !(obj instanceof IObjectCollection)) continue;
            OpenApiUtil.setCollection(ctx, result, obj);
        }
    }

    public static void setMaterial(Context ctx, CoreBaseInfo info, BillResultInfo result, String key, Object obj) throws BOSException {
        MaterialInfo lInfo = (MaterialInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(" id"));
        sic.add(new SelectorItemInfo(" name"));
        sic.add(new SelectorItemInfo(" number"));
        sic.add(new SelectorItemInfo(" model"));
        sic.add(new SelectorItemInfo(" pricePrecision"));
        sic.add(new SelectorItemInfo(" baseunit.id"));
        sic.add(new SelectorItemInfo(" assistUnit.id"));
        sic.add(new SelectorItemInfo(" materialGroup.name"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            lInfo = collection.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            result.addErrorMsgs("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + OpenApiUtil.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static String getAliasName(Context ctx, CoreBaseInfo info, String key) throws BOSException {
        String aliasName = "";
        EntitySelect select = new EntitySelect(info.getBOSType());
        select.propertySelect().select(key, "alias");
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        SimpleProperty propertyObject = entity.property(key);
        aliasName = propertyObject.getString("alias_l2");
        return aliasName;
    }

    public static void setDataBaseInfo(Context ctx, CoreBaseInfo info, BillResultInfo result, String key, Object obj) throws BOSException {
        String oql;
        DataBaseInfo lInfo = (DataBaseInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        DataBaseCollection databaseCol = iDataBase.getDataBaseCollection(oql = OpenApiUtil.getOql(lInfo, number));
        if (databaseCol != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            result.addErrorMsgs("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + OpenApiUtil.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    private static String getOql(DataBaseInfo lInfo, String number) {
        StringBuffer sb = new StringBuffer();
        if (lInfo instanceof CurrencyInfo) {
            sb.append("select id,number,name,precision where number='").append(number).append("'");
        } else if (lInfo instanceof RowTypeInfo) {
            sb.append("select id,number,name,isHasMaterialNumber,precision,destinationtype where number='").append(number).append("'");
        } else {
            sb.append("select id,number,name where number='").append(number).append("'");
        }
        return sb.toString();
    }

    public static void setCollection(Context ctx, BillResultInfo result, Object obj) throws BOSException {
        IObjectCollection collection = (IObjectCollection)obj;
        for (int i = 0; i < collection.size(); ++i) {
            CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(i);
            OpenApiUtil.buildInfoByNumber(ctx, entryInfo, result);
        }
    }

    public static void setCoreBillInfo(Context ctx, CoreBaseInfo info, BillResultInfo result, String key, Object obj) throws BOSException {
        CoreBillBaseInfo lInfo = (CoreBillBaseInfo)obj;
        if (lInfo.getId() != null) {
            return;
        }
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        String number = lInfo.getNumber();
        CoreBillBaseCollection databaseCol = iCoreBillBase.getCoreBillBaseCollection("select id,number where number='" + number + "'");
        if (databaseCol != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
        } else {
            lInfo = null;
            result.addErrorMsgs("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + OpenApiUtil.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static void setUserInfo(Context ctx, CoreBaseInfo info, BillResultInfo result, String key, Object obj) throws BOSException {
        UserInfo lInfo = (UserInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCol = iuser.getUserCollection("select id,number ,name where number='" + number + "'");
        if (userCol != null && userCol.size() > 0) {
            lInfo = userCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            result.addErrorMsgs("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + OpenApiUtil.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static void verifyData(CoreBaseInfo info, BillResultInfo result, String[] field) {
        if (result.hasError()) {
            return;
        }
        int size = field.length;
        for (int i = 0; i < size; ++i) {
            Object obj = info.get(field[i]);
            if (obj != null) continue;
            result.addErrorMsgs("\u5c5e\u6027[" + field[i] + "]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static void verifyData(AbstractObjectCollection entries, BillResultInfo result, String[] field) {
        if (result.hasError() || entries == null) {
            return;
        }
        int is = entries.size();
        for (int i = 0; i < is; ++i) {
            IObjectValue entryInfo = entries.getObject(i);
            int size = field.length;
            for (int j = 0; j < size; ++j) {
                Object obj = entryInfo.get(field[j]);
                if (obj != null) continue;
                result.addErrorMsgs("\u7b2c" + i + "\u6761\u5206\u5f55\u7684\u5c5e\u6027[" + field[j] + "]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

