/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.reverse.payment;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollPayEntryCollection;
import com.kingdee.eas.cp.bc.BizCollPayEntryInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.CreateVoucherRecordCollection;
import com.kingdee.eas.cp.bc.CreateVoucherRecordFactory;
import com.kingdee.eas.cp.bc.CreateVoucherRecordInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IBizCollPayEntry;
import com.kingdee.eas.cp.bc.ICreateVoucherRecord;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IMoreToOneVoucherOPS;
import com.kingdee.eas.cp.bc.IVoucherOperations;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.MoreToOneVoucherOPSCollection;
import com.kingdee.eas.cp.bc.MoreToOneVoucherOPSFactory;
import com.kingdee.eas.cp.bc.MoreToOneVoucherOPSInfo;
import com.kingdee.eas.cp.bc.RePaymentBillEntryCollection;
import com.kingdee.eas.cp.bc.RePaymentBillEntryInfo;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.VoucherOperationsCollection;
import com.kingdee.eas.cp.bc.VoucherOperationsFactory;
import com.kingdee.eas.cp.bc.VoucherOperationsInfo;
import com.kingdee.eas.cp.bc.VoucherTypeEnum;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BillReverseHandler {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.reverse.BillReverseHandler");
    public static final String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";
    public static final String Save = "Save";
    public static final String Submit = "Submit";
    public static final String payment = "payment";
    public static final String Delete = "Delete";
    public static final String SubmitPay = "SubmitPay";
    public static final String Pay = "Pay";
    public static final String AUDIT = "Audit";
    public static final String COUNTERAUDIT = "CounterAudit";
    public static final String SETTLEMENT = "Settlement";
    public static final String SETTLEMENTOVER = "SettlementOver";
    public static final String COUNTERSETTLEMENT = "CounterSettlement";
    public static final String CancelPay = "CancelPay";
    public static final String SubmitReturn = "SubmitReturn";
    public static final String Return = "Return";
    public static final String CancelReturn = "CancelReturn";
    public static final String addPayEntry = "addPayEntry";
    public static final String delPayEntry = "delPayEntry";
    public static final BigDecimal prec = new BigDecimal("0.5");
    static IVoucherOperations iVoucherOperation;
    static VoucherOperationsInfo operationInfo;

    public static void paymentHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, PaymentBillInfo paymentBillInfo, String mode, boolean isPay, Map paramMap) throws BOSException, EASBizException {
        int count = BizCollUtil.getPayMentSrcBillCount(ctx, paymentBillInfo, false);
        if (count > 1) {
            if (BizCollUtil.getPayMentSrcBillCount(ctx, paymentBillInfo, true) > 0) {
                throw new BizCollException(BizCollException.MULTIPAYCANNOTADD);
            }
            BillReverseHandler.paymentMultiHandler(ctx, iservice, paymentBillInfo, mode, isPay, paramMap, false);
        } else {
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("id"));
            baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(baseInfo.getId()), BizCollUtil.getBillPaySic(mode));
            BillReverseHandler.paymentSingleHandler(ctx, iservice, baseInfo, paymentBillInfo.getActPayLocAmt(), mode, isPay, null, paymentBillInfo, paramMap, true, null);
        }
    }

    public static void rePaymentHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, RePaymentBillInfo paymentBillInfo, String mode, boolean isPay) throws BOSException, EASBizException {
        BillReverseHandler.rePaymentMultiHandler(ctx, iservice, paymentBillInfo, mode, isPay);
    }

    private BizCollBillBaseInfo getBizCollBillBaseInfo(Context arg0, String billId) throws BOSException {
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        IDynamicObject iDynamicObject = null;
        iDynamicObject = arg0 == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)arg0);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, BillReverseHandler.getSelector());
        return billInfo;
    }

    public static void otherBillHandler(Context ctx, IExpenseAccountBill iservice, ExpenseAccountBillInfo baseInfo, OtherBillInfo otherBillInfo, String mode, boolean isPay) throws BOSException, EASBizException {
        int count = BizCollUtil.getOtherBillMentSrcBillCount(ctx, otherBillInfo, false);
        if (count > 1) {
            throw new BizCollException(BizCollException.CAN_NOT_MUL_TRANS_ONE);
        }
        iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("id"));
        baseInfo = iservice.getExpenseAccountBillInfo((IObjectPK)new ObjectUuidPK(baseInfo.getId()), BillReverseHandler.getBillPayableReverseSelector(mode));
        BillReverseHandler.otherBilSingleHandler(ctx, iservice, baseInfo, otherBillInfo.getAmountLocal(), mode, isPay, null, otherBillInfo, true, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpenseAccountBillInfo otherBilSingleHandler(Context ctx, IExpenseAccountBill iservice, ExpenseAccountBillInfo baseInfo, BigDecimal otherAmount, String mode, boolean isPay, String RowNumber, OtherBillInfo otherBill, boolean isFromSingle, ArrayList<OtherBillentryInfo> otherBillEntry, Map paramMap) throws BOSException, EASBizException {
        otherAmount = otherAmount.setScale(2, 4);
        ArrayList<String> otherBillEntryIds = new ArrayList<String>();
        if (otherBillEntry != null) {
            for (OtherBillentryInfo otherBillEntryInfo : otherBillEntry) {
                otherBillEntryIds.add(otherBillEntryInfo.getId().toString());
                otherAmount = otherAmount.add(otherBillEntryInfo.getAmountLocal());
            }
            logger.error((Object)("####otherBillSingleHandler \u5e94\u4ed8\u5206\u5f55\u5206\u7ec4" + otherBillEntryIds.toString()));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"otherBillSingleHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u5e94\u4ed8begin \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",\u4ed8\u6b3e\u5355\u7f16\u7801\uff1a" + otherBill.getNumber() + ",otherAmount:" + otherAmount + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState()) + ",mode:" + mode + ",isPay:" + isPay));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP080");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map param = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        BigDecimal payPrec = param.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(param.get("CP080").toString());
        CurrencyInfo payCurrency = otherBill.getCurrency();
        if (payPrec.compareTo(BizCollUtil.ZERO) == 0 && payCurrency != null && !payCurrency.getId().equals((Object)baseInfo.getCurrencyType().getId())) {
            payPrec = new BigDecimal("0.05");
        }
        param.put("payPrec", payPrec);
        param.put("RowNumber", RowNumber);
        if (Save.equals(mode) || Submit.equals(mode)) {
            if (baseInfo.getState() != null && (baseInfo.getState().getValue() == 70 || baseInfo.getState().getValue() == 80)) {
                throw new CreateToException(CreateToException.STATE_CANNOT_PAYBILL, new Object[]{baseInfo.getState().getAlias()});
            }
            if (!BillReverseHandler.getPayMentOperation(otherAmount)) {
                throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
            }
            if (baseInfo instanceof DailyPurchaseAccountBillInfo || baseInfo instanceof BizAccountOutBillInfo) {
                AdjustStateEnum adjustState;
                BillReverseHandler.checkIsMixedBusiness(ctx, baseInfo, "otherBill", null);
                if (baseInfo instanceof BizAccountOutBillInfo && (AdjustStateEnum.EDIT.equals((Object)(adjustState = ((BizAccountOutBillInfo)baseInfo).getAdjustState())) || AdjustStateEnum.SUBMIT.equals((Object)adjustState) || AdjustStateEnum.CHECKING.equals((Object)adjustState))) {
                    throw new BizCollException(BizCollException.ADJUST_CREATETO);
                }
                if (baseInfo.isIsCreatePayBill()) {
                    throw new CreateToException(CreateToException.CANNOT_OTHERBILL_PAYBILL);
                }
                if (baseInfo.isIsCreatePayPlanBill()) {
                    throw new CreateToException(CreateToException.CANNOT_OTHERBILL_PAYPLAN);
                }
                if (baseInfo.isIsCallBackPayPlan()) {
                    throw new CreateToException(CreateToException.CANNOT_OTHERBILL_CALLBACKPAYPLAN);
                }
            }
            logger.error((Object)("** reWriteBillState getState=" + (Object)((Object)baseInfo.getState())));
            if (baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreateOtherBill", true);
                BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            }
            logger.error((Object)("** reWriteBillState getState=" + (Object)((Object)baseInfo.getState())));
        }
        if (Submit.equals(mode)) {
            if (!BillReverseHandler.getPayMentOperation(otherAmount)) throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
            otherAmount = BillReverseHandler.getOtherAmount(ctx, baseInfo, otherBill, otherAmount, isFromSingle, "recievePayAmount");
            BillReverseHandler.payableHandler(ctx, iservice, baseInfo, otherAmount, Submit, RowNumber, otherBill, param);
            return baseInfo;
        } else if (AUDIT.equals(mode)) {
            otherAmount = BillReverseHandler.getOtherAmount(ctx, baseInfo, otherBill, otherAmount, isFromSingle, "recievePayAmount");
            baseInfo = BillReverseHandler.payableHandler(ctx, iservice, baseInfo, otherAmount, AUDIT, RowNumber, otherBill, param);
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillUpdateSicForOther(mode));
            return baseInfo;
        } else if (SETTLEMENT.equals(mode)) {
            baseInfo = BillReverseHandler.payableHandler(ctx, iservice, baseInfo, otherAmount, SETTLEMENTOVER, RowNumber, otherBill, param);
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillUpdateSicForOther(mode));
            if (StateEnum.ISPAYBILL.equals((Object)baseInfo.getState()) && baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0 && baseInfo.getBigDecimal("amountEncashed").compareTo(BigDecimal.ZERO) != 0) {
                BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
            }
            if (!StateEnum.ISPAYBILL.equals((Object)baseInfo.getState()) || baseInfo.getBigDecimal("amountEncashed").compareTo(BigDecimal.ZERO) != 0 || baseInfo.getAmountApproved().compareTo(baseInfo.getAmountPayable()) != 0) return baseInfo;
            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
            return baseInfo;
        } else if (COUNTERAUDIT.equals(mode)) {
            otherAmount = BillReverseHandler.getOtherAmount(ctx, baseInfo, otherBill, otherAmount, isFromSingle, "recievePayAmount");
            baseInfo = BillReverseHandler.payableHandler(ctx, iservice, baseInfo, otherAmount, COUNTERAUDIT, RowNumber, otherBill, param);
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillUpdateSicForOther(mode));
            return baseInfo;
        } else if (Delete.equals(mode)) {
            int count = BillReverseHandler.checkTracDownOtherbill(ctx, baseInfo.getId().toString(), otherBill.getId().toString(), null);
            if (count != 0) return baseInfo;
            BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreateOtherBill", false);
            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
            return baseInfo;
        } else {
            if (!COUNTERSETTLEMENT.equals(mode)) return baseInfo;
            baseInfo = BillReverseHandler.payableHandler(ctx, iservice, baseInfo, otherAmount, COUNTERSETTLEMENT, RowNumber, otherBill, param);
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillUpdateSicForOther(mode));
            if (!StateEnum.ALREADYPAYMENT.equals((Object)baseInfo.getState()) && !StateEnum.CLOSED.equals((Object)baseInfo.getState())) return baseInfo;
            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
        }
        return baseInfo;
    }

    public static BigDecimal getOtherAmount(Context ctx, BizCollBillBaseInfo baseInfo, OtherBillInfo otherBill, BigDecimal otherAmount, boolean isFromSingle, String field) throws EASBizException, BOSException {
        BigDecimal otherAmountOri = BillReverseHandler.getTotalOtherAmount(baseInfo, otherBill, isFromSingle, field);
        return BillReverseHandler.getOtherAmountByOri(ctx, baseInfo, otherBill, otherAmountOri);
    }

    public static BigDecimal getTotalOtherAmount(BizCollBillBaseInfo baseInfo, OtherBillInfo otherBill, boolean isFromSingle, String field) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal tmpAmount = new BigDecimal("0.00");
        OtherBillentryCollection otherEntryCon = otherBill.getEntry();
        if (otherEntryCon != null) {
            int size = otherEntryCon.size();
            for (int i = 0; i < size; ++i) {
                if (baseInfo.getId().toString().equals(otherEntryCon.get(i).getSourceBillId())) {
                    tmpAmount = tmpAmount.add((BigDecimal)otherEntryCon.get(i).get(field));
                }
                totalAmount = totalAmount.add((BigDecimal)otherEntryCon.get(i).get(field));
            }
        }
        if (isFromSingle) {
            return totalAmount;
        }
        return tmpAmount;
    }

    public static BigDecimal getOtherAmountByOri(Context ctx, BizCollBillBaseInfo baseInfo, OtherBillInfo otherBill, BigDecimal otherAmountOri) throws EASBizException, BOSException {
        BigDecimal otherAmount = BigDecimal.ZERO;
        String otherCurrencyId = otherBill.getCurrency().getId().toString();
        if (otherCurrencyId != null && !otherCurrencyId.equals(baseInfo.getCurrencyType().getId().toString())) {
            IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, otherCurrencyId);
            otherAmount = BizCollUtil.getAmountByAmountOriAndInfo(ctx, baseInfo, entryCoreBaseInfo, otherAmountOri, otherCurrencyId);
        } else {
            otherAmount = otherAmountOri;
        }
        logger.error((Object)("---getOtherAmountByOri getTotalEntAmount otherAmount=" + otherAmount + ",otherAmountOri=" + otherAmountOri));
        return otherAmount;
    }

    public static int checkTracDownOtherbill(Context ctx, String billId, String otherBillId, Map paramMap) throws BOSException {
        int billCount = 0;
        String sqlStr = "select 1 FROM T_AP_OtherBillentry entry INNER JOIN T_AP_OtherBill other ON other.fid = entry.fParentID and entry.fsourcebillid = ? where other.fid != ?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])new String[]{billId, otherBillId});
            if (rowSet.next()) {
                ++billCount;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return billCount;
    }

    public static BizCollBillBaseInfo paymentSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, boolean isPay, String RowNumber, PaymentBillInfo paybill, Map paramMap, boolean isFromSingle, ArrayList<PaymentBillEntryInfo> payEntryies) throws BOSException, EASBizException {
        if (paybill.isIsCBPay()) {
            if (paybill.getCbPayInfo() == null || paybill.getCbPayInfo().getPayeeCurrency() == null) {
                logger.error((Object)"####paymentSingleHandler CbPayInfo is null");
                String oql = "select cbPayInfo.id, cbPayInfo.payeeAmount, cbPayInfo.payeeCurrency.id where id ='" + paybill.getId() + "'";
                PaymentBillCollection paymentBillCol = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(oql);
                if (paymentBillCol.size() > 0) {
                    paybill.setCbPayInfo(paymentBillCol.get(0).getCbPayInfo());
                }
            }
            if (paybill.getCbPayInfo() == null || paybill.getCbPayInfo().getPayeeCurrency() == null) {
                throw new BizCollException(BizCollException.PAYCBPAYINFONOTNULL);
            }
            payAmount = paybill.getCbPayInfo().getPayeeAmount() != null ? paybill.getCbPayInfo().getPayeeAmount() : BizCollUtil.ZERO;
        }
        ArrayList<String> payEntryIds = new ArrayList<String>();
        if (payEntryies != null) {
            for (PaymentBillEntryInfo payEntryInfo : payEntryies) {
                payEntryIds.add(payEntryInfo.getId().toString());
                payAmount = payAmount.add(payEntryInfo.getLocalAmt());
            }
            logger.error((Object)("####paymentSingleHandler \u4ed8\u6b3e\u5206\u5f55\u5206\u7ec4" + payEntryIds.toString()));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"paymentSingleHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ed8\u6b3ebegin \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",\u4ed8\u6b3e\u5355\u7f16\u7801\uff1a" + paybill.getNumber() + ",payAmount:" + payAmount + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState()) + ",mode:" + mode + ",isPay:" + isPay + ",isFromSingle:" + isFromSingle + ",\u4ed8\u6b3e\u6392\u7a0b:" + paybill.isIsSchCreated()));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        Boolean isPrePayment = (Boolean)paramMap.get("isPrePayment");
        Boolean isCancelPrePayment = (Boolean)paramMap.get("isCancelPrePayment");
        Boolean isCreatePrePaymentBill = (Boolean)paramMap.get("isCreatePrePaymentBill");
        logger.error((Object)("---------paymentSingleHandler \u4ed8\u6b3e\u5355\u662f\u5426\u4ed8\u6b3e\u6392\u7a0bisIsSchCreated\uff1a" + paybill.isIsSchCreated()));
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP008");
        paramList.add("CP070");
        paramList.add("CP080");
        paramList.add("CP081");
        paramList.add("CP082");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map param = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        boolean CP008 = new Boolean(param.get("CP008").toString());
        Boolean isTm = (boolean)new Boolean(param.get("CP070").toString());
        boolean CP081 = param.get("CP081") == null ? false : new Boolean(param.get("CP081").toString());
        boolean CP082 = param.get("CP082") == null ? false : new Boolean(param.get("CP082").toString());
        param.put("CP081", CP081);
        param.put("RowNumber", RowNumber);
        BigDecimal payPrec = param.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(param.get("CP080").toString());
        CurrencyInfo payCurrency = BillReverseHandler.getPayCurrency(ctx, paybill);
        if (payPrec.compareTo(BizCollUtil.ZERO) == 0 && payCurrency != null && !payCurrency.getId().equals((Object)baseInfo.getCurrencyType().getId())) {
            payPrec = new BigDecimal("0.05");
        }
        param.put("payPrec", payPrec);
        boolean isPayment = BillReverseHandler.getPayMentOperation(payAmount);
        if (Save.equals(mode) || Submit.equals(mode)) {
            AdjustStateEnum adjustState;
            if (baseInfo.getState() != null && baseInfo.getState().getValue() < 60) {
                throw new BizCollException(BizCollException.CANNOTPAYBILLSTATE);
            }
            StateEnum billState = baseInfo.getState();
            if (!(billState == null || billState.getValue() != 80 && (!isPayment || billState.getValue() != 70 || baseInfo instanceof LoanBillInfo && Save.equals(mode)))) {
                throw new CreateToException(CreateToException.STATE_CANNOT_PAYBILL, new Object[]{baseInfo.getState().getAlias()});
            }
            if (!isPayment && baseInfo instanceof ExpenseAccountBillInfo) {
                throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
            }
            if (!CP008 && baseInfo.getAmountNotPaid() != null && baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0) {
                throw new BizCollException(BizCollException.CANNOTPAYBILL);
            }
            if (baseInfo instanceof BizAccountOutBillInfo && (AdjustStateEnum.EDIT.equals((Object)(adjustState = ((BizAccountOutBillInfo)baseInfo).getAdjustState())) || AdjustStateEnum.SUBMIT.equals((Object)adjustState) || AdjustStateEnum.CHECKING.equals((Object)adjustState))) {
                throw new BizCollException(BizCollException.ADJUST_CREATETO);
            }
            if ((baseInfo instanceof DailyPurchaseAccountBillInfo || baseInfo instanceof BizAccountOutBillInfo) && baseInfo.getBoolean("isCreateOtherBill")) {
                throw new CreateToException(CreateToException.CANNOT_OTHERBILL_PAYBILL);
            }
            if (baseInfo.isIsPaySchedule() && !paybill.isIsSchCreated()) {
                throw new CreateToException(CreateToException.BILL_PS);
            }
            if (baseInfo.isIsCallBackPayPlan()) {
                throw new CreateToException(CreateToException.CANNOT_PAYBILL_CALLBACKPAYPLAN);
            }
            BigDecimal amountNotPaid = baseInfo.getAmountNotPaid();
            BigDecimal amountPaid = baseInfo.getAmountPaid();
            if (amountNotPaid.compareTo(BizCollUtil.ZERO) > 0 && amountPaid.compareTo(BizCollUtil.ZERO) < 0 || amountNotPaid.compareTo(BizCollUtil.ZERO) < 0 && amountPaid.compareTo(BizCollUtil.ZERO) > 0) {
                throw new BizCollException(BizCollException.PAIDANDNOTPAIDAMOUNTERROR, new Object[]{amountNotPaid, amountPaid});
            }
            if (baseInfo instanceof DailyLoanBillInfo) {
                boolean isCreatePrePay = baseInfo.getBoolean("isCreatePrePaymentBill");
                boolean isCreatePay = baseInfo.getBoolean("isCreatePayBill");
                boolean isCreatePayPlan = baseInfo.getBoolean("isCreatePayPlanBill");
                if (isCreatePrePay && (isCreatePay || isCreatePayPlan)) {
                    throw new BizCollException(BizCollException.PROHIBITMIXEDPREPAYMENTANDPAYMENTAN);
                }
                BillReverseHandler.checkBillCanCreate(ctx, isCreatePrePaymentBill, isPrePayment, isCancelPrePayment, (DailyLoanBillInfo)baseInfo);
            }
            if (Save.equals(mode) && CP082) {
                payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle);
                BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, Save, RowNumber, paybill, param);
            }
            if (baseInfo instanceof DailyLoanBillInfo && isPrePayment.booleanValue()) {
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePrePaymentBill", true);
            } else if (!(isCancelPrePayment.booleanValue() || baseInfo.getBoolean("isCreatePayBill") || paybill.isIsSchCreated())) {
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", true);
            }
            if (BillReverseHandler.getPayMentOperation(payAmount) && baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            }
        }
        if (Submit.equals(mode)) {
            if (BillReverseHandler.getPayMentOperation(payAmount)) {
                payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle);
                BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, SubmitPay, RowNumber, paybill, param);
                if (baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                    BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                }
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle);
                param.put("payEntryies", payEntryies);
                param.put("paybill", paybill);
                param.put("isFromSingle", isFromSingle);
                BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), SubmitReturn, RowNumber, paybill.getId().toString(), param);
            }
        } else if (payment.equals(mode)) {
            if (!isPay) {
                if (baseInfo instanceof LoanBillInfo) {
                    BillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, RowNumber);
                }
                if (!BizCollUtil.checkRepayDelVoucher(paybill.getId().toString(), ctx)) {
                    throw new BizCollException(BizCollException.PAYEXREPAY);
                }
            }
            if (BillReverseHandler.getPayMentOperation(payAmount)) {
                if (isPay) {
                    if (StateEnum.ISPAYBILL.equals((Object)(baseInfo = BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle), Pay, RowNumber, paybill, param)).getState()) && baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0) {
                        if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkTracDownVoucher(ctx, baseInfo.getId().toString(), "hasSubmit") >= 1) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CLOSED);
                            logpk = LogUtil.beginLog((Context)ctx, (String)"BillReverseHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("close \u4ed8\u6b3e\u81ea\u52a8\u5173\u95ed  \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber()));
                            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                            if (isTm.booleanValue()) {
                                BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, true);
                            }
                        } else {
                            if (isTm.booleanValue()) {
                                BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, true);
                            }
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        }
                        BillReverseHandler.reWriteBillPayDate(iservice, baseInfo, new Date());
                    }
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        BizCollUtil.addAccountRecords(ctx, baseInfo, paybill.getId().toString(), payAmount, paybill.getPayerAccount());
                    }
                    iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("pay"));
                } else {
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        if (BizCollUtil.checkAccountRecordsHasAccounted(ctx, baseInfo, paybill.getId().toString())) {
                            if (RowNumber != null) {
                                throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTEDWITHNUMBER, new Object[]{RowNumber});
                            }
                            throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTED);
                        }
                        BizCollUtil.deleteAccountRecords(ctx, baseInfo, paybill.getId().toString());
                    }
                    if (StateEnum.ALREADYPAYMENT.equals((Object)(baseInfo = BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle), CancelPay, RowNumber, paybill, param)).getState()) || baseInfo instanceof ExpenseAccountBillInfo && StateEnum.CLOSED.equals((Object)baseInfo.getState())) {
                        if (isTm.booleanValue()) {
                            BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, false);
                        }
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                        BillReverseHandler.reWriteBillPayDate(iservice, baseInfo, null);
                    }
                    iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("pay"));
                }
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = BillReverseHandler.getPayAmount(ctx, baseInfo, paybill, payAmount, isFromSingle);
                param.put("payEntryies", payEntryies);
                param.put("paybill", paybill);
                param.put("isFromSingle", isFromSingle);
                baseInfo = isPay ? BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), Return, RowNumber, paybill.getId().toString(), param) : BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), CancelReturn, RowNumber, paybill.getId().toString(), param);
                iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("return"));
            }
            if (!isPay) {
                if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                    BillReverseHandler.handlePayEntry(ctx, baseInfo, paybill, delPayEntry, payEntryies, isFromSingle);
                }
            } else if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                BillReverseHandler.handlePayEntry(ctx, baseInfo, paybill, addPayEntry, payEntryies, isFromSingle);
            }
        } else if (Delete.equals(mode)) {
            if (BillReverseHandler.getPayMentOperation(payAmount) && StateEnum.ISPAYBILL.equals((Object)baseInfo.getState()) && BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "false", paybill.getId().toString()) == 0 && BizCollUtil.checkTracDownAgentbill(ctx, baseInfo.getId().toString(), "false") == 0) {
                if (!paybill.isIsSchCreated()) {
                    BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                }
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", false);
                if (baseInfo instanceof DailyLoanBillInfo) {
                    BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePrePaymentBill", false);
                }
            }
        } else if (COUNTERAUDIT.equals(mode) && BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "NOTSAVE") == 0 && baseInfo.getAmountPaid().compareTo(BizCollUtil.ZERO) == 0) {
            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
        }
        return baseInfo;
    }

    public static BigDecimal getPayAmount(Context ctx, BizCollBillBaseInfo baseInfo, PaymentBillInfo paybill, BigDecimal payAmount, boolean isFromSingle) throws EASBizException, BOSException {
        BigDecimal payAmountOri = BillReverseHandler.getTotalEntAmount(baseInfo, paybill, isFromSingle);
        return BillReverseHandler.getPayAmountByOri(ctx, baseInfo, paybill, payAmountOri);
    }

    public static BigDecimal getTotalEntAmount(BizCollBillBaseInfo baseInfo, PaymentBillInfo paybill, boolean isFromSingle) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal tmpAmount = new BigDecimal("0.00");
        PaymentBillEntryCollection payEntryCon = paybill.getEntries();
        if (payEntryCon != null) {
            int size = payEntryCon.size();
            for (int i = 0; i < size; ++i) {
                if (baseInfo.getId().toString().equals(payEntryCon.get(i).getSourceBillId())) {
                    tmpAmount = tmpAmount.add(payEntryCon.get(i).getAmount());
                }
                totalAmount = totalAmount.add(payEntryCon.get(i).getAmount());
            }
        }
        if (isFromSingle) {
            return totalAmount;
        }
        return tmpAmount;
    }

    public static BigDecimal getPayAmountByOri(Context ctx, BizCollBillBaseInfo baseInfo, PaymentBillInfo paybill, BigDecimal payAmountOri) throws EASBizException, BOSException {
        BigDecimal payAmount = null;
        String payCurrencyId = BillReverseHandler.getPayCurrency(ctx, paybill).getId().toString();
        if (payCurrencyId != null && !payCurrencyId.equals(baseInfo.getCurrencyType().getId().toString())) {
            IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, payCurrencyId);
            payAmount = BizCollUtil.getAmountByAmountOriAndInfo(ctx, baseInfo, entryCoreBaseInfo, payAmountOri, payCurrencyId);
        } else {
            payAmount = payAmountOri;
        }
        logger.error((Object)("---getPayAmount getTotalEntAmount payAmount=" + payAmount + ",payAmountOri=" + payAmountOri));
        return payAmount;
    }

    public static CurrencyInfo getPayCurrency(Context ctx, PaymentBillInfo paybill) throws EASBizException, BOSException {
        return paybill.isIsCBPay() ? paybill.getCbPayInfo().getPayeeCurrency() : paybill.getCurrency();
    }

    private static void handlePayEntry(Context ctx, BizCollBillBaseInfo baseInfo, PaymentBillInfo paybill, String operation, ArrayList<PaymentBillEntryInfo> payEntryies, boolean isFromSingle) throws BOSException, EASBizException {
        IBizCollPayEntry iBizCollPayEntry = null;
        if (baseInfo instanceof DailyLoanBillInfo) {
            iBizCollPayEntry = DailyLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof EvectionLoanBillInfo) {
            iBizCollPayEntry = EvectionLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof BizAccountBillInfo) {
            iBizCollPayEntry = BizAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            iBizCollPayEntry = TravelAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            iBizCollPayEntry = BizAccountOutBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            iBizCollPayEntry = DailyPurchaseAccountBillPayEntryFactory.getLocalInstance(ctx);
        }
        if (iBizCollPayEntry == null) {
            logger.error((Object)"##### handlePayEntry IBizCollPayEntry is null");
            return;
        }
        String payNumber = paybill.getNumber();
        FilterInfo delFilter = new FilterInfo();
        delFilter.getFilterItems().add(new FilterItemInfo("payBillNumber", (Object)payNumber));
        delFilter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)baseInfo.getId().toString()));
        if (operation.equals(addPayEntry)) {
            BizCollPayEntryCollection payEntryCon;
            AccountViewInfo payerAccount = paybill.getPayerAccount();
            AccountBankInfo payerAccountBank = paybill.getPayerAccountBank();
            CurrencyInfo payCurrency = BillReverseHandler.getPayCurrency(ctx, paybill);
            CompanyOrgUnitInfo company = paybill.getCompany();
            BigDecimal exchangeRate = new BigDecimal(1);
            ConvertModeEnum convertMode = ConvertModeEnum.DIRECTEXCHANGERATE;
            int exchangeRatePrecision = 4;
            if (!payCurrency.getId().toString().equals(baseInfo.getCurrencyType().getId().toString())) {
                IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, payCurrency.getId().toString());
                if (entryCoreBaseInfo != null) {
                    if (entryCoreBaseInfo.get("exchangeRate") != null) {
                        exchangeRate = (BigDecimal)entryCoreBaseInfo.get("exchangeRate");
                    }
                    if (entryCoreBaseInfo.get("convertMode") != null) {
                        convertMode = ConvertModeEnum.getEnum((int)((Integer)entryCoreBaseInfo.get("convertMode")));
                    }
                    if (entryCoreBaseInfo.get("exchangeRatePrecision") != null) {
                        exchangeRatePrecision = (Integer)entryCoreBaseInfo.get("exchangeRatePrecision");
                    }
                } else {
                    ExchangeRateInfo exRateInfo = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(payCurrency.getId().toString(), null, baseInfo.getApplierCompany().getId().toString(), baseInfo.getBizReqDate());
                    if (exRateInfo != null) {
                        exchangeRate = exRateInfo.getConvertRate();
                        convertMode = exRateInfo.getConvertMode();
                        exchangeRatePrecision = exRateInfo.getPrecision();
                    }
                }
            }
            PaymentBillEntryCollection payBillEntries = paybill.getEntries();
            EntityViewInfo queryEntity = new EntityViewInfo();
            BigDecimal totalPayAmount = new BigDecimal(0);
            int entrySeq = 0;
            if (payBillEntries.size() > 0 && (payEntryCon = iBizCollPayEntry.getBizCollPayEntryCollection("select id where bill.id='" + baseInfo.getId().toString() + "'")) != null && payEntryCon.size() > 0) {
                entrySeq = payEntryCon.size();
            }
            CoreBaseCollection payEntrycon = new CoreBaseCollection();
            int is = isFromSingle ? payBillEntries.size() : payEntryies.size();
            for (int i = 0; i < is; ++i) {
                BizCollPayEntryInfo bizCollPayEntryInfo = new BizCollPayEntryInfo();
                PaymentBillEntryInfo paymentBillEntryInfo = null;
                paymentBillEntryInfo = isFromSingle ? payBillEntries.get(i) : payEntryies.get(i);
                String payBillEntryId = paymentBillEntryInfo.getId().toString();
                FilterInfo queryFilter = new FilterInfo();
                queryFilter.getFilterItems().add(new FilterItemInfo("payBillEntry.id", (Object)payBillEntryId));
                queryEntity.setFilter(queryFilter);
                bizCollPayEntryInfo.put("bill", baseInfo);
                bizCollPayEntryInfo.setPayBillNumber(payNumber);
                bizCollPayEntryInfo.setPayerAccount(payerAccount);
                bizCollPayEntryInfo.setPayerAccountBank(payerAccountBank);
                bizCollPayEntryInfo.setCurrencyType(payCurrency);
                BigDecimal payAmountOri = paymentBillEntryInfo.getAmount();
                bizCollPayEntryInfo.setPayAmountOri(payAmountOri);
                bizCollPayEntryInfo.setPayerId(paybill.getPayeeID());
                bizCollPayEntryInfo.setPayerName(paybill.getPayeeName());
                BigDecimal payAmount = convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? payAmountOri.multiply(exchangeRate).setScale(2, 4) : payAmountOri.divide(exchangeRate, 2, 4).setScale(2, 4);
                totalPayAmount = totalPayAmount.add(payAmount);
                bizCollPayEntryInfo.setPayAmount(payAmount);
                bizCollPayEntryInfo.setPayCompany(company);
                bizCollPayEntryInfo.setExchangeRate(exchangeRate);
                bizCollPayEntryInfo.setExchangeRatePrecision(exchangeRatePrecision);
                bizCollPayEntryInfo.setConvertMode(convertMode);
                bizCollPayEntryInfo.setHasAccounted(false);
                bizCollPayEntryInfo.setSeq(entrySeq + i);
                bizCollPayEntryInfo.setPayDate(new Date());
                bizCollPayEntryInfo.setPayBank(paybill.getPayerBank());
                payEntrycon.add((CoreBaseInfo)bizCollPayEntryInfo);
            }
            if (payEntrycon != null && payEntrycon.size() > 0) {
                iBizCollPayEntry.addnewBatchData(payEntrycon);
            }
        } else if (operation.equals(delPayEntry)) {
            iBizCollPayEntry.delete(delFilter);
        }
    }

    public static BizCollBillBaseInfo rePaymentSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, boolean isPay, String RowNumber, RePaymentBillInfo paybill) throws BOSException, EASBizException {
        payAmount = payAmount.setScale(2, 4);
        if (Pay.equals(mode)) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP080");
            String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
            Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompanyId);
            baseInfo = isPay ? BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), Return, RowNumber, paybill.getId().toString(), paramMap) : BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), CancelReturn, RowNumber, paybill.getId().toString(), paramMap);
            iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("return"));
        }
        return baseInfo;
    }

    public static void paymentMultiHandler(Context ctx, IBizCollBillBase iservice, PaymentBillInfo paymentBillInfo, String mode, boolean isPay, Map paramMap, boolean isFromSingle) throws BOSException, EASBizException {
        PaymentBillEntryCollection payEntryCon = paymentBillInfo.getEntries();
        PaymentBillEntryInfo payEntryInfo = null;
        String sourceBillId = null;
        BizCollBillBaseInfo baseInfo = null;
        BizCollUtil.sortCollection(new String[]{"sourceBillID"}, (AbstractObjectCollection)paymentBillInfo.get("entries"));
        if (payEntryCon != null) {
            LinkedHashMap payEntryGroups = new LinkedHashMap();
            ArrayList<PaymentBillEntryInfo> list = null;
            int size = payEntryCon.size();
            for (int i = 0; i < size; ++i) {
                payEntryInfo = payEntryCon.get(i);
                sourceBillId = payEntryInfo.getSourceBillId();
                if (!payEntryGroups.containsKey(sourceBillId)) {
                    list = new ArrayList<PaymentBillEntryInfo>();
                    list.add(payEntryInfo);
                    payEntryGroups.put(sourceBillId, list);
                    continue;
                }
                ((ArrayList)payEntryGroups.get(sourceBillId)).add(payEntryInfo);
            }
            for (String billId : payEntryGroups.keySet()) {
                ArrayList payEntries = (ArrayList)payEntryGroups.get(billId);
                baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), BillReverseHandler.getBillSic("id"));
                iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("id"));
                baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), BizCollUtil.getBillPaySic(mode));
                baseInfo = BillReverseHandler.paymentSingleHandler(ctx, iservice, baseInfo, BizCollUtil.ZERO, mode, isPay, String.valueOf(((PaymentBillEntryInfo)payEntries.get(0)).getSeq()), paymentBillInfo, paramMap, isFromSingle, payEntries);
            }
        }
    }

    public static void otherBillMultiHandler(Context ctx, IExpenseAccountBill iservice, OtherBillInfo otherBillInfo, String mode, boolean isPay) throws BOSException, EASBizException {
        OtherBillentryCollection otherBillEntryCon = otherBillInfo.getEntry();
        OtherBillentryInfo otherBillentryInfo = null;
        String sourceBillId = null;
        ExpenseAccountBillInfo baseInfo = null;
        BizCollUtil.sortCollection(new String[]{"sourceBillID"}, (AbstractObjectCollection)otherBillInfo.get("entry"));
        if (otherBillEntryCon != null) {
            LinkedHashMap otherEntryGroups = new LinkedHashMap();
            ArrayList<OtherBillentryInfo> list = null;
            int size = otherBillEntryCon.size();
            for (int i = 0; i < size; ++i) {
                otherBillentryInfo = otherBillEntryCon.get(i);
                sourceBillId = otherBillentryInfo.getSourceBillId();
                if (!otherEntryGroups.containsKey(sourceBillId)) {
                    list = new ArrayList<OtherBillentryInfo>();
                    list.add(otherBillentryInfo);
                    otherEntryGroups.put(sourceBillId, list);
                    continue;
                }
                ((ArrayList)otherEntryGroups.get(sourceBillId)).add(otherBillentryInfo);
            }
            for (String billId : otherEntryGroups.keySet()) {
                ArrayList otherBillEntry = (ArrayList)otherEntryGroups.get(billId);
                baseInfo = iservice.getExpenseAccountBillInfo((IObjectPK)new ObjectUuidPK(billId), BillReverseHandler.getBillSic("id"));
                iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("id"));
                baseInfo = iservice.getExpenseAccountBillInfo((IObjectPK)new ObjectUuidPK(billId), BillReverseHandler.getBillPayableReverseSelector(mode));
                baseInfo = BillReverseHandler.otherBilSingleHandler(ctx, iservice, baseInfo, BigDecimal.ZERO, mode, isPay, String.valueOf(((OtherBillentryInfo)otherBillEntry.get(0)).getSeq()), otherBillInfo, false, otherBillEntry, null);
            }
        }
    }

    public static void checkIsMixedBusiness(Context ctx, BizCollBillBaseInfo baseInfo, String type, Map map) throws BOSException, EASBizException {
        AbstractObjectCollection loanCheckEntries = (AbstractObjectCollection)baseInfo.get("LoanCheckEntries");
        if (loanCheckEntries != null && loanCheckEntries.size() > 0) {
            HashSet<Object> sourceIdSet = new HashSet<Object>();
            boolean isCreatePay = false;
            boolean isCreatePlanPay = false;
            boolean isCreatePrePayment = false;
            int size = loanCheckEntries.size();
            for (int j = 0; j < size; ++j) {
                sourceIdSet.add(loanCheckEntries.getObject(j).get("sourceBillId"));
            }
            if (sourceIdSet.size() == 0) {
                return;
            }
            ArrayList idList = new ArrayList(sourceIdSet);
            StringBuilder idSql = new StringBuilder();
            int size2 = idList.size();
            for (int m = 0; m < size2; ++m) {
                idSql.append("?,");
            }
            idSql.deleteCharAt(idSql.toString().length() - 1);
            String sqlStr = "select fisCreatePayBill, fisCreatePayPlanBill, fisCreatePrePaymentBill, FIsSetPayState, FisImport  from T_BC_DailyLoanBill where FID IN (" + idSql.toString() + ")";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr, (Object[])idList.toArray());
                while (rowSet.next()) {
                    if (rowSet.getInt("fisCreatePayBill") == 1) {
                        isCreatePay = true;
                    }
                    if (rowSet.getInt("fisCreatePayPlanBill") == 1) {
                        isCreatePlanPay = true;
                    }
                    if (rowSet.getInt("fisCreatePrePaymentBill") == 1) {
                        isCreatePrePayment = true;
                    }
                    if (rowSet.getInt("FIsSetPayState") == 1) {
                        isCreatePay = true;
                    }
                    if (!rowSet.getBoolean("FisImport")) continue;
                    isCreatePay = true;
                }
                if ("otherBill".equals(type) && (isCreatePay || isCreatePlanPay)) {
                    throw new BizCollException(BizCollException.PROHIBITLOANASSOCIATEDPAYMENT);
                }
                if ("paymentBill".equals(type) && isCreatePrePayment) {
                    throw new BizCollException(BizCollException.PROHIBITLOANASSOCIATEDPREPAYMENT);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static SelectorItemCollection getBillPayReverseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("returnAmount"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.budgetDo"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        sic.add(new SelectorItemInfo("entries.currencyType.id"));
        sic.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
        return sic;
    }

    public static SelectorItemCollection getBillPayableReverseSelector(String type) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("billTypeCode"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountPayable"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("isCreatePayBill"));
        sic.add(new SelectorItemInfo("isVouchered"));
        sic.add(new SelectorItemInfo("isDapVouchered"));
        sic.add(new SelectorItemInfo("adjustState"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.budgetDo"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        sic.add(new SelectorItemInfo("entries.currencyType.id"));
        sic.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        if (!Save.equals(type) && !Delete.equals(type)) {
            sic.add(new SelectorItemInfo("collectionEntries.currencyType.id"));
            sic.add(new SelectorItemInfo("collectionEntries.exchangeRate"));
            sic.add(new SelectorItemInfo("collectionEntries.convertMode"));
            sic.add(new SelectorItemInfo("collectionEntries.exchangeRatePrecision"));
        }
        if (Save.equals(type) || Submit.equals(type)) {
            sic.add(new SelectorItemInfo("loanCheckEntries.sourceBillID"));
        }
        return sic;
    }

    public static void rePaymentMultiHandler(Context ctx, IBizCollBillBase iservice, RePaymentBillInfo paymentBillInfo, String mode, boolean isPay) throws BOSException, EASBizException {
        RePaymentBillEntryCollection payEntryCon = paymentBillInfo.getEntries();
        RePaymentBillEntryInfo payEntryInfo = null;
        String sourceBillId = null;
        BigDecimal payAmount = null;
        BizCollBillBaseInfo baseInfo = null;
        if (payEntryCon != null) {
            int size = payEntryCon.size();
            for (int i = 0; i < size; ++i) {
                payEntryInfo = payEntryCon.get(i);
                payAmount = payEntryInfo.getAmount();
                if (sourceBillId == null || !payEntryInfo.getSourceBillId().equals(sourceBillId)) {
                    BOSObjectType srcBosType = BizCollUtil.getBOSType(payEntryInfo.getSourceBillId());
                    if (srcBosType.equals((Object)BizCollUtil.getBypeByBill(BizCollBillTypeEnum.EVECTION_LOAN))) {
                        iservice = EvectionLoanBillFactory.getLocalInstance(ctx);
                    } else if (srcBosType.equals((Object)BizCollUtil.getBypeByBill(BizCollBillTypeEnum.DAILY_LOAN))) {
                        iservice = DailyLoanBillFactory.getLocalInstance(ctx);
                    }
                    baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(payEntryInfo.getSourceBillId()), BillReverseHandler.getBizCollBillBaseSelector());
                    sourceBillId = payEntryInfo.getSourceBillId();
                }
                baseInfo = BillReverseHandler.rePaymentSingleHandler(ctx, iservice, baseInfo, payAmount, mode, isPay, String.valueOf(i + 1), paymentBillInfo);
            }
        }
    }

    private static SelectorItemCollection getBizCollBillBaseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("returnAmount"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.budgetDo"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        return sic;
    }

    protected BigDecimal getPayAmount(Context ctx, boolean isSuspenseAcc, boolean PayBillCanNotCreateVoucher, BizCollBillBaseInfo baseInfo, VoucherInfo voucherInfo, Map destSrcBillMap, Map destSrcAmountMap, BOTBillOperStateEnum bOTBillOperStateEnum, BOTMappingInfo mappingInfo) throws BOSException, EASBizException {
        BigDecimal payAmount = BizCollUtil.ZERO;
        String type = "isVoucher";
        String destBillId = voucherInfo.getId().toString();
        StateEnum billState = baseInfo.getState();
        if (!(PayBillCanNotCreateVoucher || isSuspenseAcc || StateEnum.ALREADYSUSPENSEACCOUNT.equals((Object)billState))) {
            Map map = BizCollUtil.getVoucherInfo(ctx, voucherInfo);
            if (map != null) {
                type = (String)map.get("type");
                if (type.equals("error")) {
                    throw new BizCollException(BizCollException.VOUCHERAMOUNTERROR);
                }
                if (!type.equals("isVoucher")) {
                    payAmount = ((BigDecimal)map.get("payAmount")).setScale(2, 4);
                    if ((mappingInfo.getIsTempSave() == 0 || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) && ((List)destSrcBillMap.get(destBillId)).size() > 1) {
                        BigDecimal totalAmountNotPaid = (BigDecimal)destSrcAmountMap.get(destBillId);
                        int srcBillcount = ((List)destSrcBillMap.get(destBillId)).size();
                        MoreToOneVoucherOPSCollection con = MoreToOneVoucherOPSFactory.getLocalInstance(ctx).getCollection("select id,voucherID,billID,amount where voucherID='" + destBillId + "'");
                        if (con != null && con.size() > 0 && srcBillcount == con.size()) {
                            totalAmountNotPaid = new BigDecimal("0.00");
                            Iterator it = con.iterator();
                            while (it.hasNext()) {
                                MoreToOneVoucherOPSInfo info = (MoreToOneVoucherOPSInfo)it.next();
                                totalAmountNotPaid = totalAmountNotPaid.add(info.getAmount());
                            }
                        }
                        if (totalAmountNotPaid.compareTo(payAmount) != 0) {
                            throw new BizCollException(BizCollException.PAYAMOUNTISNOTEQLNOTPAYAMOUNT);
                        }
                        if (baseInfo.getAmountNotPaid() != null) {
                            payAmount = baseInfo.getAmountNotPaid();
                        }
                    }
                }
            } else {
                return null;
            }
        }
        return payAmount;
    }

    protected Map<String, Object> getVoucherMap(Context ctx, boolean isSuspendDap, boolean isReturnVoucher, BOTBillOperStateEnum operState, boolean billCanVoucher, VoucherInfo voucherInfo, Map paramMap, BizCollBillBaseInfo billInfo) throws BOSException {
        HashMap<String, Object> voucherMap = new HashMap<String, Object>();
        VoucherTypeEnum voucherType = VoucherTypeEnum.VOUCHER;
        String voucherId = voucherInfo.getId().toString();
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)operState)) {
            if (isSuspendDap) {
                voucherType = VoucherTypeEnum.DAPVOUCHER;
            } else if (isReturnVoucher) {
                voucherType = VoucherTypeEnum.RETURNVOUCHER;
            } else {
                boolean withCn = new Boolean(paramMap.get("CP008").toString());
                BigDecimal amounEncashed = (BigDecimal)billInfo.get("amountEncashed");
                voucherType = !withCn && billInfo instanceof LoanBillInfo ? VoucherTypeEnum.PAYVOUCHER : (!withCn && billInfo instanceof ExpenseAccountBillInfo && amounEncashed != null && amounEncashed.compareTo(BizCollUtil.ZERO) > 0 ? VoucherTypeEnum.PAYVOUCHER : VoucherTypeEnum.VOUCHER);
            }
        } else {
            String queryOql;
            ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
            CreateVoucherRecordCollection createVoucherRecords = iCreateVoucherRecord.getCreateVoucherRecordCollection(String.format(queryOql = "select voucherType where voucherid = '%s'", voucherId));
            if (createVoucherRecords.size() != 0) {
                CreateVoucherRecordInfo createVoucherRecordInfo = createVoucherRecords.get(0);
                voucherType = createVoucherRecordInfo.getVoucherType();
            }
        }
        voucherMap.put("voucherType", (Object)voucherType);
        voucherMap.put("state", voucherInfo.getBizStatus().getValue());
        return voucherMap;
    }

    protected BigDecimal changePayAmountForDel(Context ctx, VoucherInfo voucher, BizCollBillBaseInfo baseInfo, Map destSrcBillMap, BigDecimal payAmount) throws BOSException, EASBizException {
        MoreToOneVoucherOPSCollection con;
        String srcBillId = baseInfo.getId().toString();
        String destBillId = voucher.getId().toString();
        if (((List)destSrcBillMap.get(destBillId)).size() > 1 && (con = MoreToOneVoucherOPSFactory.getLocalInstance(ctx).getCollection("select id,voucherID,billID,amount where voucherID='" + destBillId + "' and billID='" + srcBillId + "'")) != null && con.size() > 0) {
            MoreToOneVoucherOPSInfo moreToOneVoucherOPSInfo = con.get(0);
            payAmount = moreToOneVoucherOPSInfo.getAmount();
        }
        return payAmount;
    }

    public static void voucherSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, VoucherInfo voucherInfo, String mode, boolean isSuspenseAcc, boolean PayBillCanNotCreateVoucher, String billIds, BigDecimal payAmount) throws BOSException, EASBizException {
        Map map;
        String type = "isVoucher";
        String state = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP080");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompanyId);
        boolean hasSubmit = false;
        if (!(PayBillCanNotCreateVoucher && baseInfo instanceof ExpenseAccountBillInfo || isSuspenseAcc || StateEnum.ALREADYSUSPENSEACCOUNT.equals((Object)baseInfo.getState()) || BizCollUtil.checkIsRefFiAndCas(ctx, baseInfo.getApplierCompany().getId().toString()))) {
            map = BizCollUtil.getVoucherInfo(ctx, voucherInfo);
            if (map != null) {
                type = (String)map.get("type");
                if (type.equals("error")) {
                    throw new BizCollException(BizCollException.VOUCHERAMOUNTERROR);
                }
                state = String.valueOf(map.get("state"));
                if (state != null && !state.equals("0") && !state.equals("2")) {
                    hasSubmit = true;
                }
            } else {
                return;
            }
        }
        if (mode.equals(Delete)) {
            if (StateEnum.ALREADYSUSPENSEACCOUNT.equals((Object)baseInfo.getState()) || StateEnum.ISSUSPENSEACCOUNT.equals((Object)baseInfo.getState())) {
                BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
            } else if (type.equals("isVoucher")) {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    if (PayBillCanNotCreateVoucher && baseInfo.getBigDecimal("amountEncashed") != null && baseInfo.getBigDecimal("amountEncashed").compareTo(BizCollUtil.ZERO) > 0) {
                        if (baseInfo.getString("actionFlag") != null) {
                            if (baseInfo.getString("actionFlag").equals("R")) {
                                if (BizCollUtil.checkIsFirstVoucher(ctx, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime())) {
                                    map = BizCollUtil.checkVoucherCanDelete(ctx, baseInfo, billIds, voucherInfo);
                                    if (map.get("equalsFirstRecord") != null && (map.get("equalsFirstRecord").equals(true) ? Integer.valueOf(map.get("size").toString()) > 1 : Integer.valueOf(map.get("size").toString()) > 0)) {
                                        throw new BizCollException(BizCollException.CANNOTDELETESUSPENSEVOUCHER);
                                    }
                                    BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                                }
                            } else if (baseInfo.getString("actionFlag").equals("T")) {
                                BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                            }
                            if (baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) <= 0) {
                                BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                            }
                        } else {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        }
                        BizCollUtil.updateAccountRecordsHasNotAccounted(ctx, baseInfo, billIds, voucherInfo.getId().toString());
                    } else {
                        BigDecimal amountEncashed;
                        if (baseInfo.getString("actionFlag") != null) {
                            if (baseInfo.getString("actionFlag").equals("R")) {
                                if (BizCollUtil.checkIsFirstVoucher(ctx, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime())) {
                                    if (BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "false") > 0) {
                                        throw new BizCollException(BizCollException.CANNOTDELETEFIRSTSUSPENSEVOUCHER);
                                    }
                                    BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                                }
                            } else if (baseInfo.getString("actionFlag").equals("T")) {
                                BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                            }
                        }
                        BigDecimal bigDecimal = amountEncashed = ((ExpenseAccountBillInfo)baseInfo).getAmountEncashed() == null ? BizCollUtil.ZERO : ((ExpenseAccountBillInfo)baseInfo).getAmountEncashed();
                        if (amountEncashed.compareTo(BizCollUtil.ZERO) > 0) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        } else if ("R".equals(baseInfo.getString("actionFlag"))) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISSUSPENSEACCOUNT);
                        } else if ("T".equals(baseInfo.getString("actionFlag"))) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYSUSPENSEACCOUNT);
                        } else {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                        }
                    }
                } else if (baseInfo.getString("actionFlag") != null) {
                    if (baseInfo.getString("actionFlag").equals("R")) {
                        if (BizCollUtil.checkIsFirstVoucher(ctx, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime())) {
                            if (BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "false") > 0) {
                                throw new BizCollException(BizCollException.CANNOTDELETEFIRSTSUSPENSEVOUCHER);
                            }
                            BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                        }
                    } else if (baseInfo.getString("actionFlag").equals("T")) {
                        BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, null);
                    }
                    BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                }
            } else {
                BillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, null);
                if (hasSubmit && billIds != null && billIds.indexOf(",") <= 0) {
                    BillReverseHandler.deleteVoucherOperation(ctx, voucherInfo.getId().toString());
                }
                if (type.equals("isPay")) {
                    if (hasSubmit) {
                        baseInfo = BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, CancelPay, null, null, paramMap);
                        iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("pay"));
                    }
                    if (baseInfo.getAmountPaid().compareTo(BizCollUtil.ZERO) == 0 && BizCollUtil.checkTracDownVoucherState(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString(), 0, null) == 0) {
                        if ("R".equals(baseInfo.getString("actionFlag"))) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISSUSPENSEACCOUNT);
                        } else if ("T".equals(baseInfo.getString("actionFlag"))) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYSUSPENSEACCOUNT);
                        } else {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                        }
                    } else if (baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) > 0) {
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                    }
                } else if (type.equals("isReturn") && baseInfo instanceof LoanBillInfo && hasSubmit) {
                    baseInfo = BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount, CancelReturn, null, null, paramMap);
                    iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("return"));
                }
            }
            if (billIds != null && billIds.indexOf(",") > 0) {
                MoreToOneVoucherOPSFactory.getLocalInstance(ctx).delete("where voucherID = '" + voucherInfo.getId().toString() + "' and billID='" + baseInfo.getId().toString() + "'");
            }
        } else {
            if (!baseInfo.getBoolean("isVouchered")) {
                BillReverseHandler.updateBillVoucherFlag(iservice, baseInfo, "isVouchered", true);
            }
            if (mode.equals(Save)) {
                if (isSuspenseAcc) {
                    BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, "T");
                    if (baseInfo instanceof ExpenseAccountBillInfo && PayBillCanNotCreateVoucher) {
                        BizCollUtil.updateAccountRecordsHasAccounted(ctx, baseInfo, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime(), true);
                        if (!baseInfo.getState().equals((Object)StateEnum.ISPAYBILL)) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYSUSPENSEACCOUNT);
                        }
                    } else {
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYSUSPENSEACCOUNT);
                    }
                } else if (type.equals("isPay")) {
                    if (baseInfo instanceof ExpenseAccountBillInfo) {
                        BillReverseHandler.checkAmountEncashed(ctx, baseInfo, "isPay");
                    }
                    if (StateEnum.ALREADYPAYMENT.equals((Object)baseInfo.getState())) {
                        throw new BizCollException(BizCollException.BILLALREADYPAY);
                    }
                    BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                } else if (!type.equals("isReturn") && type.equals("isVoucher")) {
                    if (baseInfo instanceof LoanBillInfo) {
                        throw new BizCollException(BizCollException.CANNOTVOUCHERBYLOAN);
                    }
                    if (baseInfo instanceof ExpenseAccountBillInfo) {
                        if (PayBillCanNotCreateVoucher) {
                            System.out.print("******voucherHandler updateAccountRecordsHasAccounted");
                            BizCollUtil.updateAccountRecordsHasAccounted(ctx, baseInfo, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime(), false);
                        } else {
                            BillReverseHandler.checkAmountEncashed(ctx, baseInfo, "isVoucher");
                        }
                    }
                    if (baseInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT) || baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYVOUCHER);
                    }
                }
            } else if (mode.equals(Submit)) {
                if (billIds != null && billIds.indexOf(",") > 0) {
                    BillReverseHandler.updateMoreToOneVoucherOPSInfo(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString(), baseInfo.getAmountNotPaid());
                }
                if (baseInfo instanceof LoanBillInfo) {
                    BillReverseHandler.checkTracDownVoucherState(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString());
                }
                if (isSuspenseAcc || StateEnum.ALREADYSUSPENSEACCOUNT.equals((Object)baseInfo.getState()) || baseInfo.getString("actionFlag") != null && baseInfo.getString("actionFlag").equals("T")) {
                    if (baseInfo instanceof ExpenseAccountBillInfo && PayBillCanNotCreateVoucher) {
                        BizCollUtil.updateAccountRecordsHasAccounted(ctx, baseInfo, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime(), true);
                        if (!BizCollUtil.checkVoucherAccountCorrect(ctx, baseInfo, billIds, voucherInfo, "SuspenseVoucher")) {
                            throw new BizCollException(BizCollException.VOUCHERISNOTEQUALSRECORDS);
                        }
                        if (!baseInfo.getState().equals((Object)StateEnum.ISPAYBILL)) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISSUSPENSEACCOUNT);
                        }
                    } else {
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISSUSPENSEACCOUNT);
                    }
                    BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, "R");
                } else if (type.equals("isVoucher")) {
                    if (baseInfo instanceof LoanBillInfo) {
                        if (baseInfo.getString("actionFlag") == null || !baseInfo.getString("actionFlag").equals("R")) {
                            throw new BizCollException(BizCollException.CANNOTVOUCHERBYLOAN);
                        }
                        if (!hasSubmit) {
                            throw new BizCollException(BizCollException.CANNOTVOUCHERBYLOAN);
                        }
                    } else if (baseInfo instanceof ExpenseAccountBillInfo) {
                        if (PayBillCanNotCreateVoucher) {
                            BizCollUtil.updateAccountRecordsHasAccounted(ctx, baseInfo, billIds, voucherInfo.getId().toString(), voucherInfo.getCreateTime(), false);
                            if (!BizCollUtil.checkVoucherAccountCorrect(ctx, baseInfo, billIds, voucherInfo, "Voucher")) {
                                throw new BizCollException(BizCollException.VOUCHERISNOTEQUALSRECORDS);
                            }
                            if (!baseInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT) && baseInfo.getString("actionFlag") != null && baseInfo.getString("actionFlag").equals("T")) {
                                BillReverseHandler.setActionFlag(ctx, iservice, baseInfo, "R");
                            }
                        } else {
                            BillReverseHandler.checkAmountEncashed(ctx, baseInfo, "isVoucher");
                        }
                    }
                    if (!(baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) > 0 || PayBillCanNotCreateVoucher && BizCollUtil.checkTracDownVoucherState(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString(), 0, null) > 0)) {
                        BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CLOSED);
                        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"BillReverseHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("close \u81ea\u52a8\u5173\u95ed  \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber()));
                        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                    }
                } else {
                    BigDecimal compareAmount = null;
                    if (billIds != null && billIds.indexOf(",") <= 0) {
                        compareAmount = BillReverseHandler.checkVoucherOperations(ctx, voucherInfo.getId().toString(), type, payAmount, baseInfo.getAmountBalance());
                    }
                    if (compareAmount != null && compareAmount.compareTo(BizCollUtil.ZERO) == 0) {
                        return;
                    }
                    if (type.equals("isPay")) {
                        if (baseInfo instanceof ExpenseAccountBillInfo) {
                            BillReverseHandler.checkAmountEncashed(ctx, baseInfo, "isPay");
                        }
                        baseInfo = compareAmount != null ? (compareAmount.compareTo(BizCollUtil.ZERO) > 0 ? BillReverseHandler.payHandler(ctx, iservice, baseInfo, compareAmount, Pay, null, null, paramMap) : BillReverseHandler.payHandler(ctx, iservice, baseInfo, compareAmount.abs(), CancelPay, null, null, paramMap)) : BillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, Pay, null, null, paramMap);
                        iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("pay"));
                        if (baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0) {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        } else {
                            BillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                        }
                        if (billIds != null && billIds.indexOf(",") <= 0) {
                            BillReverseHandler.updateVoucherOperation(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString(), payAmount);
                        }
                    } else if (type.equals("isReturn") && baseInfo instanceof LoanBillInfo) {
                        baseInfo = compareAmount != null ? (compareAmount.compareTo(BizCollUtil.ZERO) > 0 ? BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, compareAmount, Return, null, null, paramMap) : BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, compareAmount.abs(), CancelReturn, null, null, paramMap)) : BillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount, Return, null, null, paramMap);
                        iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("return"));
                        if (billIds != null && billIds.indexOf(",") <= 0) {
                            BillReverseHandler.updateVoucherOperation(ctx, baseInfo.getId().toString(), voucherInfo.getId().toString(), payAmount);
                        }
                    }
                }
            }
        }
    }

    public static BizCollBillBaseInfo payHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, String RowNumber, PaymentBillInfo paybill, Map paramMap) throws BOSException, EASBizException {
        BigDecimal payPrec = new BigDecimal(paramMap.get("payPrec").toString());
        BigDecimal amountNotPaid = null;
        BigDecimal amountPaid = null;
        BigDecimal amountBalance = null;
        if (payAmount != null) {
            amountNotPaid = baseInfo.getAmountNotPaid();
            amountPaid = baseInfo.getAmountPaid();
            BigDecimal bigDecimal = amountBalance = baseInfo.getAmountBalance() == null ? BizCollUtil.ZERO : baseInfo.getAmountBalance();
            if (mode.equals(Save)) {
                if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
                    logger.error((Object)("--payHandler payAmount=" + payAmount + ";amountNotPaid=" + amountNotPaid + ";number=" + baseInfo.getNumber()));
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountNotPaid});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountNotPaid});
                }
                BigDecimal amountNotPaidAndPaid = amountNotPaid.add(amountPaid);
                BigDecimal payAmountCount = BizCollUtil.getPayAmountCount(ctx, baseInfo, paybill, null, "save", paramMap);
                logger.error((Object)("--payHandler payAmountCount=" + payAmountCount + ";amountNotPaidAndPaid=" + amountNotPaidAndPaid + ";payAmount=" + payAmount + ";number=" + baseInfo.getNumber()));
                if (payAmountCount.compareTo(amountNotPaidAndPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.SOURCEAMOUNT_LT_PAYAMOUNT_WITHNUM, new Object[]{RowNumber, amountNotPaidAndPaid, payAmountCount});
                    }
                    throw new BizCollException(BizCollException.SOURCEAMOUNT_LT_PAYAMOUNT, new Object[]{amountNotPaidAndPaid, payAmountCount});
                }
            } else if (mode.equals(SubmitPay)) {
                boolean amountEncashedError;
                if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountNotPaid});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountNotPaid});
                }
                BigDecimal submitAmount = BizCollUtil.getPayAmountCount(ctx, baseInfo, paybill, null, "submit", paramMap);
                logger.error((Object)("--payHandler submitAmount=" + submitAmount + ";amountNotPaid=" + amountNotPaid + ";payAmount=" + payAmount + ";number=" + baseInfo.getNumber()));
                if (submitAmount != null && (submitAmount = submitAmount.setScale(2, 4)).compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.NOTPAIDNOTENOUGHWITHNUM, new Object[]{RowNumber, amountNotPaid, submitAmount});
                    }
                    throw new BizCollException(BizCollException.NOTPAIDNOTENOUGH, new Object[]{amountNotPaid, submitAmount});
                }
                CommonUtilFacadeFactory.getLocalInstance(ctx).checkBillCurAndExcRate(baseInfo, true, paramMap);
                if (baseInfo instanceof ExpenseAccountBillInfo && baseInfo.get("amountEncashed") != null && (amountEncashedError = CommonUtilFacadeFactory.getLocalInstance(ctx).checkAmountEncashed(baseInfo, null))) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.AMOUNTENCASHEDERRORWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.AMOUNTENCASHEDERROR);
                }
                if (BizCollUtil.checkPayBillEntryAmount(ctx, baseInfo, paybill, null, paramMap)) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.ENTRYPAYNOTGTCOLLECTIONAMOUNTWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.ENTRYPAYNOTGTCOLLECTIONAMOUNT);
                }
                boolean CP081 = new Boolean(paramMap.get("CP081").toString());
                if (CP081 && BizCollUtil.checkPayAmountByAccountBank(ctx, baseInfo, paybill, null, paramMap)) {
                    throw new BizCollException(BizCollException.COLLECTIONAMOUNT_LT_PAYAMOUNTCOUNT, new Object[]{paybill.getPayeeAccountBank()});
                }
            } else if (mode.equals(Pay)) {
                if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountNotPaid});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountNotPaid});
                }
                CommonUtilFacadeFactory.getLocalInstance(ctx).checkBillCurAndExcRate(baseInfo, true, paramMap);
                if (BizCollUtil.checkPayBillEntryAmount(ctx, baseInfo, paybill, null, paramMap)) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.ENTRYPAYNOTGTCOLLECTIONAMOUNTWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.ENTRYPAYNOTGTCOLLECTIONAMOUNT);
                }
                boolean CP081 = new Boolean(paramMap.get("CP081").toString());
                if (CP081 && BizCollUtil.checkPayAmountByAccountBank(ctx, baseInfo, paybill, null, paramMap)) {
                    throw new BizCollException(BizCollException.COLLECTIONAMOUNT_LT_PAYAMOUNTCOUNT, new Object[]{paybill.getPayeeAccountBank()});
                }
                BigDecimal amountDif = amountNotPaid.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    baseInfo.setAmountNotPaid(BizCollUtil.ZERO);
                    baseInfo.setAmountPaid(amountPaid.add(payAmount).add(amountDif));
                    baseInfo.setAmountBalance(amountBalance.add(payAmount).add(amountDif));
                } else {
                    baseInfo.setAmountNotPaid(amountNotPaid.subtract(payAmount));
                    baseInfo.setAmountPaid(amountPaid.add(payAmount));
                    baseInfo.setAmountBalance(amountBalance.add(payAmount));
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"payHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ed8\u6b3ePay \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            } else if (mode.equals(CancelPay)) {
                if (baseInfo instanceof ExpenseAccountBillInfo && payAmount.compareTo(amountPaid.add(payPrec)) > 0) {
                    throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANPAY, new Object[]{payAmount, amountPaid});
                }
                if (baseInfo instanceof LoanBillInfo) {
                    if (payAmount.compareTo(amountBalance.add(payPrec)) > 0) {
                        if (RowNumber != null) {
                            throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountBalance});
                        }
                        throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountBalance});
                    }
                    ctx.put((Object)"paybill", (Object)paybill);
                    BigDecimal ReturnAmount = BizCollUtil.getReturenAmountCount(ctx, baseInfo, paybill.getId().toString(), "");
                    ctx.remove((Object)"paybill");
                    if (amountBalance.add(payPrec).add(ReturnAmount).compareTo(payAmount) < 0) {
                        if (RowNumber != null) {
                            throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCEWITHNUM, new Object[]{RowNumber, payAmount, amountBalance, ReturnAmount.abs()});
                        }
                        throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCE, new Object[]{payAmount, amountBalance, ReturnAmount.abs()});
                    }
                }
                if (BizCollUtil.checkHasTracDownExpensebill(ctx, baseInfo.getId().toString()) > 0) {
                    throw new BizCollException(BizCollException.CANNOTREPAYWITHEXPENSE);
                }
                BigDecimal amountDif = amountPaid.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    baseInfo.setAmountNotPaid(amountNotPaid.add(payAmount).add(amountDif));
                    baseInfo.setAmountPaid(amountPaid.subtract(payAmount).subtract(amountDif));
                    baseInfo.setAmountBalance(amountBalance.subtract(payAmount).subtract(amountDif));
                } else {
                    baseInfo.setAmountNotPaid(amountNotPaid.add(payAmount));
                    baseInfo.setAmountPaid(amountPaid.subtract(payAmount));
                    baseInfo.setAmountBalance(amountBalance.subtract(payAmount));
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"payHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u53d6\u6d88\u4ed8\u6b3eCancelPay \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
        return baseInfo;
    }

    public static BizCollBillBaseInfo cancelPreHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, BigDecimal payAmount, String mode, String RowNumber, PaymentBillInfo paybill) throws BOSException, EASBizException {
        if (!(billInfo instanceof LoanBillInfo)) {
            return null;
        }
        LoanBillInfo baseInfo = (LoanBillInfo)billInfo;
        BigDecimal amountNotPaid = null;
        BigDecimal amountPaid = null;
        BigDecimal amountBalance = null;
        BigDecimal returnAmount = null;
        if (payAmount != null) {
            amountNotPaid = baseInfo.getAmountNotPaid();
            amountPaid = baseInfo.getAmountPaid();
            amountBalance = baseInfo.getAmountBalance() == null ? BizCollUtil.ZERO : baseInfo.getAmountBalance();
            BigDecimal bigDecimal = returnAmount = baseInfo.getReturnAmount() == null ? BizCollUtil.ZERO : baseInfo.getReturnAmount();
            if (mode.equals(SubmitPay)) {
                BigDecimal submitAmount = BizCollUtil.getDestBillAmountCount(ctx, baseInfo, paybill, null);
                if (submitAmount != null && (submitAmount = submitAmount.setScale(2, 4)).compareTo(amountBalance) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.AMOUNTBALANCENOTENOUGHWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.AMOUNTBALANNOTENOUGH);
                }
                if (payAmount.compareTo(amountBalance) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTAMOUNTBALANCE);
                }
            } else if (mode.equals(Pay)) {
                if (payAmount.compareTo(amountBalance) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTAMOUNTBALANCE);
                }
                baseInfo.setAmountBalance(amountBalance.subtract(payAmount));
                baseInfo.setReturnAmount(returnAmount.add(payAmount));
                baseInfo.setReturnDate(new Date());
            } else if (mode.equals(CancelPay)) {
                if (BizCollUtil.checkHasTracDownExpensebill(ctx, baseInfo.getId().toString()) > 0) {
                    throw new BizCollException(BizCollException.CANNOTREPAYWITHEXPENSE);
                }
                if (payAmount.compareTo(returnAmount) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANAMOUNTSENDEDBACKWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANAMOUNTSENDEDBACK);
                }
                baseInfo.setAmountBalance(amountBalance.add(payAmount));
                baseInfo.setReturnAmount(returnAmount.subtract(payAmount));
                baseInfo.setReturnDate(new Date());
            }
        }
        return baseInfo;
    }

    public static ExpenseAccountBillInfo payableHandler(Context ctx, IBizCollBillBase iservice, ExpenseAccountBillInfo baseInfo, BigDecimal otherAmount, String mode, String RowNumber, OtherBillInfo otherBill, Map paramMap) throws BOSException, EASBizException {
        BigDecimal payPrec = new BigDecimal(paramMap.get("payPrec").toString());
        BigDecimal amountNotPaid = null;
        BigDecimal amountPaid = null;
        BigDecimal amountBalance = null;
        BigDecimal amountApproved = null;
        BigDecimal amountEncashed = null;
        if (otherAmount != null) {
            BigDecimal loanCheckAmount;
            amountNotPaid = baseInfo.getAmountNotPaid() == null ? BigDecimal.ZERO : baseInfo.getAmountNotPaid();
            amountPaid = baseInfo.getAmountPaid() == null ? BigDecimal.ZERO : baseInfo.getAmountPaid();
            amountBalance = baseInfo.getAmountBalance() == null ? BigDecimal.ZERO : baseInfo.getAmountBalance();
            amountApproved = baseInfo.getAmountApproved() == null ? BigDecimal.ZERO : baseInfo.getAmountApproved();
            BigDecimal bigDecimal = amountEncashed = baseInfo.getAmountEncashed() == null ? BizCollUtil.ZERO : baseInfo.getAmountEncashed();
            if (mode.equals(Submit)) {
                if (otherAmount.compareTo(amountApproved.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, otherAmount, amountApproved});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{otherAmount, amountApproved});
                }
                BigDecimal submitAmount = BizCollUtil.getOtherAmountCount(ctx, baseInfo, otherBill, mode, paramMap);
                logger.error((Object)("--otherHandler submitAmount=" + submitAmount + ";amountApproved=" + amountApproved + ";number=" + baseInfo.getNumber()));
                if (submitAmount != null && (submitAmount = submitAmount.setScale(2, 4)).compareTo(amountApproved.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.SUBMITAMNOTBIGAMAPPROVEDWITHNUM, new Object[]{RowNumber, submitAmount, amountApproved});
                    }
                    throw new BizCollException(BizCollException.SUBMITAMOUNTNOTALLOWBIGAMOUNTAPPROVED, new Object[]{submitAmount, amountApproved});
                }
            }
            if (mode.equals(AUDIT)) {
                baseInfo.setAmountPayable(baseInfo.getAmountPayable().add(otherAmount));
                logger.error((Object)("--otherPayHandler AmountPayable=" + baseInfo.getAmountPayable() + "otherAmount=" + otherAmount + ";number=" + baseInfo.getNumber()));
            } else if (mode.equals(COUNTERAUDIT)) {
                baseInfo.setAmountPayable(baseInfo.getAmountPayable().subtract(otherAmount));
                logger.error((Object)("--otherPayHandler AmountPayable=" + baseInfo.getAmountPayable() + "otherAmount=" + otherAmount + ";number=" + baseInfo.getNumber()));
            } else if (mode.equals(SETTLEMENTOVER)) {
                loanCheckAmount = amountApproved.subtract(amountEncashed);
                BigDecimal verifyAmountSum = BizCollUtil.getOtherAmountCount(ctx, baseInfo, otherBill, mode, paramMap);
                BigDecimal otherAmountTmp = verifyAmountSum.subtract(loanCheckAmount);
                if (otherAmountTmp.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal amountDif = amountNotPaid.subtract(otherAmountTmp);
                    if (amountDif.abs().compareTo(payPrec) <= 0) {
                        baseInfo.setAmountPaid(otherAmountTmp.add(amountDif));
                        baseInfo.setAmountNotPaid(amountEncashed.subtract(otherAmountTmp.add(amountDif)));
                        baseInfo.setAmountBalance(otherAmountTmp.add(amountDif));
                    } else {
                        baseInfo.setAmountPaid(otherAmountTmp);
                        baseInfo.setAmountNotPaid(amountEncashed.subtract(otherAmountTmp));
                        baseInfo.setAmountBalance(otherAmountTmp);
                    }
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"otherPayHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u5e94\u4ed8\u5355\u7ed3\u7b97 \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",otherAmount:" + verifyAmountSum + "," + otherAmountTmp + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            } else if (mode.equals(COUNTERSETTLEMENT)) {
                loanCheckAmount = amountApproved.subtract(amountEncashed);
                BigDecimal verifyAmountSum = BizCollUtil.getOtherAmountCount(ctx, baseInfo, otherBill, mode, paramMap);
                BigDecimal otherAmountTmp = verifyAmountSum.subtract(loanCheckAmount);
                if (otherAmountTmp.compareTo(BigDecimal.ZERO) >= 0) {
                    BigDecimal amountDif = amountPaid.subtract(otherAmountTmp);
                    if (amountDif.abs().compareTo(payPrec) <= 0) {
                        otherAmountTmp = otherAmountTmp.add(amountDif);
                        baseInfo.setAmountPaid(otherAmountTmp);
                        baseInfo.setAmountNotPaid(amountEncashed.subtract(otherAmountTmp));
                        baseInfo.setAmountBalance(otherAmountTmp);
                    } else {
                        baseInfo.setAmountPaid(otherAmountTmp);
                        baseInfo.setAmountNotPaid(amountEncashed.subtract(otherAmountTmp));
                        baseInfo.setAmountBalance(otherAmountTmp);
                    }
                } else {
                    baseInfo.setAmountPaid(BigDecimal.ZERO);
                    baseInfo.setAmountNotPaid(amountEncashed);
                    baseInfo.setAmountBalance(BigDecimal.ZERO);
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"otherPayHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u5e94\u4ed8\u5355\u53cd\u7ed3\u7b97 \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",otherAmount:" + verifyAmountSum + "," + otherAmountTmp + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
        return baseInfo;
    }

    public static LoanBillInfo returnHandler(Context ctx, IBizCollBillBase iservice, LoanBillInfo loanBillInfo, BigDecimal payAmount, String mode, String RowNumber, String paybillid, Map paramMap) throws BOSException, EASBizException {
        ArrayList payEntryies = (ArrayList)paramMap.get("payEntryies");
        PaymentBillInfo paybill = (PaymentBillInfo)paramMap.get("paybill");
        boolean isFromSingle = (Boolean)paramMap.get("isFromSingle");
        BigDecimal payPrec = new BigDecimal(paramMap.get("CP080").toString());
        BigDecimal amountBalance = null;
        BigDecimal returnAmount = null;
        boolean isHandleDif = false;
        boolean isEntriesReverse = false;
        if (payAmount != null) {
            amountBalance = loanBillInfo.getAmountBalance();
            returnAmount = loanBillInfo.getReturnAmount();
            if (amountBalance != null) {
                amountBalance = amountBalance.setScale(2, 4);
            }
            if (returnAmount == null) {
                returnAmount = BizCollUtil.ZERO;
            }
            returnAmount = returnAmount.setScale(2, 4);
            isEntriesReverse = BillReverseHandler.isEntriesReverse(loanBillInfo, paybill, isFromSingle);
            if (mode.equals(SubmitReturn)) {
                BigDecimal doingAmount = BizCollUtil.ZERO;
                if (paybillid != null) {
                    doingAmount = BizCollUtil.getReturenAmountCount(ctx, loanBillInfo, paybillid, "");
                }
                logger.error((Object)("--returnHandler returnAmount=" + returnAmount + ";amountBalance=" + amountBalance + ";doingAmount=" + doingAmount + ";payAmount=" + payAmount + ";number=" + loanBillInfo.getNumber()));
                if (payAmount.compareTo(amountBalance.add(doingAmount).add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber, loanBillInfo.getNumber(), payAmount, amountBalance, doingAmount.abs()});
                    }
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE, new Object[]{loanBillInfo.getNumber(), payAmount, amountBalance, doingAmount.abs()});
                }
                if (isEntriesReverse) {
                    BigDecimal amountDif = amountBalance.subtract(payAmount);
                    if (amountDif.abs().compareTo(payPrec) <= 0) {
                        payAmount = payAmount.add(amountDif);
                        isHandleDif = true;
                    }
                    BillReverseHandler.returnLoanBillEntry(ctx, loanBillInfo, paybill, payAmount, mode, payEntryies, payPrec, isFromSingle, isHandleDif, isEntriesReverse);
                }
            } else if (mode.equals(Return)) {
                BigDecimal amountDif = amountBalance.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    payAmount = payAmount.add(amountDif);
                    isHandleDif = true;
                }
                if (payAmount.compareTo(amountBalance) > 0 && !BizCollUtil.isRePayMentBill(paybillid)) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber, loanBillInfo.getNumber(), payAmount, amountBalance, "0"});
                    }
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE, new Object[]{loanBillInfo.getNumber(), payAmount, amountBalance, "0"});
                }
                loanBillInfo.setReturnAmount(returnAmount.add(payAmount));
                loanBillInfo.setAmountBalance(amountBalance.subtract(payAmount));
                loanBillInfo.setReturnDate(new Date());
                BillReverseHandler.returnLoanBillEntry(ctx, loanBillInfo, paybill, payAmount, mode, payEntryies, payPrec, isFromSingle, isHandleDif, isEntriesReverse);
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"returnHandler", (BOSObjectType)loanBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(loanBillInfo.getId()), (String)("\u8fd8\u6b3eReturn \u5355\u636e\u7f16\u7801\uff1a" + loanBillInfo.getNumber() + ",payAmount:" + payAmount + ",\u8fd8\u6b3e\u91d1\u989d\uff1a" + loanBillInfo.getReturnAmount() + ",\u53ef\u7528\u4f59\u989d\uff1a" + loanBillInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)loanBillInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            } else if (mode.equals(CancelReturn)) {
                BigDecimal amountDif = returnAmount.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    payAmount = payAmount.add(amountDif);
                    isHandleDif = true;
                }
                if (returnAmount.subtract(payAmount).compareTo(BizCollUtil.ZERO) <= 0) {
                    loanBillInfo.setReturnDate(null);
                }
                loanBillInfo.setReturnAmount(returnAmount.subtract(payAmount));
                loanBillInfo.setAmountBalance(amountBalance.add(payAmount));
                BillReverseHandler.returnLoanBillEntry(ctx, loanBillInfo, paybill, payAmount, mode, payEntryies, payPrec, isFromSingle, isHandleDif, isEntriesReverse);
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"returnHandler", (BOSObjectType)loanBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(loanBillInfo.getId()), (String)("\u53d6\u6d88\u8fd8\u6b3eCancelReturn \u5355\u636e\u7f16\u7801\uff1a" + loanBillInfo.getNumber() + ",payAmount:" + payAmount + ",\u8fd8\u6b3e\u91d1\u989d\uff1a" + loanBillInfo.getReturnAmount() + ",\u53ef\u7528\u4f59\u989d\uff1a" + loanBillInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)loanBillInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
        return loanBillInfo;
    }

    private static BigDecimal checkVoucherOperations(Context ctx, String voucherID, VoucherTypeEnum voucherType, BigDecimal payAmount, BigDecimal amountBalance) throws BizCollException {
        BigDecimal compareAmount = null;
        try {
            String selectOql;
            VoucherOperationsCollection con;
            if (iVoucherOperation == null) {
                iVoucherOperation = VoucherOperationsFactory.getLocalInstance(ctx);
            }
            if ((con = iVoucherOperation.getCollection(String.format(selectOql = "select id, voucherID, billID, amount where voucherID='%s'", voucherID))) != null && con.size() > 0) {
                operationInfo = con.get(0);
                BigDecimal hisAmount = operationInfo.getAmount();
                if (hisAmount != null) {
                    hisAmount = hisAmount.setScale(2, 4);
                    if (VoucherTypeEnum.PAYVOUCHER.equals((Object)voucherType)) {
                        if (hisAmount.compareTo(payAmount.add(amountBalance)) > 0) {
                            throw new BizCollException(BizCollException.CANNOTPAY);
                        }
                    } else if (hisAmount.compareTo(payAmount.subtract(amountBalance)) < 0) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE);
                    }
                    compareAmount = payAmount.subtract(hisAmount);
                }
            } else {
                operationInfo = null;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return compareAmount;
    }

    @Deprecated
    private static BigDecimal checkVoucherOperations(Context ctx, String voucherID, String voucherType, BigDecimal payAmount, BigDecimal amountBalance) throws BizCollException {
        BigDecimal compareAmount = null;
        try {
            String selectOql;
            VoucherOperationsCollection con;
            if (iVoucherOperation == null) {
                iVoucherOperation = VoucherOperationsFactory.getLocalInstance(ctx);
            }
            if ((con = iVoucherOperation.getCollection(String.format(selectOql = "select id, voucherID, billID, amount where voucherID='%s'", voucherID))) != null && con.size() > 0) {
                operationInfo = con.get(0);
                BigDecimal hisAmount = operationInfo.getAmount();
                if (hisAmount != null) {
                    hisAmount = hisAmount.setScale(2, 4);
                    if ("isPay".equals(voucherType)) {
                        if (hisAmount.compareTo(payAmount.add(amountBalance)) > 0) {
                            throw new BizCollException(BizCollException.CANNOTPAY);
                        }
                    } else if (hisAmount.compareTo(payAmount.subtract(amountBalance)) < 0) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE);
                    }
                    compareAmount = payAmount.subtract(hisAmount);
                }
            } else {
                operationInfo = null;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return compareAmount;
    }

    private static void updateVoucherOperation(Context ctx, String billid, String voucherID, BigDecimal amount) {
        try {
            if (iVoucherOperation == null) {
                iVoucherOperation = VoucherOperationsFactory.getLocalInstance(ctx);
            }
            if (operationInfo != null) {
                operationInfo.setAmount(amount);
                iVoucherOperation.update((IObjectPK)new ObjectUuidPK(operationInfo.getId()), operationInfo);
            } else {
                operationInfo = new VoucherOperationsInfo();
                operationInfo.setBillID(billid);
                operationInfo.setVoucherID(voucherID);
                operationInfo.setAmount(amount);
                iVoucherOperation.addnew(operationInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private static void updateMoreToOneVoucherOPSInfo(Context ctx, String billid, String voucherID, BigDecimal amount) throws BOSException {
        String queryOql = "select id,voucherID,billID,amount where voucherID='%s' and billID='%s'";
        IMoreToOneVoucherOPS iMoreToOneVoucher = MoreToOneVoucherOPSFactory.getLocalInstance(ctx);
        MoreToOneVoucherOPSCollection con = iMoreToOneVoucher.getCollection(String.format(queryOql, voucherID, billid));
        if (con == null || con.size() <= 0) {
            MoreToOneVoucherOPSInfo moreToOneVoucherOPSInfo = new MoreToOneVoucherOPSInfo();
            moreToOneVoucherOPSInfo.setBillID(billid);
            moreToOneVoucherOPSInfo.setVoucherID(voucherID);
            moreToOneVoucherOPSInfo.setAmount(amount);
            iMoreToOneVoucher.addnew(moreToOneVoucherOPSInfo);
        }
    }

    private static void deleteVoucherOperation(Context ctx, String voucherID) {
        try {
            if (iVoucherOperation == null) {
                iVoucherOperation = VoucherOperationsFactory.getLocalInstance(ctx);
            }
            iVoucherOperation.delete("where voucherID='" + voucherID + "'");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static boolean getPayMentOperation(BigDecimal payAmount) {
        if (payAmount != null && payAmount.compareTo(BizCollUtil.ZERO) >= 0) {
            return true;
        }
        if (payAmount != null && payAmount.compareTo(BizCollUtil.ZERO) < 0) {
            return false;
        }
        return false;
    }

    private static void checkTracDownPaybillState(Context ctx, String billid) throws BOSException, EASBizException {
        if (BizCollUtil.checkTracDownPaybill(ctx, billid, "true") > 0) {
            throw new BizCollException(BizCollException.CANNOTPAY);
        }
    }

    private static void checkTracDownVoucherState(Context ctx, String billid, String voucherId) throws BOSException, EASBizException {
        if (BizCollUtil.checkTracDownVoucherState(ctx, billid, voucherId, 0, null) > 0) {
            throw new BizCollException(BizCollException.CANNOTVOUCHER);
        }
    }

    public static void checkSourceBillHasClose(Context ctx, BizCollBillBaseInfo baseInfo, String RowNumber) throws BOSException, EASBizException {
        if (StateEnum.CLOSED.equals((Object)baseInfo.getState())) {
            if (RowNumber != null) {
                throw new BizCollException(BizCollException.ISSOURCEBILLCLOSEWITHNUM, new Object[]{RowNumber});
            }
            throw new BizCollException(BizCollException.ISSOURCEBILLCLOSE);
        }
    }

    private static void setActionFlag(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, String actionFlag) throws BOSException, EASBizException {
        billInfo.setString("actionFlag", actionFlag);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("actionFlag"));
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    protected static void reWriteBillState(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, StateEnum state) throws BOSException, EASBizException {
        billInfo.setState(state);
        iservice.updatePartial((CoreBaseInfo)billInfo, BillReverseHandler.getBillSic("state"));
    }

    protected static void reWriteBillPayDate(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, Date date) throws BOSException, EASBizException {
        billInfo.setPayDate(date);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("payDate"));
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    protected static void reWriteBillAmountPaid(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, boolean isPay) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amountPaid"));
        selector.add(new SelectorItemInfo("amountNotPaid"));
        if (isPay) {
            BigDecimal amountApproved = billInfo.getAmountApproved();
            billInfo.setAmountPaid(amountApproved);
            billInfo.setAmountNotPaid(BizCollUtil.ZERO);
        } else {
            BigDecimal amountApproved = billInfo.getAmountApproved();
            billInfo.setAmountPaid(BizCollUtil.ZERO);
            billInfo.setAmountNotPaid(amountApproved);
        }
        iservice.updatePartial((CoreBaseInfo)billInfo, selector);
    }

    public static void updateBillVoucherFlag(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, String fieldName, boolean isVouchered) throws BOSException, EASBizException {
        billInfo.setBoolean(fieldName, isVouchered);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(fieldName));
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private static void checkAmountEncashed(Context ctx, BizCollBillBaseInfo baseInfo, String checkType) throws BOSException, EASBizException {
        ExpenseAccountBillInfo info = (ExpenseAccountBillInfo)baseInfo;
        if (checkType.equals("isPay")) {
            if (info.getAmountEncashed() == null || info.getAmountEncashed().compareTo(BizCollUtil.ZERO) <= 0) {
                throw new BizCollException(BizCollException.CANNOTVOUCHERBYEXPENSETOPAY);
            }
        } else if (!(!checkType.equals("isVoucher") || info.getAmountEncashed() == null || info.getAmountEncashed().compareTo(BizCollUtil.ZERO) <= 0 || StateEnum.ALREADYPAYMENT.equals((Object)info.getState()) || StateEnum.ALREADYVOUCHER.equals((Object)info.getState()) || StateEnum.ISSUSPENSEACCOUNT.equals((Object)info.getState()) || StateEnum.CLOSED.equals((Object)info.getState()))) {
            throw new BizCollException(BizCollException.CANNOTVOUCHERBYEXPENSE);
        }
    }

    public static SelectorItemCollection getBillSic(String type) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        if ("id".equals(type)) {
            return sic;
        }
        sic.add(new SelectorItemInfo("applierCompany.id"));
        if (type.equals("return") || type.equals("bill")) {
            sic.add(new SelectorItemInfo("returnAmount"));
            sic.add(new SelectorItemInfo("returnDate"));
            sic.add(new SelectorItemInfo("amountBalance"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("amountPaidOri"));
            sic.add(new SelectorItemInfo("amountNotPaidOri"));
            sic.add(new SelectorItemInfo("amountApproved"));
        } else if (type.equals("pay") || type.equals("bill")) {
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("amountApproved"));
            sic.add(new SelectorItemInfo("amountPaidOri"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountNotPaidOri"));
            sic.add(new SelectorItemInfo("amountBalance"));
            sic.add(new SelectorItemInfo("amountBalanceOri"));
        } else if (type.equals("payable")) {
            sic.add(new SelectorItemInfo("amountPayable"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("amountBalance"));
        }
        return sic;
    }

    public static SelectorItemCollection getBillUpdateSicForOther(String mode) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (AUDIT.equals(mode) || COUNTERAUDIT.equals(mode)) {
            sic.add(new SelectorItemInfo("amountPayable"));
        } else if (SETTLEMENT.equals(mode) || COUNTERSETTLEMENT.equals(mode)) {
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("amountBalance"));
        }
        return sic;
    }

    public static SelectorItemCollection getRePayMentSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.amountOri"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        return sic;
    }

    public static SelectorItemCollection getPayMentSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("actPayLocAmt"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeID"));
        sic.add(new SelectorItemInfo("payerAccount.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.localAmt"));
        sic.add(new SelectorItemInfo("entries.actualAmt"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("isCreatePrePaymentBill"));
        sic.add(new SelectorItemInfo("isCreatePayBill"));
        sic.add(new SelectorItemInfo("payBillType.id"));
        sic.add(new SelectorItemInfo("payBillType.number"));
        return sic;
    }

    public static boolean isEntriesReverse(LoanBillInfo loanBillInfo, PaymentBillInfo paybill, boolean isFromSingle) {
        boolean isEntriesReverse = false;
        AbstractObjectCollection con = (AbstractObjectCollection)loanBillInfo.get("entries");
        if (con != null) {
            CoreBillEntryBaseInfo loanEntryInfo = null;
            String sourceBillEntryId = paybill.getEntries().get(0).getSourceBillEntryId();
            if (!StringUtils.isEmpty((String)sourceBillEntryId)) {
                int size = con.size();
                for (int i = 0; i < size; ++i) {
                    loanEntryInfo = (CoreBillEntryBaseInfo)con.getObject(i);
                    if (!sourceBillEntryId.equals(loanEntryInfo.getId().toString())) continue;
                    isEntriesReverse = true;
                    break;
                }
            }
        }
        return isEntriesReverse;
    }

    public static void returnLoanBillEntry(Context ctx, LoanBillInfo loanBillInfo, PaymentBillInfo paybill, BigDecimal payAmount, String mode, ArrayList<PaymentBillEntryInfo> payEntryies, BigDecimal payPrec, boolean isFromSingle, boolean isHandleDif, boolean isEntriesReverse) throws EASBizException, BOSException {
        AbstractObjectCollection con = (AbstractObjectCollection)loanBillInfo.get("entries");
        if (con != null) {
            BizCollUtil.sortCollection(new String[]{"id"}, con);
            CoreBillEntryBaseInfo loanEntryInfo = null;
            if (isEntriesReverse) {
                if (isFromSingle) {
                    PaymentBillEntryCollection entries = paybill.getEntries();
                    payEntryies = new ArrayList();
                    PaymentBillEntryInfo payEntryInfo = null;
                    int size = entries.size();
                    for (int i = 0; i < size; ++i) {
                        payEntryInfo = entries.get(i);
                        payEntryies.add(payEntryInfo);
                    }
                }
                HashMap<String, CoreBillEntryBaseInfo> loanEntriesMap = new HashMap<String, CoreBillEntryBaseInfo>();
                int size = con.size();
                for (int i = 0; i < size; ++i) {
                    loanEntryInfo = (CoreBillEntryBaseInfo)con.getObject(i);
                    loanEntriesMap.put(loanEntryInfo.getId().toString(), loanEntryInfo);
                }
                BigDecimal payAmountOfEntries = BizCollUtil.ZERO;
                PaymentBillEntryInfo paymentBillEntryInfo = null;
                int size2 = payEntryies.size();
                for (int i = 0; i < size2; ++i) {
                    paymentBillEntryInfo = (PaymentBillEntryInfo)payEntryies.get(i);
                    int seq = paymentBillEntryInfo.getSeq();
                    payAmountOfEntries = BillReverseHandler.getPayAmountByOri(ctx, loanBillInfo, paybill, (BigDecimal)paymentBillEntryInfo.get("localAmt")).abs();
                    loanEntryInfo = (CoreBillEntryBaseInfo)loanEntriesMap.get(paymentBillEntryInfo.getSourceBillEntryId());
                    BillReverseHandler.handleLoanEntry(ctx, loanBillInfo, loanEntryInfo, payAmountOfEntries, payPrec, mode, isHandleDif, seq);
                }
            } else {
                BillReverseHandler.handleLoanEntryOneByOne(ctx, loanBillInfo, con, payAmount, mode, false);
            }
        }
    }

    public static void handleLoanEntry(Context ctx, LoanBillInfo loanBillInfo, CoreBillEntryBaseInfo entryInfo, BigDecimal payAmount, BigDecimal payPrec, String mode, boolean isHandleDif, int seq) throws EASBizException, BOSException {
        Object iLoanEntryService = null;
        if (loanBillInfo instanceof DailyLoanBillInfo) {
            iLoanEntryService = DailyLoanBillEntryFactory.getLocalInstance(ctx);
        } else if (loanBillInfo instanceof EvectionLoanBillInfo) {
            iLoanEntryService = EvectionLoanBillEntryFactory.getLocalInstance(ctx);
        } else {
            return;
        }
        iLoanEntryService.updatePartial((CoreBaseInfo)entryInfo, BillReverseHandler.getReturnLoanEntrySic("lock"));
        entryInfo = (CoreBillEntryBaseInfo)iLoanEntryService.getValue((IObjectPK)new ObjectUuidPK(entryInfo.getId()), BillReverseHandler.getReturnLoanEntrySic("select"));
        int convertModeEnum = 0;
        BigDecimal amountPaid = null;
        BigDecimal amountPaidOri = null;
        BigDecimal amountBalance = null;
        BigDecimal amountBalanceOri = null;
        BigDecimal exchangeRate = null;
        BigDecimal payAmountOri = null;
        convertModeEnum = (Integer)entryInfo.get("convertMode");
        exchangeRate = entryInfo.getBigDecimal("exchangeRate");
        if (entryInfo.getBigDecimal("amountPaid") == null) {
            entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
        }
        payAmountOri = convertModeEnum == 0 ? payAmount.divide(exchangeRate, 2, 4) : payAmount.multiply(exchangeRate).setScale(2, 4);
        if (mode.equals(SubmitReturn)) {
            amountBalance = entryInfo.getBigDecimal("amountBalance");
            if ((payAmount.compareTo(amountBalance) >= 0 || isHandleDif) && payAmount.compareTo(amountBalance.add(payPrec)) > 0) {
                throw new BizCollException(BizCollException.LOANBALANCENOTENOUGH, new Object[]{seq, payAmount, amountBalance});
            }
            return;
        }
        if (mode.equals(Return)) {
            amountBalance = entryInfo.getBigDecimal("amountBalance");
            amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri");
            if (payAmount.compareTo(amountBalance) >= 0 || isHandleDif) {
                entryInfo.setBigDecimal("amountBalance", BizCollUtil.ZERO);
                entryInfo.setBigDecimal("amountBalanceOri", BizCollUtil.ZERO);
                entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(amountBalance));
                payAmount = payAmount.subtract(amountBalance);
            } else {
                entryInfo.setBigDecimal("amountBalance", amountBalance.subtract(payAmount));
                entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.subtract(payAmountOri));
                entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(payAmount));
                payAmount = BizCollUtil.ZERO;
            }
        } else if (mode.equals(CancelReturn)) {
            amountPaid = entryInfo.getBigDecimal("amountPaid");
            amountPaidOri = convertModeEnum == 0 ? amountPaid.divide(exchangeRate, 2, 4) : amountPaid.multiply(exchangeRate).setScale(2, 4);
            if (payAmount.compareTo(amountPaid) >= 0 || isHandleDif) {
                entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(entryInfo.getBigDecimal("amountPaid")));
                entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(amountPaidOri));
                entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
                payAmount = payAmount.subtract(amountPaid);
            } else {
                entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(payAmountOri));
                entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(payAmount));
                entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").subtract(payAmount));
                payAmount = BizCollUtil.ZERO;
            }
        }
        iLoanEntryService.updatePartial((CoreBaseInfo)entryInfo, BillReverseHandler.getReturnLoanEntrySic("update"));
    }

    public static void handleLoanEntryOneByOne(Context ctx, LoanBillInfo loanBillInfo, AbstractObjectCollection loanBillEntries, BigDecimal payAmount, String mode, boolean isHandleDif) throws EASBizException, BOSException {
        if (loanBillEntries != null) {
            Object iLoanEntryService = null;
            if (loanBillInfo instanceof DailyLoanBillInfo) {
                iLoanEntryService = DailyLoanBillEntryFactory.getLocalInstance(ctx);
            } else if (loanBillInfo instanceof EvectionLoanBillInfo) {
                iLoanEntryService = EvectionLoanBillEntryFactory.getLocalInstance(ctx);
            } else {
                return;
            }
            CoreBillEntryBaseInfo entryInfo = null;
            int convertModeEnum = 0;
            BigDecimal amountPaid = null;
            BigDecimal amountPaidOri = null;
            BigDecimal amountBalance = null;
            BigDecimal amountBalanceOri = null;
            BigDecimal exchangeRate = null;
            BigDecimal payAmountOri = null;
            int size = loanBillEntries.size();
            for (int i = 0; i < size; ++i) {
                if (payAmount.compareTo(BizCollUtil.ZERO) <= 0) continue;
                entryInfo = (CoreBillEntryBaseInfo)loanBillEntries.getObject(i);
                iLoanEntryService.updatePartial((CoreBaseInfo)entryInfo, BillReverseHandler.getReturnLoanEntrySic("lock"));
                entryInfo = (CoreBillEntryBaseInfo)iLoanEntryService.getValue((IObjectPK)new ObjectUuidPK(entryInfo.getId()), BillReverseHandler.getReturnLoanEntrySic("select"));
                convertModeEnum = (Integer)entryInfo.get("convertMode");
                exchangeRate = entryInfo.getBigDecimal("exchangeRate");
                if (entryInfo.getBigDecimal("amountPaid") == null) {
                    entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
                }
                payAmountOri = convertModeEnum == 0 ? payAmount.divide(exchangeRate, 2, 4) : payAmount.multiply(exchangeRate).setScale(2, 4);
                if (mode.equals(Return)) {
                    amountBalance = entryInfo.getBigDecimal("amountBalance");
                    amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri");
                    if (payAmount.compareTo(amountBalance) >= 0 || isHandleDif) {
                        entryInfo.setBigDecimal("amountBalance", BizCollUtil.ZERO);
                        entryInfo.setBigDecimal("amountBalanceOri", BizCollUtil.ZERO);
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(amountBalance));
                        payAmount = payAmount.subtract(amountBalance);
                    } else {
                        entryInfo.setBigDecimal("amountBalance", amountBalance.subtract(payAmount));
                        entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.subtract(payAmountOri));
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(payAmount));
                        payAmount = BizCollUtil.ZERO;
                    }
                } else if (mode.equals(CancelReturn)) {
                    amountPaid = entryInfo.getBigDecimal("amountPaid");
                    amountPaidOri = convertModeEnum == 0 ? amountPaid.divide(exchangeRate, 2, 4) : amountPaid.multiply(exchangeRate).setScale(2, 4);
                    if (payAmount.compareTo(amountPaid) >= 0 || isHandleDif) {
                        entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(entryInfo.getBigDecimal("amountPaid")));
                        entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(amountPaidOri));
                        entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
                        payAmount = payAmount.subtract(amountPaid);
                    } else {
                        entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(payAmountOri));
                        entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(payAmount));
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").subtract(payAmount));
                        payAmount = BizCollUtil.ZERO;
                    }
                }
                iLoanEntryService.updatePartial((CoreBaseInfo)entryInfo, BillReverseHandler.getReturnLoanEntrySic("update"));
            }
        }
    }

    public static SelectorItemCollection getReturnLoanEntrySic(String type) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if ("lock".equals(type)) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("exchangeRate"));
            return sic;
        }
        if ("select".equals(type)) {
            sic.add(new SelectorItemInfo("currencyType.id"));
            sic.add(new SelectorItemInfo("exchangeRate"));
            sic.add(new SelectorItemInfo("convertMode"));
            sic.add(new SelectorItemInfo("exchangeRatePrecision"));
        }
        if ("select".equals(type) || "update".equals(type)) {
            sic.add(new SelectorItemInfo("amountBalance"));
            sic.add(new SelectorItemInfo("amountBalanceOri"));
            sic.add(new SelectorItemInfo("amountPaid"));
        }
        return sic;
    }

    public static void updateBillProperty(Context ctx, BizCollBillBaseInfo billInfo, String fieldName, Object fieldValue) throws EASBizException, BOSException {
        billInfo.put(fieldName, fieldValue);
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(ctx, billInfo.getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(fieldName));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        iCoreBase.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private void deleteVoucherHandler(Context ctx, BizCollBillBaseInfo billInfo, boolean withFi, boolean withCas, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        String billId = billInfo.getId().toString();
        StateEnum billState = billInfo.getState();
        ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
        if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
            String queryOql = "SELECT ID WHERE BILLID = '%s' AND VOUCHERTYPE != '%s'";
            if (StateEnum.CLOSED.equals((Object)billState)) {
                throw new BizCollException(BizCollException.CANNOT_DELVOUCHER_ISCLOSED);
            }
            if (billState.equals((Object)StateEnum.ALREADYPAYMENT)) {
                throw new BizCollException(BizCollException.CANNOT_DELVOUCHER_ISPAYMENT);
            }
            if (iCreateVoucherRecord.exists(String.format(queryOql, billId, voucherType.getValue()))) {
                throw new BizCollException(BizCollException.CANNOTDELETESUSPENSEVOUCHER);
            }
            BillReverseHandler.updateBillProperty(ctx, billInfo, "isDapVouchered", 0);
            BillReverseHandler.updateBillProperty(ctx, billInfo, "actionFlag", null);
        } else {
            String queryOql = "SELECT FID WHERE BILLID='%s' AND VOUCHERTYPE!='%s'";
            if (!iCreateVoucherRecord.exists(String.format(queryOql, billId, "20"))) {
                BillReverseHandler.updateBillProperty(ctx, billInfo, "isVouchered", 0);
            }
            IBizCollBillBase iBizCollBillBase = BizCollUtil.getBillInstance(ctx, billInfo);
            if (VoucherTypeEnum.RETURNVOUCHER.equals((Object)voucherType)) {
                BillReverseHandler.checkSourceBillHasClose(ctx, billInfo, null);
                BigDecimal amountBalance = BigDecimal.ZERO;
                if (billInfo instanceof LoanBillInfo) {
                    amountBalance = billInfo.getAmountApproved();
                } else if (billInfo instanceof ExpenseAccountBillInfo) {
                    amountBalance = (BigDecimal)billInfo.get("amountEncashed");
                }
                billInfo.put("returnAmount", BizCollUtil.ZERO);
                billInfo.put("amountBalance", amountBalance);
                iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, BillReverseHandler.getBillSic("return"));
            } else if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
                if (billInfo instanceof LoanBillInfo) {
                    if (BizCollUtil.checkHasTracDownExpensebill(ctx, billId) > 0) {
                        throw new BizCollException(BizCollException.CANNOTREPAYWITHEXPENSE);
                    }
                    queryOql = "SELECT FID WHERE BILLID='%s' AND VOUCHERTYPE='%s'";
                    if (iCreateVoucherRecord.exists(String.format(queryOql, billId, "40"))) {
                        throw new BizCollException(BizCollException.EXSIT_RETURN_VOUCHER);
                    }
                    ArrayList<String> bosTypes = new ArrayList<String>();
                    bosTypes.add(new RePaymentBillInfo().getBOSType().toString());
                    if (BizCollUtil.getTraceDownBillCount(ctx, billId, bosTypes) > 0) {
                        throw new BizCollException(BizCollException.VOUCHEREXREPAY);
                    }
                }
                if (withFi && !withCas) {
                    BigDecimal amountNotPaid = BigDecimal.ZERO;
                    if (billInfo instanceof LoanBillInfo) {
                        amountNotPaid = billInfo.getAmountApproved();
                    } else if (billInfo instanceof ExpenseAccountBillInfo) {
                        amountNotPaid = (BigDecimal)billInfo.get("amountEncashed");
                    }
                    billInfo.setState(StateEnum.CHECKED);
                    billInfo.setAmountPaid(BizCollUtil.ZERO);
                    billInfo.setAmountNotPaid(amountNotPaid);
                    billInfo.setAmountBalance(BizCollUtil.ZERO);
                    iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, BillReverseHandler.getBillSic("pay"));
                }
            }
        }
    }

    private void submitSingleVoucherHandler(Context ctx, BizCollBillBaseInfo billInfo, VoucherTypeEnum voucherType, boolean withFi, boolean withCas, boolean billCanCreateVoucher) throws EASBizException, BOSException {
        String billId = billInfo.getId().toString();
        String billVoucherField = "isVouchered";
        StateEnum billState = billInfo.getState();
        if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
            billVoucherField = "isDapVouchered";
        } else if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
            BigDecimal amountPaid = BizCollUtil.ZERO;
            if (billInfo instanceof LoanBillInfo) {
                amountPaid = billInfo.getAmountApproved();
            } else if (billInfo instanceof ExpenseAccountBillInfo) {
                boolean existCheckLoan;
                BigDecimal amountEncashed;
                amountPaid = amountEncashed = (BigDecimal)billInfo.get("amountEncashed");
                AbstractObjectCollection billEntries = (AbstractObjectCollection)billInfo.get("loanCheckEntries");
                boolean bl = existCheckLoan = billEntries != null && billEntries.size() > 0;
                if (!billCanCreateVoucher) {
                    if (existCheckLoan && (amountEncashed.compareTo(BizCollUtil.ZERO) == 0 && StateEnum.CHECKED.equals((Object)billState) || StateEnum.ALREADYPAYMENT.equals((Object)billState))) {
                        BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.CLOSED);
                    }
                } else if (amountEncashed.compareTo(BizCollUtil.ZERO) == 0 || StateEnum.ALREADYPAYMENT.equals((Object)billState)) {
                    BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.CLOSED);
                }
            }
            if (withFi && !withCas && billInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) != 0) {
                IBizCollBillBase iBizCollBillBase = BizCollUtil.getBillInstance(ctx, billInfo);
                billInfo.setAmountNotPaid(BizCollUtil.ZERO);
                billInfo.setAmountPaid(amountPaid);
                billInfo.setAmountBalance(amountPaid);
                SelectorItemCollection updateSelector = BillReverseHandler.getBillSic("pay");
                iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, updateSelector);
            }
        } else if (VoucherTypeEnum.RETURNVOUCHER.equals((Object)voucherType)) {
            IBizCollBillBase iBizCollBillBase = BizCollUtil.getBillInstance(ctx, billInfo);
            BigDecimal returnAmount = BizCollUtil.ZERO;
            if (billInfo instanceof LoanBillInfo) {
                returnAmount = billInfo.getAmountBalance();
            }
            billInfo.put("returnAmount", returnAmount);
            billInfo.put("returnDate", new Date());
            billInfo.put("amountBalance", BizCollUtil.ZERO);
            iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, BillReverseHandler.getBillSic("return"));
        }
    }

    private void checkExistSameVoucher(Context ctx, String billId, String voucherId, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        String queryOqlTemp = "SELECT ID WHERE BILLID = '%s' AND VOUCHERID != '%s' AND VOUCHERTYPE in ('%s')";
        ArrayList<String> voucherTypes = new ArrayList<String>();
        if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType) || VoucherTypeEnum.PAYVOUCHER.equals((Object)voucherType)) {
            voucherTypes.add("10");
            voucherTypes.add("30");
        } else {
            voucherTypes.add(voucherType.getValue());
        }
        String queryOql = String.format(queryOqlTemp, billId, voucherId, StringUtils.join((Object[])voucherTypes.toArray(), (String)"','"));
        boolean exists = CreateVoucherRecordFactory.getLocalInstance(ctx).exists(queryOql);
        if (exists) {
            throw new BizCollException(BizCollException.NOSAMEVOUCHER);
        }
    }

    protected void saveSingleVoucherHandler(Context ctx, BizCollBillBaseInfo billInfo, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        String billVoucherField = "isVouchered";
        if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
            BillReverseHandler.updateBillProperty(ctx, billInfo, "actionFlag", "T");
            billVoucherField = "isDapVouchered";
        }
        BillReverseHandler.updateBillProperty(ctx, billInfo, billVoucherField, "1");
    }

    protected void updatePayEntryHasAccounted(Context ctx, BizCollBillBaseInfo baseInfo, String voucherId, String hasAccounted) {
        StringBuffer sqlAccountEdString = new StringBuffer();
        try {
            String billid = baseInfo.getId().toString();
            sqlAccountEdString.append("update " + this.getAccountRecordsTable(baseInfo) + " set FhasAccounted= '" + hasAccounted + "',FvoucherId='" + voucherId + "' where fbillid = '" + billid + "'");
            DbUtil.execute((Context)ctx, (String)sqlAccountEdString.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected void updatePayEntryHasNotAccounted(Context ctx, BizCollBillBaseInfo baseInfo, String voucherId, String hasAccounted) {
        StringBuffer sqlAccountEdString = new StringBuffer();
        try {
            String billid = baseInfo.getId().toString();
            sqlAccountEdString.append("update " + this.getAccountRecordsTable(baseInfo) + " set FhasAccounted= '" + hasAccounted + "',FvoucherId = null  where fbillid = '" + billid + "' and fvoucherId = '" + voucherId + "'");
            DbUtil.execute((Context)ctx, (String)sqlAccountEdString.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    protected String getAccountRecordsTable(BizCollBillBaseInfo baseInfo) {
        if (baseInfo instanceof BizAccountBillInfo) {
            return "T_BC_BizAccountBillPayEntry";
        }
        if (baseInfo instanceof TravelAccountBillInfo) {
            return "T_BC_TravelAccountBillPayEntry";
        }
        if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            return "T_BC_PurchaseAccountPayEntry";
        }
        if (baseInfo instanceof BizAccountOutBillInfo) {
            return "T_BC_BizAccountOutBillPayEntry";
        }
        if (baseInfo instanceof DailyLoanBillInfo) {
            return "T_BC_DailyLoanBillPayEntry";
        }
        if (baseInfo instanceof EvectionLoanBillInfo) {
            return "T_BC_EvectionLoanBillPayEntry";
        }
        return null;
    }

    private void updateIsCreatePayBill(Context context, String billTableName, String value, Set<String> sourceBillIds) throws BOSException {
        String sourceBillIdsStr = StringUtils.join(sourceBillIds.iterator(), (String)"','");
        sourceBillIdsStr = "'" + sourceBillIdsStr + "'";
        String updateSql = null;
        updateSql = " UPDATE " + billTableName + " SET FisCreatePayBill=%s WHERE FID in (%s)";
        DbUtil.execute((Context)context, (String)String.format(updateSql, value, sourceBillIdsStr));
    }

    public static void checkBillCanCreate(Context context, Boolean isCreatePrePaymentBill, Boolean isPrePayment, Boolean isCancelPrePayment, DailyLoanBillInfo dailyLoanBillInfo) throws DailyLoanBillException, BOSException {
        if (!isCreatePrePaymentBill.booleanValue()) {
            if (isPrePayment.booleanValue() || isCancelPrePayment.booleanValue()) {
                throw new DailyLoanBillException(DailyLoanBillException.LOANBILLNOTTODEALWITHINTEGRATION);
            }
            if (dailyLoanBillInfo.isIsCreatePrePaymentBill()) {
                throw new DailyLoanBillException(DailyLoanBillException.NOTALLOWEDGENERATEPAYMENTANDPREPAYMENT);
            }
        }
        if (!isPrePayment.booleanValue() && !isCancelPrePayment.booleanValue() && dailyLoanBillInfo.isIsCreatePrePaymentBill() || (isPrePayment.booleanValue() || isCancelPrePayment.booleanValue()) && dailyLoanBillInfo.isIsCreatePayBill()) {
            throw new DailyLoanBillException(DailyLoanBillException.NOTALLOWEDGENERATEPAYMENTANDPREPAYMENT);
        }
        if (!isCancelPrePayment.booleanValue() && dailyLoanBillInfo.isIsCreatePayBill() && dailyLoanBillInfo.isIsCreatePrePaymentBill()) {
            throw new DailyLoanBillException(DailyLoanBillException.NOTALLOWEDGENERATEPAYMENTANDPREPAYMENT);
        }
        if (isPrePayment.booleanValue() && (dailyLoanBillInfo.isIsDapVouchered() && dailyLoanBillInfo.isIsCreatePrePaymentBill() || dailyLoanBillInfo.isIsCreatePrePaymentBill() && dailyLoanBillInfo.isIsVouchered())) {
            throw new DailyLoanBillException(DailyLoanBillException.CANNOTBEGENERATEDPREPAYANDVOUCHER);
        }
        if (isCancelPrePayment.booleanValue() && (dailyLoanBillInfo.isIsDapVouchered() || dailyLoanBillInfo.isIsVouchered())) {
            throw new DailyLoanBillException(DailyLoanBillException.CANNOTBEGENERATEDCANCELPREPAYANDVOUCHER);
        }
        if (isCancelPrePayment.booleanValue() && dailyLoanBillInfo.isIsCreatePayBill() && dailyLoanBillInfo.isIsCreatePrePaymentBill()) {
            throw new DailyLoanBillException(DailyLoanBillException.NOTALLOWEDGENERATEPAYMENTANDCANCELPREPAYMENT);
        }
        if (dailyLoanBillInfo.isIsCreatePayBill() && dailyLoanBillInfo.isIsCreatePrePaymentBill()) {
            throw new DailyLoanBillException(DailyLoanBillException.PREPAYPAYMENTLOANBILLNOTALLOWEPAYBILLRETURN);
        }
        if (isCancelPrePayment.booleanValue()) {
            BillReverseHandler.checkBillCanReturn(context, dailyLoanBillInfo);
        }
    }

    private static void checkBillCanReturn(Context context, DailyLoanBillInfo dailyLoanBillInfo) throws BOSException, DailyLoanBillException {
        try {
            StringBuffer sql = new StringBuffer("select bot.fid from t_bot_relation bot ");
            sql.append(" left join T_BC_BizAccountBill account on account.fid=bot.fdestObjectID");
            sql.append(" left join T_BC_TravelAccountBill travel on travel.fid=bot.fdestObjectID");
            sql.append(" where account.fstate in('25','30') and  travel.fstate in('25','30') and bot.fsrcObjectID='" + dailyLoanBillInfo.getId() + "'");
            IRowSet set = DbUtil.executeQuery((Context)context, (String)sql.toString());
            if (set.size() > 0) {
                throw new DailyLoanBillException(DailyLoanBillException.PREPAYPAYMENTLOANBILLHASBIZACCOUNTCANNOTRETURN);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("returnAmount"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("amountControlType"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.budgetDo"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        return sic;
    }
}

