/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.reverse.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractBizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCommonUtilForWKFacadeFactory;
import com.kingdee.eas.cp.bc.CreateVoucherRecordCollection;
import com.kingdee.eas.cp.bc.CreateVoucherRecordFactory;
import com.kingdee.eas.cp.bc.CreateVoucherRecordInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.ICreateVoucherRecord;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.VoucherTypeEnum;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherReverseUtil {
    public static final String BillInfoKey = "BillInfo";
    public static final String VoucherInfoKey = "VoucherInfo";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.reverse.util.VoucherReverseUtil");
    public static String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";

    public static Map convertBOTRelationToMap(Context ctx, BOTRelationCollection bOTRelationInfos, CoreBillBaseCollection srcBillVOs, IObjectCollection destBillVOs) throws BOSException, EASBizException {
        HashMap<String, Map<String, IObjectCollection>> reverseBillMap = new HashMap<String, Map<String, IObjectCollection>>();
        Map<String, IObjectCollection> billAndVoucherMap = null;
        Object it = null;
        BOTRelationInfo botObj = null;
        IObjectCollection voucherCon = null;
        IObjectValue voucherInfo = null;
        int size = bOTRelationInfos.size();
        for (int i = 0; i < size; ++i) {
            botObj = bOTRelationInfos.get(i);
            if (reverseBillMap.containsKey(botObj.getSrcObjectID())) {
                billAndVoucherMap = (Map)reverseBillMap.get(botObj.getSrcObjectID());
                voucherCon = (IObjectCollection)billAndVoucherMap.get(VoucherInfoKey);
            } else {
                billAndVoucherMap = new HashMap<String, IObjectValue>();
                billAndVoucherMap.put(BillInfoKey, (IObjectCollection)VoucherReverseUtil.getObjectInfo(botObj.getSrcObjectID(), (IObjectCollection)srcBillVOs));
                voucherCon = new CoreBaseCollection();
            }
            voucherInfo = VoucherReverseUtil.getObjectInfo(botObj.getDestObjectID(), destBillVOs);
            if (voucherInfo != null) {
                voucherCon.addObject(voucherInfo);
            }
            billAndVoucherMap.put(VoucherInfoKey, voucherCon);
            reverseBillMap.put(botObj.getSrcObjectID(), billAndVoucherMap);
        }
        return reverseBillMap;
    }

    public static Map convertBOTRelationToMap(Context ctx, List bOTRelationInfos, CoreBillBaseCollection srcBillVOs, List destBillVOs) throws BOSException, EASBizException {
        HashMap<String, Map<String, IObjectCollection>> reverseBillMap = new HashMap<String, Map<String, IObjectCollection>>();
        Map<String, IObjectCollection> billAndVoucherMap = null;
        Object it = null;
        BOTRelationCollection botRelationColl = null;
        BOTRelationInfo botObj = null;
        IObjectCollection voucherCon = null;
        IObjectValue voucherInfo = null;
        int size = bOTRelationInfos.size();
        for (int i = 0; i < size; ++i) {
            if (!(bOTRelationInfos.get(i) instanceof BOTRelationCollection)) continue;
            botRelationColl = (BOTRelationCollection)bOTRelationInfos.get(i);
            int sizeColl = botRelationColl.size();
            for (int j = 0; j < sizeColl; ++j) {
                botObj = botRelationColl.get(j);
                if (reverseBillMap.containsKey(botObj.getSrcObjectID())) {
                    billAndVoucherMap = (Map)reverseBillMap.get(botObj.getSrcObjectID());
                    voucherCon = (IObjectCollection)billAndVoucherMap.get(VoucherInfoKey);
                } else {
                    billAndVoucherMap = new HashMap<String, IObjectValue>();
                    billAndVoucherMap.put(BillInfoKey, (IObjectCollection)VoucherReverseUtil.getObjectInfo(botObj.getSrcObjectID(), (IObjectCollection)srcBillVOs));
                    voucherCon = new CoreBaseCollection();
                }
                voucherInfo = VoucherReverseUtil.getObjectInfo(botObj.getDestObjectID(), destBillVOs);
                if (voucherInfo != null) {
                    voucherCon.addObject(voucherInfo);
                }
                billAndVoucherMap.put(VoucherInfoKey, voucherCon);
                reverseBillMap.put(botObj.getSrcObjectID(), billAndVoucherMap);
            }
        }
        return reverseBillMap;
    }

    public static IObjectValue getObjectInfo(String billId, IObjectCollection billVOs) {
        if (billVOs != null) {
            int size = billVOs.size();
            for (int i = 0; i < size; ++i) {
                if (!billVOs.getObject(i).getString("id").equals(billId)) continue;
                return billVOs.getObject(i);
            }
        }
        return null;
    }

    public static IObjectValue getObjectInfo(String billId, List billVOs) {
        IObjectValue objectInfo = null;
        IObjectCollection billColl = null;
        if (billVOs != null) {
            int size = billVOs.size();
            for (int i = 0; i < size; ++i) {
                if (billVOs.get(i) instanceof IObjectCollection) {
                    billColl = (IObjectCollection)billVOs.get(i);
                    objectInfo = VoucherReverseUtil.getObjectInfo(billId, billColl);
                    if (objectInfo == null) continue;
                    return objectInfo;
                }
                logger.error((Object)"##cp.bc getObjectInfo billVOs is not IObjectCollection");
            }
        }
        return null;
    }

    public static void addVoucherRecord(Context ctx, ICreateVoucherRecord iCreateVoucherRecord, Map billAndVoucherMap, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        BizCollBillBaseInfo bill = (BizCollBillBaseInfo)billAndVoucherMap.get(BillInfoKey);
        IObjectCollection con = (IObjectCollection)billAndVoucherMap.get(VoucherInfoKey);
        IObjectValue voucherInfo = null;
        if (bill != null && con != null) {
            CoreBaseCollection addCon = new CoreBaseCollection();
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                voucherInfo = con.getObject(i);
                CreateVoucherRecordInfo createVoucherRecord = new CreateVoucherRecordInfo();
                createVoucherRecord.setVoucherID(voucherInfo.getString("id"));
                createVoucherRecord.setVoucherNumber(voucherInfo.getString("number"));
                createVoucherRecord.setBillID(bill.getId().toString());
                createVoucherRecord.setBillNumber(bill.getNumber());
                createVoucherRecord.setVoucherType(voucherType);
                createVoucherRecord.setCreateTime(new Timestamp(System.currentTimeMillis()));
                createVoucherRecord.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
                addCon.add((CoreBaseInfo)createVoucherRecord);
            }
            iCreateVoucherRecord.addnewBatchData(addCon);
        }
    }

    public static void voucherBatchReverseSave(Context ctx, Map reverseBillMap, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfoList) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        StringBuilder logStrBu = new StringBuilder(500);
        AbstractBizCollBillBaseInfo billInfo = null;
        IObjectCollection con = null;
        if (reverseBillMap != null) {
            ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
            IBOTMapping ibotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP002");
            paramList.add("CP008");
            paramList.add("CP00801");
            paramList.add("CP00802");
            paramList.add("CP024");
            boolean withFi = false;
            boolean withCas = false;
            boolean withCasPaymentCanSus = false;
            String companyId = "";
            HashMap<String, Map> companyParamMap = new HashMap<String, Map>();
            Map paramMap = null;
            String voucherIds = "";
            String voucherId = "";
            String voucherNumbers = null;
            Map billAndVoucherMap = null;
            Set set = reverseBillMap.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                billAndVoucherMap = (Map)reverseBillMap.get(it.next().toString());
                billInfo = (BizCollBillBaseInfo)billAndVoucherMap.get(BillInfoKey);
                con = (IObjectCollection)billAndVoucherMap.get(VoucherInfoKey);
                if (billInfo == null || billInfo.getApplierCompany() == null) {
                    throw new BizCollException(BizCollException.BILLISNULL);
                }
                companyId = billInfo.getApplierCompany().getId().toString();
                if (companyParamMap.containsKey(companyId)) {
                    paramMap = (Map)companyParamMap.get(companyId);
                } else {
                    paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
                    companyParamMap.put(companyId, paramMap);
                }
                withFi = new Boolean(paramMap.get("CP002").toString());
                withCas = new Boolean(paramMap.get("CP008").toString());
                withCasPaymentCanSus = new Boolean(paramMap.get("CP00802").toString());
                HashMap<String, String> voucherMap = new HashMap<String, String>();
                if (con != null) {
                    voucherId = null;
                    voucherIds = "";
                    voucherNumbers = "";
                    voucherId = con.getObject(0).get("id").toString();
                    int size = con.size();
                    for (int i = 0; i < size; ++i) {
                        voucherMap.put(con.getObject(i).get("id").toString(), con.getObject(i).getString("number"));
                        voucherIds = voucherIds + "'" + con.getObject(i).get("id").toString() + "',";
                        voucherNumbers = voucherNumbers + con.getObject(i).getString("number") + ",";
                    }
                    if (voucherIds.length() > 0) {
                        voucherIds = voucherIds.substring(0, voucherIds.length() - 1);
                        voucherNumbers = voucherNumbers.substring(0, voucherNumbers.length() - 1);
                    }
                }
                VoucherTypeEnum voucherType = VoucherTypeEnum.VOUCHER;
                boolean isSuspendDap = "Y".equals(billInfo.get("actionFlag"));
                if (isSuspendDap) {
                    BillReverseHandler.updateBillProperty(ctx, (BizCollBillBaseInfo)billInfo, "actionFlag", null);
                    voucherType = VoucherTypeEnum.DAPVOUCHER;
                } else {
                    boolean isReturnVoucher = "payVoucher".equals(billInfo.get("voucherFlag"));
                    if (isReturnVoucher) {
                        BillReverseHandler.updateBillProperty(ctx, (BizCollBillBaseInfo)billInfo, "voucherFlag", null);
                        voucherType = VoucherTypeEnum.RETURNVOUCHER;
                    }
                }
                logger.error((Object)("##cp.bc voucherReverse type:" + bOTBillOperStateEnum + "," + (Object)((Object)voucherType) + ",number:" + billInfo.getNumber() + "," + (Object)((Object)billInfo.getState()) + ",isVoucher:" + billInfo.getBoolean("isVouchered") + ",amt:" + billInfo.get("amountEncashed") + "," + billInfo.getBigDecimal("returnAmount") + ",voucher:" + voucherNumbers + ";paramMap:" + paramMap + "\n"));
                String queryTemplate = "SELECT ISTEMPSAVE WHERE ID = '%s'";
                BOTMappingInfo botMappingTemp = ibotMapping.getBOTMappingInfo(String.format(queryTemplate, VoucherReverseUtil.getBotMapping(billInfo.getId().toString(), bOTRelationInfoList)));
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    VoucherReverseUtil.voucherCheck((BizCollBillBaseInfo)billInfo, voucherType, paramMap);
                    VoucherReverseUtil.voucherFieldHandler(ctx, (BizCollBillBaseInfo)billInfo, voucherType);
                    if (botMappingTemp.getIsTempSave() == 0) {
                        VoucherReverseUtil.billAmountHandler(ctx, (BizCollBillBaseInfo)billInfo, null, voucherType, withFi, withCas);
                    }
                    VoucherReverseUtil.addVoucherRecord(ctx, iCreateVoucherRecord, billAndVoucherMap, voucherType);
                    VoucherReverseUtil.updateVoucherNumber(ctx, (BizCollBillBaseInfo)billInfo, con, 0, null);
                    BizInvoicePoolUtil.updateVoucherInfo(ctx, billInfo.getId(), voucherIds, (BizCollBillBaseInfo)billInfo, con, "update");
                } else if (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                    CreateVoucherRecordCollection recordCon = iCreateVoucherRecord.getCreateVoucherRecordCollection("select voucherID,voucherNumber,voucherType where billID='" + billInfo.getId().toString() + "'");
                    String allVoucherNumber = "";
                    String newVoucherNumber = null;
                    CoreBaseCollection newCon = new CoreBaseCollection();
                    int size = recordCon.size();
                    for (int i = 0; i < size; ++i) {
                        if (voucherMap.get(recordCon.get(i).getVoucherID()) != null) {
                            voucherType = recordCon.get(i).getVoucherType();
                            newVoucherNumber = voucherMap.get(recordCon.get(i).getVoucherID()).toString();
                            if (!recordCon.get(i).getVoucherNumber().equals(newVoucherNumber)) {
                                recordCon.get(i).setVoucherNumber(newVoucherNumber);
                                recordCon.get(i).setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                                recordCon.get(i).setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                                newCon.add((CoreBaseInfo)recordCon.get(i));
                            }
                            allVoucherNumber = allVoucherNumber + newVoucherNumber + ",";
                            continue;
                        }
                        allVoucherNumber = allVoucherNumber + recordCon.get(i).getVoucherNumber() + ",";
                    }
                    if (newCon.size() > 0) {
                        iCreateVoucherRecord.update(newCon);
                    }
                    VoucherReverseUtil.billAmountHandler(ctx, (BizCollBillBaseInfo)billInfo, voucherIds, voucherType, withFi, withCas);
                    VoucherReverseUtil.updateVoucherNumber(ctx, (BizCollBillBaseInfo)billInfo, con, 2, allVoucherNumber);
                    BizInvoicePoolUtil.updateVoucherInfo(ctx, billInfo.getId(), voucherIds, (BizCollBillBaseInfo)billInfo, con, "update");
                } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                    CreateVoucherRecordInfo info = iCreateVoucherRecord.getCreateVoucherRecordInfo("select voucherType where voucherID='" + voucherId + "' and billID='" + billInfo.getId().toString() + "'");
                    iCreateVoucherRecord.delete("where voucherID in(" + voucherIds + ") and billID='" + billInfo.getId().toString() + "'");
                    voucherType = info.getVoucherType();
                    BizInvoicePoolUtil.updateVoucherInfo(ctx, billInfo.getId(), voucherIds, (BizCollBillBaseInfo)billInfo, con, "delete");
                    VoucherReverseUtil.deleteVoucherHandler(ctx, (BizCollBillBaseInfo)billInfo, voucherIds, withFi, withCas, withCasPaymentCanSus, info.getVoucherType());
                    VoucherReverseUtil.updateVoucherNumber(ctx, (BizCollBillBaseInfo)billInfo, con, 1, null);
                }
                if (logStrBu.length() == 0) {
                    logStrBu.append("voucherReverse type:" + bOTBillOperStateEnum + "," + (Object)((Object)voucherType));
                }
                logStrBu.append(",number:" + billInfo.getNumber() + "," + (Object)((Object)billInfo.getState()) + ",isVoucher:" + billInfo.getBoolean("isVouchered") + "," + billInfo.getBoolean("isDapVouchered"));
                if (billInfo.get("amountEncashed") != null) {
                    logStrBu.append("," + billInfo.get("amountEncashed"));
                }
                if (logStrBu.toString().indexOf(voucherNumbers) == -1) {
                    logStrBu.append(";voucher:" + voucherNumbers);
                }
                logStrBu.append("\n");
                Long startTimeNgisc = System.currentTimeMillis();
                IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billInfo.getId());
                iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
                logger.error((Object)("cp.bc voucherReverse ngisc_reverse number=" + billInfo.getNumber() + "voucher=" + voucherNumbers + ",time\uff1a" + (System.currentTimeMillis() - startTimeNgisc) + "ms"));
            }
        }
        if (ctx != null && billInfo != null) {
            String logStr = logStrBu.toString();
            if (logStr.length() > 1500) {
                logStr = logStr.substring(0, 1500);
            }
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"voucherBatchReverseSave", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)logStr);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        }
        logger.error((Object)("cp.bc voucherReverse finished number=" + (billInfo != null ? billInfo.getNumber() : "") + ",OperState=" + bOTBillOperStateEnum + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    public static String getBotMapping(String billId, BOTRelationCollection bOTRelationInfos) {
        if (bOTRelationInfos != null) {
            BOTRelationInfo info = null;
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                info = bOTRelationInfos.get(i);
                if (!info.getSrcObjectID().equals(billId)) continue;
                return info.getBOTMappingID();
            }
        }
        return null;
    }

    public static void voucherCheck(BizCollBillBaseInfo billInfo, VoucherTypeEnum voucherType, Map paramMap) throws EASBizException, BOSException {
        boolean isRelaFi = new Boolean(paramMap.get("CP002").toString());
        boolean isRelaCn = new Boolean(paramMap.get("CP008").toString());
        boolean CP00801 = new Boolean(paramMap.get("CP00801").toString());
        boolean billCanCreateVoucher = new Boolean(paramMap.get("CP024").toString());
        if (!isRelaFi) {
            throw new BizCollException(BizCollException.NOTVOUCHER);
        }
        StateEnum billState = billInfo.getState();
        if (billState.getValue() < 60) {
            throw new BizCollException(BizCollException.BILLCANNOTVOUCHERSTATE);
        }
        if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType) && billInfo instanceof ExpenseAccountBillInfo) {
            BigDecimal amountEncashed = billInfo.getBigDecimal("amountEncashed");
            if (!isRelaCn) {
                if (billState.getValue() != 60) {
                    throw new BizCollException(BizCollException.BILLCANNOTBATCHVOUCHER);
                }
            } else if (isRelaFi && isRelaCn && !billCanCreateVoucher) {
                boolean isMonthlyBalance = false;
                if (billInfo instanceof TravelAccountBillInfo) {
                    CoreBillEntryBaseInfo entry = null;
                    AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
                    int size = entries.size();
                    for (int i = 0; i < size; ++i) {
                        entry = (CoreBillEntryBaseInfo)entries.getObject(i);
                        if (!entry.getBoolean("monthlyBalance")) continue;
                        isMonthlyBalance = true;
                        break;
                    }
                }
                if (!isMonthlyBalance) {
                    if (billInfo.get("LoanCheckEntries") != null && ((AbstractObjectCollection)billInfo.get("LoanCheckEntries")).size() == 0) {
                        throw new BizCollException(BizCollException.CANNOTVOUCHERWITHOUTLOANCHECK);
                    }
                    if (billState.getValue() != 60 || amountEncashed == null || amountEncashed.compareTo(BizCollUtil.ZERO) > 0) {
                        throw new BizCollException(BizCollException.BILLCANNOTBATCHVOUCHER);
                    }
                }
            } else if (CP00801 ? (billState.getValue() != 60 || amountEncashed == null || amountEncashed.compareTo(BizCollUtil.ZERO) > 0) && billState.getValue() != 70 : billState.getValue() != 60 && billState.getValue() != 70 && billState.getValue() != 65) {
                throw new BizCollException(BizCollException.BILLCANNOTBATCHVOUCHER);
            }
        }
    }

    public static void voucherFieldHandler(Context ctx, BizCollBillBaseInfo billInfo, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        String billVoucherField = "isVouchered";
        if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
            billVoucherField = "isDapVouchered";
        } else if (VoucherTypeEnum.RETURNVOUCHER.equals((Object)voucherType)) {
            return;
        }
        if (!billInfo.getBoolean(billVoucherField)) {
            ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
            String oql = "SELECT ID, VOUCHERTYPE WHERE BILLID = '" + billInfo.getId().toString() + "'";
            CreateVoucherRecordCollection recordCon = iCreateVoucherRecord.getCreateVoucherRecordCollection(oql);
            VoucherTypeEnum voucherTypeRecord = null;
            int size = recordCon.size();
            for (int i = 0; i < size; ++i) {
                voucherTypeRecord = recordCon.get(i).getVoucherType();
                if (VoucherTypeEnum.VOUCHER.equals((Object)voucherTypeRecord) && VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
                    throw new BizCollException(BizCollException.NOSAMEVOUCHER);
                }
                if (!VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherTypeRecord) || !VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) continue;
                throw new BizCollException(BizCollException.CANNOTSUSPENSEVOUCHER);
            }
            BillReverseHandler.updateBillProperty(ctx, billInfo, billVoucherField, "1");
        } else {
            if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
                throw new BizCollException(BizCollException.NOSAMEVOUCHER);
            }
            if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
                throw new BizCollException(BizCollException.CANNOTSUSPENSEVOUCHER);
            }
        }
    }

    public static void billAmountHandler(Context ctx, BizCollBillBaseInfo billInfo, String voucherIds, VoucherTypeEnum voucherType, boolean withFi, boolean withCas) throws EASBizException, BOSException {
        if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
            if (billInfo instanceof ExpenseAccountBillInfo) {
                StateEnum billState = billInfo.getState();
                boolean needReverseState = true;
                needReverseState = BizCommonUtilForWKFacadeFactory.getLocalInstance(ctx).needReverseStateForVoucherSubmit(billInfo, voucherIds, voucherType, withFi, withCas);
                if (BizCollUtil.checkTracDownVoucherState(ctx, billInfo.getId().toString(), voucherIds, 1, null) <= 0 && needReverseState) {
                    BigDecimal amountEncashed = (BigDecimal)billInfo.get("amountEncashed");
                    if (withFi && !withCas || amountEncashed.compareTo(BizCollUtil.ZERO) <= 0 && StateEnum.CHECKED.equals((Object)billState) || StateEnum.ALREADYPAYMENT.equals((Object)billState)) {
                        BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.CLOSED);
                        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"BillReverseHandler", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)("close \u751f\u6210\u51ed\u8bc1\u81ea\u52a8\u5173\u95ed  \u5355\u636e\u7f16\u7801\uff1a" + billInfo.getNumber()));
                        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                    }
                }
            }
        } else if (VoucherTypeEnum.RETURNVOUCHER.equals((Object)voucherType)) {
            if (billInfo.getBigDecimal("returnAmount") != null && billInfo.getBigDecimal("returnAmount").compareTo(BizCollUtil.ZERO) != 0) {
                return;
            }
            IBizCollBillBase iBizCollBillBase = BizCollUtil.getBillInstance(ctx, billInfo);
            BigDecimal returnAmount = BizCollUtil.ZERO;
            if (billInfo instanceof LoanBillInfo) {
                returnAmount = billInfo.getAmountBalance();
            }
            billInfo.put("returnAmount", returnAmount);
            billInfo.put("returnDate", new Date());
            billInfo.put("amountBalance", BizCollUtil.ZERO);
            CoreBillEntryBaseInfo entry = null;
            AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = (CoreBillEntryBaseInfo)entries.getObject(i);
                entry.put("amountPaid", (Object)entry.getBigDecimal("amountBalance"));
                entry.put("amountBalance", (Object)BizCollUtil.ZERO);
                entry.put("amountBalanceOri", (Object)BizCollUtil.ZERO);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("returnAmount"));
            sic.add(new SelectorItemInfo("returnDate"));
            sic.add(new SelectorItemInfo("amountBalance"));
            sic.add(new SelectorItemInfo("entries.amountPaid"));
            sic.add(new SelectorItemInfo("entries.amountBalance"));
            sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
            iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, sic);
        }
    }

    public static void deleteVoucherHandler(Context ctx, BizCollBillBaseInfo billInfo, String voucherIds, boolean withFi, boolean withCas, boolean withCasPaymentCanSus, VoucherTypeEnum voucherType) throws EASBizException, BOSException {
        String billId = billInfo.getId().toString();
        StateEnum billState = billInfo.getState();
        ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
        if (VoucherTypeEnum.DAPVOUCHER.equals((Object)voucherType)) {
            String queryOql = "SELECT ID WHERE BILLID = '%s' AND VOUCHERTYPE != '%s'";
            if (!withCasPaymentCanSus && billState.equals((Object)StateEnum.ALREADYPAYMENT)) {
                throw new BizCollException(BizCollException.CANNOT_DELVOUCHER_ISPAYMENT);
            }
            if (iCreateVoucherRecord.exists(String.format(queryOql, billId, voucherType.getValue()))) {
                throw new BizCollException(BizCollException.CANNOTDELETESUSPENSEVOUCHER);
            }
            if (StateEnum.CLOSED.equals((Object)billState)) {
                throw new BizCollException(BizCollException.CANNOT_DELVOUCHER_ISCLOSED);
            }
            queryOql = "SELECT FID WHERE BILLID='%s' AND VOUCHERTYPE='%s'";
            if (!iCreateVoucherRecord.exists(String.format(queryOql, billId, "20"))) {
                BillReverseHandler.updateBillProperty(ctx, billInfo, "isDapVouchered", 0);
            }
        } else {
            String queryOql;
            if (billInfo instanceof LoanBillInfo) {
                BillReverseHandler.checkSourceBillHasClose(ctx, billInfo, null);
            }
            if (!iCreateVoucherRecord.exists(String.format(queryOql = "SELECT FID WHERE BILLID='%s' AND VOUCHERTYPE!='%s' AND VOUCHERTYPE!='%s'", billId, "20", "40"))) {
                BillReverseHandler.updateBillProperty(ctx, billInfo, "isVouchered", 0);
            }
            IBizCollBillBase iBizCollBillBase = BizCollUtil.getBillInstance(ctx, billInfo);
            if (VoucherTypeEnum.RETURNVOUCHER.equals((Object)voucherType)) {
                BillReverseHandler.checkSourceBillHasClose(ctx, billInfo, null);
                if (billInfo.getBigDecimal("returnAmount") != null && billInfo.getBigDecimal("returnAmount").compareTo(BizCollUtil.ZERO) == 0) {
                    return;
                }
                int returnVoucherCount = BizCollUtil.checkTracDownVoucherState(ctx, billInfo.getId().toString(), voucherIds, 2, VoucherTypeEnum.RETURNVOUCHER);
                if (returnVoucherCount == 0) {
                    BigDecimal amountBalance = BigDecimal.ZERO;
                    if (billInfo instanceof LoanBillInfo) {
                        amountBalance = billInfo.getAmountApproved().subtract(billInfo.getAmountUsed());
                    } else if (billInfo instanceof ExpenseAccountBillInfo) {
                        amountBalance = (BigDecimal)billInfo.get("amountEncashed");
                    }
                    billInfo.put("returnAmount", BizCollUtil.ZERO);
                    billInfo.put("returnDate", null);
                    billInfo.put("amountBalance", amountBalance);
                    CoreBillEntryBaseInfo entry = null;
                    BigDecimal amountBalanceOri = null;
                    AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
                    int size = entries.size();
                    for (int i = 0; i < size; ++i) {
                        entry = (CoreBillEntryBaseInfo)entries.getObject(i);
                        entry.put("amountBalance", (Object)entry.getBigDecimal("amountPaid"));
                        amountBalanceOri = entry.getInt("convertMode") == 0 ? entry.getBigDecimal("amountPaid").divide(entry.getBigDecimal("exchangeRate"), 2, 4) : entry.getBigDecimal("amountPaid").multiply(entry.getBigDecimal("exchangeRate")).setScale(2, 4);
                        entry.put("amountBalanceOri", (Object)amountBalanceOri);
                        entry.put("amountPaid", (Object)BizCollUtil.ZERO);
                    }
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("returnAmount"));
                    sic.add(new SelectorItemInfo("returnDate"));
                    sic.add(new SelectorItemInfo("amountBalance"));
                    sic.add(new SelectorItemInfo("entries.amountPaid"));
                    sic.add(new SelectorItemInfo("entries.amountBalance"));
                    sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
                    iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, sic);
                }
            } else if (VoucherTypeEnum.VOUCHER.equals((Object)voucherType)) {
                int voucherCount;
                if (billInfo instanceof LoanBillInfo) {
                    queryOql = "SELECT FID WHERE BILLID='%s' AND VOUCHERTYPE='%s'";
                    if (iCreateVoucherRecord.exists(String.format(queryOql, billId, "40"))) {
                        throw new BizCollException(BizCollException.EXSIT_RETURN_VOUCHER);
                    }
                } else if (billInfo instanceof ExpenseAccountBillInfo && StateEnum.CLOSED.equals((Object)billState) && (voucherCount = BizCollUtil.checkTracDownVoucherState(ctx, billInfo.getId().toString(), voucherIds, 0, null)) == 0) {
                    BigDecimal amountEncashed = (BigDecimal)billInfo.get("amountEncashed");
                    if (!withCas) {
                        BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.CHECKED);
                    } else if (withCas) {
                        if (amountEncashed.compareTo(BizCollUtil.ZERO) <= 0) {
                            BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.CHECKED);
                        } else {
                            BillReverseHandler.updateBillProperty(ctx, billInfo, "state", (Object)StateEnum.ALREADYPAYMENT);
                        }
                    }
                }
            }
        }
    }

    public static CoreBillBaseCollection getBillInfos(Context ctx, IObjectPK[] srcBillPKs) throws BOSException, EASBizException {
        if (srcBillPKs != null && srcBillPKs.length > 0) {
            ArrayList<String> idList = new ArrayList<String>();
            StringBuilder idSql = new StringBuilder();
            String srcBillPk = null;
            int size = srcBillPKs.length;
            for (int i = 0; i < size; ++i) {
                srcBillPk = srcBillPKs[i].toString();
                if (idList.contains(srcBillPk)) continue;
                idList.add(srcBillPk);
                idSql.append("?,");
            }
            idSql.deleteCharAt(idSql.toString().length() - 1);
            Collections.sort(idList);
            BOSObjectType type = BOSUuid.read((String)srcBillPKs[0].toString()).getType();
            EntityObjectInfo vo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
            String sqlLock = "UPDATE " + vo.getTable().getName() + " SET FID = FID WHERE FID IN (" + idSql.toString() + ")";
            DbUtil.execute((Context)ctx, (String)sqlLock, (Object[])idList.toArray());
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
            ev.setFilter(filter);
            ev.setSelector(VoucherReverseUtil.getVoucherReverseBillSic());
            IObjectCollection con = iDynamicObject.getCollection(type, ev);
            if (con != null && con.size() > 0) {
                CoreBillBaseCollection billCon = new CoreBillBaseCollection();
                billCon.addObjectCollection(con);
                return billCon;
            }
        }
        return null;
    }

    public static void updateVoucherNumber(Context ctx, BizCollBillBaseInfo billInfo, IObjectCollection con, int reverseType, String newVoucherNumbers) throws EASBizException, BOSException {
        String voucherNumbers = "";
        if (billInfo.getString("voucherNumbers") != null) {
            voucherNumbers = billInfo.getString("voucherNumbers");
        }
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            if (reverseType == 0) {
                if (voucherNumbers.contains(con.getObject(i).getString("number"))) continue;
                voucherNumbers = con.getObject(i).getString("number") + "," + voucherNumbers;
                continue;
            }
            if (reverseType == 1) {
                if (!voucherNumbers.contains(con.getObject(i).getString("number"))) continue;
                if (voucherNumbers.contains(con.getObject(i).getString("number") + ",")) {
                    voucherNumbers = voucherNumbers.replace(con.getObject(i).getString("number") + ",", "");
                    continue;
                }
                voucherNumbers = voucherNumbers.replace(con.getObject(i).getString("number"), "");
                continue;
            }
            if (reverseType != 2) continue;
            voucherNumbers = newVoucherNumbers;
        }
        if (voucherNumbers.trim().length() > 1 && voucherNumbers.lastIndexOf(",") == voucherNumbers.length() - 1) {
            voucherNumbers = voucherNumbers.substring(0, voucherNumbers.length() - 1);
        }
        BillReverseHandler.updateBillProperty(ctx, billInfo, "voucherNumbers", voucherNumbers);
    }

    public static void paVoucherBatchReverseSave(Context ctx, Map reverseBillMap, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfoList) throws EASBizException, BOSException {
        if (reverseBillMap != null) {
            Map billAndVoucherMap = null;
            Set set = reverseBillMap.keySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                billAndVoucherMap = (Map)reverseBillMap.get(it.next().toString());
                BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)billAndVoucherMap.get(BillInfoKey);
                IObjectCollection con = (IObjectCollection)billAndVoucherMap.get(VoucherInfoKey);
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                    BillReverseHandler.updateBillProperty(ctx, billInfo, "pcaVouchered", "1");
                    continue;
                }
                if (!BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) continue;
                BillReverseHandler.updateBillProperty(ctx, billInfo, "pcaVouchered", "0");
            }
        }
    }

    public static SelectorItemCollection getVoucherReverseBillSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("returnAmount"));
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("voucherFlag"));
        sic.add(new SelectorItemInfo("amountEncashed"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("amountNotPaid"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("voucherNumbers"));
        sic.add(new SelectorItemInfo("adjustState"));
        sic.add(new SelectorItemInfo("isCreateOtherBill"));
        sic.add(new SelectorItemInfo("isVouchered"));
        sic.add(new SelectorItemInfo("isDapVouchered"));
        sic.add(new SelectorItemInfo("sourceSystem"));
        sic.add(new SelectorItemInfo("entries.currencyType.id"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.convertMode"));
        sic.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
        sic.add(new SelectorItemInfo("entries.amountBalance"));
        sic.add(new SelectorItemInfo("entries.amountBalanceOri"));
        sic.add(new SelectorItemInfo("entries.amountUsed"));
        sic.add(new SelectorItemInfo("entries.amountUsedOri"));
        sic.add(new SelectorItemInfo("entries.amountPaid"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.amountOri"));
        sic.add(new SelectorItemInfo("entries.amountApproved"));
        sic.add(new SelectorItemInfo("entries.amountApprovedOri"));
        sic.add(new SelectorItemInfo("entries.monthlyBalance"));
        sic.add(new SelectorItemInfo("loanCheckEntries.id"));
        return sic;
    }
}

