/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionExpBillEntryBaseInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryCollection;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.util.CPBCCommonParams;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractBillBudgetModify {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.budget.AbstractBillBudgetModify");

    protected abstract boolean checkEntryChange(Object var1, BizCollCoreBillBaseInfo var2, Map var3);

    protected abstract void updateBudgetDo(Context var1, CoreBillEntryBaseInfo var2, BizCollCoreBillBaseInfo var3, Map var4, List var5) throws EASBizException, BOSException;

    protected abstract void setBudgetDoForReturnBudgetOfApproved(Context var1, CoreBillEntryBaseInfo var2, BizCollCoreBillBaseInfo var3, Map var4, List var5);

    protected abstract void setBudgetDoForReturnBudgetOfNotApproved(AbstractObjectCollection var1, List var2);

    protected abstract String getSetBudgetSql();

    protected abstract String getSetReturnBudgetSql();

    protected abstract AbstractObjectCollection getBillEntry(BizCollCoreBillBaseInfo var1);

    protected void updateBudgetDoForReturnBudget(Context ctx, BizCollCoreBillBaseInfo billInfo, boolean approved) throws EASBizException, BOSException {
        if (billInfo == null) {
            return;
        }
        AbstractObjectCollection cols = this.getBillEntry(billInfo);
        if (approved) {
            this.updateBudgetDoForReturnBudget_Approved(ctx, billInfo, cols);
        } else {
            this.updateBudgetDoForReturnBudget_NotApproved(ctx, cols);
        }
    }

    protected void updateBudgetDoForReturnBudget_Approved(Context ctx, BizCollCoreBillBaseInfo billInfo, AbstractObjectCollection cols) throws BOSException {
        String sourceBillId = billInfo.getSourceBillId();
        Set sourceEntrySet = this.getSourceEntryCols(cols);
        Map sourceEntrysMap = this.getBizSourceBillCols(ctx, sourceBillId, sourceEntrySet);
        int length = cols.size();
        ArrayList params = new ArrayList(4);
        for (int i = 0; i < length; ++i) {
            CoreBillEntryBaseInfo tempEntry = (CoreBillEntryBaseInfo)cols.getObject(i);
            this.setBudgetDoForReturnBudgetOfApproved(ctx, tempEntry, billInfo, sourceEntrysMap, params);
        }
        if (params.size() > 0) {
            DbUtil.executeBatchAndReturn((Context)ctx, (String)this.getSetReturnBudgetSql(), params);
        }
    }

    protected void updateBudgetDoForReturnBudget_NotApproved(Context ctx, AbstractObjectCollection cols) throws BOSException {
        int length = cols.size();
        ArrayList params = new ArrayList(4);
        this.setBudgetDoForReturnBudgetOfNotApproved(cols, params);
        if (params.size() > 0) {
            DbUtil.executeBatchAndReturn((Context)ctx, (String)this.getSetReturnBudgetSql(), params);
        }
    }

    public void updateBudgetDoForBgAudit(Context ctx, BizCollCoreBillBaseInfo billInfo) throws EASBizException, BOSException {
        if (billInfo == null) {
            logger.info((Object)"updateBudgetDoForBgAudit: billInfo is null");
            return;
        }
        AbstractObjectCollection cols = this.getBillEntry(billInfo);
        String sourceBillId = billInfo.getSourceBillId();
        int length = cols.size();
        Set sourceEntrySet = this.getSourceEntryCols(cols);
        Map sourceEntrysMap = this.getBizSourceBillCols(ctx, sourceBillId, sourceEntrySet);
        ArrayList params = new ArrayList(4);
        for (int i = 0; i < length; ++i) {
            IObjectValue tempEntry = cols.getObject(i);
            this.updateBudgetDo(ctx, (CoreBillEntryBaseInfo)tempEntry, billInfo, sourceEntrysMap, params);
        }
        if (length > 0) {
            DbUtil.executeBatchAndReturn((Context)ctx, (String)this.getSetBudgetSql(), params);
        }
    }

    protected Set getSourceEntryCols(AbstractObjectCollection cols) {
        HashSet<String> sourceEntrySet = new HashSet<String>();
        int length = cols.size();
        for (int i = 0; i < length; ++i) {
            IObjectValue tempEntry = cols.getObject(i);
            if (tempEntry instanceof OtherExpenseBillEntryInfo) {
                if (((OtherExpenseBillEntryInfo)tempEntry).getSourceBillEntryID() == null) continue;
                sourceEntrySet.add(((OtherExpenseBillEntryInfo)tempEntry).getSourceBillEntryID());
                continue;
            }
            if (tempEntry instanceof EvectionExpBillEntryBaseInfo) {
                if (((EvectionExpBillEntryBaseInfo)tempEntry).getSourceBillEntryID() == null) continue;
                sourceEntrySet.add(((EvectionExpBillEntryBaseInfo)tempEntry).getSourceBillEntryID());
                continue;
            }
            logger.info((Object)"updateBudgetDoForBgAuditByAddNew ,entry's billtype is error!");
        }
        return sourceEntrySet;
    }

    protected String getFilterById(Set sourceBillIds) {
        String filters = null;
        if (sourceBillIds.size() > 0) {
            StringBuffer ids = new StringBuffer();
            Iterator ite = sourceBillIds.iterator();
            if (ite.hasNext()) {
                ids.append("'" + ite.next() + "'");
            }
            while (ite.hasNext()) {
                ids.append(",'" + ite.next() + "'");
            }
            filters = ids.toString();
        }
        return filters;
    }

    public Map getBizSourceBillCols(Context ctx, String sourceBillId, Set sourceEntryIds) throws BOSException {
        if (sourceBillId == null) {
            return null;
        }
        BOSObjectType sourceBosType = new ObjectUuidPK(sourceBillId).getObjectType();
        if (CPBCCommonParams.OTHEREXPENSEBOSTYPE.equals((Object)sourceBosType)) {
            return this.getSourceBillOfOtherBillCols(ctx, sourceEntryIds);
        }
        if (CPBCCommonParams.DAILYLOANBOSTYPE.equals((Object)sourceBosType)) {
            return this.getSourceBillOfDailyLoanBillCols(ctx, sourceEntryIds);
        }
        if (CPBCCommonParams.EVECTIONLOANBOSTYPE.equals((Object)sourceBosType)) {
            return this.getSourceBillOfEvectionLoanBillCols(ctx, sourceEntryIds);
        }
        return null;
    }

    protected Map getSourceBillOfOtherBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<BOSUuid, String> entryMap = new HashMap<BOSUuid, String>();
        OtherExpenseBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            EntityViewInfo ev = this.getSourceBillEntityView(sourceEntryIds);
            otherEntryCols = OtherExpenseBillEntryFactory.getLocalInstance(ctx).getOtherExpenseBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    OtherExpenseBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    protected Map getSourceBillOfDailyLoanBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<BOSUuid, String> entryMap = new HashMap<BOSUuid, String>();
        DailyLoanBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            EntityViewInfo ev = this.getSourceBillEntityView(sourceEntryIds);
            otherEntryCols = DailyLoanBillEntryFactory.getLocalInstance(ctx).getDailyLoanBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    DailyLoanBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    protected Map getSourceBillOfEvectionLoanBillCols(Context ctx, Set sourceEntryIds) throws BOSException {
        HashMap<BOSUuid, String> entryMap = new HashMap<BOSUuid, String>();
        EvectionLoanBillEntryCollection otherEntryCols = null;
        if (sourceEntryIds.size() > 0) {
            EntityViewInfo ev = this.getSourceBillEntityView(sourceEntryIds);
            otherEntryCols = EvectionLoanBillEntryFactory.getLocalInstance(ctx).getEvectionLoanBillEntryCollection(ev);
            if (otherEntryCols != null) {
                int leng = otherEntryCols.size();
                for (int i = 0; i < leng; ++i) {
                    EvectionLoanBillEntryInfo entryInfo = otherEntryCols.get(i);
                    StringBuffer tempID = new StringBuffer();
                    tempID.append(entryInfo.getExpenseType().getId().toString());
                    tempID.append(entryInfo.getBill().getCostedDept().getId().toString());
                    entryMap.put(entryInfo.getId(), tempID.toString());
                }
            }
        }
        return entryMap;
    }

    protected EntityViewInfo getSourceBillEntityView(Set sourceEntryIds) {
        SelectorItemCollection sic = this.getSourceBillSelector();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.getFilterById(sourceEntryIds), CompareType.INNER));
        ev.setFilter(filter);
        ev.setSelector(sic);
        return ev;
    }

    protected SelectorItemCollection getSourceBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("bill.costedDept.id"));
        return sic;
    }
}

