/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.ng;

import com.kingdee.eas.cp.bc.ng.MyTrustStrategy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class HttpServiceHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.ng.HttpServiceHelper");
    private static CloseableHttpClient httpClient;

    public static <T> T doPost(String url, Map<String, String> headerMap, String bodyJson, Class<T> cls) {
        Object resultObj = null;
        String resultStr = null;
        try {
            resultStr = HttpServiceHelper.http(url) ? HttpServiceHelper.doPostByHttp(url, headerMap, bodyJson) : HttpServiceHelper.doPostByHttps(url, headerMap, bodyJson);
            if (resultStr != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                resultObj = objectMapper.readValue(resultStr, cls);
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u53d1\u9001\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25!" + bodyJson));
            logger.error((Object)("resultStr====" + resultStr));
            logger.error((Object)"doPost:", (Throwable)e);
        }
        return (T)resultObj;
    }

    private static boolean http(String url) {
        try {
            if ("https".equals(new URL(url).getProtocol())) {
                return false;
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)("\u89e3\u6790url\u662f\u5426\u4e3ahttp\u534f\u8bae\u62a5\u9519\uff0curl====" + url));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPostByHttp(String url, Map<String, String> headerMap, String bodyJson) throws UnsupportedEncodingException, IOException, HttpException {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setSoTimeout(10000);
        PostMethod httpPost = new PostMethod(url);
        if (headerMap != null && headerMap.size() != 0) {
            for (String key : headerMap.keySet()) {
                httpPost.addRequestHeader(key, headerMap.get(key));
            }
        }
        StringRequestEntity requestEntity = new StringRequestEntity(bodyJson, "text/json", "UTF-8");
        httpPost.setRequestEntity((RequestEntity)requestEntity);
        String responseMsg = "";
        try {
            httpClient.executeMethod((HttpMethod)httpPost);
            responseMsg = httpPost.getResponseBodyAsString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            httpPost.releaseConnection();
        }
        return responseMsg;
    }

    private static String doPostByHttps(String url, Map<String, String> headerMap, String bodyJson) throws IOException {
        String result = null;
        HttpPost post = null;
        try {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).build();
            CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            post = new HttpPost(url);
            post.setHeader("Content-Type", "application/json; charset=UTF-8");
            post.setHeader("Accept", "application/json; charset=UTF-8");
            if (headerMap != null) {
                for (String k : headerMap.keySet()) {
                    post.setHeader(k, headerMap.get(k));
                }
            }
            StringEntity entity = new StringEntity(bodyJson, "UTF-8");
            post.setEntity((HttpEntity)entity);
            HttpResponse response = client.execute((HttpUriRequest)post);
            int rspCode = response.getStatusLine().getStatusCode();
            logger.error((Object)("rspCode =======" + rspCode + "::" + url + "::bodyJson" + bodyJson));
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            logger.error((Object)("result =======" + result));
            String string = result;
            return string;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File doPost(String url, String access_token) {
        OutputStream os = null;
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        File file = new File(fileName);
        InputStream is = null;
        try {
            url = url.substring(0, url.lastIndexOf("/")) + "/" + URLEncoder.encode(fileName, "UTF-8");
            if (HttpServiceHelper.http(url)) {
                is = HttpServiceHelper.getInputStreamByHttp(url, access_token);
                if (is != null) {
                    os = new FileOutputStream(file);
                    int bytesRead = 0;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                    os.close();
                    is.close();
                } else {
                    logger.error((Object)"\u83b7\u53d6is\u5931\u8d25!");
                }
                File bytesRead = file;
                return bytesRead;
            }
            File bytesRead = HttpServiceHelper.getFileByHttps(file, url, access_token);
            return bytesRead;
        }
        catch (IOException e) {
            logger.error((Object)("\u53d1\u9001\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25!" + url));
            logger.error((Object)("doPost:" + e));
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("\u5173\u95ed\u8d44\u6e90\u5931\u8d25!" + url));
            }
        }
        return null;
    }

    private static File getFileByHttps(File file, String url, String access_token) throws IOException {
        HttpPost post = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            CloseableHttpClient client = HttpServiceHelper.getCloseableHttpClient();
            post = new HttpPost(url);
            post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            post.setHeader("Accept", "application/x-www-form-urlencoded; charset=UTF-8");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("access_token", access_token));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = client.execute((HttpUriRequest)post);
            int rspCode = response.getStatusLine().getStatusCode();
            logger.info((Object)(file.getName() + "::::::resCode" + rspCode));
            is = response.getEntity().getContent();
            if (is != null) {
                os = new FileOutputStream(file);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
                File file2 = file;
                return file2;
            }
            File file3 = null;
            return file3;
        }
        catch (IOException e) {
            logger.error((Object)"https\u8bf7\u6c42\u6587\u4ef6\u9519\u8bef!");
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
            if (post != null) {
                post.releaseConnection();
            }
        }
    }

    public static synchronized CloseableHttpClient getCloseableHttpClient() {
        if (httpClient == null) {
            SSLConnectionSocketFactory sslConnectionSocketFactory = null;
            try {
                MyTrustStrategy trustStrategy = new MyTrustStrategy();
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)trustStrategy).build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", sslConnectionSocketFactory).build();
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
            connectionManager.setMaxTotal(200);
            connectionManager.setDefaultMaxPerRoute(20);
            HttpClientBuilder httpClientBuilder = HttpClients.custom();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            httpClient = httpClientBuilder.build();
        }
        return httpClient;
    }

    private static InputStream getInputStreamByHttp(String url, String access_token) throws IOException, HttpException {
        HttpClient httpClient = new HttpClient();
        HttpClientParams httpParams = httpClient.getParams();
        Integer overTime = 5000;
        httpParams.setParameter("http.connection.timeout", (Object)overTime);
        httpParams.setParameter("http.socket.timeout", (Object)overTime);
        GetMethod httpGet = new GetMethod(url);
        httpGet.addRequestHeader("access_token", access_token);
        httpGet.addRequestHeader("api", "true");
        httpGet.addRequestHeader("Content-Type", "text/plain");
        httpClient.executeMethod((HttpMethod)httpGet);
        if (httpGet.getStatusCode() == 200) {
            return httpGet.getResponseBodyAsStream();
        }
        logger.error((Object)("url======" + url + ":httpGet.getStatusCode()=======" + httpGet.getStatusCode()));
        return null;
    }
}

