/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.ng;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ng.ConfigUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.log4j.Logger;

public class ISCHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.ng.ISCHelper");

    public static String getNgId(Context ctx, String easId) throws EASBizException, BOSException {
        String cls = "kd.isc.iscb.util.connector.server.ConnectorCallback";
        String method = "findMappingValue";
        BOSObjectType type = BOSUuid.read((String)easId).getType();
        String dataCenter = ctx.getAIS();
        String ruleNumber = ConfigUtil.get(type.toString());
        String id = (String)ISCHelper.invoke(cls, method, new Object[]{dataCenter, ruleNumber, easId}, new Class[]{String.class, String.class, String.class});
        logger.info((Object)String.format("easId:%s,ngId:%s", easId, id));
        return id;
    }

    public static Object invoke(String className, String methodName, Object[] params, Class[] paramCls) throws EASBizException, BOSException {
        Object ret = null;
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getDeclaredMethod(methodName, paramCls);
            Object obj = clazz.newInstance();
            ret = method.invoke(obj, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.info((Object)String.format("className:%s,methodName:%s,params:%s,\u8c03\u7528\u5931\u8d25:%s", className, methodName, Arrays.toString((Object[])params), e.getMessage()));
        }
        logger.info((Object)String.format("className:%s,methodName:%s,params:%s,ret:%s", className, methodName, Arrays.toString((Object[])params), ret));
        return ret;
    }

    public static String getAccessToken(Map<String, String> loginInfo) throws EASBizException, BOSException {
        String accessToken = null;
        if (loginInfo != null) {
            String cls = "kd.isc.iscb.util.connector.server.ConnectorCallback";
            String getAccessToken = "getAccessToken";
            accessToken = (String)ISCHelper.invoke(cls, getAccessToken, new Object[]{loginInfo}, new Class[]{Map.class});
        }
        return accessToken;
    }

    public static Map<String, String> getLoginInfo(String dataCenter) throws EASBizException, BOSException {
        String cls = "kd.isc.iscb.util.connector.server.ConnectorCallback";
        String getIerpLoginInfo = "getIerpLoginInfo";
        Map loginInfo = (Map)ISCHelper.invoke(cls, getIerpLoginInfo, new Object[]{dataCenter}, new Class[]{String.class});
        return loginInfo;
    }

    public static boolean isFromISC() throws EASBizException, BOSException {
        String isRunning;
        String cls;
        Object ret;
        if (ConfigUtil.enableISC().booleanValue() && (ret = ISCHelper.invoke(cls = "kd.isc.iscb.util.connector.server.CommandDispatcher", isRunning = "isRunning", new Object[0], new Class[0])) != null) {
            return (Boolean)ret;
        }
        return false;
    }
}

