/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.plugins;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.extend.flow.ITemplate;
import com.kingdee.eas.base.form.extend.flow.TemplateFactory;
import com.kingdee.eas.base.form.extend.flow.TemplateInfo;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.DataChangeCommandArg;
import com.kingdee.eas.base.form.plugin.AbstractBillPlugin;
import com.kingdee.eas.base.form.web.IDynamicWebFormView;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.MakeControl;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.util.BcCommonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizAccountOutBillPlugin
extends AbstractBillPlugin {
    private OperationStatus operationStatus;
    private String operateAction;
    private int currRow = 0;
    private boolean cp019 = false;
    private Context ctx;
    private CompanyOrgUnitInfo company;
    private static String AMOUNT_APPROVE = "amountApprove";
    private static String[] saveActionStr = new String[]{"FbtnSave", "FbtnSave1"};
    private static String[] submitActionStr = new String[]{"FbtnSubmit", "FbtnSubmit1"};
    private static String[] entryActionStr = new String[]{"FbtnAdd", "FbtnMin", "FbtnCopyEntry"};
    private static String[] billElementStr = new String[]{"Fbillnumber", "FtxtTitle", "FbasedataApplier", "FbasedataApplierDept", "FtxtPhone", "FbasedataApplierPosi", "Ftxt", "Ftxt1", "FbasedataPayCompany", "FbasedataPayDept", "FbasedataCurr", "FbasedataPaymethod", "FbasedataClient", "FtxtReceivePer", "FtxtReceiveAccount", "FtxtReceiveBank", "Fdate", "FbasedataFeeObj", "FlistUrgent"};
    private static String[] entryElementStr = new String[]{"FbasedataPayDeptEntry", "Fremark", "FbasedataOperType", "FtxtName", "FbasedataFeeType", "FtxtFeeMark", "FtxtPersons", "FdateHappen", "FAmountPre", "FAmount", "FAmountAudit", "FbasedataTerminal", "FbasedataPayCompanyEntry"};
    private static String[] unLockAmountApprovetStr = new String[]{"Ftxt1", "FbasedataPaymethod", "FAmountAudit"};
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.plugins.BizAccountOutBillPlugin");

    public boolean onInitialize(OpenBillParameter param) throws BOSException, EASBizException {
        this.checkPermission("cp_bc_BizAccountOutBill_View");
        this.operationStatus = param.billOperation;
        this.ctx = this.application.getContext();
        this.checkCurrentUserInfo(this.ctx);
        String flowTempId = BizAccountOutBillPlugin.getTemplateId(this.ctx);
        if (flowTempId == null || "".equals(flowTempId)) {
            this.application.showConfirm("templateNotExist", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"82_BizAccountOutBillPlugin"), EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"83_BizAccountOutBillPlugin"), 0);
            return false;
        }
        this.application.setCustomParameter("flowTempId", (Object)flowTempId);
        this.company = (CompanyOrgUnitInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getOrgUnit(@CONTEXT, LoginOrg, @MAINORGTYPE, NULL)");
        this.cp019 = this.getCP019(this.ctx, this.company.getId().toString());
        return super.onInitialize(param);
    }

    private void checkPermission(String permissionItem) throws BOSException, EASBizException {
        Context ctx = this.application.getContext();
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        BusinessSeviceUtil.checkFunctionPermission((Context)ctx, (String)cuId, (String)permissionItem);
    }

    public void onLoad() {
        try {
            UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
            String userId = user.getId().toString();
            String oqlFilter = this.getCompanyF7InitFilter(this.ctx, userId, this.cp019).toString();
            this.application.setFieldFilter("FbasedataPayCompany", oqlFilter);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.application.getValue("FbasedataPayCompany", 0);
            String oql = this.f7CostCenterFilterInfo(company);
            if (!this.cp019) {
                oql = "";
            }
            this.application.setFieldFilter("FbasedataPayDept", oql);
            oql = "usedStatus=1";
            this.application.setFieldFilter("FbasedataClient", oql);
            String oqlSupport = "";
            oqlSupport = BizAccountOutBillPlugin.getSupportedObjF7Filter(this.ctx, null);
            this.application.setFieldFilter("FbasedataFeeObj", oqlSupport);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void afterBindData() {
        if (OperationStatus.ADDNEW.equals(this.operationStatus)) {
            try {
                BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getRemoteInstance().forLoanBillCreateNewData();
                if ("NewEntry".equals(this.operateAction)) {
                    this.application.setValue("FbasedataPayDeptEntry", (Object)baseInfo.getCostedDept(), this.currRow);
                    this.operateAction = null;
                    this.currRow = 0;
                } else if ("DeleteEntry".equals(this.operateAction) || "CopyEntryRow".equals(this.operateAction)) {
                    this.operateAction = null;
                    this.currRow = 0;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (this.application.getValue("FbasedataClient", 0) != null) {
            this.application.lockElement("FbasedataClient", 0, true);
        }
        BizAccountOutBillInfo info = (BizAccountOutBillInfo)this.application.getBillModel().getBillValue();
        boolean isFromWorkflow = this.application.getBillView().getWfState().isFromWorkflow();
        String workFlowState = (String)this.application.getCustomParameter("state");
        if (info.getState() != null) {
            int billState = info.getState().getValue();
            if (OperationStatus.EDIT.equals(this.operationStatus) && 20 != billState) {
                this.lockElement(saveActionStr);
            }
        }
        if (isFromWorkflow && workFlowState == null) {
            this.lockElement(saveActionStr);
            this.lockElement(submitActionStr);
            this.lockElement(entryActionStr);
            this.lockElement(billElementStr);
            this.lockElement(entryElementStr);
        }
        if (isFromWorkflow && AMOUNT_APPROVE.equals(workFlowState)) {
            this.lockElement(saveActionStr);
            this.lockElement(billElementStr);
            this.lockElement(entryActionStr);
            this.lockElement(entryElementStr);
            this.unLockElement(unLockAmountApprovetStr);
        }
        if (OperationStatus.VIEW.equals(this.operationStatus)) {
            this.lockElement(new String[]{"FbtnAttach"});
        }
    }

    public void afterCreateNewData() {
        if (OperationStatus.ADDNEW.equals(this.operationStatus)) {
            try {
                BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getRemoteInstance().forLoanBillCreateNewData();
                CompanyOrgUnitInfo currFIUnit = ContextUtil.getCurrentFIUnit((Context)this.ctx);
                this.application.setValue("FbasedataCompany", (Object)currFIUnit, 0);
                this.application.setValue("FbasedataApplierDept", (Object)baseInfo.getOrgUnit(), 0);
                this.application.setValue("FbasedataCurr", (Object)baseInfo.getCurrencyType(), 0);
                this.application.setValue("FbasedataPaymethod", (Object)this.getDefaultPayMode(this.ctx), 0);
                this.application.setValue("FbasedataPayDept", (Object)baseInfo.getCostedDept(), 0);
                this.application.setValue("FbasedataPayDeptEntry", (Object)baseInfo.getCostedDept(), 0);
                this.application.setValue("FtxtTitle", (Object)BizCollBillTypeEnum.BIZ_ACCOUNT_OUT.toString(), 0);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    private SettlementTypeInfo getDefaultPayMode(Context ctx) {
        SettlementTypeInfo settle = null;
        try {
            ISettlementType iSettle = SettlementTypeFactory.getRemoteInstance();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            viewInfo.setFilter(filter);
            SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
            if (collPay != null && collPay.size() > 0) {
                settle = collPay.get(0);
            }
        }
        catch (BOSException e) {
            settle = null;
        }
        return settle;
    }

    protected static String getTemplateId(Context ctx) throws BOSException, EASBizException {
        ITemplate iTemplate = TemplateFactory.getRemoteInstance();
        String oql = "select id where cu.id='eThjryu4wEKoEK1veu3ZzDUlqpQ=' and formID='VaSB33xwQcySz4zvOJTA/Zp+rpI='";
        TemplateInfo tempInfo = null;
        try {
            tempInfo = iTemplate.getTemplateInfo(oql);
        }
        catch (ObjectNotFoundException e) {
            logger.error((Object)e.getMessage());
            return "";
        }
        String templateId = tempInfo.getId() != null ? tempInfo.getId().toString() : null;
        return templateId;
    }

    public void doCustomOperation(String operation) throws BOSException, EASBizException {
        if ("viewBugdet".equals(operation)) {
            this.checkPermission("cp_bc_BizAccountOutBill_Budget");
            String pk = this.application.getBillModel().getPKValue();
            IDynamicWebFormView view = (IDynamicWebFormView)this.application.getBillView();
            String pageId = view.getPageId();
            String sessionId = (String)this.application.getCustomParameter("JSESSIONID");
            StringBuffer params = BcCommonUtil.appendParam("billId", pk, true);
            BcCommonUtil.appendParam(params, "pageId", pageId, true);
            BcCommonUtil.appendParam(params, "JSESSIONID", sessionId, true);
            String url = "/easweb/cp/bc/bgBalanceView.jsf" + params.toString();
            this.application.popupWindow(url, OpenModeEnum.OpenNewWindow.getValue(), "viewBudget", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"84_BizAccountOutBillPlugin"), 890, 720);
        }
    }

    public void dataChanged(DataChangeCommandArg dataChangeCommandArg) {
        block22: {
            try {
                if ("FbasedataPayDept".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    CostCenterOrgUnitInfo payDept = (CostCenterOrgUnitInfo)this.application.getValue("FbasedataPayDept", 0);
                    CostCenterOrgUnitInfo costCenterInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(payDept.getId().toString()));
                    BizCollBillBaseInfo info = CommonUtilFacadeFactory.getRemoteInstance().forLoanBillCostCenterAction(costCenterInfo);
                    CompanyOrgUnitInfo payCompany = info.getCompany();
                    this.application.setValue("FbasedataPayCompany", (Object)payCompany, dataChangeCommandArg.getRow());
                    break block22;
                }
                if ("FbasedataPayDeptEntry".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    CostCenterOrgUnitInfo payDept = (CostCenterOrgUnitInfo)this.application.getValue("FbasedataPayDeptEntry", dataChangeCommandArg.getRow());
                    CostCenterOrgUnitInfo costCenterInfo = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(payDept.getId().toString()));
                    BizCollBillBaseInfo info = CommonUtilFacadeFactory.getRemoteInstance().forLoanBillCostCenterAction(costCenterInfo);
                    CompanyOrgUnitInfo payCompany = info.getCompany();
                    this.application.setValue("FbasedataPayCompanyEntry", (Object)payCompany, dataChangeCommandArg.getRow());
                    break block22;
                }
                if ("FbasedataFeeType".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    try {
                        ExpenseTypeInfo expenseInfo = (ExpenseTypeInfo)this.application.getValue("FbasedataFeeType", dataChangeCommandArg.getRow());
                        String expenseTypeId = expenseInfo.getId().toString();
                        if (expenseTypeId != null && !"".equals(expenseTypeId)) {
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("operationType.id"));
                            expenseInfo = ExpenseTypeFactory.getRemoteInstance().getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(expenseTypeId), sic);
                        }
                        if (expenseInfo != null && expenseInfo.getOperationType() != null && expenseInfo.getOperationType().getId() != null) {
                            String operationId = expenseInfo.getOperationType().getId().toString();
                            OperationTypeInfo operationInfo = OperationTypeFactory.getRemoteInstance().getOperationTypeInfo((IObjectPK)new ObjectUuidPK(operationId));
                            this.application.setValue("FbasedataOperType", (Object)operationInfo, dataChangeCommandArg.getRow());
                        }
                        break block22;
                    }
                    catch (BOSException ex) {
                        logger.error((Object)ex.getMessage());
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage());
                    }
                    break block22;
                }
                if ("FAmount".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    Object value = dataChangeCommandArg.getNewValue();
                    this.application.setValue("FAmountAudit", value, dataChangeCommandArg.getRow());
                    if ("NewEntry".equals(this.operateAction) || "CopyEntryRow".equals(this.operateAction)) {
                        this.currRow = dataChangeCommandArg.getRow();
                    }
                } else if ("FbasedataPayCompany".equalsIgnoreCase(dataChangeCommandArg.getKey()) && this.cp019) {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.application.getValue("FbasedataPayCompany", 0);
                    String oql = this.f7CostCenterFilterInfo(company);
                    this.application.setFieldFilter("FbasedataPayDept", oql);
                    String oqlSupport = "";
                    oqlSupport = BizAccountOutBillPlugin.getSupportedObjF7Filter(this.ctx, company.getId().toString());
                    this.application.setFieldFilter("FbasedataFeeObj", oqlSupport);
                } else if ("FbasedataApplierDept".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    AdminOrgUnitInfo deptInfo = (AdminOrgUnitInfo)this.application.getValue("FbasedataApplierDept", 0);
                    FilterInfo filter = null;
                    filter = deptInfo == null || deptInfo.getId() == null ? this.getApplierF7InitFilter(this.ctx, null) : this.getApplierF7InitFilter(this.ctx, deptInfo.getId().toString());
                    this.application.setFieldFilter("FbasedataApplier", filter.toString());
                } else if ("FbasedataApplier".equalsIgnoreCase(dataChangeCommandArg.getKey())) {
                    PersonInfo person = (PersonInfo)this.application.getValue("FbasedataApplier", 0);
                    if (person == null || person.getId() == null) {
                        return;
                    }
                    CustomerInfo customer = this.getCustomerByPersonId(this.ctx, person.getId().toString());
                    this.application.setValue("FbasedataClient", (Object)customer, dataChangeCommandArg.getRow());
                    if (customer != null) {
                        this.application.lockElement("FbasedataClient", 0, true);
                    } else {
                        this.application.lockElement("FbasedataClient", 0, false);
                    }
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public void onGetFieldFilter(BaseDataFilterArg arg) {
        try {
            if ("FbasedataPayCompanyEntry".equalsIgnoreCase(arg.getKey())) {
                UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
                String userId = user.getId().toString();
                String oqlFilter = this.getCompanyF7InitFilter(this.ctx, userId, this.cp019).toString();
                arg.setOql(oqlFilter);
            } else if ("FbasedataPayDeptEntry".equalsIgnoreCase(arg.getKey())) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.application.getValue("FbasedataPayCompanyEntry", arg.getRowIndex());
                String oqlFilter = this.f7CostCenterFilterInfo(company);
                arg.setOql(oqlFilter);
            } else if ("FbasedataFeeType".equalsIgnoreCase(arg.getKey())) {
                FilterInfo baseExpenseTypeFilterInfo = new FilterInfo();
                baseExpenseTypeFilterInfo.getFilterItems().add(new FilterItemInfo("operationType.isEnable", null, CompareType.IS));
                baseExpenseTypeFilterInfo.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE, CompareType.EQUALS));
                baseExpenseTypeFilterInfo.setMaskString("#0 or #1");
                String oqlFilter = baseExpenseTypeFilterInfo.toString();
                arg.setOql(oqlFilter);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private String f7CostCenterFilterInfo(CompanyOrgUnitInfo company) {
        if (company != null) {
            String companyId = company.getId().toString();
            return this.getCostCenterByCompanyFilter(companyId);
        }
        return this.getCostCenterByCompanyFilter(null);
    }

    private String getCostCenterByCompanyFilter(String companyId) {
        String filterString = null;
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isBizUnit", (Object)true));
        fic.add(new FilterItemInfo("isSealUp", (Object)false));
        filter.setMaskString("#0 and #1");
        try {
            OrgUnitCollection unitColl = null;
            if (companyId != null && !"".equals(companyId)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                unitColl = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(companyId, 1, 5);
            }
            Set<String> orgIdSet = new HashSet<String>();
            if (this.cp019) {
                UserInfo user = (UserInfo)this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
                String userId = user.getId().toString();
                UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo("select * , *.* , orgRange.* where id = '" + userId + "'");
                Set setIds = MakeControl.getOrgIdsByUserAndType(OrgRangeType.BIZ_ORG_TYPE, userInfo);
                if (setIds != null && setIds.size() > 0 && unitColl != null && unitColl.size() > 0) {
                    String temp = null;
                    for (int i = unitColl.size() - 1; i >= 0; --i) {
                        temp = unitColl.get(i).getId().toString();
                        if (!setIds.contains(temp)) continue;
                        orgIdSet.add(temp);
                    }
                } else if (setIds != null && setIds.size() > 0 && (unitColl == null || unitColl.size() == 0)) {
                    orgIdSet = setIds;
                }
            } else if (unitColl != null) {
                for (int i = unitColl.size() - 1; i >= 0; --i) {
                    String temp = unitColl.get(i).getId().toString();
                    orgIdSet.add(temp);
                }
            }
            if (orgIdSet.size() > 0) {
                fic.add(new FilterItemInfo("id", orgIdSet, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and #2");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        filterString = filter.toString();
        return filterString;
    }

    private FilterInfo getCompanyF7InitFilter(Context ctx, String userId, boolean CP019) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isBizUnit", (Object)true));
        fic.add(new FilterItemInfo("isSealUp", (Object)false));
        filter.setMaskString("#0 and #1");
        if (CP019) {
            try {
                UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo("select * , *.* , orgRange.* where id = '" + userId + "'");
                Set setIds = MakeControl.getOrgIdsByUserAndType(OrgRangeType.BIZ_ORG_TYPE, userInfo);
                fic.add(new FilterItemInfo("id", (Object)setIds, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and #2");
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filter;
    }

    private FilterInfo getOrgUnitF7InitFilter0(Context ctx, CompanyOrgUnitInfo companyInfo) {
        FilterInfo filter = new FilterInfo();
        try {
            OrgUnitCollection unitColl = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(companyInfo.getId().toString(), 1, 0);
            if (unitColl != null && unitColl.size() > 0) {
                FilterItemCollection fic = filter.getFilterItems();
                HashSet<String> idSet = new HashSet<String>();
                for (int i = 0; i < unitColl.size(); ++i) {
                    idSet.add(unitColl.get(i).getId().toString());
                }
                fic.add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                return filter;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    private FilterInfo getApplierF7InitFilter(Context ctx, String orgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (orgUnitId != null && !"".equals(orgUnitId)) {
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            fic.add(new FilterItemInfo("inService", (Object)new Integer(2), CompareType.NOTEQUALS));
        } else {
            OrgUnitCollection unitColl = null;
            FilterItemCollection fic = filter.getFilterItems();
            try {
                CompanyOrgUnitInfo currentCompanyInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
                unitColl = OrgUnitRelationFactory.getRemoteInstance().getFromUnit(currentCompanyInfo.getId().toString(), 1, 0);
                int size = 0;
                if (unitColl != null) {
                    size = unitColl.size();
                }
                fic.add(new FilterItemInfo("inService", (Object)new Integer(2), CompareType.NOTEQUALS));
                if (size > 0) {
                    HashSet<String> idSet = new HashSet<String>();
                    for (int i = 0; i < size; ++i) {
                        idSet.add(unitColl.get(i).getId().toString());
                    }
                    fic.add(new FilterItemInfo("AdminOrgUnit.id", idSet, CompareType.INCLUDE));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filter;
    }

    private CustomerInfo getCustomerByPersonId(Context ctx, String personId) {
        CustomerInfo customer = null;
        try {
            customer = BizAccountOutBillFactory.getRemoteInstance().getCustomerByPersonId(personId);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return customer;
    }

    public static String getSupportedObjF7Filter(Context ctx, String companyId) {
        String retStr = "";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (companyId != null && !"".equals(companyId.trim())) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        } else {
            filter.setMaskString("#0");
        }
        retStr = filter.toString();
        return retStr;
    }

    private boolean getCP019(Context ctx, String companyId) {
        boolean cp019 = false;
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("CP019");
        try {
            Map params = this._getParams(ctx, paramNumberList, companyId);
            if (params != null && params.get("CP019") != null) {
                cp019 = Boolean.valueOf(params.get("CP019").toString());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return cp019;
    }

    private Map _getParams(Context ctx, List paramNumberList, String companyId) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        IParamControl iParam = ParamControlFactory.getRemoteInstance();
        String[] paramNumbers = null;
        int size = paramNumberList.size();
        if (paramNumberList != null && size > 0) {
            paramNumbers = new String[size];
            for (int i = 0; i < size; ++i) {
                paramNumbers[i] = (String)paramNumberList.get(i);
            }
            paramMap = iParam.getParamHashMap(paramNumbers, companyId);
        }
        return paramMap;
    }

    private void checkCurrentUserInfo(Context ctx) throws BizCollException {
        UserInfo curUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (curUser == null || curUser.getPerson() == null) {
            throw new BizCollException(new NumericExceptionSubItem("033", EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"85_BizAccountOutBillPlugin")));
        }
    }

    public void afterConfirm(String id, int returnOption) throws EASBizException, BOSException {
        if ("templateNotExist".equals(id)) {
            this.application.close();
        }
        super.afterConfirm(id, returnOption);
    }

    public boolean beforeOperation(FormOperation operation) throws BOSException, EASBizException {
        if ("Save".equalsIgnoreCase(operation.getOperation()) || "Submit".equalsIgnoreCase(operation.getOperation())) {
            this.checkPermission("cp_bc_BizAccountOutBill_Update");
            if (!this.verifyModel()) {
                return false;
            }
        }
        this.operateAction = operation.getOperation();
        return super.beforeOperation(operation);
    }

    private boolean verifyModel() {
        boolean retboolean = true;
        BizAccountOutBillEntryCollection entryColl = (BizAccountOutBillEntryCollection)((Object)this.application.getBillModel().getBillValue().get("entries"));
        if (entryColl != null) {
            int j = entryColl.size();
            for (int i = 0; i < j; ++i) {
                BizAccountOutBillEntryInfo entryInfo = entryColl.get(i);
                BigDecimal amount = entryInfo.getAmount();
                BigDecimal amountApproved = entryInfo.getAmountApproved();
                if (amount != null && amount.compareTo(new BigDecimal("0")) < 0) {
                    this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"86_BizAccountOutBillPlugin"));
                    retboolean = false;
                    break;
                }
                if (amountApproved != null && amountApproved.compareTo(new BigDecimal("0")) < 0) {
                    this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"87_BizAccountOutBillPlugin"));
                    retboolean = false;
                    break;
                }
                if (amount == null || amount.compareTo(amountApproved) >= 0) continue;
                this.application.showMessage(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"88_BizAccountOutBillPlugin"));
                retboolean = false;
                break;
            }
        }
        return retboolean;
    }

    public void lockElement(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String str = arg[i];
            this.application.lockElement(str, true);
        }
    }

    public void unLockElement(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String str = arg[i];
            this.application.lockElement(str, false);
        }
    }
}

