/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.rabbitmq.util.MD5EncryptUtils;
import com.kingdee.eas.base.param.INewParamAfterDeal;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamSetModify;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BCParamCheck
implements INewParamCheck,
INewParamAfterDeal,
IParamSetModify {
    private static final Log log = LogFactory.getLog(BCParamCheck.class);
    private static String[] WATINGEXPENSE_BILLTABLE = new String[]{"T_BC_DAILYLOANBILL", "T_BC_EVECTIONLOANBILL"};
    private static Map cacheMap = new HashMap();
    public static int timeOut = 30000;
    private static Map validatorMap = new HashMap();

    public boolean setParamModify(Context ctx, ParamInfo paramInfo) throws BOSException, EASBizException {
        return false;
    }

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        if (modelCol == null || modelCol.size() == 0) {
            return;
        }
        String number = modelCol.get(0).getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GLParamCheck: Parameter:" + number + "; OrgCount:" + modelCol.size() + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof MultiOrgValidator) {
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                } else if (validator instanceof SingleOrgValidator) {
                    for (int i = 0; i < modelCol.size(); ++i) {
                        ((SingleOrgValidator)validator).check(ctx, modelCol.get(i));
                    }
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
        String number = model.getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (log.isDebugEnabled()) {
            log.debug((Object)("GLParamCheck: Parameter:" + number + "; validator:" + validator));
        }
        if (validator != null) {
            try {
                if (validator instanceof SingleOrgValidator) {
                    ((SingleOrgValidator)validator).check(ctx, model);
                } else if (validator instanceof MultiOrgValidator) {
                    ParamItemCollection modelCol = new ParamItemCollection();
                    modelCol.add(model);
                    ((MultiOrgValidator)validator).check(ctx, modelCol);
                }
            }
            catch (SQLException e) {
                throw new SQLAccessException(e);
            }
        }
    }

    public void afterDeal(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
    }

    public void afterDeal(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
    }

    static {
        validatorMap.put("CP003", new Validator_CP003());
        validatorMap.put("CP008", new Validator_CP008());
    }

    private static class Validator_CP008
    implements MultiOrgValidator {
        private Validator_CP008() {
        }

        @Override
        public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException, SQLException {
            ArrayList<String> orgIdList = new ArrayList<String>();
            ParamItemInfo model = null;
            int k = modelCol.size();
            for (int i = 0; i < k; ++i) {
                model = modelCol.get(i);
                orgIdList.add(model.getOrgUnitID().getId().toString());
            }
            if (model == null || orgIdList == null || orgIdList.size() < 1) {
                return;
            }
            Collections.sort(orgIdList);
            String paramYesKey = "CP008Yes" + MD5EncryptUtils.encryptByMd5((String)orgIdList.toString());
            String paramNoKey = "CP008No" + MD5EncryptUtils.encryptByMd5((String)orgIdList.toString());
            long currentTim = System.currentTimeMillis();
            if ("true".equals(model.getValue())) {
                long cacheTim;
                if (cacheMap.containsKey(paramYesKey) && currentTim - (cacheTim = ((Long)cacheMap.get(paramYesKey)).longValue()) < (long)timeOut) {
                    cacheMap.put(paramYesKey, currentTim);
                    return;
                }
                try {
                    IRowSet hasExpensing = this.checkBillState(ctx, orgIdList, "60");
                    if (hasExpensing != null && hasExpensing.next()) {
                        cacheMap.put(paramYesKey, currentTim);
                        throw new BizCollException(BizCollException.PARAM_CP008_UPDATE_WORNING);
                    }
                    if (cacheMap.containsKey(paramNoKey)) {
                        cacheMap.remove(paramNoKey);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else if ("false".equals(model.getValue())) {
                long cacheTim;
                if (cacheMap.containsKey(paramNoKey) && currentTim - (cacheTim = ((Long)cacheMap.get(paramNoKey)).longValue()) < (long)timeOut) {
                    cacheMap.put(paramNoKey, currentTim);
                    return;
                }
                try {
                    IRowSet hasPayBill = this.checkBillState(ctx, orgIdList, "65,70");
                    if (hasPayBill != null && hasPayBill.next()) {
                        cacheMap.put(paramNoKey, currentTim);
                        throw new BizCollException(BizCollException.PARAM_CP008_UPDATENO_WORNING);
                    }
                    if (cacheMap.containsKey(paramYesKey)) {
                        cacheMap.remove(paramYesKey);
                    }
                }
                catch (SQLException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }

        private IRowSet checkBillState(Context ctx, ArrayList orgIdList, String stateStr) throws BOSException, SQLException {
            if (orgIdList == null || orgIdList.size() < 1) {
                return null;
            }
            String idParam = BizCollUtil.convertListToSqlParamStr(orgIdList);
            StringBuilder billSql = new StringBuilder();
            ArrayList<String> paramList = new ArrayList<String>();
            billSql.append(" SELECT * FROM (\n ");
            int len = WATINGEXPENSE_BILLTABLE.length;
            for (int i = 0; i < len; ++i) {
                billSql.append(" SELECT FID, FNUMBER FROM ").append(WATINGEXPENSE_BILLTABLE[i]);
                if (orgIdList.size() > 1) {
                    billSql.append(" WHERE FAPPLIERCOMPANYID in ( ").append(idParam).append(" ) ");
                } else {
                    billSql.append(" WHERE FAPPLIERCOMPANYID = ? ");
                }
                if (stateStr.contains(",")) {
                    billSql.append(" AND (FSTATE in (").append(stateStr).append(") AND  FAMOUNTBALANCE > 0) ");
                } else {
                    billSql.append(" AND (FSTATE = ").append(stateStr).append(" AND  FAMOUNTBALANCE > 0) ");
                }
                if (i < len - 1) {
                    billSql.append("\n UNION ALL \n");
                }
                for (int j = 0; j < orgIdList.size(); ++j) {
                    paramList.add(orgIdList.get(j).toString());
                }
            }
            billSql.append(" \n ) as A ");
            return DbUtil.executeQuery((Context)ctx, (String)billSql.toString(), (Object[])paramList.toArray());
        }
    }

    private static class Validator_CP003
    implements SingleOrgValidator {
        private Validator_CP003() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException, SQLException {
            String orgUnitId = model.getOrgUnitID().getId().toString();
            HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
            hmParamIn.put("CP002", new ObjectUuidPK(orgUnitId));
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            boolean allowcussent = Boolean.valueOf(hmAllParam.get("CP002").toString());
            if (!allowcussent) {
                throw new BizCollException(BizCollException.PARAM_CP003_ENABLE_WORNING);
            }
        }
    }

    private static interface MultiOrgValidator {
        public void check(Context var1, ParamItemCollection var2) throws BOSException, EASBizException, SQLException;
    }

    private static interface SingleOrgValidator {
        public void check(Context var1, ParamItemInfo var2) throws BOSException, EASBizException, SQLException;
    }
}

