/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCommonUtilForWKFacadeFactory;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillCollection;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillCollection;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CommonDataUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.CommonDataUtil");
    static Map map = null;

    public static List getRecordsOfCheckSourceBill(Context ctx, BizCollBillTypeEnum billtype, Map map) throws BOSException, ParserException {
        ArrayList listModel = new ArrayList();
        Set set = null;
        if (map.get("relationIds") != null) {
            set = BizCollUtil.getBillIdByRelationId(ctx, billtype, (String)map.get("relationIds"));
            if (set != null && set.size() > 0) {
                map.put("billIds", set);
            } else {
                return listModel;
            }
        }
        map.put("isCheckSource", true);
        AbstractObjectCollection con = null;
        logger.error((Object)("---cpbc--getSourceBills--getRecordsOfCheckSourceBill--billtype:" + (Object)((Object)billtype)));
        if (billtype.equals((Object)BizCollBillTypeEnum.DAILY_LOAN)) {
            con = DailyLoanBillEntryFactory.getLocalInstance(ctx).getDailyLoanBillEntryCollection(CommonDataUtil.getLoanBillEntityView(ctx, false, map));
        } else if (billtype.equals((Object)BizCollBillTypeEnum.EVECTION_LOAN)) {
            con = EvectionLoanBillEntryFactory.getLocalInstance(ctx).getEvectionLoanBillEntryCollection(CommonDataUtil.getLoanBillEntityView(ctx, true, map));
        } else if (billtype.equals((Object)BizCollBillTypeEnum.OTHER_EXPENSE)) {
            con = OtherExpenseBillEntryFactory.getLocalInstance(ctx).getOtherExpenseBillEntryCollection(CommonDataUtil.getReqBillEntityView(ctx, false, map));
        } else if (billtype.equals((Object)BizCollBillTypeEnum.EVECTION_REQ)) {
            con = EvectionReqBillEntryFactory.getLocalInstance(ctx).getEvectionReqBillEntryCollection(CommonDataUtil.getReqBillEntityView(ctx, true, map));
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("CP046");
        Map mapCp046 = new HashMap();
        String CP046 = "0";
        try {
            mapCp046 = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(list);
            CP046 = mapCp046.get("CP046").toString();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        if (con != null) {
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                CommonDataUtil.contructCheckModel((CoreBillEntryBaseInfo)con.getObject(i), listModel, CP046);
            }
        }
        return listModel;
    }

    public static List getRecordsOfCreateToBills(Context ctx, BizCollBillTypeEnum billtype, Map map) throws BOSException, ParserException {
        ArrayList listModel = new ArrayList();
        if (billtype.equals((Object)BizCollBillTypeEnum.DAILY_LOAN)) {
            CommonDataUtil.getReqBillRecords(ctx, false, listModel, map);
        } else if (billtype.equals((Object)BizCollBillTypeEnum.EVECTION_LOAN)) {
            CommonDataUtil.getReqBillRecords(ctx, true, listModel, map);
        } else if (billtype.equals((Object)BizCollBillTypeEnum.BIZ_ACCOUNT)) {
            CommonDataUtil.getReqBillRecords(ctx, false, listModel, map);
            CommonDataUtil.getLoanBillRecords(ctx, false, listModel, map);
        } else if (billtype.equals((Object)BizCollBillTypeEnum.TRAVEL_ACCOUNT)) {
            CommonDataUtil.getReqBillRecords(ctx, true, listModel, map);
            CommonDataUtil.getLoanBillRecords(ctx, true, listModel, map);
        }
        return listModel;
    }

    public static FilterInfo getPersonAndOrgFilter(Context ctx, Map map, String userId, String personId, String companyId) throws BOSException {
        IOrgUnitRelation iOrgUnitRelation = null;
        IPositionMember iPositionMember = null;
        if (ctx != null) {
            iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        } else {
            iOrgUnitRelation = OrgUnitRelationFactory.getRemoteInstance();
            iPositionMember = PositionMemberFactory.getRemoteInstance();
        }
        boolean isDepartmentCtrl = map.get("CP014") == null ? false : new Boolean(map.get("CP014").toString());
        FilterInfo tempFilter = new FilterInfo();
        if (isDepartmentCtrl) {
            String queryPositionOql = "SELECT POSITION.*, POSITION.ADMINORGUNIT.ID, POSITION.ADMINORGUNIT.NAME,POSITION.ADMINORGUNIT.NUMBER, POSITION.ADMINORGUNIT.PARENT, POSITION.ADMINORGUNIT.ISCOSTORGUNIT, POSITION.ADMINORGUNIT.LONGNUMBER WHERE PERSON.ID = '%s' AND POSITION.ADMINORGUNIT.ID IN (SELECT DISTINCT RELATION.FFROMUNITID FROM T_ORG_UNITRELATION RELATION INNER JOIN T_ORG_TYPERELATION TYPE ON TYPE.FID=RELATION.FTYPERELATIONID WHERE RELATION.FTOUNITID='%s' AND TYPE.FFROMTYPE=0 AND TYPE.FTOTYPE=1) AND POSITION.ADMINORGUNIT.ISSEALUP = 0 ORDER BY ISPRIMARY DESC, POSITION.NUMBER ASC";
            PositionMemberCollection positionMembers = iPositionMember.getPositionMemberCollection(String.format(queryPositionOql, personId, companyId));
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            if (positionMembers != null && positionMembers.size() > 0) {
                PositionInfo position = positionMembers.get(0).getPosition();
                adminOrgUnitInfo = position.getAdminOrgUnit();
                tempFilter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)adminOrgUnitInfo.getNumber(), CompareType.EQUALS));
            } else {
                tempFilter.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)"", CompareType.EQUALS));
            }
        } else {
            tempFilter.getFilterItems().add(new FilterItemInfo("biller.id", (Object)userId, CompareType.EQUALS));
            if (map.get("applier") != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)map.get("applier").toString(), CompareType.EQUALS));
                tempFilter.setMaskString("#0 or #1");
            }
        }
        return tempFilter;
    }

    public static FilterInfo getPersonAndOrgFilterByAddRow(Context ctx, Map map) throws BOSException {
        boolean isDepartmentCtrl = map.get("CP014") == null ? false : new Boolean(map.get("CP014").toString());
        boolean isNeedCompanyFilter = map.get("CP052") == null ? false : new Boolean(map.get("CP052").toString());
        boolean isNeedCompanyFilterByCreator = map.get("CP05201") == null ? false : new Boolean(map.get("CP05201").toString());
        FilterInfo tempFilter = new FilterInfo();
        if (isDepartmentCtrl) {
            String orgUnit = null;
            if (map.get("orgUnit") != null && !StringUtils.isEmpty((String)map.get("orgUnit").toString())) {
                orgUnit = map.get("orgUnit").toString();
            }
            tempFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnit, CompareType.EQUALS));
        } else {
            String applier = null;
            if (map.get("applier") != null && !StringUtils.isEmpty((String)map.get("applier").toString())) {
                applier = map.get("applier").toString();
            }
            if (isNeedCompanyFilter) {
                String companyId = null;
                if (map.get("companyId") != null && !StringUtils.isEmpty((String)map.get("companyId").toString())) {
                    companyId = map.get("companyId").toString();
                }
                tempFilter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)applier, CompareType.EQUALS));
                if (isNeedCompanyFilterByCreator) {
                    tempFilter.getFilterItems().add(new FilterItemInfo("biller.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
                    tempFilter.setMaskString("#0 or #1");
                }
                FilterInfo comFilter = new FilterInfo();
                comFilter.getFilterItems().add(new FilterItemInfo("applierCompany.id", (Object)companyId, CompareType.EQUALS));
                tempFilter.mergeFilter(comFilter, "and");
            } else {
                if (isNeedCompanyFilterByCreator) {
                    tempFilter.getFilterItems().add(new FilterItemInfo("biller.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
                    tempFilter.setMaskString("#0 or #1");
                }
                tempFilter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)applier, CompareType.EQUALS));
            }
        }
        return tempFilter;
    }

    public static FilterInfo getBillIdSetFilter(Context ctx, BOSObjectType bosType, FilterInfo filter, Map map) throws BOSException {
        FilterInfo tempFilter = null;
        IDynamicObject iDynamicObject = null;
        iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        IObjectPK[] idArray = iDynamicObject.getPKList(bosType, filter, sorter);
        Set<String> idSet = new HashSet<String>();
        for (int i = 0; i < idArray.length; ++i) {
            idSet.add(idArray[i].toString());
        }
        if (map.get("CP051") == "false" && BizCollUtil.evectionReqBosType.equals((Object)bosType)) {
            try {
                idSet = BizCollUtil.getForBillIdSet(ctx, idSet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (BizCollUtil.isLoanBill(bosType)) {
            idSet = CommonUtilFacadeFactory.getLocalInstance(ctx).getCheckDestBillDoneForBillIdSet(idSet);
        }
        if (idSet.size() > 0) {
            String field = "id";
            tempFilter = new FilterInfo();
            if (map.get("isCheckSource") != null) {
                field = "bill.id";
                tempFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
                if (map.get("billNumber") != null) {
                    tempFilter.getFilterItems().add(new FilterItemInfo("bill.number", (Object)("%" + map.get("billNumber") + "%"), CompareType.LIKE));
                }
            }
            logger.error((Object)("---cpbc--getSourceBills--getBillIdSetFilter--tempFilter:" + tempFilter));
            tempFilter.getFilterItems().add(new FilterItemInfo(field, idSet, CompareType.INCLUDE));
            if (map.get("selectedIds") != null && ((Set)map.get("selectedIds")).size() > 0) {
                tempFilter.getFilterItems().add(new FilterItemInfo("id", (Object)((Set)map.get("selectedIds")), CompareType.NOTINCLUDE));
            }
            if (map.get("billIds") != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo(field, (Object)((Set)map.get("billIds")), CompareType.INCLUDE));
            }
            if (map.get("expenseTypeId") != null) {
                tempFilter.getFilterItems().add(new FilterItemInfo("expenseType", map.get("expenseTypeId"), CompareType.EQUALS));
            }
        }
        return tempFilter;
    }

    private static FilterInfo getAmountBalanceFilter() throws BOSException {
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
        return tempFilter;
    }

    @Deprecated
    private static EntityViewInfo getLoanBillEntityView(Context ctx, boolean isEvection, Map map) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (map.get("isCheckSource") != null) {
            entityViewInfo.setSelector(CommonDataUtil.getCheckSelectors());
        } else {
            entityViewInfo.setSelector(CommonDataUtil.getCreateSelectors());
        }
        if (map.get("billid") != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", map.get("billid")));
            entityViewInfo.setFilter(filter);
            entityViewInfo.setSorter(CommonDataUtil.getSorter(map.get("isCheckSource")));
            return entityViewInfo;
        }
        FilterInfo filter = CommonDataUtil.getLoanBillFilter(ctx, isEvection, map);
        logger.error((Object)("---cpbc--getSourceBills--getLoanBillEntityView--filter:" + filter));
        BOSObjectType bosType = isEvection ? BizCollUtil.evectionloanBosType : BizCollUtil.dailyloanBosType;
        FilterInfo entryfilter = CommonDataUtil.getBillIdSetFilter(ctx, bosType, filter, map);
        if (entryfilter != null && entryfilter.getFilterItems().size() > 0) {
            entityViewInfo.setFilter(entryfilter);
        } else if (map.get("isCheckSource") != null) {
            entityViewInfo.setFilter("bill.state=-1");
        } else {
            entityViewInfo.setFilter("state=-1");
        }
        entityViewInfo.setSorter(CommonDataUtil.getSorter(map.get("isCheckSource")));
        return entityViewInfo;
    }

    public static FilterInfo getLoanBillFilter(Context ctx, boolean isEvection, Map map) throws BOSException {
        FilterInfo filter = new FilterInfo();
        if (map.get("billid") != null) {
            filter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", map.get("billid")));
        } else {
            BizCollBillTypeEnum billType = (BizCollBillTypeEnum)((Object)map.get("billtype"));
            boolean isNeedRelaFi = map.get("CP002") == null ? false : new Boolean(map.get("CP002").toString());
            boolean isNeedRelaCas = map.get("CP008") == null ? false : new Boolean(map.get("CP008").toString());
            boolean isNeedRelaAp = map.get("CP042") == null ? false : new Boolean(map.get("CP042").toString());
            boolean isRepayFrom = false;
            FilterInfo tempFilter = new FilterInfo();
            FilterInfo tempFilterAp = new FilterInfo();
            filter = CommonDataUtil.getPersonAndOrgFilterByAddRow(ctx, map);
            filter.mergeFilter(CommonDataUtil.getAmountBalanceFilter(), "and");
            filter.mergeFilter(CommonDataUtil.getOnRePayFilter(), "and");
            if (map.get("billtype").equals((Object)BizCollBillTypeEnum.REPAYMENT)) {
                isRepayFrom = true;
            }
            FilterItemCollection fic = tempFilter.getFilterItems();
            FilterItemCollection ficAp = tempFilterAp.getFilterItems();
            if (isNeedRelaCas) {
                fic.add(new FilterItemInfo("loanState", (Object)"N", CompareType.EQUALS));
                fic.add(new FilterItemInfo("state", (Object)70));
                if (BizCollBillTypeEnum.REPAYMENT.equals((Object)billType)) {
                    fic.add(new FilterItemInfo("state", (Object)65));
                    tempFilter.setMaskString("#0 and(#1 or #2)");
                }
            } else if (isNeedRelaFi) {
                fic.add(new FilterItemInfo("state", (Object)60));
                fic.add(new FilterItemInfo("amountNotPaid", (Object)0));
            } else if (!isRepayFrom) {
                fic.add(new FilterItemInfo("state", (Object)60));
            }
            if (!isEvection && isNeedRelaAp && (BizCollBillTypeEnum.REPAYMENT.equals((Object)billType) || BizCollBillTypeEnum.TRAVEL_ACCOUNT.equals((Object)billType) || BizCollBillTypeEnum.BIZ_ACCOUNT.equals((Object)billType))) {
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill is null"));
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill", (Object)false));
                tempFilterAp.setMaskString("#0 or #1");
            }
            if (!isEvection && !isNeedRelaAp) {
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill is null"));
                ficAp.add(new FilterItemInfo("isCreatePrePaymentBill", (Object)false));
                tempFilterAp.setMaskString("#0 or #1");
            }
            filter.mergeFilter(tempFilter, "and");
            filter.mergeFilter(tempFilterAp, "and");
            try {
                String fieldFilter;
                if (map.get("fieldFilter") != null && !StringUtils.isEmpty((String)(fieldFilter = map.get("fieldFilter").toString()))) {
                    FilterInfo comFilter1 = new FilterInfo(fieldFilter);
                    filter.mergeFilter(comFilter1, "and");
                }
            }
            catch (Exception e) {
                logger.error((Object)("loanBill fieldFilter deal error. " + e.getMessage()), (Throwable)e);
            }
            filter = BizCommonUtilForWKFacadeFactory.getLocalInstance(ctx).getLoanBillEntityView(filter, isEvection, map);
        }
        return filter;
    }

    public static FilterInfo getOnRePayFilter() throws BOSException {
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("isRePay", (Object)0, CompareType.EQUALS));
        tempFilter.getFilterItems().add(new FilterItemInfo("isRePay", null, CompareType.EQUALS));
        tempFilter.setMaskString("#0 or #1");
        return tempFilter;
    }

    @Deprecated
    private static EntityViewInfo getReqBillEntityView(Context ctx, boolean isEvection, Map map) throws BOSException, ParserException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (map.get("isCheckSource") != null) {
            entityViewInfo.setSelector(CommonDataUtil.getCheckSelectors());
        } else {
            entityViewInfo.setSelector(CommonDataUtil.getCreateSelectors());
        }
        FilterInfo filter = new FilterInfo();
        if (map.get("billid") != null) {
            filter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", map.get("billid")));
            entityViewInfo.setFilter(filter);
            entityViewInfo.setSorter(CommonDataUtil.getSorter(map.get("isCheckSource")));
            return entityViewInfo;
        }
        filter = CommonDataUtil.getReqBillFilter(ctx, isEvection, map);
        logger.error((Object)("---cpbc--getSourceBills--getReqBillEntityView--filter:" + filter));
        BOSObjectType bosType = isEvection ? BizCollUtil.evectionReqBosType : BizCollUtil.otherBillBosType;
        FilterInfo entryfilter = CommonDataUtil.getBillIdSetFilter(ctx, bosType, filter, map);
        if (entryfilter != null && entryfilter.getFilterItems().size() > 0) {
            entityViewInfo.setFilter(entryfilter);
        } else if (map.get("isCheckSource") != null) {
            entityViewInfo.setFilter("bill.state=-1");
        } else {
            entityViewInfo.setFilter("state=-1");
        }
        return entityViewInfo;
    }

    public static FilterInfo getReqBillFilter(Context ctx, boolean isEvection, Map map) throws BOSException {
        FilterInfo filter = CommonDataUtil.getPersonAndOrgFilterByAddRow(ctx, map);
        filter.mergeFilter(CommonDataUtil.getAmountBalanceFilter(), "and");
        FilterInfo tempFilter = new FilterInfo();
        tempFilter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
        filter.mergeFilter(tempFilter, "and");
        try {
            String fieldFilter;
            if (map.get("fieldFilter") != null && !StringUtils.isEmpty((String)(fieldFilter = map.get("fieldFilter").toString()))) {
                FilterInfo comFilter1 = new FilterInfo(fieldFilter);
                filter.mergeFilter(comFilter1, "and");
            }
        }
        catch (Exception e) {
            logger.error((Object)("reqBill fieldFilter deal error. " + e.getMessage()), (Throwable)e);
        }
        return filter;
    }

    public static SorterItemCollection getSorter(Object isCheckSource) {
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = null;
        item = isCheckSource != null ? new SorterItemInfo("bill.bizreqdate") : new SorterItemInfo("bizreqdate");
        item.setSortType(SortType.DESCEND);
        sorter.add(item);
        if (isCheckSource != null) {
            item = new SorterItemInfo("bill.id");
            sorter.add(item);
        }
        return sorter;
    }

    public static SelectorItemCollection getCreateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bizReqDate"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("operationType.name"));
        return sic;
    }

    public static SelectorItemCollection getCheckSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("bill.createTime"));
        sic.add(new SelectorItemInfo("bill.number"));
        sic.add(new SelectorItemInfo("bill.amountApproved"));
        sic.add(new SelectorItemInfo("bill.cause"));
        sic.add(new SelectorItemInfo("bill.operationType.name"));
        sic.add(new SelectorItemInfo("bill.sourceBillID"));
        sic.add(new SelectorItemInfo("bill.billTypeCode"));
        sic.add(new SelectorItemInfo("bill.isCreatePrePaymentBill"));
        sic.add(new SelectorItemInfo("bill.isCreatePayBill"));
        sic.add(new SelectorItemInfo("bill.isCreatePayPlanBill"));
        sic.add(new SelectorItemInfo("bill.applier.id"));
        sic.add(new SelectorItemInfo("bill.applier.name"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountBalanceOri"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("exchangeRatePrecision"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("bill.amountControlType"));
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.displayName"));
        sic.add(new SelectorItemInfo("bill.costedDept.id"));
        sic.add(new SelectorItemInfo("bill.costedDept.name"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        return sic;
    }

    private static List getReqBillRecords(Context ctx, boolean isEvection, List listModel, Map map) throws BOSException, ParserException {
        if (isEvection) {
            EvectionReqBillCollection con = EvectionReqBillFactory.getLocalInstance(ctx).getEvectionReqBillCollection(CommonDataUtil.getReqBillEntityView(ctx, isEvection, map));
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                EvectionReqBillInfo info = con.get(i);
                CommonDataUtil.contructModel(info, listModel, BizCollBillTypeEnum.EVECTION_REQ);
            }
        } else {
            OtherExpenseBillCollection con = OtherExpenseBillFactory.getLocalInstance(ctx).getOtherExpenseBillCollection(CommonDataUtil.getReqBillEntityView(ctx, isEvection, map));
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                OtherExpenseBillInfo info = con.get(i);
                CommonDataUtil.contructModel(info, listModel, BizCollBillTypeEnum.OTHER_EXPENSE);
            }
        }
        return listModel;
    }

    private static List getLoanBillRecords(Context ctx, boolean isEvection, List listModel, Map map) throws BOSException, ParserException {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        if (isEvection) {
            EvectionLoanBillCollection con = EvectionLoanBillFactory.getLocalInstance(ctx).getEvectionLoanBillCollection(CommonDataUtil.getLoanBillEntityView(ctx, isEvection, map));
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                EvectionLoanBillInfo info = con.get(i);
                CommonDataUtil.contructModel(info, listModel, BizCollBillTypeEnum.EVECTION_LOAN);
            }
        } else {
            DailyLoanBillCollection con = DailyLoanBillFactory.getLocalInstance(ctx).getDailyLoanBillCollection(CommonDataUtil.getLoanBillEntityView(ctx, isEvection, map));
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                DailyLoanBillInfo info = con.get(i);
                CommonDataUtil.contructModel(info, listModel, BizCollBillTypeEnum.DAILY_LOAN);
            }
        }
        return listModel;
    }

    private static void contructModel(BizCollBillBaseInfo info, List listModel, BizCollBillTypeEnum billtype) {
        if (info != null) {
            map = new HashMap();
            map.put("id", info.getId().toString());
            map.put("bizReqDate", info.getBizReqDate());
            map.put("number", info.getNumber());
            map.put("name", info.getName());
            map.put("amount", info.getAmount());
            map.put("amountApproved", info.getAmountApproved());
            map.put("cause", info.getCause());
            map.put("amountBalance", info.getAmountBalance());
            if (info.getOperationType() != null) {
                map.put("operationType", info.getOperationType().getName());
            } else {
                map.put("operationType", "");
            }
            map.put("billtype", billtype);
            listModel.add(map);
        }
    }

    private static void contructCheckModel(CoreBillEntryBaseInfo info, List listModel, String CP046) {
        if (info != null) {
            map = new HashMap();
            CommonDataUtil.contructCheckModelMap(info, map, CP046);
            listModel.add(map);
        }
    }

    public static void contructCheckModelMap(CoreBillEntryBaseInfo info, Map map, String CP046) {
        IObjectValue billInfo = info.getObjectValue("bill");
        map.put("id", billInfo.get("id").toString());
        map.put("bizReqDate", billInfo.getTimestamp("createTime"));
        map.put("number", billInfo.get("number"));
        if (billInfo.getObjectValue("applier") != null) {
            map.put("applier.name", billInfo.getObjectValue("applier").get("name"));
        } else {
            map.put("applier.name", "");
        }
        map.put("amountBalanceOri", info.getBigDecimal("amountBalanceOri"));
        map.put("amountApproved", info.getBigDecimal("amountApproved"));
        map.put("exchangeRate", info.getBigDecimal("exchangeRate"));
        map.put("convertMode", info.get("convertMode"));
        if (info.getObjectValue("bill").get("amountControlType").equals(20)) {
            map.put("amountControlType", true);
        } else {
            map.put("amountControlType", false);
        }
        map.put("exchangeRatePrecision", info.get("exchangeRatePrecision"));
        map.put("currencyTypeId", info.getObjectValue("currencyType").get("id"));
        map.put("currencyTypeName", info.getObjectValue("currencyType").get("name"));
        map.put("cause", billInfo.get("cause"));
        if (info.getObjectValue("bill").getObjectValue("operationType") != null) {
            map.put("operationType", billInfo.getObjectValue("operationType").get("name"));
        } else {
            map.put("operationType", "");
        }
        if (billInfo.get("billTypeCode") != null) {
            map.put("billTypeCode", billInfo.get("billTypeCode"));
        } else {
            map.put("billTypeCode", "");
        }
        map.put("amountBalance", info.getBigDecimal("amountBalance"));
        map.put("amountUsed", info.getBigDecimal("amountUsed"));
        if (info.getObjectValue("expenseType") != null) {
            map.put("sourceBillExpenseTypeId", info.getObjectValue("expenseType").get("id"));
            map.put("expenseTypeDisplayName", info.getObjectValue("expenseType").get("displayName"));
            map.put("expenseType", info.getObjectValue("expenseType").get("name"));
        } else {
            map.put("expenseType", "");
            map.put("sourceBillExpenseTypeId", "");
            map.put("expenseTypeDisplayName", "");
        }
        if (info.getObjectValue("project") != null) {
            map.put("sourceBillProjectId", info.getObjectValue("project").get("id"));
            map.put("sourceBillProjectName", info.getObjectValue("project").get("name"));
        } else {
            map.put("project", "");
            map.put("sourceBillProjectId", "");
        }
        if (CP046.equals("0")) {
            if (info.getObjectValue("bill").getObjectValue("costedDept") != null) {
                map.put("sourceBillCostCenterId", billInfo.getObjectValue("costedDept").get("id"));
                map.put("sourceBillCostCenterName", billInfo.getObjectValue("costedDept").get("name"));
            } else {
                map.put("sourceBillCostCenterId", "");
                map.put("sourceBillCostCenterName", "");
            }
        } else if (info.getObjectValue("costCenter") != null) {
            map.put("sourceBillCostCenterId", info.getObjectValue("costCenter").get("id"));
            map.put("sourceBillCostCenterName", info.getObjectValue("costCenter").get("name"));
        } else {
            map.put("sourceBillCostCenterId", "");
            map.put("sourceBillCostCenterName", "");
        }
        map.put("entryid", info.get("id"));
        if (info.getObjectValue("bill").get("sourceBillID") != null) {
            map.put("hasSourceBill", "true");
        } else {
            map.put("hasSourceBill", "false");
        }
        map.put("isCreatePrePaymentBill", billInfo.getBoolean("isCreatePrePaymentBill"));
        map.put("isCreatePayBill", billInfo.getBoolean("isCreatePayBill"));
        map.put("isCreatePayPlanBill", billInfo.getBoolean("isCreatePayPlanBill"));
    }

    public static String parseLongNumber(String longNumber) {
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        if (numbers.length != 0) {
            return numbers[numbers.length - 1];
        }
        return null;
    }

    public static final IBizCtrl getEntityBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)new MetaDataPK(entityObjectInfo.getFullName()));
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = CommonDataUtil.getBizInterface(ctx, clzFactory, null);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static final IBizCtrl getBizInterface(Context ctx, Class clzFactory, Context mainOrgCtx) throws BOSException {
        IBizCtrl iBiz = null;
        try {
            Class[] parameterTypes = new Class[]{Context.class};
            Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    public static List getSourceBillInfos(Set ids) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CP046");
        Map mapCp046 = new HashMap();
        String CP046 = "0";
        try {
            mapCp046 = ExpenseCommenFacadeFactory.getRemoteInstance().getParams(list);
            CP046 = mapCp046.get("CP046").toString();
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList listModel = new ArrayList();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(CommonDataUtil.getCheckSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        DailyLoanBillEntryCollection dailyCon = DailyLoanBillEntryFactory.getRemoteInstance().getDailyLoanBillEntryCollection(entityViewInfo);
        int size = dailyCon.size();
        for (int i = 0; i < size; ++i) {
            CommonDataUtil.contructCheckModel((CoreBillEntryBaseInfo)dailyCon.getObject(i), listModel, CP046);
        }
        EvectionLoanBillEntryCollection evectionCon = EvectionLoanBillEntryFactory.getRemoteInstance().getEvectionLoanBillEntryCollection(entityViewInfo);
        int size2 = evectionCon.size();
        for (int i = 0; i < size2; ++i) {
            CommonDataUtil.contructCheckModel((CoreBillEntryBaseInfo)evectionCon.getObject(i), listModel, CP046);
        }
        return listModel;
    }

    public static Map convertListToMap(List list) {
        if (list.size() > 0) {
            HashMap listMap = new HashMap();
            Map tempMap = new HashMap();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                tempMap = (Map)list.get(i);
                listMap.put(tempMap.get("entryid").toString(), tempMap);
            }
            return listMap;
        }
        return null;
    }
}

