/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.IDailyLoanBill;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DailyLoanCollectionEntriesAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.BizAccountBillReceivablesInfoAddByExcel");
    private String[] STRING_FIELDS_EN = new String[]{"collectionEntries.payerName", "collectionEntries.payerBank", "collectionEntries.payerAccount"};
    private String[] STRING_OBJS_EN = new String[]{"payerName", "payerBank", "payerAccount"};
    private String[] EXP_STRING = new String[]{"number", "payMode.name", "collectionEntries.payerName", "collectionEntries.payerAccount", "collectionEntries.payerBank", "openArea.number", "openArea.name", "currencyType.number", "currencyType.name", "collectionEntries.exchangeRate"};
    private String[] EXP_BIGDECIMAL = new String[]{"collectionEntries.amount", "collectionEntries.amountOri"};
    private IObjectPK TEMPPK = null;
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.DailyLoanCollectionEntryForDatatask";
    private final String initImportPermissionItem = "cp_bc_DailyLoan_initImport";
    private int hasLoanBillInitPermission = -1;
    private Set idsEverImported = new HashSet();
    Map<String, Object> initImportPermMap = new HashMap<String, Object>(128);
    private HashMap<String, DailyLoanBillEntryInfo> map;
    private static final String[] notNullFields = new String[]{"number", "collectionEntries.payerType", "collectionEntries.payerName"};
    private static final String[] notNullColNames = new String[]{"\u5355\u636e\u5934_\u5355\u636e\u7f16\u53f7", "\u6536\u6b3e\u4eba\u7c7b\u578b", "\u6536\u6b3e\u4eba"};
    private HashMap<String, Object> objectMap = new HashMap();

    private IObjectPK getInfoPKbyNumber(Context ctx, String number) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            CoreBaseCollection col = DailyLoanBillFactory.getLocalInstance(ctx).getCollection(viewInfo);
            if (col.size() > 0) {
                return new ObjectUuidPK(col.get(0).getId());
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DailyLoanBillAccountEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BizImportUtil.validateNotNullField(hsData, notNullFields, notNullColNames);
        DailyLoanBillInfo bill = null;
        Object data = null;
        Object numberdata = ((DataToken)hsData.get((Object)"number")).data;
        String str = null;
        DailyLoanBillEntryCollection entryCol = null;
        DailyLoanBillAccountEntryInfo entryInfo = null;
        Object[] params = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        str = numberdata.toString();
        if (str != null && str.trim().length() > 0) {
            SettlementTypeInfo info;
            block44: {
                PayerTypeEnum payerType;
                block42: {
                    this.TEMPPK = this.getInfoPKbyNumber(ctx, str);
                    if (this.TEMPPK != null) {
                        try {
                            IDailyLoanBill iFixBill = DailyLoanBillFactory.getLocalInstance(ctx);
                            SelectorItemCollection items = new SelectorItemCollection();
                            items.add(new SelectorItemInfo("applierCompany.id"));
                            items.add(new SelectorItemInfo("applierCompany.number"));
                            items.add(new SelectorItemInfo("applierCompany.name"));
                            items.add(new SelectorItemInfo("number"));
                            items.add(new SelectorItemInfo("state"));
                            items.add(new SelectorItemInfo("currencyType.number"));
                            items.add(new SelectorItemInfo("entries.currencyType.number"));
                            items.add(new SelectorItemInfo("entries.exchangeRate"));
                            items.add(new SelectorItemInfo("entries.convertMode"));
                            items.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
                            items.add(new SelectorItemInfo("applierCompany.id"));
                            items.add(new SelectorItemInfo("applierCompany.name"));
                            items.add(new SelectorItemInfo("applierCompany.number"));
                            DailyLoanBillInfo dailyLoanBillInfo = iFixBill.getDailyLoanBillInfo(this.TEMPPK, items);
                            CompanyOrgUnitInfo applierCompany = dailyLoanBillInfo.getApplierCompany();
                            this.hasLoanBillInitPermission = BizImportUtil.hasDailyInitImportPermission(ctx, applierCompany, "cp_bc_DailyLoan_initImport", this.initImportPermMap) ? 1 : 0;
                            if (this.hasLoanBillInitPermission == 0 && !dailyLoanBillInfo.getState().equals((Object)StateEnum.DRAFT)) {
                                params = new Object[]{userInfo.getName(), applierCompany.getName()};
                                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RES, (String)"NOT_PER_IMPORT_CHECK", (Locale)ctx.getOriginLocale()), params));
                            }
                            if (!(this.hasLoanBillInitPermission != 1 || dailyLoanBillInfo.getState().equals((Object)StateEnum.DRAFT) || dailyLoanBillInfo.getState().equals((Object)StateEnum.CHECKED) || dailyLoanBillInfo.getState().equals((Object)StateEnum.ALREADYPAYMENT))) {
                                params = new Object[]{userInfo.getName(), applierCompany.getName()};
                                throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RES, (String)"HAS_PER_IMPORT_CHECK", (Locale)ctx.getOriginLocale()), params));
                            }
                            entryCol = dailyLoanBillInfo.getEntries();
                            bill = dailyLoanBillInfo;
                        }
                        catch (BOSException e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                        catch (EASBizException e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_BILL", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                    }
                    if (this.map == null) {
                        this.map = new HashMap();
                        for (int i = 0; i < entryCol.size(); ++i) {
                            DailyLoanBillEntryInfo dailyentryInfo = entryCol.get(i);
                            if (dailyentryInfo.getCurrencyType() == null) continue;
                            this.map.put(dailyentryInfo.getCurrencyType().getNumber().trim(), dailyentryInfo);
                        }
                        if (bill.getCurrencyType() != null) {
                            DailyLoanBillEntryInfo enInfo = new DailyLoanBillEntryInfo();
                            enInfo.setExchangeRatePrecision(new Integer(4));
                            enInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                            enInfo.setExchangeRate(new BigDecimal(1));
                            this.map.put(bill.getCurrencyType().getNumber().trim(), enInfo);
                        }
                    }
                    entryInfo = new DailyLoanBillAccountEntryInfo();
                    entryInfo.setBill(bill);
                    entryInfo.setSeq(bill.getCollectionEntries().size() + 1);
                    payerType = null;
                    data = ((DataToken)hsData.get((Object)"collectionEntries.payerType")).data;
                    if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                        payerType = BizImportUtil.getPayerTypeValue(ctx, str);
                        entryInfo.setPayerType(payerType);
                    }
                    if ((data = ((DataToken)hsData.get((Object)"payMode.name")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                        try {
                            ISettlementType iSet = SettlementTypeFactory.getLocalInstance((Context)ctx);
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            viewInfo.setFilter(BizCollUtil.getInportFilter(str));
                            viewInfo.setSelector(BizCollUtil.getInportSic());
                            SettlementTypeCollection collection = iSet.getSettlementTypeCollection(viewInfo);
                            if (collection != null && collection.size() > 0) {
                                info = collection.get(0);
                                if (info != null) {
                                    entryInfo.setPayMode(info);
                                }
                                break block42;
                            }
                            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"PAYMODE_ERROR", (Locale)ctx.getOriginLocale()));
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"currencyType.number")).data) != null) {
                    str = data.toString().trim();
                    if (str == null || "".equals(str)) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"CURRENCYTYPE_NOT_NULL", (Locale)ctx.getOriginLocale()));
                    }
                    if (this.map.containsKey(str)) {
                        DailyLoanBillEntryInfo dailyinfo = this.map.get(str);
                        entryInfo.setConvertMode(dailyinfo.getConvertMode());
                        entryInfo.setExchangeRatePrecision(dailyinfo.getExchangeRatePrecision());
                        entryInfo.setExchangeRate(dailyinfo.getExchangeRate());
                        try {
                            CurrencyInfo info2;
                            ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
                            EntityViewInfo viewInfo = new EntityViewInfo();
                            FilterInfo filter = new FilterInfo();
                            filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                            viewInfo.setFilter(filter);
                            viewInfo.getSelector().add(new SelectorItemInfo("id"));
                            CurrencyCollection collection = icurreny.getCurrencyCollection(viewInfo);
                            if (collection != null && collection.size() > 0 && (info2 = collection.get(0)) != null) {
                                entryInfo.setCurrencyType(info2);
                            }
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_CURRENCYTYPE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                    }
                }
                for (int i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
                    Object o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
                    if (o == null) continue;
                    String value = o.toString();
                    entryInfo.setString(this.STRING_OBJS_EN[i], value);
                }
                if (PayerTypeEnum.customer.equals((Object)payerType) || PayerTypeEnum.supplier.equals((Object)payerType)) {
                    HashMap<String, Boolean> paramMap = new HashMap<String, Boolean>();
                    String companyId = "";
                    companyId = bill == null || bill.get("applierCompany") == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : ((CompanyOrgUnitInfo)bill.get("applierCompany")).getId().toString();
                    boolean cp075 = false;
                    String paramValue = "CP075";
                    String paramk = paramValue + companyId;
                    try {
                        if (this.objectMap.containsKey(paramk)) {
                            cp075 = (Boolean)this.objectMap.get(paramk);
                        } else {
                            cp075 = BizImportUtil.getParams(ctx, companyId, paramValue);
                            this.objectMap.put(paramk, cp075);
                        }
                        paramMap.put(paramValue, cp075);
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    catch (EASBizException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                    BizImportUtil.initImportPayerIdByPayerType(ctx, bill, entryInfo, hsData, payerType, this.objectMap, paramMap);
                } else {
                    BizImportUtil.initImportPayerId(ctx, entryInfo, hsData, this.objectMap);
                }
                try {
                    Object o = ((DataToken)hsData.get((Object)"collectionEntries.amountOri")).data;
                    if (o != null && o.toString().trim().length() > 0) {
                        BigDecimal value = new BigDecimal(o.toString());
                        if (value != null) {
                            entryInfo.setAmountOri(value);
                        }
                        break block44;
                    }
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"FAMOUNTORI_NOT_NULL", (Locale)ctx.getOriginLocale()));
                }
                catch (NumberFormatException nex) {
                    logger.error((Object)nex.getMessage());
                    throw new TaskExternalException("amountOri" + ResourceBase.getString((String)RES, (String)"NUMBERFORMET", (Locale)ctx.getOriginLocale()));
                }
            }
            BigDecimal rate = entryInfo.getExchangeRate();
            BigDecimal amountOri = entryInfo.getAmountOri();
            BigDecimal amount = entryInfo.getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? amountOri.multiply(rate).setScale(2, 4) : amountOri.divide(rate, 2, 4);
            entryInfo.setAmount(amount);
            data = ((DataToken)hsData.get((Object)"openArea.number")).data;
            if (data != null && (str = data.toString()) != null && str.trim().length() > 0) {
                info = null;
                try {
                    info = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaInfo("select id where number = '" + str + "'");
                }
                catch (ObjectNotFoundException e) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"NOT_EXIST_FOPENAREANUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{str}));
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                entryInfo.setOpenArea((OpenAreaInfo)info);
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"FNUMBER_NOT_NULL", (Locale)ctx.getOriginLocale()));
        }
        return entryInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            this.idsEverImported.add(this.TEMPPK);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filterInfo = BizCollUtil.getExportFilterForQuery(ctx, paramMap);
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.DailyLoanCollectionEntryForDatatask";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (!StringUtils.isEmpty((String)rs.getString("collectionEntries.payerType"))) {
                result.put("collectionEntries.payerType", BizImportUtil.getPayerTypeValue(ctx, String.valueOf(rs.getInt("collectionEntries.payerType"))).getAlias(ctx.getOriginLocale()));
            }
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING);
            BizCollUtil.initExportBigDecimalData(ctx, rs, result, this.EXP_BIGDECIMAL);
            if (StringUtils.isEmpty((String)rs.getString("collectionEntries.payerId"))) {
                result.put("isNoSysPayer", "1");
            } else {
                result.put("isNoSysPayer", "0");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    @Deprecated
    public static PayerTypeEnum getPayerTypeValue(String value) {
        PayerTypeEnum tSaved = PayerTypeEnum.other;
        if (value != null) {
            value = value.trim();
            List EnumList = PayerTypeEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                PayerTypeEnum payerTypeEnum = (PayerTypeEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(payerTypeEnum.getValue());
                String enumName = payerTypeEnum.getName();
                String enumAlias = payerTypeEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = payerTypeEnum;
                break;
            }
        }
        return tSaved;
    }
}

