/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.EvectionLoanBillAccountEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EvectionLoanCollectionEntriesAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.EvectionLoanCollectionEntriesAddByExcel");
    private String[] STRING_FIELDS_EN = new String[]{"collectionEntries.payerName", "collectionEntries.payerBank", "collectionEntries.payerAccount"};
    private String[] STRING_OBJS_EN = new String[]{"payerName", "payerBank", "payerAccount"};
    private String[] EXP_STRING = new String[]{"number", "payMode.name", "collectionEntries.payerName", "collectionEntries.payerAccount", "collectionEntries.payerBank", "openArea.number", "openArea.name", "currencyType.number", "currencyType.name", "collectionEntries.exchangeRate"};
    private String[] EXP_BIGDECIMAL = new String[]{"collectionEntries.amount", "collectionEntries.amountOri"};
    String[] IMP_BIGDECIMAL_FIELDS_EN = new String[]{"collectionEntries.amountOri"};
    String[] IMP_BIGDECIMAL_OBJS = new String[]{"amountOri"};
    private final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.EvectionLoanBillCollectionEntryForDatatask";
    private HashMap<String, CoreBaseInfo> billMap = new HashMap();
    private HashMap<String, CoreBaseInfo> dataMap = new HashMap();
    private static final String[] notNullFields = new String[]{"number", "collectionEntries.payerName"};
    private static final String[] notNullColNames = new String[]{"\u5355\u636e\u5934_\u5355\u636e\u7f16\u53f7", "\u6536\u6b3e\u4eba"};
    private HashMap<String, CoreBaseInfo> objectMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EvectionLoanBillAccountEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BizImportUtil.validateNotNullField(hsData, notNullFields, notNullColNames);
        EvectionLoanBillInfo billInfo = null;
        EvectionLoanBillEntryCollection entryCol = null;
        EvectionLoanBillEntryInfo entryInfo = null;
        EvectionLoanBillAccountEntryInfo accEntryInfo = null;
        Object objData = ((DataToken)hsData.get((Object)"number")).data;
        String strData = "";
        String paramData = "";
        if (objData != null && StringUtils.isNotEmpty((String)objData.toString())) {
            strData = objData.toString().trim();
            accEntryInfo = new EvectionLoanBillAccountEntryInfo();
            if (this.billMap.containsKey(strData)) {
                billInfo = (EvectionLoanBillInfo)this.billMap.get(strData);
                entryCol = billInfo.getEntries();
            } else {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)strData, CompareType.EQUALS));
                EntityViewInfo viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                SelectorItemCollection sec = viewInfo.getSelector();
                sec.add(new SelectorItemInfo("id"));
                sec.add(new SelectorItemInfo("state"));
                sec.add(new SelectorItemInfo("currencyType.number"));
                sec.add(new SelectorItemInfo("entries.currencyType.number"));
                sec.add(new SelectorItemInfo("entries.exchangeRate"));
                sec.add(new SelectorItemInfo("entries.convertMode"));
                sec.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
                try {
                    EvectionLoanBillCollection evecLoanBillcol = EvectionLoanBillFactory.getLocalInstance(ctx).getEvectionLoanBillCollection(viewInfo);
                    if (evecLoanBillcol.size() > 0) {
                        billInfo = evecLoanBillcol.get(0);
                        if (!billInfo.getState().equals((Object)StateEnum.DRAFT)) {
                            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"NOT_DRAFT_VALUE", (Locale)ctx.getOriginLocale()));
                        }
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"NOT_EXIST_BILL", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{strData}));
                    }
                    entryCol = billInfo.getEntries();
                    this.billMap.put(strData, (CoreBaseInfo)billInfo);
                }
                catch (BOSException bex) {
                    throw new TaskExternalException(bex.getMessage(), bex.getCause());
                }
            }
            accEntryInfo.setBill(billInfo);
            accEntryInfo.setSeq(billInfo.getCollectionEntries().size() + 1);
            objData = ((DataToken)hsData.get((Object)"payMode.name")).data;
            SettlementTypeInfo settlementInfo = new SettlementTypeInfo();
            if (objData != null && StringUtils.isNotEmpty((String)objData.toString())) {
                strData = objData.toString().trim();
                paramData = "payMode." + strData;
                if (this.dataMap.containsKey(paramData)) {
                    settlementInfo = (SettlementTypeInfo)this.dataMap.get(paramData);
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("deletedStatus"));
                    CoreBaseCollection coreCol = this.getCoreBaseCollection(ctx, settlementInfo.getBOSType(), sic, strData);
                    if (coreCol != null && coreCol.size() > 0) {
                        settlementInfo = (SettlementTypeInfo)coreCol.get(0);
                        this.dataMap.put(paramData, (CoreBaseInfo)settlementInfo);
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"PAYMODE_ERROR", (Locale)ctx.getOriginLocale()));
                    }
                }
                if (settlementInfo != null && settlementInfo.getDeletedStatus().getValue() == 1) {
                    accEntryInfo.setPayMode(settlementInfo);
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"ERROR_STATE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{strData}));
                }
            }
            if ((objData = ((DataToken)hsData.get((Object)"currencyType.number")).data) != null && StringUtils.isNotEmpty((String)objData.toString())) {
                strData = objData.toString().trim();
                if (billInfo.getCurrencyType() != null && strData.equals(billInfo.getCurrencyType().getNumber())) {
                    accEntryInfo.setCurrencyType(billInfo.getCurrencyType());
                    accEntryInfo.setExchangeRatePrecision(new Integer(4));
                    accEntryInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    accEntryInfo.setExchangeRate(new BigDecimal(1));
                }
                if (entryCol.size() > 0 && accEntryInfo.getCurrencyType() == null) {
                    for (int i = 0; i < entryCol.size(); ++i) {
                        entryInfo = entryCol.get(i);
                        if (entryInfo.getCurrencyType() == null || !strData.equals(entryInfo.getCurrencyType().getNumber())) continue;
                        accEntryInfo.setCurrencyType(entryInfo.getCurrencyType());
                        accEntryInfo.setConvertMode(entryInfo.getConvertMode());
                        accEntryInfo.setExchangeRate(entryInfo.getExchangeRate());
                        accEntryInfo.setExchangeRatePrecision(entryInfo.getExchangeRatePrecision());
                        break;
                    }
                }
                if (accEntryInfo.getCurrencyType() == null) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"NOT_EXIST_CURRENCYTYPE", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{strData}));
                }
            } else {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"CURRENCYTYPE_NOT_NULL", (Locale)ctx.getOriginLocale()));
            }
            objData = ((DataToken)hsData.get((Object)"openArea.number")).data;
            if (objData != null && StringUtils.isNotEmpty((String)objData.toString())) {
                strData = objData.toString().trim();
                paramData = "currencyType.number" + strData;
                OpenAreaInfo openAreaInfo = new OpenAreaInfo();
                if (this.dataMap.containsKey(paramData)) {
                    openAreaInfo = (OpenAreaInfo)this.dataMap.get(paramData);
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("number"));
                    CoreBaseCollection coreCol = this.getCoreBaseCollection(ctx, openAreaInfo.getBOSType(), sic, strData);
                    if (coreCol != null && coreCol.size() > 0) {
                        openAreaInfo = (OpenAreaInfo)coreCol.get(0);
                        this.dataMap.put(paramData, (CoreBaseInfo)openAreaInfo);
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"NOT_EXIST_FOPENAREANUMBER", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{strData}));
                    }
                }
                accEntryInfo.setOpenArea(openAreaInfo);
            }
            BizCollUtil.initInportBigDecimalData(ctx, null, accEntryInfo, hsData, this.IMP_BIGDECIMAL_FIELDS_EN, this.IMP_BIGDECIMAL_OBJS);
            BigDecimal exRate = accEntryInfo.getExchangeRate();
            BigDecimal amountOri = accEntryInfo.getAmountOri();
            BigDecimal amount = BizCollUtil.computeAmount(amountOri, accEntryInfo.getConvertMode(), exRate);
            accEntryInfo.setAmount(amount);
            for (int i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
                objData = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
                if (objData == null) continue;
                strData = objData.toString().trim();
                accEntryInfo.setString(this.STRING_OBJS_EN[i], strData);
            }
        } else {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.ImportDataResource", (String)"FNUMBER_NOT_NULL", (Locale)ctx.getOriginLocale()));
        }
        BizImportUtil.initImportPayerId(ctx, accEntryInfo, hsData, this.objectMap);
        return accEntryInfo;
    }

    private CoreBaseCollection getCoreBaseCollection(Context ctx, BOSObjectType bosObjectType, SelectorItemCollection sic, String nameOrNum) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)nameOrNum, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)nameOrNum, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        try {
            CoreBaseCollection coreCol = (CoreBaseCollection)DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, viewInfo);
            if (coreCol.size() > 1) {
                viewInfo.getFilter().clear();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)nameOrNum, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                coreCol = (CoreBaseCollection)DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, viewInfo);
            }
            return coreCol;
        }
        catch (BOSException bex) {
            logger.error((Object)bex.getMessage(), (Throwable)bex);
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iEvectionLoanBillAccount = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !iEvectionLoanBillAccount.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iEvectionLoanBillAccount.addnew(coreBaseInfo);
            } else {
                iEvectionLoanBillAccount.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        return BizCollUtil.getExportFilterForQuery(ctx, paramMap);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.EvectionLoanBillCollectionEntryForDatatask";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING);
            BizCollUtil.initExportBigDecimalData(ctx, rs, result, this.EXP_BIGDECIMAL);
            if (StringUtils.isEmpty((String)rs.getString("collectionEntries.payerId"))) {
                result.put("isNoSysPayer", "1");
            } else {
                result.put("isNoSysPayer", "0");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

