/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollCoreBillBase;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.AssistantAccountUtil;
import com.kingdee.eas.cp.bc.util.BizImportUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanReqAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.LoanReqAddByExcel");
    Map<String, Object> personPositionMap = new HashMap<String, Object>(128);
    Map<String, Object> initImportPermMap = new HashMap<String, Object>(128);
    String[] IMP_STRING = new String[]{"tel", "cause", "name"};
    String[] IMP_DATE = new String[]{"foreseeDate", "bizReqDate"};
    String[] IMP_BIGDECIMAL_FIELDS_EN = new String[]{"entries.amountOri", "entries.amount", "entries.amountApprovedOri", "entries.amountApproved"};
    String[] IMP_BIGDECIMAL_OBJS_EN = new String[]{"amountOri", "amount", "amountApprovedOri", "amountApproved"};
    String[] IMP_STRING_FIELDS_EN = new String[]{"entries.purpose", "entries.participants", "entries.comment"};
    String[] IMP_STRING_OBJS_EN = new String[]{"purpose", "participants", "comment"};
    String[] EXP_STRING = new String[]{"number", "name", "currencyType.name", "applier.name", "orgUnit.name", "applierCompany.name", "company.name", "costedDept.name", "tel", "cause", "payMode.name", "biller.name"};
    String[] EXP_STRING_EN = new String[]{"entries.purpose", "entries.comment", "expenseType.name", "entries.participants", "costCenter.name", "company1.name", "currencyType1.name", "entries.exchangeRate", "entries.convertMode", "entries.exchangeRatePrecision"};
    String[] EXP_DATE = new String[]{"bizReqDate", "foreseeDate", "billDate"};
    String[] EXP_BIGDECIMAL = new String[]{"amountApproved", "amount", "entries.amountOri", "entries.amount", "entries.amountApprovedOri", "entries.amountApproved"};
    private IObjectPK TEMPPK = null;
    private String TEMPNUMBER = null;
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";
    private final String solution = "com.kingdee.eas.cp.bc.app.DailyLoanWithEntryBillQuery";
    private Set idsEverImported = new HashSet();
    private final String initImportPermissionItem = "cp_bc_DailyLoan_initImport";
    private int hasLoanBillInitPermission = -1;
    private boolean isNeedBudget = false;
    private boolean loanBillUseBg = false;
    private boolean isFi = false;
    private boolean isCas = false;

    private IObjectPK getInfoPKbyNumber(Context ctx, String number) throws TaskExternalException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        try {
            CoreBaseCollection col = this.getController(ctx).getCollection(viewInfo);
            if (col.size() > 0) {
                return new ObjectUuidPK(col.get(0).getId());
            }
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DailyLoanBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), bex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
            this.idsEverImported.add(this.TEMPPK);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable chsData, Context ctx) throws TaskExternalException {
        DailyLoanBillInfo billInfo = new DailyLoanBillInfo();
        boolean importDataByRule = BizImportUtil.getBooleanParam(ctx, "importDataByRule");
        boolean isAddNew = !this.isSltImportUpdate();
        ICodingRuleManager iCodingRuleManager = BizImportUtil.getICodingRuleManager(ctx, isAddNew);
        IBizCollCoreBillBase iFixBill = (IBizCollCoreBillBase)this.getController(ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Object[] params = null;
        Object str = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP029");
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        for (int t = 0; t < chsData.size(); ++t) {
            Hashtable hsData = (Hashtable)chsData.get(new Integer(t));
            Object data = null;
            if (t == 0) {
                if (isAddNew) {
                    this.TEMPPK = BizImportUtil.dealWithNumberAddNew(ctx, iFixBill, billInfo, hsData, importDataByRule);
                } else {
                    billInfo = (DailyLoanBillInfo)BizImportUtil.dealWithNumberUpdate(ctx, iFixBill, hsData);
                    this.TEMPPK = new ObjectUuidPK(billInfo.getId());
                }
                if (this.TEMPPK == null || this.isSltImportUpdate()) {
                    try {
                        String state;
                        BizCollUtil.initInportDateData(ctx, billInfo, null, hsData, this.IMP_DATE, this.IMP_DATE);
                        BizCollUtil.initInportStringData(ctx, billInfo, null, hsData, this.IMP_STRING, this.IMP_STRING);
                        this.personPositionMap.put("perm.permItem", "cp_bc_DailyLoan_Import");
                        BizCollUtil.initInportCommonData(ctx, billInfo, hsData, this.personPositionMap);
                        CompanyOrgUnitInfo applierCompany = billInfo.getApplierCompany();
                        this.hasLoanBillInitPermission = BizImportUtil.hasDailyInitImportPermission(ctx, applierCompany, "cp_bc_DailyLoan_initImport", this.initImportPermMap) ? 1 : 0;
                        String string = state = hsData.get("state") != null && ((DataToken)hsData.get((Object)"state")).data != null ? ((DataToken)hsData.get((Object)"state")).data.toString() : "";
                        if (this.hasLoanBillInitPermission == 0 && !"20".equals(state) && !"\u6682\u5b58".equals(state)) {
                            params = new Object[]{userInfo.getName(), applierCompany.getName()};
                            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RES, (String)"NOT_PER_IMPORT_CHECK", (Locale)ctx.getOriginLocale()), params));
                        }
                        if (!(this.hasLoanBillInitPermission != 1 || "20".equals(state) || "\u6682\u5b58".equals(state) || "60".equals(state) || "\u5ba1\u6838\u901a\u8fc7".equals(state) || "70".equals(state) || "\u5df2\u4ed8\u6b3e".equals(state))) {
                            params = new Object[]{userInfo.getName(), applierCompany.getName()};
                            throw new TaskExternalException(MessageFormat.format(ResourceBase.getString((String)RES, (String)"HAS_PER_IMPORT_CHECK", (Locale)ctx.getOriginLocale()), params));
                        }
                        BizImportUtil.initPaymode(ctx, billInfo, hsData);
                        BizImportUtil.initStateForLoan(ctx, billInfo, hsData);
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    billInfo.setBillTypeCode(BizCollBillTypeEnum.DAILY_LOAN);
                    billInfo.setBillDate(new Date());
                }
                if (this.isSltImportUpdate() && this.TEMPPK != null && !this.idsEverImported.contains(this.TEMPPK)) {
                    billInfo.getEntries().clear();
                    billInfo.setAmount(null);
                    billInfo.setAmountApproved(null);
                }
                if (isAddNew && importDataByRule) {
                    BizImportUtil.buildNumber(ctx, billInfo, iCodingRuleManager);
                }
            }
            if (this.hasLoanBillInitPermission == 1) {
                try {
                    Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
                    this.isNeedBudget = new Boolean(paramMap.get("CP001").toString());
                    this.loanBillUseBg = new Boolean(paramMap.get("CP029").toString());
                    this.isFi = new Boolean(paramMap.get("CP002").toString());
                    this.isCas = new Boolean(paramMap.get("CP008").toString());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            this.handleEntry(billInfo, hsData, ctx);
        }
        return billInfo;
    }

    private void handleEntry(DailyLoanBillInfo info, Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal entryAmountApproved;
        DailyLoanBillEntryInfo entryInfo = null;
        Object data = ((DataToken)hsData.get((Object)"entries.seq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            DailyLoanBillEntryCollection entryCollection = info.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                DailyLoanBillEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"Repetition_Coding", (Locale)ctx.getOriginLocale()));
            }
            entryInfo = new DailyLoanBillEntryInfo();
            entryInfo.setBill(info);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        } else {
            DailyLoanBillEntryCollection entryCollection = info.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new DailyLoanBillEntryInfo();
            entryInfo.setBill(info);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        BizCollUtil.initInportBigDecimalData(ctx, null, entryInfo, hsData, this.IMP_BIGDECIMAL_FIELDS_EN, this.IMP_BIGDECIMAL_OBJS_EN);
        BigDecimal tempAmount = info.getAmount();
        BigDecimal tempAmountApproved = info.getAmountApproved();
        BigDecimal entryAmount = entryInfo.getAmount() == null ? BizCollUtil.ZERO : entryInfo.getAmount();
        BigDecimal bigDecimal = entryAmountApproved = entryInfo.getAmountApproved() == null ? BizCollUtil.ZERO : entryInfo.getAmountApproved();
        if (tempAmount != null) {
            entryAmount = entryAmount.add(tempAmount);
        }
        if (tempAmountApproved != null) {
            entryAmountApproved = entryAmountApproved.add(tempAmountApproved);
        }
        info.setAmount(entryAmount);
        info.setAmountApproved(entryAmountApproved);
        if (this.hasLoanBillInitPermission == 1 && info.getState() != null && !info.getState().equals((Object)StateEnum.DRAFT)) {
            if (this.isFi || this.isCas) {
                if (info.getState().equals((Object)StateEnum.CHECKED)) {
                    if (!this.isCas) {
                        this.setBillPaid(info);
                    } else {
                        this.setBillNotPaid(info);
                    }
                } else if (info.getState().equals((Object)StateEnum.ALREADYPAYMENT)) {
                    if (!this.isCas) {
                        throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"CANNOTIMPORTPAYSTATEWITHOUTCAS", (Locale)ctx.getOriginLocale()));
                    }
                    this.setBillPaid(info);
                }
            } else {
                if (info.getState().equals((Object)StateEnum.ALREADYPAYMENT)) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"CANNOTIMPORTPAYSTATEWITHOUTCAS", (Locale)ctx.getOriginLocale()));
                }
                this.setBillPaid(info);
            }
            info.setAmountUsed(BizCollUtil.ZERO);
            info.setReturnAmount(BizCollUtil.ZERO);
            entryInfo.setAmountBalance(entryInfo.getAmountApproved());
            entryInfo.setAmountBalanceOri(entryInfo.getAmountApprovedOri());
            entryInfo.setAmountUsed(BizCollUtil.ZERO);
            entryInfo.setAmountUsedOri(BizCollUtil.ZERO);
            if (this.isNeedBudget && this.loanBillUseBg) {
                entryInfo.setBudgetBalance(entryInfo.getAmountApproved());
            }
        }
        BizCollUtil.initInportStringData(ctx, null, entryInfo, hsData, this.IMP_STRING_FIELDS_EN, this.IMP_STRING_OBJS_EN);
        BizCollUtil.initInportEntryCommonData(ctx, info, entryInfo, hsData, this.personPositionMap);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (!StringUtils.isEmpty((String)rs.getString("prior"))) {
                result.put("prior", AssistantAccountUtil.getPriorValue(String.valueOf(rs.getInt("prior"))).getAlias(ctx.getOriginLocale()));
            }
            result.put("state", AssistantAccountUtil.getStateAlias(String.valueOf(rs.getInt("state"))));
            result.put("entries.seq", new Integer(rs.getInt("entries.seq")).toString());
            if ("true".equals(rs.getString("isVouchered"))) {
                result.put("isVouchered", "1");
            } else {
                result.put("isVouchered", "0");
            }
            if ("true".equals(rs.getString("isCreatePayBill"))) {
                result.put("isCreatePayBill", "1");
            } else {
                result.put("isCreatePayBill", "0");
            }
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING);
            BizCollUtil.initExportStringData(ctx, rs, result, this.EXP_STRING_EN);
            BizCollUtil.initExportBigDecimalData(ctx, rs, result, this.EXP_BIGDECIMAL);
            BizCollUtil.initExportDateData(ctx, rs, result, this.EXP_DATE);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new TaskExternalException("Database access error occurs, can't read field values!", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Map paramMap = this.getContextMap();
        FilterInfo filterInfo = BizCollUtil.getExportFilterForQuery(ctx, paramMap);
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.DailyLoanWithEntryBillQuery";
    }

    private void setBillPaid(DailyLoanBillInfo info) {
        info.setAmountNotPaid(BizCollUtil.ZERO);
        info.setAmountPaid(info.getAmountApproved());
        info.setAmountBalance(info.getAmountApproved());
    }

    private void setBillNotPaid(DailyLoanBillInfo info) {
        info.setAmountNotPaid(info.getAmountApproved());
        info.setAmountPaid(BizCollUtil.ZERO);
        info.setAmountBalance(BizCollUtil.ZERO);
    }

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }
}

