/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.CpBudgetCtrlCaller;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.SourceSystem;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBalance;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.ma.nbudget.face.IControlResult;
import com.kingdee.eas.ma.nbudget.face.IExtBillCheck;
import com.kingdee.eas.util.ResourceBase;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NBgControlCallerUtil {
    private static final String RES = "com.kingdee.eas.cp.bc.WebCommonUtilResource";
    public static final String BUDGET_ITEMNAME = "itemName";
    public static final String BUDGET_ORGNAME = "orgUnitName";
    public static final String BUDGET_ELEMENTNAME = "elementName";
    public static final String BUDGET_PERIODNAME = "periodName";
    public static final String BUDGET_BUDGET = "budget";
    public static final String BUDGET_ACTUAL = "actual";
    public static final String BUDGET_BALANCE = "balance";
    public static final String BUDGET_BALANCESTRING = "balanceString";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.NBgControlCallerUtil");
    private static BgControlCaller caller = new BgControlCaller();

    public static boolean requestBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.requestBudget(billId) : caller.requestBudget(ctx, billId);
        logger.error((Object)("### runner cpbc NBgControlCallerUtil.requestBudget billId=" + billId + ",callerResult=" + callerResult.getResult()));
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            logger.error((Object)("### runner cpbc NBgControlCallerUtil.requestBudget cause.size()=" + cause.size()));
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new BudgetControlException(BudgetControlException.BANK, new Object[]{cause.get(0)});
            }
        } else {
            result = true;
        }
        logger.error((Object)("### runner cpbc NBgControlCallerUtil.requestBudget billId=" + billId + ",result=" + result));
        return result;
    }

    public static boolean specialBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        logger.error((Object)("####cpbc NBgControlCallerUtil.specialBudget billId=" + billId));
        IControlResult callerResult = null;
        boolean result = false;
        callerResult = ctx == null ? caller.specialBudget(billId) : caller.specialBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)("####cpbc--specialBudget " + cause));
                throw new BudgetControlException(BudgetControlException.BANK, new Object[]{cause.get(0)});
            }
        } else {
            result = true;
        }
        logger.error((Object)("####cpbc--NBgControlCallerUtil.specialBudget billId=" + billId + ",result=" + result));
        return result;
    }

    public static IControlResult returnBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        IControlResult callerResult = null;
        boolean result = false;
        logger.error((Object)("####cpbc NBgControlCallerUtil.returnBudget billId=" + billId));
        callerResult = ctx == null ? caller.returnBudget(billId) : caller.returnBudget(ctx, billId);
        if (callerResult.getResult() != 1) {
            List cause = callerResult.getCause();
            if (cause.size() > 0) {
                logger.error((Object)cause);
                throw new BudgetControlException(BudgetControlException.BANK, new Object[]{cause.get(0)});
            }
        } else {
            result = true;
        }
        logger.error((Object)("####cpbc--NBgControlCallerUtil.returnBudget billId=" + billId + ",result=" + result));
        return callerResult;
    }

    public static IBudgetBalance queryBalance(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.queryBalance(billId);
        }
        return caller.queryBalance(ctx, billId);
    }

    public static IBudgetBalance queryBalance(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.queryBalance(model);
        }
        return caller.queryBalance(ctx, model);
    }

    public static List getBalance(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ArrayList resultList = new ArrayList();
        HashMap result = new HashMap();
        NBgControlCallerUtil.handleModelForBudget(ctx, model);
        IBudgetBalance budgetBalance = NBgControlCallerUtil.queryBalance(ctx, model);
        return NBgControlCallerUtil.getBalanceList(budgetBalance, ctx);
    }

    public static List getBalance(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        ArrayList resultList = new ArrayList();
        HashMap result = new HashMap();
        IBudgetBalance budgetBalance = NBgControlCallerUtil.queryBalance(ctx, billId);
        return NBgControlCallerUtil.getBalanceList(budgetBalance, ctx);
    }

    private static List getBalanceList(IBudgetBalance budgetBalance, Context ctx) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        String[] result = null;
        List balances = budgetBalance.getBalance();
        IBalance balance = null;
        String[] object = null;
        BigDecimal data = new BigDecimal(0);
        HashMap dump = new HashMap();
        String itemNumber = null;
        if (balances != null) {
            for (int i = 0; i < balances.size(); ++i) {
                StringBuffer balanceString = new StringBuffer();
                result = new String[10];
                balance = (IBalance)balances.get(i);
                object = balance.getReqItem();
                String string = itemNumber = object != null && object.length >= 2 ? object[0] : null;
                if (itemNumber == null) continue;
                result[0] = object != null && object.length >= 2 ? object[1] : null;
                object = balance.getOrgUnit();
                result[1] = object != null && object.length >= 2 ? object[2] : null;
                object = balance.getElement();
                result[2] = object != null && object.length >= 2 ? object[2] : null;
                object = balance.getPeriod();
                result[3] = object != null && object.length >= 2 ? object[2] : null;
                result[7] = object != null && object.length >= 2 ? object[1] : null;
                BigDecimal bigDecimal = data = balance.getBudget() != null ? balance.getBudget() : new BigDecimal(0);
                if (balance.getBudget() == null) {
                    logger.error((Object)("---cpbc--balance---balance.getBudget()---" + balance.getBudget() + "----\u9884\u7b97\u6570---" + data));
                }
                result[4] = CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data);
                data = balance.getActual() != null ? balance.getActual() : new BigDecimal(0);
                result[5] = CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data);
                BigDecimal bigDecimal2 = data = balance.getBalance() != null ? balance.getBalance() : new BigDecimal(0);
                if (balance.getExtBalance() != null) {
                    balanceString.append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(balance.getExtBalance()));
                    balanceString.append("(").append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data)).append(")");
                } else {
                    balanceString.append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                }
                result[6] = balanceString.toString();
                StringBuffer extName = new StringBuffer();
                StringBuffer reqName = new StringBuffer();
                result[8] = extName.toString();
                object = balance.getCurrency();
                result[9] = object != null && object.length >= 2 ? object[2] : "";
                resultList.add(result);
            }
        }
        return resultList;
    }

    private static List getBalanceMap(IBudgetBalance budgetBalance) {
        ArrayList resultList = new ArrayList();
        HashMap<String, CharSequence> result = new HashMap<String, CharSequence>();
        List balances = budgetBalance.getBalance();
        IBalance balance = null;
        String[] object = null;
        BigDecimal data = new BigDecimal(0);
        StringBuffer balanceString = new StringBuffer();
        if (balances != null) {
            for (int i = 0; i < balances.size(); ++i) {
                balance = (IBalance)balances.get(i);
                object = balance.getReqItem();
                result.put(BUDGET_ITEMNAME, object != null && object.length >= 2 ? object[1] : null);
                object = balance.getOrgUnit();
                result.put(BUDGET_ORGNAME, object != null && object.length >= 2 ? object[2] : null);
                object = balance.getPeriod();
                result.put(BUDGET_PERIODNAME, object != null && object.length >= 2 ? object[2] : null);
                data = balance.getBudget() != null ? balance.getBudget() : new BigDecimal(0);
                result.put(BUDGET_BUDGET, CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                data = balance.getActual() != null ? balance.getActual() : new BigDecimal(0);
                result.put(BUDGET_ACTUAL, CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                data = balance.getBalance() != null ? balance.getBalance() : new BigDecimal(0);
                result.put(BUDGET_BALANCE, CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data));
                if (balance.getExtBalance() != null) {
                    balanceString.append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(balance.getExtBalance()));
                    balanceString.append("(").append(CpBudgetCtrlCaller.DEFAULT_AMOUNT_FORMAT.format(data)).append(")");
                } else {
                    balanceString.setLength(0);
                }
                result.put(BUDGET_BALANCESTRING, balanceString);
                resultList.add(result);
            }
        }
        return resultList;
    }

    public static boolean checkBizUnitInfo(Context ctx, BOSUuid billId, IExtBillCheck check) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.checkBizUnitInfo(billId, check);
        }
        return caller.checkBizUnitInfo(ctx, billId, check);
    }

    public static boolean checkBizUnitInfo(Context ctx, IObjectValue model, IExtBillCheck check) throws EASBizException, BOSException {
        if (ctx == null) {
            return caller.checkBizUnitInfo(model, check);
        }
        return caller.checkBizUnitInfo(ctx, model, check);
    }

    public static void showBudget(Component owner, IObjectValue info) throws EASBizException, BOSException {
        NBgControlCallerUtil.handleModelForBudget(null, info);
        BgControlCaller.showBudget((Component)owner, (IObjectValue)info);
    }

    public static void handleModelForBudget(Context ctx, IObjectValue info) {
        try {
            NBgControlCallerUtil.handleModelForBudget(ctx, info, null);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void handleModelForBudget(Context ctx, IObjectValue info, Map<String, Object> paramMap) throws Exception {
        boolean isDealStandField = paramMap != null && paramMap.get("isDealStandField") != null ? (Boolean)paramMap.get("isDealStandField") : false;
        ArrayList<String> standardFields = null;
        standardFields = isDealStandField || info.get("sourceSystem") == null || info instanceof BizCollBillBaseInfo && !SourceSystem.CPBC.equals((Object)((BizCollBillBaseInfo)info).getSourceSystem()) ? new ArrayList() : new ArrayList<String>(){
            {
                this.add("bizReqDate");
                this.add("applierCompany.name");
                this.add("applierCompany.number");
                this.add("orgUnit.name");
                this.add("orgUnit.number");
                this.add("company.name");
                this.add("company.number");
                this.add("company.baseCurrency.number");
                this.add("costedDept.name");
                this.add("costedDept.number");
                this.add("currencyType.name");
                this.add("currencyType.number");
                this.add("entries.budgetDo");
                this.add("entries.expenseType.name");
                this.add("entries.expenseType.number");
                this.add("entries.company.name");
                this.add("entries.company.number");
                this.add("entries.costCenter.name");
                this.add("entries.costCenter.number");
                this.add("entries.company.baseCurrency.number");
                this.add("entries.currencyType.number");
            }
        };
        List budgetFields = null;
        try {
            budgetFields = ctx != null ? caller.getRequestFields(ctx, info) : caller.getRequestFields(info);
            if (budgetFields == null) {
                logger.info((Object)"##handleModelForBudget budgetFields is null");
                return;
            }
            StringBuilder fieldlog = new StringBuilder();
            for (String field : budgetFields) {
                if (standardFields.contains(field)) continue;
                fieldlog.append(field + ":");
                String[] fields = field.split("\\.");
                try {
                    NBgControlCallerUtil.setFieldData(ctx, fields, 0, info, fieldlog);
                }
                catch (Exception e) {
                    fieldlog.append("error;");
                    logger.info((Object)("##handleModelForBudget fieldlog=" + fieldlog));
                    if (paramMap != null && paramMap.get("fieldlog") != null) {
                        paramMap.put("fieldlog", fieldlog.toString());
                    }
                    throw e;
                }
            }
            if (paramMap != null && paramMap.get("fieldlog") != null) {
                paramMap.put("fieldlog", fieldlog.toString());
            }
            logger.info((Object)("##handleModelForBudget fieldlog=" + fieldlog));
        }
        catch (Exception e) {
            logger.error((Object)("###### \u9884\u7b97\u67e5\u8be2\u524d\u5904\u7406model\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    private static void setFieldData(Context ctx, String[] fields, int index, Object parentObj, StringBuilder fieldlog) throws Exception {
        Class<?> parentClass = parentObj.getClass();
        Method getMethod = parentClass.getMethod("get", String.class);
        Object infoObj = getMethod.invoke(parentObj, fields[index]);
        if (infoObj != null) {
            Class<?> infoClass = infoObj.getClass();
            if (infoClass.getName().contains("Collection")) {
                Method sizeMethod = infoClass.getMethod("size", new Class[0]);
                int size = (Integer)sizeMethod.invoke(infoObj, new Object[0]);
                for (int i = 0; i < size; ++i) {
                    Method infoMethod = infoClass.getMethod("get", Integer.TYPE);
                    Object entryObj = infoMethod.invoke(infoObj, i);
                    if (entryObj == null) continue;
                    try {
                        NBgControlCallerUtil.setFieldData(ctx, fields, 1, entryObj, fieldlog);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("###### \u9884\u7b97\u67e5\u8be2\u524d\u5904\u7406model\u7684\u5206\u5f55\u5faa\u73af\u51fa\u9519\uff1ai:" + i + " fields\uff1a" + fields[i] + " entryObj:" + entryObj));
                        throw e;
                    }
                }
            } else if (index < fields.length - 1) {
                NBgControlCallerUtil.setFieldData(ctx, fields, ++index, infoObj, fieldlog);
            } else if (fieldlog != null) {
                fieldlog.append(infoObj + ";");
            }
        } else {
            Method idMethod = parentClass.getMethod("getId", new Class[0]);
            BOSUuid parentBOSUuid = (BOSUuid)idMethod.invoke(parentObj, new Object[0]);
            if (parentBOSUuid != null && !StringUtils.isEmpty((String)parentBOSUuid.toString())) {
                String parentId = parentBOSUuid.toString();
                Method BOSTypeMethod = parentClass.getMethod("getBOSType", new Class[0]);
                BOSObjectType bosObjectType = (BOSObjectType)BOSTypeMethod.invoke(parentObj, new Object[0]);
                ObjectUuidPK parentPK = new ObjectUuidPK(parentId);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo(fields[index]));
                IObjectValue parentInfo = null;
                parentInfo = ctx == null ? DynamicObjectFactory.getRemoteInstance().getValue(bosObjectType, (IObjectPK)parentPK, sic) : DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(bosObjectType, (IObjectPK)parentPK, sic);
                Class<?> newInfoClass = parentInfo.getClass();
                Method newGetMethod = newInfoClass.getMethod("get", String.class);
                infoObj = newGetMethod.invoke((Object)parentInfo, fields[index]);
                if (infoObj != null) {
                    Method setMethod = parentClass.getMethod("put", String.class, Object.class);
                    setMethod.invoke(parentObj, fields[index], infoObj);
                    if (index < fields.length - 1) {
                        NBgControlCallerUtil.setFieldData(ctx, fields, ++index, infoObj, fieldlog);
                    } else if (fieldlog != null) {
                        fieldlog.append("putValue:" + infoObj + ";");
                    }
                } else if (fieldlog != null) {
                    fieldlog.append("putValue:" + infoObj + ";");
                }
            }
        }
    }

    @Deprecated
    public static void setFieldData(Context ctx, String[] fields, int index, Object parentObj) throws Exception {
        NBgControlCallerUtil.setFieldData(ctx, fields, index, parentObj, null);
    }

    public static void checkBudget(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        if (ctx == null) {
            caller.checkBudget(billId);
        } else {
            caller.checkBudget(ctx, billId);
        }
    }

    public static void checkBudget(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (ctx == null) {
            caller.checkBudget(model);
        } else {
            caller.checkBudget(ctx, model);
        }
    }

    public static void checkBgWhenIsAllowOver(Context ctx, IObjectValue model, Map paramMap) throws EASBizException, BOSException {
        boolean isMustDesWhenOverBg;
        boolean submitCheckBg = new Boolean(paramMap.get("CP020").toString());
        Map result = NBgControlCallerUtil.checkBudgetResult(ctx, model, submitCheckBg, isMustDesWhenOverBg = new Boolean(paramMap.get("CP031").toString()).booleanValue());
        boolean isOverBudget = result != null && result.get("isOverBudget") != null && (Boolean)result.get("isOverBudget") == true;
        model.setBoolean("isOverBudget", isOverBudget);
        if (isMustDesWhenOverBg) {
            String budgetDescription = model.getString("budgetdescription");
            if (result != null && result.get("message") != null) {
                if (StringUtils.isEmpty((String)budgetDescription) || model.get("budgetmaybechange") != null && model.getBoolean("budgetmaybechange")) {
                    throw new BudgetControlException(BudgetControlException.BANK, new Object[]{JSONUtils.convertObjectToJson((Context)ctx, (Object)result)});
                }
            } else {
                model.setString("budgetdescription", null);
            }
        }
    }

    public static boolean checkBudgetDo(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        AbstractObjectCollection entryCollection = (AbstractObjectCollection)model.get("entries");
        if (entryCollection != null) {
            for (int m = 0; m < entryCollection.size(); ++m) {
                CoreBillEntryBaseInfo entry = (CoreBillEntryBaseInfo)entryCollection.getObject(m);
                BigDecimal budgetDo = entry.getBigDecimal("budgetdo");
                if (budgetDo == null || budgetDo.compareTo(BizCollUtil.ZERO) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static Map checkBudgetResult(Context ctx, IObjectValue model, boolean submitCheckBg, boolean isMustDesWhenOverBg) throws EASBizException, BOSException {
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        StringBuffer message = new StringBuffer();
        logger.error((Object)("##checkBudgetResult number" + model.getString("number") + ",CP020=" + submitCheckBg + ",CP031=" + isMustDesWhenOverBg));
        NBgControlCallerUtil.handleModelForBudget(ctx, model);
        IBudgetBalance budgetBalance = caller.queryBalance(ctx, model);
        logger.error((Object)("##checkBudgetResult queryBalance=" + JSONUtils.convertObjectToJson((Context)ctx, (Object)budgetBalance)));
        boolean hasBudgetDo = NBgControlCallerUtil.checkBudgetDo(ctx, model);
        if (!hasBudgetDo) {
            logger.error((Object)"##checkBudgetResult BudgetDo is 0");
            return result;
        }
        if (submitCheckBg) {
            caller.checkBudget(ctx, budgetBalance);
        }
        logger.error((Object)"##checkBudgetResult checkBudget success");
        if (isMustDesWhenOverBg) {
            List balances = budgetBalance.getBalance();
            result.put("isBudgetPass", Boolean.valueOf(true));
            IBalance balance = null;
            if (balances != null) {
                for (int i = 0; i < balances.size(); ++i) {
                    balance = (IBalance)balances.get(i);
                    if (!balance.isControl() || !balance.isOverBudget()) continue;
                    message.append(ResourceBase.getString((String)RES, (String)"ISOVERBUDGET", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{balance.getOrgUnit()[2], balance.getReqItem()[1]}));
                }
            }
            if (message.length() > 0) {
                result.put("message", message);
            }
        }
        List balancesIsOverBuget = budgetBalance.getBalance();
        IBalance IsOverBuget = null;
        BigDecimal balance = BizCollUtil.ZERO;
        BigDecimal reqAmount = BizCollUtil.ZERO;
        if (balancesIsOverBuget != null) {
            boolean isOverBudget = false;
            for (int i = 0; i < balancesIsOverBuget.size(); ++i) {
                IsOverBuget = (IBalance)balancesIsOverBuget.get(i);
                if (IsOverBuget.getBalance() != null) {
                    balance = IsOverBuget.getBalance();
                }
                if (IsOverBuget.getReqAmount() != null) {
                    reqAmount = IsOverBuget.getReqAmount();
                }
                if (!IsOverBuget.isOverBudget() && balance.compareTo(BizCollUtil.ZERO) >= 0 && (balance.compareTo(BizCollUtil.ZERO) != 0 || reqAmount.compareTo(BizCollUtil.ZERO) <= 0)) continue;
                isOverBudget = true;
                break;
            }
            result.put("isOverBudget", Boolean.valueOf(isOverBudget));
            logger.error((Object)("##checkBudgetResult isOverBudget=" + isOverBudget));
        }
        return result;
    }

    public static boolean checkBillBgChange(Context ctx, BizCollBillBaseInfo info, BizCollBillBaseInfo infoOld) {
        try {
            String[] checkFields = new String[]{"sourceBillEntryID", "checkAmount"};
            if (BizCollUtil.checkEntryIsChange(info, infoOld, "LoanCheckEntries", checkFields)) {
                return true;
            }
            if (BizCollUtil.checkEntryIsChange(info, infoOld, "ReqCheckEntries", checkFields)) {
                return true;
            }
            if (NBgControlCallerUtil.checkBgFieldsIsChange(ctx, info, infoOld)) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return true;
        }
        return false;
    }

    private static boolean checkBgFieldsIsChange(Context ctx, BizCollBillBaseInfo info, BizCollBillBaseInfo infoOld) throws EASBizException, BOSException {
        List budgetFields = caller.getRequestFields(ctx, (IObjectValue)info);
        if (budgetFields == null) {
            return false;
        }
        StringBuilder log = new StringBuilder("###cpbc### budgetFields:" + budgetFields.toString());
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)infoOld.getId().toString()));
        SelectorItemCollection selector = new SelectorItemCollection();
        Iterator iterator = budgetFields.iterator();
        while (iterator.hasNext()) {
            selector.add(new SelectorItemInfo((String)iterator.next()));
        }
        BizCollBillBaseInfo newInfoOld = iBizCollBillBase.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(infoOld.getId().toString()), selector);
        if (budgetFields.contains("entries.budgetDo")) {
            NBgControlCallerUtil.updateEntryBudgetDo(newInfoOld, infoOld);
        }
        for (String field : budgetFields) {
            String[] fields = field.split("\\.");
            if (fields.length > 1) {
                Object newfieldValue = NBgControlCallerUtil.getFieldValue(field, (IObjectValue)info);
                Object oldfieldValue = NBgControlCallerUtil.getFieldValue(field, (IObjectValue)newInfoOld);
                log.append(";field:" + field + ",newfieldValue:" + newfieldValue + ",oldfieldValue:" + oldfieldValue);
                if (!NBgControlCallerUtil.checkFieldValueChange(newfieldValue, oldfieldValue)) continue;
                return true;
            }
            log.append(";field:" + field + ",newfieldValue:" + info.get(field) + ",oldfieldValue:" + newInfoOld.get(field));
            if (!NBgControlCallerUtil.checkFieldValueChange(info.get(field), newInfoOld.get(field))) continue;
            return true;
        }
        logger.info((Object)log);
        return false;
    }

    private static void updateEntryBudgetDo(BizCollBillBaseInfo newInfoOld, BizCollBillBaseInfo infoOld) {
        if (newInfoOld == null || infoOld == null) {
            return;
        }
        IObjectCollection tempNewCol = (IObjectCollection)newInfoOld.get("entries");
        IObjectCollection tempOldCol = (IObjectCollection)infoOld.get("entries");
        int j = tempNewCol.size();
        for (int i = 0; i < j; ++i) {
            IObjectValue tempNewInfo = tempNewCol.getObject(i);
            IObjectValue tempOldInfo = tempOldCol.getObject(i);
            if (!tempNewInfo.getString("id").equals(tempOldInfo.getString("id"))) continue;
            tempNewInfo.setBigDecimal("budgetDo", tempOldInfo.getBigDecimal("budgetDo"));
        }
    }

    private static boolean checkFieldValueChange(Object newfieldValue, Object oldfieldValue) {
        if (newfieldValue == null && oldfieldValue == null) {
            return false;
        }
        if (newfieldValue == null || oldfieldValue == null) {
            return true;
        }
        if (newfieldValue instanceof Date) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
            newfieldValue = sd.format(newfieldValue);
            oldfieldValue = sd.format(oldfieldValue);
        }
        if (oldfieldValue instanceof BigDecimal) {
            return ((BigDecimal)newfieldValue).compareTo((BigDecimal)oldfieldValue) != 0;
        }
        return !newfieldValue.equals(oldfieldValue);
    }

    private static Object getFieldValue(String field, IObjectValue info) {
        if (info == null) {
            return null;
        }
        IObjectCollection tempCol = null;
        StringBuilder tempValue = null;
        String[] fields = field.split("\\.");
        Object tempInfo = info.get(fields[0]);
        if (tempInfo == null) {
            return null;
        }
        if (tempInfo instanceof IObjectCollection) {
            tempValue = new StringBuilder();
            tempCol = (IObjectCollection)tempInfo;
            for (int k = 0; k < tempCol.size(); ++k) {
                tempValue.append(NBgControlCallerUtil.getFieldValue(field.substring(field.indexOf(".") + 1, field.length()), tempCol.getObject(k)));
            }
            return tempValue.toString();
        }
        int j = fields.length - 1;
        for (int i = 0; i < j; ++i) {
            if ((info = info.getObjectValue(fields[i])) != null) continue;
            return null;
        }
        if (info.get(fields[fields.length - 1]) instanceof BigDecimal) {
            return info.getBigDecimal(fields[fields.length - 1]).setScale(4);
        }
        return info.get(fields[fields.length - 1]);
    }
}

