/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.BizCollBillDataProvider;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;

public class RePaymentBillDataProvider
extends BizCollBillDataProvider {
    public RePaymentBillDataProvider() {
    }

    public RePaymentBillDataProvider(List id, IMetaDataPK qpk) {
        super(id, qpk);
    }

    public RePaymentBillDataProvider(KDNoteHelper appHlp, BOSObjectType bosType, List ids) {
        super(appHlp, bosType, ids);
    }

    protected String getReportQueryName() {
        return "com.kingdee.eas.cp.bc.app.RePaymentBillQueryForPrintQuery";
    }

    protected String getR1ReportBillQueryName() {
        return "com.kingdee.eas.cp.bc.app.RePaymentBillForR1PrintQuery";
    }

    protected String getR1ReportEntryQueryName() {
        return "com.kingdee.eas.cp.bc.app.RePaymentBillEntryForPrintQuery";
    }

    protected String getR1ReportEntrySumQueryName() {
        return null;
    }

    @Override
    protected IRowSet parsePrintValue(IRowSet rowSet) throws SQLException {
        BigDecimal amount = null;
        rowSet.previous();
        while (rowSet.next()) {
            amount = rowSet.getBigDecimal("amount");
            if (amount != null && amount.compareTo(new BigDecimal("0.00")) == 0) {
                amount = new BigDecimal("0.00");
            }
            rowSet.updateString("amountCapital", BizCollUtil.getChineseFormat(amount, false));
        }
        rowSet.beforeFirst();
        rowSet = this.parseEnumValue(rowSet, "state", "stateAlias", StateEnum.getEnumList());
        return rowSet;
    }

    @Override
    protected IRowSet updateBillReprotRowSet(IRowSet rowSet) throws SQLException {
        BigDecimal amount = null;
        while (rowSet.next()) {
            amount = rowSet.getBigDecimal("amount");
            if (amount != null && amount.compareTo(new BigDecimal("0.00")) == 0) {
                amount = new BigDecimal("0.00");
            }
            rowSet.updateString("amountCapital", BizCollUtil.getChineseFormat(amount, false));
        }
        rowSet.beforeFirst();
        return rowSet;
    }
}

