/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillLoanCheckEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillLoanCheckEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseCollection;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollCheckEntryInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.BudgetModifyUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillLoanCheckEntryFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryFactory;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IBizCollCheckEntry;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.ILoanBill;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryFactory;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillLoanCheckEntryFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillReqCheckEntryFactory;
import com.kingdee.eas.cp.bc.util.CPBCCommonParams;
import com.kingdee.eas.cp.bc.util.NBgControlCallerUtil;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillEntryBase;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReverseUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.ReverseUtil");
    static String expenseTypeId = null;
    static String costCenterId = null;
    static String projectId = null;
    static Map tempMap = null;
    static Map checkMap = null;
    static Map entryMap = null;
    static Map infoMap = null;
    static BigDecimal amount = null;
    static List valueList = null;
    static CoreBaseInfo entryInfo = null;

    public static SelectorItemCollection getReverseBillUpdateSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("amountBalance"));
        return sic;
    }

    public static SelectorItemCollection getReverseEntryUpdateSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("budgetDo"));
        return sic;
    }

    public static SelectorItemCollection getReverseBillSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("amountUsedOri"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountBalanceOri"));
        sic.add(new SelectorItemInfo("bill.state"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("bill.number"));
        sic.add(new SelectorItemInfo("bill.amountBalance"));
        return sic;
    }

    public static SelectorItemCollection getReverseBillSelectSicRePay() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("amountUsedOri"));
        sic.add(new SelectorItemInfo("amountPaid"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("convertMode"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("exchangeRatePrecision"));
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountBalanceOri"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("bill.state"));
        sic.add(new SelectorItemInfo("bill.id"));
        sic.add(new SelectorItemInfo("bill.number"));
        sic.add(new SelectorItemInfo("bill.amountBalance"));
        sic.add(new SelectorItemInfo("bill.returnAmount"));
        sic.add(new SelectorItemInfo("bill.isRePay"));
        sic.add(new SelectorItemInfo("bill.currencyType.id"));
        return sic;
    }

    public static void createCheckModel(Object info, BizCollCheckEntryInfo checkinfo) {
        if (info != null) {
            IRow row = (IRow)info;
            checkinfo.setSourceBillID((String)row.getCell("billid").getValue());
            checkinfo.setSourceBillEntryID((String)row.getCell("entryid").getValue());
            checkinfo.setSourceBillNumber((String)row.getCell("billNumber").getValue());
            checkinfo.setSourceBillDate((Date)row.getCell("billDate").getValue());
            checkinfo.setSourceBillCause((String)row.getCell("billCause").getValue());
            checkinfo.setSourceBillOperationType((String)row.getCell("billOperationType").getValue());
            checkinfo.setSourceBillExpenseType((String)row.getCell("billExpenseType").getValue());
            checkinfo.setSourceBillAmountApproved((BigDecimal)row.getCell("billAmountApproved").getValue());
            checkinfo.setSourceBillAmountBalance((BigDecimal)row.getCell("billAmountBalance").getValue());
        }
    }

    public static List groupEntriesByExpenseType(List con, String costDepId) {
        amount = null;
        tempMap = new HashMap();
        expenseTypeId = null;
        costCenterId = null;
        projectId = null;
        valueList = new ArrayList();
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            Map entryInfo = (Map)con.get(i);
            if (expenseTypeId == null && costCenterId == null && projectId == null) {
                expenseTypeId = entryInfo.get("expenseType").toString();
                projectId = entryInfo.get("project").toString();
                costCenterId = costDepId != null ? costDepId : entryInfo.get("costCenter").toString();
                infoMap = new HashMap();
                infoMap.put("expenseType", expenseTypeId);
                infoMap.put("costCenter", costCenterId);
                infoMap.put("project", projectId);
                infoMap.put("amount", (BigDecimal)entryInfo.get("amount"));
                valueList.add(infoMap);
                continue;
            }
            if (entryInfo.get("expenseType").toString().equals(expenseTypeId) && (costDepId != null || entryInfo.get("costCenter").toString().equals(costCenterId)) && entryInfo.get("project").toString().equals(projectId)) {
                infoMap = (Map)valueList.get(valueList.size() - 1);
                amount = (BigDecimal)infoMap.get("amount");
                amount = amount.add((BigDecimal)entryInfo.get("amount"));
                infoMap.put("amount", amount);
                continue;
            }
            expenseTypeId = entryInfo.get("expenseType").toString();
            projectId = entryInfo.get("project").toString();
            costCenterId = costDepId != null ? costDepId : entryInfo.get("costCenter").toString();
            infoMap = new HashMap();
            infoMap.put("expenseType", expenseTypeId);
            infoMap.put("costCenter", costCenterId);
            infoMap.put("project", projectId);
            infoMap.put("amount", (BigDecimal)entryInfo.get("amount"));
            valueList.add(infoMap);
        }
        return valueList;
    }

    public static List groupEntriesByExpenseType(Context ctx, List con, String costDepId) {
        ArrayList valueList = new ArrayList();
        Map infoMap = null;
        String[] bgFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(ctx).get("BGFIELD_DIMENSION");
        HashMap dimensionMap = null;
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            Map entryInfo = (Map)con.get(i);
            dimensionMap = new HashMap();
            int dimensionSize = bgFileds.length;
            for (int j = 0; j < dimensionSize; ++j) {
                String bgFiled = bgFileds[j];
                dimensionMap.put(bgFiled, entryInfo.get(bgFiled));
                if (!"costCenter".equals(bgFiled)) continue;
                if (costDepId != null) {
                    dimensionMap.put(bgFiled, costDepId);
                    continue;
                }
                dimensionMap.put(bgFiled, entryInfo.get(bgFiled));
            }
            dimensionMap.put("amount", entryInfo.get("amount"));
            if (valueList.size() > 0) {
                boolean isSame = true;
                int jsize = valueList.size();
                for (int j = 0; j < jsize && !(isSame = BudgetModifyUtil.isSameDimension(bgFileds, dimensionMap, infoMap = (Map)valueList.get(j))); ++j) {
                }
                if (isSame) {
                    if (infoMap == null) continue;
                    BigDecimal amount = infoMap.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)infoMap.get("amount");
                    BigDecimal dimensionAmount = dimensionMap.get("amount") == null ? BigDecimal.ZERO : (BigDecimal)dimensionMap.get("amount");
                    amount = amount.add(dimensionAmount);
                    infoMap.put("amount", amount);
                    continue;
                }
                valueList.add(dimensionMap);
                continue;
            }
            valueList.add(dimensionMap);
        }
        return valueList;
    }

    public static List sortCheckList(List list) {
        BizCollUtil.sort("sourceBillAmountBalance", list);
        BizCollUtil.sort("sourceBillDate", list);
        BizCollUtil.sort("sourceBillExpenseTypeId", list);
        BizCollUtil.sort("sourceBillCostCenterId", list);
        BizCollUtil.sort("sourceBillProjectId", list);
        return list;
    }

    public static Map getBillService(Context ctx, BizCollBillBaseInfo info, String type) {
        HashMap<String, Object> serviceMap = new HashMap<String, Object>();
        try {
            IBizCollCheckEntry icheckService = null;
            Object iEntryService = null;
            Object iotherEntryService = null;
            if (type.equals("req")) {
                iEntryService = info instanceof DailyLoanBillInfo || info instanceof DailyPurchaseAccountBillInfo || info instanceof BizAccountBillInfo || info instanceof BizAccountOutBillInfo ? OtherExpenseBillEntryFactory.getLocalInstance(ctx) : EvectionReqBillEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof TravelAccountBillInfo) {
                iEntryService = EvectionLoanBillEntryFactory.getLocalInstance(ctx);
                iotherEntryService = DailyLoanBillEntryFactory.getLocalInstance(ctx);
            } else {
                iEntryService = DailyLoanBillEntryFactory.getLocalInstance(ctx);
                iotherEntryService = EvectionLoanBillEntryFactory.getLocalInstance(ctx);
            }
            if (info instanceof BizAccountBillInfo) {
                icheckService = type.equals("req") ? BizAccountBillReqCheckEntryFactory.getLocalInstance(ctx) : BizAccountBillLoanCheckEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof BizAccountOutBillInfo) {
                icheckService = type.equals("req") ? BizAccountOutBillReqCheckEntryFactory.getLocalInstance(ctx) : BizAccountOutBillLoanCheckEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof DailyPurchaseAccountBillInfo) {
                icheckService = type.equals("req") ? DailyPurchaseAccountBillReqCheckEntryFactory.getLocalInstance(ctx) : DailyPurchaseAccountBillLoanCheckEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof TravelAccountBillInfo) {
                icheckService = type.equals("req") ? TravelAccountBillReqCheckEntryFactory.getLocalInstance(ctx) : TravelAccountBillLoanCheckEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof DailyLoanBillInfo) {
                icheckService = DailyLoanBillReqCheckEntryFactory.getLocalInstance(ctx);
            } else if (info instanceof EvectionLoanBillInfo) {
                icheckService = EvectionLoanBillReqCheckEntryFactory.getLocalInstance(ctx);
            }
            serviceMap.put("icheckService", icheckService);
            serviceMap.put("iEntryService", iEntryService);
            serviceMap.put("iotherEntryService", iotherEntryService);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return serviceMap;
    }

    public static SelectorItemCollection getBudgetBalanceSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("budgetBalance"));
        sic.add(new SelectorItemInfo("amountApproved"));
        sic.add(new SelectorItemInfo("bill.state"));
        sic.add(new SelectorItemInfo("bill.number"));
        return sic;
    }

    public static void returnSourceBg(Context ctx, BizCollBillBaseInfo info, String checkType, List<CoreBaseInfo> checkList) throws EASBizException, BOSException {
        ICoreBillEntryBase iEntryService = null;
        ICoreBillEntryBase iotherEntryService = null;
        checkList = ReverseUtil.dealCheckListByRequstBg(ctx, info, checkList);
        ReverseUtil.sortCheckList(checkList);
        Map service = ReverseUtil.getBillService(ctx, info, checkType);
        iEntryService = (ICoreBillEntryBase)service.get("iEntryService");
        iotherEntryService = (ICoreBillEntryBase)service.get("iotherEntryService");
        HashMap sourceMap = new HashMap();
        LinkedHashSet sourceEntryIds = new LinkedHashSet();
        BizCollUtil.sort(new String[]{"sourceBillID", "sourceBillEntryID"}, checkList);
        ReverseUtil.getBudgetUsed(checkList, sourceMap, sourceEntryIds);
        ReverseUtil.updateBudgetBalance(ctx, info, sourceMap, sourceEntryIds, iEntryService, iotherEntryService, "returnBudget");
    }

    public static void updateCheckAndSourceBg(Context ctx, BizCollBillBaseInfo info, String checkType, List<CoreBaseInfo> checkList, List<Map> entryGroupList) throws EASBizException, BOSException {
        ICoreBillEntryBase iEntryService = null;
        ICoreBillEntryBase iotherEntryService = null;
        ICoreBillEntryBase icheckService = null;
        checkList = ReverseUtil.dealCheckListByRequstBg(ctx, info, checkList);
        ReverseUtil.sortCheckList(checkList);
        Map service = ReverseUtil.getBillService(ctx, info, checkType);
        iEntryService = (ICoreBillEntryBase)service.get("iEntryService");
        iotherEntryService = (ICoreBillEntryBase)service.get("iotherEntryService");
        icheckService = (ICoreBillEntryBase)service.get("icheckService");
        HashMap sourceMap = new HashMap();
        LinkedHashSet sourceEntryIds = new LinkedHashSet();
        CoreBaseCollection con = new CoreBaseCollection();
        BizCollUtil.sort(new String[]{"sourceBillID", "sourceBillEntryID"}, checkList);
        ReverseUtil.updateBudgetUsed(checkList, entryGroupList, sourceMap, sourceEntryIds);
        con = BizCollUtil.converToObjectCollection(checkList);
        icheckService.updateBatchData(con);
        ReverseUtil.updateBudgetBalance(ctx, info, sourceMap, sourceEntryIds, iEntryService, iotherEntryService, "bgAudit");
    }

    public static Set updateBudgetBalance(Context ctx, BizCollBillBaseInfo info, Map sourceMap, Set sourceEntryIds, ICoreBillEntryBase iEntryService, ICoreBillEntryBase iotherEntryService, String operate) throws EASBizException, BOSException {
        String entryId = null;
        LinkedHashSet<String> billids = new LinkedHashSet<String>();
        CoreBaseInfo sourceEntryInfo = null;
        ICoreBillEntryBase iSrcEntryServic = null;
        BigDecimal sourceEntryBudgetBalance = null;
        BigDecimal checkBudgetUsed = null;
        BigDecimal newSourceEntryBudgetBalance = null;
        HashMap<String, ICoreBillEntryBase> iSrcEnyServiceMap = new HashMap<String, ICoreBillEntryBase>();
        HashMap<String, CoreBaseCollection> updateSrcEnyMap = new HashMap<String, CoreBaseCollection>();
        CoreBaseCollection updateSrcEnyCon = null;
        String srcEnyBosType = null;
        ICoreBillEntryBase icheckService = null;
        CoreBaseCollection updateCheckEnyCon = new CoreBaseCollection();
        boolean forBillClose = false;
        if (ctx != null && ctx.get((Object)"forBillClose") != null && ctx.get((Object)"forBillClose") instanceof Boolean) {
            forBillClose = (Boolean)ctx.get((Object)"forBillClose");
            ctx.remove((Object)"forBillClose");
        }
        StringBuilder logStrBu = new StringBuilder(500);
        logStrBu.append("updateBudgetBalance " + operate + " \u5355\u636e:" + info.getNumber() + " \n");
        for (Object next : sourceEntryIds) {
            if (next == null || StringUtils.isEmpty((String)next.toString())) {
                throw new ExpAccException(ExpAccException.CHECKENTRYSOURCEIDNOTNULL);
            }
            entryId = next.toString();
            iSrcEntryServic = (ICoreBillEntryBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)entryId));
            String string = "update " + ReverseUtil.getTableName(ctx, entryId) + " set fid = fid where fid =?";
            DbUtil.execute((Context)ctx, (String)string, (Object[])new String[]{entryId});
            sourceEntryInfo = iSrcEntryServic.getValue((IObjectPK)new ObjectUuidPK(entryId), ReverseUtil.getBudgetBalanceSelector());
            srcEnyBosType = iSrcEntryServic.getType().toString();
            if (updateSrcEnyMap.containsKey(srcEnyBosType)) {
                updateSrcEnyCon = (CoreBaseCollection)updateSrcEnyMap.get(srcEnyBosType);
                updateSrcEnyCon.add(sourceEntryInfo);
            } else {
                updateSrcEnyCon = new CoreBaseCollection();
                updateSrcEnyCon.add(sourceEntryInfo);
                updateSrcEnyMap.put(srcEnyBosType, updateSrcEnyCon);
                iSrcEnyServiceMap.put(srcEnyBosType, iSrcEntryServic);
            }
            if (operate.equals("bgAudit")) {
                sourceEntryBudgetBalance = sourceEntryInfo.getBigDecimal("budgetBalance") == null ? BigDecimal.ZERO : sourceEntryInfo.getBigDecimal("budgetBalance");
                checkBudgetUsed = sourceMap.get(sourceEntryInfo.getId().toString()) == null ? BigDecimal.ZERO : (BigDecimal)sourceMap.get(sourceEntryInfo.getId().toString());
                newSourceEntryBudgetBalance = sourceEntryBudgetBalance.subtract(checkBudgetUsed);
                sourceEntryInfo.setBigDecimal("budgetBalance", newSourceEntryBudgetBalance);
                if (ctx != null) {
                    logStrBu.append("\u51b2\u9500:").append(sourceEntryInfo.getObjectValue("bill").get("number")).append("," + checkBudgetUsed + "," + sourceEntryBudgetBalance + "," + newSourceEntryBudgetBalance + " \n");
                }
                sourceEntryInfo.remove("bill");
                continue;
            }
            if (forBillClose && sourceEntryInfo.getObjectValue("bill").get("state").equals(80)) {
                sourceEntryInfo.setBigDecimal("budgetdo", ((BigDecimal)sourceMap.get(sourceEntryInfo.getId().toString())).negate());
                if (!billids.contains(sourceEntryInfo.getObjectValue("bill").get("id").toString())) {
                    billids.add(sourceEntryInfo.getObjectValue("bill").get("id").toString());
                }
                if (ctx != null) {
                    logStrBu.append("\u51b2\u9500:").append(sourceEntryInfo.getObjectValue("bill").get("number")).append("," + sourceEntryInfo.get("budgetdo") + " \n");
                }
            } else {
                Map checkInfoMap;
                CoreBaseInfo checkInfo;
                String sourceEntryId = sourceEntryInfo.getId().toString();
                sourceEntryBudgetBalance = sourceEntryInfo.getBigDecimal("budgetBalance") == null ? BigDecimal.ZERO : sourceEntryInfo.getBigDecimal("budgetBalance");
                checkBudgetUsed = sourceMap.get(sourceEntryId) == null ? BigDecimal.ZERO : (BigDecimal)sourceMap.get(sourceEntryId);
                newSourceEntryBudgetBalance = sourceEntryBudgetBalance.add(checkBudgetUsed);
                sourceEntryInfo.setBigDecimal("budgetBalance", newSourceEntryBudgetBalance);
                if (newSourceEntryBudgetBalance.compareTo(sourceEntryInfo.getBigDecimal("amountApproved")) > 0) {
                    logger.error((Object)("####updateBudgetBalance \u51b2\u9500\u5355\u636e:" + sourceEntryInfo.getObjectValue("bill").get("number") + ",\u51b2\u9500\u91d1\u989d=" + checkBudgetUsed + ",\u8fd4\u8fd8\u524d\u9884\u7b97=" + sourceEntryBudgetBalance + ",\u8fd4\u8fd8\u540e\u9884\u7b97=" + newSourceEntryBudgetBalance));
                    throw new BudgetControlException(BudgetControlException.SOURCEBILLRETURNBUDGETERROR);
                }
                if (sourceMap.get("checkInfoMap") != null && (checkInfo = (CoreBaseInfo)(checkInfoMap = (Map)sourceMap.get("checkInfoMap")).get(sourceEntryId)) != null) {
                    CoreBaseInfo checkInfoClone = (CoreBaseInfo)checkInfo.clone();
                    checkInfoClone.put("budgetUsed", (Object)BizCollUtil.ZERO);
                    updateCheckEnyCon.add(checkInfoClone);
                    if (icheckService == null) {
                        icheckService = (ICoreBillEntryBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, checkInfoClone.getId());
                    }
                }
                if (ctx != null) {
                    logStrBu.append("\u51b2\u9500:").append(sourceEntryInfo.getObjectValue("bill").get("number")).append("," + checkBudgetUsed + "," + sourceEntryBudgetBalance + "," + newSourceEntryBudgetBalance + " \n");
                }
            }
            sourceEntryInfo.remove("bill");
        }
        if (updateSrcEnyMap != null && updateSrcEnyMap.size() > 0) {
            for (Map.Entry entry : updateSrcEnyMap.entrySet()) {
                srcEnyBosType = (String)entry.getKey();
                updateSrcEnyCon = (CoreBaseCollection)entry.getValue();
                iSrcEntryServic = (ICoreBillEntryBase)iSrcEnyServiceMap.get(srcEnyBosType);
                iSrcEntryServic.updateBatchData(updateSrcEnyCon);
            }
            updateSrcEnyMap.clear();
        }
        if (updateCheckEnyCon != null && updateCheckEnyCon.size() > 0 && icheckService != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("budgetUsed"));
            icheckService.updatePartialBatchData((IObjectCollection)updateCheckEnyCon, sic);
            updateCheckEnyCon.clear();
        }
        if (ctx != null) {
            String logStr = logStrBu.toString();
            if (logStr.length() > 1500) {
                logStr = logStr.substring(0, 1500);
            }
            IObjectPK iObjectPK = LogUtil.beginLog((Context)ctx, (String)"updateBudgetBalance", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId()), (String)logStr);
            LogUtil.afterLog((Context)ctx, (IObjectPK)iObjectPK);
        }
        return billids;
    }

    public static void getBudgetUsed(List<CoreBaseInfo> checkList, Map sourceMap, Set sourceEntryIds) {
        BizCollCheckEntryInfo checkInfo = null;
        BigDecimal budgetUsed = null;
        HashMap<String, BizCollCheckEntryInfo> checkInfoMap = new HashMap<String, BizCollCheckEntryInfo>();
        if (checkList != null) {
            int size = checkList.size();
            for (int i = 0; i < size; ++i) {
                checkInfo = (BizCollCheckEntryInfo)checkList.get(i);
                budgetUsed = checkInfo.getBigDecimal("budgetUsed");
                if (budgetUsed == null || budgetUsed.compareTo(BizCollUtil.ZERO) <= 0) continue;
                sourceMap.put(checkInfo.getSourceBillEntryID(), budgetUsed);
                sourceEntryIds.add(checkInfo.getSourceBillEntryID());
                checkInfoMap.put(checkInfo.getSourceBillEntryID(), checkInfo);
            }
            if (checkInfoMap.size() > 0) {
                sourceMap.put("checkInfoMap", checkInfoMap);
            }
        }
    }

    public static void updateBudgetUsed(List<CoreBaseInfo> checkList, List<Map> entryGroupList, Map sourceMap, Set sourceEntryIds) {
        ReverseUtil.updateBudgetUsed(checkList, entryGroupList, sourceMap, sourceEntryIds, false);
    }

    public static String updateBudgetUsed(List<CoreBaseInfo> checkList, List<Map> entryGroupList, Map sourceMap, Set sourceEntryIds, boolean forBillClose) {
        String sourceBillIds = "";
        BizCollCheckEntryInfo checkInfo = null;
        BigDecimal checkAmount = null;
        BigDecimal budgetUsed = null;
        Map entryMap = null;
        String[] bgFileds = (String[])BudgetModifyUtil.getDimensionAndFiled(null).get("BGFIELD_DIMENSION");
        String[] bgcheckSourceFiled = (String[])BudgetModifyUtil.getDimensionAndFiled(null).get("SOURCEBGFIELD_DIMENSION");
        HashMap<String, Object> dimensionMap = null;
        if (checkList != null) {
            int size = checkList.size();
            block0: for (int i = 0; i < size; ++i) {
                int j;
                checkInfo = (BizCollCheckEntryInfo)checkList.get(i);
                dimensionMap = new HashMap<String, Object>();
                int dimensionSize = bgcheckSourceFiled.length;
                for (j = 0; j < dimensionSize; ++j) {
                    String bgFiled = bgFileds[j];
                    String bgCtlSourceField = bgcheckSourceFiled[j];
                    dimensionMap.put(bgFiled, checkInfo.get(bgCtlSourceField));
                }
                if (forBillClose) {
                    checkAmount = checkInfo.getBudgetUsed() == null ? BizCollUtil.ZERO : checkInfo.getBudgetUsed();
                } else {
                    BigDecimal bigDecimal = checkAmount = checkInfo.getCheckAmount() == null ? BizCollUtil.ZERO : checkInfo.getCheckAmount();
                }
                if (!forBillClose) {
                    checkInfo.setBigDecimal("budgetUsed", BizCollUtil.ZERO);
                }
                int entrysize = entryGroupList.size();
                for (j = 0; j < entrysize; ++j) {
                    entryMap = entryGroupList.get(j);
                    boolean isSame = BudgetModifyUtil.isSameDimension(bgFileds, entryMap, dimensionMap);
                    if (!isSame) continue;
                    budgetUsed = checkAmount.compareTo((BigDecimal)entryMap.get("amount")) > 0 ? (BigDecimal)entryMap.get("amount") : checkAmount;
                    entryMap.put("amount", ((BigDecimal)entryMap.get("amount")).subtract(budgetUsed));
                    if (!forBillClose) {
                        checkInfo.setBigDecimal("budgetUsed", budgetUsed);
                    }
                    sourceBillIds = sourceBillIds + "'" + checkInfo.getSourceBillID() + "',";
                    sourceMap.put(checkInfo.getSourceBillEntryID(), budgetUsed);
                    sourceEntryIds.add(checkInfo.getSourceBillEntryID());
                    continue block0;
                }
            }
            if (sourceBillIds.length() > 1) {
                sourceBillIds = sourceBillIds.substring(0, sourceBillIds.length() - 1);
            }
        }
        return sourceBillIds;
    }

    public static void checkSourceBillCanClose(Context ctx, BizCollBillBaseInfo info, boolean isPass, Map paramMap) throws BOSException {
        Map<String, Object> bosTypeAndIdMap;
        boolean isRelaFi = paramMap.get("CP002") == null ? false : new Boolean(paramMap.get("CP002").toString());
        boolean isRelaCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        boolean loanBillUseBg = paramMap.get("CP029") == null ? false : new Boolean(paramMap.get("CP029").toString());
        boolean reqBillUseBg = paramMap.get("CP030") == null ? false : new Boolean(paramMap.get("CP030").toString());
        boolean eveReqBillUseBg = paramMap.get("CP051") == null ? false : new Boolean(paramMap.get("CP051").toString());
        ArrayList<String> sourceBillIdList = new ArrayList();
        int state = 80;
        if (!isPass) {
            state = 60;
        }
        if (info.get("ReqCheckEntries") != null && ((AbstractObjectCollection)info.get("ReqCheckEntries")).size() > 0) {
            sourceBillIdList = ReverseUtil.getSourceBillIdList((AbstractObjectCollection)info.get("ReqCheckEntries"));
            bosTypeAndIdMap = ReverseUtil.getBosTypeAndIdMap(ctx, sourceBillIdList);
            List otherExpBillIdList = (List)bosTypeAndIdMap.get(CPBCCommonParams.OTHEREXPENSEBOSTYPE.toString());
            List eveReqBillIdList = (List)bosTypeAndIdMap.get(CPBCCommonParams.EVECTIONREQBOSTYPE.toString());
            if (otherExpBillIdList != null && otherExpBillIdList.size() > 0) {
                ReverseUtil.reverseSourceBillState(ctx, "T_BC_OtherExpenseBill", "T_BC_OtherExpenseBillEntry", otherExpBillIdList, state, isPass, reqBillUseBg, paramMap);
            }
            if (eveReqBillIdList != null && eveReqBillIdList.size() > 0) {
                ReverseUtil.reverseSourceBillState(ctx, "T_BC_EvectionReqBill", "T_BC_EvectionReqBillEntry", eveReqBillIdList, state, isPass, eveReqBillUseBg, paramMap);
            }
        }
        if (info.get("LoanCheckEntries") != null && ((AbstractObjectCollection)info.get("LoanCheckEntries")).size() > 0) {
            sourceBillIdList = ReverseUtil.getSourceBillIdList((AbstractObjectCollection)info.get("LoanCheckEntries"));
            if (isRelaCn && !isPass) {
                state = 70;
            } else if (isRelaFi && !isPass) {
                state = 60;
            }
            bosTypeAndIdMap = ReverseUtil.getBosTypeAndIdMap(ctx, sourceBillIdList);
            List dailyLoanBillIdList = (List)bosTypeAndIdMap.get(CPBCCommonParams.DAILYLOANBOSTYPE.toString());
            List eveLoanBillIdList = (List)bosTypeAndIdMap.get(CPBCCommonParams.EVECTIONLOANBOSTYPE.toString());
            if (eveLoanBillIdList != null && eveLoanBillIdList.size() > 0) {
                ReverseUtil.reverseSourceBillState(ctx, "T_BC_EvectionLoanBill", "T_BC_EvectionLoanBillEntry", eveLoanBillIdList, state, isPass, loanBillUseBg, paramMap);
            }
            if (dailyLoanBillIdList != null && dailyLoanBillIdList.size() > 0) {
                ReverseUtil.reverseSourceBillState(ctx, "T_BC_DailyLoanBill", "T_BC_DailyLoanBillEntry", dailyLoanBillIdList, state, isPass, loanBillUseBg, paramMap);
            }
        }
    }

    private static Map<String, Object> getBosTypeAndIdMap(Context ctx, List<String> billIdList) {
        HashMap<String, Object> bosTypeAndIdMap = new HashMap<String, Object>();
        if (billIdList == null) {
            return bosTypeAndIdMap;
        }
        List<String> billIdListTmp = null;
        Iterator<String> it = billIdList.iterator();
        while (it.hasNext()) {
            String billId = it.next().toString();
            String bosType = BOSUuid.read((String)billId).getType().toString();
            if (bosTypeAndIdMap.containsKey(bosType)) {
                billIdListTmp = (List)bosTypeAndIdMap.get(bosType);
                billIdListTmp.add(billId);
                continue;
            }
            billIdListTmp = new ArrayList();
            billIdListTmp.add(billId);
            bosTypeAndIdMap.put(bosType, billIdListTmp);
        }
        return bosTypeAndIdMap;
    }

    public static boolean isEvectionReq(Context ctx, List billIdList) {
        Iterator it = billIdList.iterator();
        while (it.hasNext()) {
            String billId = it.next().toString();
            if (!BizCollUtil.isEvectionReq(billId)) continue;
            return true;
        }
        return false;
    }

    public static void reverseEvectionReqBillState(Context ctx, String id) throws BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        BOSObjectType type = BOSUuid.read((String)id).getType();
        if (!BizCollUtil.evectionloanBosType.equals((Object)type) && !BizCollUtil.travelAccountBillBosType.equals((Object)type)) {
            return;
        }
        StringBuilder sqlString = new StringBuilder();
        sqlString.append("SELECT EVE.FID FROM T_BOT_RELATION BOT ");
        sqlString.append("INNER JOIN T_BC_EVECTIONREQBILL EVE ON EVE.FID = BOT.FSRCOBJECTID ");
        sqlString.append("WHERE EVE.FSTATE = 80 AND BOT.FDESTOBJECTID = ?");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString(), (Object[])new Object[]{id});
        if (rowSet.size() > 0) {
            ArrayList<String> srcEvecReqIds = new ArrayList<String>();
            try {
                while (rowSet.next()) {
                    String fid = rowSet.getString("FID");
                    srcEvecReqIds.add(fid);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            sqlString = new StringBuilder();
            sqlString.append("UPDATE T_BC_EVECTIONREQBILL SET FSTATE=60 ");
            sqlString.append("WHERE FSTATE=80 AND ");
            sqlString.append("FID IN (");
            sqlString.append(ReverseUtil.convertListToSqlParamStr(srcEvecReqIds));
            sqlString.append(")");
            DbUtil.execute((Context)ctx, (String)sqlString.toString(), (Object[])srcEvecReqIds.toArray());
            String logStr = "close \u51fa\u5dee\u7533\u8bf7\u53d6\u6d88\u81ea\u52a8\u5173\u95ed \u5355\u636eid:" + srcEvecReqIds.toString();
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"reverseEvectionReqBillState", (BOSObjectType)BizCollUtil.evectionReqBosType, null, (String)logStr);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        }
    }

    public static void deleteLoanReverseEvectionReqBillState(Context ctx, String id, String billSourceId) throws BOSException {
        String sourceEntryTable = null;
        if (BOSUuid.read((String)id).getType().equals((Object)new EvectionLoanBillInfo().getBOSType())) {
            sourceEntryTable = "t_bc_evectionloanbillentry";
        } else if (BOSUuid.read((String)id).getType().equals((Object)new TravelAccountBillInfo().getBOSType())) {
            sourceEntryTable = "t_bc_travelaccountbillentry";
        } else {
            return;
        }
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("update t_bc_evectionreqbill set fstate=60 ");
        sqlString.append("where ");
        sqlString.append(" fid = '").append(billSourceId).append("'");
        DbUtil.execute((Context)ctx, (String)sqlString.toString());
    }

    public static void reverseSourceBillState(Context ctx, String sourceBillTable, String sourceBillEntryTable, List<String> sourceBillIds, int state, boolean isPass, boolean useBg, Map paramMap) throws BOSException {
        boolean isNeedBudget = paramMap.get("CP001") == null ? false : new Boolean(paramMap.get("CP001").toString());
        boolean isRelaFi = paramMap.get("CP002") == null ? false : new Boolean(paramMap.get("CP002").toString());
        boolean isRelaCn = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        boolean isCanVoucher = paramMap.get("CP024") == null ? false : new Boolean(paramMap.get("CP024").toString());
        StringBuffer sqlString = new StringBuffer();
        String sourceBillIdStr = ReverseUtil.getQueryIdStr(sourceBillIds);
        if (StringUtils.isNotEmpty((String)sourceBillIdStr) && (isRelaFi && isRelaCn && isCanVoucher || isRelaFi && !isRelaCn) && !"T_BC_OtherExpenseBill".equals(sourceBillTable) && !"T_BC_EvectionReqBill".equals(sourceBillTable)) {
            sourceBillIds = ReverseUtil.removeNoVoucherBillId(ctx, sourceBillTable, sourceBillIdStr);
        }
        if (sourceBillIds != null && sourceBillIds.size() > 0) {
            BOSUuid uid = BOSUuid.read((String)sourceBillIds.get(0));
            if (isPass) {
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                ArrayList<String> noEntityTypes = new ArrayList<String>();
                noEntityTypes.add(new VoucherInfo().getBOSType().toString());
                noEntityTypes.add(new PaymentBillInfo().getBOSType().toString());
                noEntityTypes.add(new RePaymentBillInfo().getBOSType().toString());
                noEntityTypes.add(new AgentPayBillInfo().getBOSType().toString());
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo botFilter = new FilterInfo();
                botFilter.getFilterItems().add(new FilterItemInfo("srcObjectID", new HashSet<String>(sourceBillIds), CompareType.INCLUDE));
                botFilter.getFilterItems().add(new FilterItemInfo("destEntityID", new HashSet(noEntityTypes), CompareType.NOTINCLUDE));
                entityView.setFilter(botFilter);
                BOTRelationCollection botCollection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(entityView);
                SelectorItemCollection billSelector = new SelectorItemCollection();
                billSelector.add(new SelectorItemInfo("id"));
                billSelector.add(new SelectorItemInfo("state"));
                int is = botCollection.size();
                for (int i = 0; i < is; ++i) {
                    BizCollBillBaseInfo billInfo;
                    StateEnum billState;
                    String srcObjId = botCollection.get(i).getSrcObjectID();
                    String destObjId = botCollection.get(i).getDestObjectID();
                    ObjectUuidPK destObjUuid = new ObjectUuidPK(destObjId);
                    IObjectValue objInfo = iDynamicObject.getValue(destObjUuid.getObjectType(), (IObjectPK)destObjUuid, billSelector);
                    if (!(objInfo instanceof BizCollBillBaseInfo) || !StateEnum.SUBMIT.equals((Object)(billState = (billInfo = (BizCollBillBaseInfo)objInfo).getState())) && !StateEnum.CHECKING.equals((Object)billState)) continue;
                    sourceBillIds.remove(srcObjId);
                }
                if (sourceBillIds.size() > 0) {
                    StringBuilder sb = new StringBuilder("select fbillid from " + sourceBillEntryTable + " where ");
                    if (isNeedBudget && useBg) {
                        sb.append(" (fbudgetBalance>0 or famountBalance>0)");
                    } else {
                        sb.append(" famountBalance>0 ");
                    }
                    sb.append("and fbillid in (").append(ReverseUtil.convertListToSqlParamStr(sourceBillIds)).append(")");
                    try {
                        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])sourceBillIds.toArray());
                        while (iRowSet.next()) {
                            String fbillid = iRowSet.getString("fbillid");
                            sourceBillIds.remove(fbillid);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"### runner cpbc reverseSourceBillState SQLException####", (Throwable)e);
                        throw new BOSException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                ReverseUtil.removeNoCancelCloseBillId(ctx, sourceBillTable, sourceBillIds);
            }
            if (sourceBillIds.size() > 0) {
                IObjectPK logpk;
                sqlString.append("update " + sourceBillTable + " set fstate=" + state + " where ");
                sqlString.append(" fid in (").append(ReverseUtil.convertListToSqlParamStr(sourceBillIds)).append(")");
                DbUtil.execute((Context)ctx, (String)sqlString.toString(), (Object[])sourceBillIds.toArray());
                if (80 == state) {
                    logpk = LogUtil.beginLog((Context)ctx, (String)"ReverseUtil", (BOSObjectType)uid.getType(), (IObjectPK)new ObjectUuidPK(uid), (String)("close \u4e0b\u6e38\u5ba1\u6838\u901a\u8fc7\u4e0a\u6e38\u81ea\u52a8\u5173\u95ed  \u5355\u636eid\uff1a" + sourceBillIds.toString()));
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                } else {
                    logpk = LogUtil.beginLog((Context)ctx, (String)"ReverseUtil", (BOSObjectType)uid.getType(), (IObjectPK)new ObjectUuidPK(uid), (String)("close \u4e0b\u6e38\u53cd\u5ba1\u6838\u4e0a\u6e38\u53d6\u6d88\u81ea\u52a8\u5173\u95ed   \u5355\u636eid\uff1a" + sourceBillIds.toString()));
                    LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
                }
            }
        }
    }

    public static String getQueryIdStr(List<String> billIds) {
        String queryIdStr = "";
        for (String billId : billIds) {
            queryIdStr = queryIdStr + "'" + billId + "',";
        }
        if (StringUtils.isNotBlank((String)queryIdStr)) {
            queryIdStr = queryIdStr.substring(0, queryIdStr.length() - 1);
        }
        return queryIdStr;
    }

    public static String getSourceBillId(AbstractObjectCollection con) {
        String sourceBillId = "";
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            sourceBillId = sourceBillId + "'" + con.getObject(i).getString("sourceBillID") + "',";
        }
        return sourceBillId.substring(0, sourceBillId.length() - 1);
    }

    public static List<String> getSourceBillIdList(AbstractObjectCollection collection) {
        ArrayList<String> idList = new ArrayList<String>();
        int is = collection.size();
        for (int i = 0; i < is; ++i) {
            String sourceBillID = (String)collection.getObject(i).get("sourceBillID");
            if (idList.contains(sourceBillID)) continue;
            idList.add(sourceBillID);
        }
        return idList;
    }

    public static void returnSourceBillBudgetForClose(Context ctx, Set billIds) throws BgCtrlException, EASBizException, BOSException, UuidException {
        if (billIds.size() > 0) {
            for (Object billid : billIds) {
                NBgControlCallerUtil.requestBudget(ctx, BOSUuid.read((String)billid.toString()));
            }
        }
    }

    @Deprecated
    public static void returnSourceBillBudgetForClose(Set billIds) throws BgCtrlException, EASBizException, BOSException, UuidException {
        if (billIds.size() > 0) {
            for (Object billid : billIds) {
                NBgControlCallerUtil.requestBudget(null, BOSUuid.read((String)billid.toString()));
            }
        }
    }

    public static List<String> removeNoVoucherBillId(Context ctx, String sourceBillTable, String billIdStr) throws BOSException {
        ArrayList<String> sourceBillIdList = new ArrayList<String>();
        String sqlString = "select fid, FisVouchered from " + sourceBillTable + " where fid in (" + billIdStr + ")";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString);
            while (rowSet.next()) {
                if (rowSet.getInt("FisVouchered") != 1) continue;
                sourceBillIdList.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return sourceBillIdList;
    }

    private static List<String> removeNoCancelCloseBillId(Context ctx, String sourceBillTable, List<String> sourceBillIds) throws BOSException {
        if (sourceBillIds.size() > 0) {
            StringBuilder sb = new StringBuilder("SELECT FID FROM " + sourceBillTable + " WHERE FSTATE != 80 ");
            sb.append("AND FID IN (").append(ReverseUtil.convertListToSqlParamStr(sourceBillIds)).append(")");
            try {
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])sourceBillIds.toArray());
                while (iRowSet.next()) {
                    String fid = iRowSet.getString("FID");
                    sourceBillIds.remove(fid);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return sourceBillIds;
    }

    public static String getTableName(Context ctx, String billId) {
        BOSObjectType type = BOSUuid.read((String)billId).getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        return vo.getTable().getName();
    }

    public static String getCostDeptIdForBg(Context ctx, BizCollBillBaseInfo info, Map paramMap) throws EASBizException, BOSException {
        String costdeptId = null;
        String isShowHeadCompany = "0";
        if (paramMap != null && paramMap.get("CP046") != null) {
            isShowHeadCompany = paramMap.get("CP046").toString();
        } else {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP046");
            String applierCompanyId = info.getApplierCompany().getId().toString();
            IExpenseCommenFacade iExpenseCommenFacade = ctx != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx) : ExpenseCommenFacadeFactory.getRemoteInstance();
            paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
            isShowHeadCompany = paramMap.get("CP046").toString();
        }
        if (info instanceof LoanBillInfo && isShowHeadCompany.equals("0")) {
            costdeptId = info.getCostedDept().getId().toString();
        }
        return costdeptId;
    }

    public static boolean checkBillIsRequstBg(Context ctx, BizCollBillBaseInfo billInfo) throws BOSException {
        boolean result = true;
        if (billInfo == null || billInfo.getId() == null) {
            return true;
        }
        if (billInfo instanceof LoanBillInfo && ReverseUtil.checkBillIsRequstBgSpecialDeal(ctx, billInfo)) {
            return true;
        }
        String billId = billInfo.getId().toString();
        String sqlString = "SELECT FBILLID FROM T_MBG_BGCONTROLRECORDDETAIL WHERE FBILLID = ?  UNION ALL SELECT FBILLID FROM T_BG_BGCTRLRECORD WHERE FBILLID = ?";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString, (Object[])new Object[]{billId, billId});
            if (rowSet.size() == 0) {
                result = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("##checkBillIsRequstBg number=" + billInfo.getNumber() + ", result=" + result));
        return result;
    }

    public static boolean checkBillIsRequstBgSpecialDeal(Context ctx, BizCollBillBaseInfo billInfo) throws BOSException {
        boolean result = false;
        if (billInfo instanceof LoanBillInfo && ((AbstractObjectCollection)billInfo.get("reqCheckEntries")).size() > 0) {
            result = true;
            AbstractObjectCollection entries = (AbstractObjectCollection)billInfo.get("entries");
            IObjectValue entryInfo = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.getObject(i);
                BigDecimal budgetDo = entryInfo.getBigDecimal("budgetdo");
                if (budgetDo == null || budgetDo.compareTo(BizCollUtil.ZERO) == 0) continue;
                result = false;
                break;
            }
            if (result) {
                result = false;
                AbstractObjectCollection reqCheckEntries = (AbstractObjectCollection)billInfo.get("reqCheckEntries");
                int size2 = reqCheckEntries.size();
                for (int i = 0; i < size2; ++i) {
                    IObjectValue reqCheckInfo = reqCheckEntries.getObject(i);
                    BigDecimal budgetUsed = reqCheckInfo.getBigDecimal("budgetUsed");
                    if (budgetUsed == null || budgetUsed.compareTo(BizCollUtil.ZERO) == 0) continue;
                    result = true;
                    break;
                }
            }
        }
        logger.info((Object)("##checkBillIsRequstBgSpecialDeal number=" + billInfo.getNumber() + ", result=" + result));
        return result;
    }

    public static List dealCheckListByRequstBg(Context ctx, BizCollBillBaseInfo info, List checkList) throws BOSException {
        if (checkList == null || checkList.size() == 0) {
            return checkList;
        }
        ArrayList<BizCollCheckEntryInfo> newCheckList = new ArrayList<BizCollCheckEntryInfo>();
        BizCollCheckEntryInfo checkInfo = null;
        StringBuilder sourceBillIdStr = new StringBuilder(80);
        HashSet<String> noBgBillIdSet = new HashSet<String>();
        int size = checkList.size();
        for (int i = 0; i < size; ++i) {
            checkInfo = (BizCollCheckEntryInfo)checkList.get(i);
            if (StringUtils.isEmpty((String)checkInfo.getSourceBillID()) || sourceBillIdStr.indexOf(checkInfo.getSourceBillID()) != -1) continue;
            sourceBillIdStr.append("'" + checkInfo.getSourceBillID() + "',");
            noBgBillIdSet.add(checkInfo.getSourceBillID());
        }
        if (sourceBillIdStr.length() == 0) {
            return checkList;
        }
        sourceBillIdStr.deleteCharAt(sourceBillIdStr.length() - 1);
        String sqlString = "SELECT DISTINCT FBILLID FROM T_MBG_BGCONTROLRECORDDETAIL WHERE FBILLID IN (" + sourceBillIdStr + ") UNION ALL SELECT DISTINCT FBILLID FROM T_BG_BGCTRLRECORD WHERE FBILLID IN (" + sourceBillIdStr + ")";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString);
            while (rowSet.next()) {
                noBgBillIdSet.remove(rowSet.getString("FBILLID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("dealCheckListByRequstBg error" + e.getMessage()), (Throwable)e);
            return checkList;
        }
        if (noBgBillIdSet.size() > 0) {
            ReverseUtil.dealNoBgBillIdSet(ctx, noBgBillIdSet);
        }
        if (noBgBillIdSet.size() == 0) {
            return checkList;
        }
        int size2 = checkList.size();
        for (int i = 0; i < size2; ++i) {
            checkInfo = (BizCollCheckEntryInfo)checkList.get(i);
            if (noBgBillIdSet.contains(checkInfo.getSourceBillID())) continue;
            newCheckList.add(checkInfo);
        }
        logger.info((Object)("##dealCheckListByRequstBg noBgBillIdSet=" + noBgBillIdSet + " ,sourceBillIdStr=" + sourceBillIdStr + " ,number=" + (info == null ? "" : info.getNumber())));
        return newCheckList;
    }

    public static Set<String> dealNoBgBillIdSet(Context ctx, Set<String> noBgBillIdSet) {
        IBizCollBillBase iBizCollBillBase = null;
        BizCollBillBaseInfo billInfo = null;
        BizCollBillBaseCollection billCol = null;
        String billId = null;
        String bosType = null;
        HashMap<String, Set<String>> billMap = new HashMap<String, Set<String>>();
        HashMap<String, IBizCollBillBase> iBillServiceMap = new HashMap<String, IBizCollBillBase>();
        Set<String> billIdSetTmp = new HashSet();
        Iterator<String> iterator = noBgBillIdSet.iterator();
        try {
            while (iterator.hasNext()) {
                billId = iterator.next();
                bosType = BOSUuid.getBOSObjectType((String)billId, (boolean)true).toString();
                if ("E76173AD".equals(bosType) || "DE853384".equals(bosType)) continue;
                if (billMap.containsKey(bosType)) {
                    billIdSetTmp = (Set)billMap.get(bosType);
                    billIdSetTmp.add(billId);
                    continue;
                }
                iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)billId));
                if (!(iBizCollBillBase instanceof ILoanBill)) continue;
                billIdSetTmp = new HashSet();
                billIdSetTmp.add(billId);
                billMap.put(bosType, billIdSetTmp);
                iBillServiceMap.put(bosType, iBizCollBillBase);
            }
            if (billMap != null && billMap.size() > 0) {
                EntityViewInfo entityView = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("entries.budgetDo"));
                sic.add(new SelectorItemInfo("reqCheckEntries.id"));
                sic.add(new SelectorItemInfo("reqCheckEntries.budgetUsed"));
                entityView.setSelector(sic);
                FilterInfo filter = null;
                for (Map.Entry srcEntry : billMap.entrySet()) {
                    bosType = (String)srcEntry.getKey();
                    billIdSetTmp = (Set)srcEntry.getValue();
                    iBizCollBillBase = (IBizCollBillBase)iBillServiceMap.get(bosType);
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", billIdSetTmp, CompareType.INCLUDE));
                    entityView.setFilter(filter);
                    billCol = iBizCollBillBase.getBizCollBillBaseCollection(entityView);
                    int size = billCol.size();
                    for (int i = 0; i < size; ++i) {
                        billInfo = billCol.get(i);
                        if (!ReverseUtil.checkBillIsRequstBgSpecialDeal(ctx, billInfo)) continue;
                        noBgBillIdSet.remove(billInfo.getId().toString());
                    }
                }
                billMap = null;
                iBillServiceMap = null;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return noBgBillIdSet;
    }

    public static String convertListToSqlParamStr(List list) {
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            sb.append("?,");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

