/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BCWebUtil {
    public static final String EXPENSE_VIEW_PERMISSION = "cp_bc_Expense_View";
    public static final String EXPENSE_UPDATE_PERMISSION = "cp_bc_Expense_Update";
    public static final String DAILYLOAN_VIEW_PERMISSION = "cp_bc_DailyLoan_View";
    public static final String DAILYLOAN_UPDATE_PERMISSION = "cp_bc_DailyLoan_Update";
    public static final String EVECTIONREQ_VIEW_PERMISSION = "cp_bc_EvectionReq_View";
    public static final String EVECTIONREQ_UPDATE_PERMISSION = "cp_bc_EvectionReq_Update";
    public static final String EVECTIONLOAD_VIEW_PERMISSION = "cp_bc_EvectionLoan_View";
    public static final String EVECTIONLOAD_UPDATE_PERMISSION = "cp_bc_EvectionLoan_Update";
    public static final String REXPENSEACCOUNT_VIEW_PERMISSION = "cp_bc_ExpenseAccount_View";
    public static final String EXPENSEACCOUNT_UPDATE_PERMISSION = "cp_bc_ExpenseAccount_Update";
    public static final String TRAVELACCOUNT_VIEW_PERMISSION = "cp_bc_TravelAccount_View";
    public static final String TRAVELACCOUNT_UPDATE_PERMISSION = "cp_bc_TravelAccount_Update";
    public static final String BIZACCOUNTOUTBILL_VIEW_PERMISSION = "cp_bc_BizAccountOutBill_View";
    public static final String BIZACCOUNTOUTBILL_UPDATE_PERMISSION = "cp_bc_BizAccountOutBill_Update";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.web.BCWebUtil");

    public static void checkPermission(Context ctx, String permissionItem) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (cuId == null || StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK orgPK = new ObjectUuidPK(cuId);
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, (IObjectPK)orgPK, permissionItem);
    }

    public static boolean isHasPermission(Context ctx, String permissionItem) {
        try {
            BCWebUtil.checkPermission(ctx, permissionItem);
        }
        catch (PermissionServiceException e) {
            logger.error((Object)e.getMessage());
            logger.debug((Object)("com.kingdee.eas.cp.bc.web.BCWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermItemException e) {
            logger.error((Object)e.getMessage());
            logger.debug((Object)("com.kingdee.eas.cp.bc.web.BCWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (PermissionException e) {
            logger.error((Object)e.getMessage());
            logger.debug((Object)("com.kingdee.eas.cp.bc.web.BCWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            logger.debug((Object)("com.kingdee.eas.cp.bc.web.BCWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            logger.debug((Object)("com.kingdee.eas.cp.bc.web.BCWebUtil.isHasPermission is error: " + e.getMessage()));
            return false;
        }
        return true;
    }
}

