/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.carm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.util.SmInfo;
import com.kingdee.eas.cp.carm.CarDispatchCollection;
import com.kingdee.eas.cp.carm.CarDispatchFactory;
import com.kingdee.eas.cp.carm.CarDispatchInfo;
import com.kingdee.eas.cp.carm.CarDispatchUserEntryCollection;
import com.kingdee.eas.cp.carm.CarDispatchUserEntryFactory;
import com.kingdee.eas.cp.carm.CarRequestFactory;
import com.kingdee.eas.cp.carm.CarRequestInfo;
import com.kingdee.eas.cp.carm.DispatchStatus;
import com.kingdee.eas.cp.carm.DocStatus;
import com.kingdee.eas.cp.carm.app.AbstractCarDispatchControllerBean;
import com.kingdee.eas.cp.carm.web.CarMessageUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.perf.app.PfServerUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CarDispatchControllerBean
extends AbstractCarDispatchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.carm.app.CarDispatchControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BOSUuid id = ((CarDispatchInfo)model).getId();
        CarDispatchCollection carCol = null;
        if (id != null && !id.toString().equals("")) {
            carCol = CarDispatchFactory.getLocalInstance(ctx).getCarDispatchCollection("select * where id='" + id.toString() + "'");
        }
        IObjectPK pk = super._submit(ctx, model);
        if (((CarDispatchInfo)model).getStartMileage().compareTo(new BigDecimal(0)) <= 0) {
            if (carCol != null && carCol.size() > 0) {
                CarMessageUtils.modifySendInform(ctx, (CarDispatchInfo)model);
            } else {
                CarMessageUtils.newSendInform(ctx, (CarDispatchInfo)model);
            }
        }
        return pk;
    }

    @Override
    protected void _sendMessage(Context ctx, IObjectValue model) throws BOSException {
        CarDispatchInfo info = (CarDispatchInfo)model;
        try {
            this.sendMsg(ctx, info, false);
        }
        catch (Exception e) {
            logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
        }
        try {
            CarDispatchControllerBean.sendMail(ctx, info, false);
        }
        catch (Exception e) {
            logger.error((Object)("send Email error:" + e.getMessage() + e.getStackTrace().toString()));
        }
    }

    @Override
    protected void _sendDeleteMessage(Context ctx, IObjectValue model) throws BOSException {
        CarDispatchInfo info = null;
        try {
            info = this.getCarDispatchInfo(ctx, (IObjectPK)new ObjectUuidPK(((CarDispatchInfo)model).getId()));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        try {
            this.sendMsg(ctx, info, true);
        }
        catch (Exception e) {
            logger.error((Object)("send sms error:" + e.getMessage() + e.getStackTrace().toString()));
        }
        try {
            CarDispatchControllerBean.sendMail(ctx, info, true);
        }
        catch (Exception e) {
            logger.error((Object)("send Email error:" + e.getMessage() + e.getStackTrace().toString()));
        }
    }

    private static void sendMail(Context ctx, CarDispatchInfo info, boolean isDeleteMsg) throws Exception {
        MailUtil mailUtil = MailUtil.getInstance((Context)ctx);
        String from = CarDispatchControllerBean.getMailPersonStr(ctx, info.getAttemper());
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        CarDispatchUserEntryCollection col = new CarDispatchUserEntryCollection();
        if (info.getId() != null) {
            String oql = "select user.id where parent.id = '" + info.getId().toString() + "'";
            col = CarDispatchUserEntryFactory.getLocalInstance(ctx).getCarDispatchUserEntryCollection(oql);
        } else {
            col = info.getUserEntry();
        }
        if (col != null) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                list.add(col.get(i).getUser());
            }
        }
        String to = CarDispatchControllerBean.getMailPersonStr(ctx, list);
        String cc = "";
        String subject = "";
        String body = "";
        if (isDeleteMsg) {
            subject = CarDispatchControllerBean.getDeleteMsg(info);
            body = CarDispatchControllerBean.getDeleteMsg(info);
        } else {
            subject = CarDispatchControllerBean.getMsgToUsers(info);
            body = CarDispatchControllerBean.getMsgToUsers(info);
        }
        if (to == null || to.length() == 0) {
            return;
        }
        mailUtil.sendHtmlMail(from, to, cc, subject, body);
        to = CarDispatchControllerBean.getMailPersonStr(ctx, info.getDriver());
        if (to == null || to.length() == 0) {
            return;
        }
        if (isDeleteMsg) {
            subject = CarDispatchControllerBean.getDeleteMsg(info);
            body = CarDispatchControllerBean.getDeleteMsg(info);
        } else {
            subject = CarDispatchControllerBean.getMsgToDriver(info);
            body = CarDispatchControllerBean.getMsgToDriver(info);
        }
        mailUtil.sendHtmlMail(from, to, cc, subject, body);
    }

    private void sendMsg(Context ctx, CarDispatchInfo info, boolean isDeleteMsg) throws BOSException, EASBizException {
        CarDispatchUserEntryCollection col = new CarDispatchUserEntryCollection();
        if (info.getId() != null) {
            String oql = "select user.id where parent.id = '" + info.getId().toString() + "'";
            col = CarDispatchUserEntryFactory.getLocalInstance(ctx).getCarDispatchUserEntryCollection(oql);
        } else {
            col = info.getUserEntry();
        }
        HashSet<String> set = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            set.add(col.get(i).getUser().getId().toString());
        }
        String messageStr1 = "";
        String messageStr2 = "";
        String senderStr = info.getAttemper().getName();
        if (isDeleteMsg) {
            messageStr1 = CarDispatchControllerBean.getDeleteMsg(info);
            messageStr2 = CarDispatchControllerBean.getDeleteMsg(info);
        } else {
            messageStr1 = CarDispatchControllerBean.getMsgToUsers(info);
            messageStr2 = CarDispatchControllerBean.getMsgToDriver(info);
        }
        CarDispatchControllerBean.sendMessage(ctx, this.getUsersId(ctx, set), messageStr1, senderStr, messageStr1, info.getId().toString(), 0);
        set = new HashSet();
        set.add(info.getDriver().getId().toString());
        CarDispatchControllerBean.sendMessage(ctx, this.getUsersId(ctx, set), messageStr2, senderStr, messageStr2, info.getId().toString(), 0);
    }

    private String[] getUsersId(Context ctx, HashSet set) throws BOSException, EASBizException {
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        UserCollection uc = iuser.getUserCollection(evi);
        if (uc.size() == 0) {
            return new String[0];
        }
        String[] userIds = new String[uc.size()];
        int size = userIds.length;
        for (int i = 0; i < size; ++i) {
            userIds[i] = uc.get(i).getId().toString();
        }
        return userIds;
    }

    private static String getMsgToUsers(CarDispatchInfo info) {
        return "\u60a8\u7684\u7528\u8f66\u7533\u8bf7\u5df2\u8c03\u5ea6\u6d3e\u8f66\u5355\uff08\u5355\u53f7" + info.getNumber() + "\uff09\uff0c\u6267\u884c\u53f8\u673a\u4e3a" + info.getDriver().getName();
    }

    private static String getMsgToDriver(CarDispatchInfo info) {
        return "\u8bf7\u6267\u884c\u5355\u53f7\u4e3a" + info.getNumber() + "\u6d3e\u8f66\u5355\u4efb\u52a1\uff0c\u6267\u884c\u65f6\u95f4\u4e3a" + CarDispatchControllerBean.getTimeStr(info.getSendTimePlan());
    }

    private static String getDeleteMsg(CarDispatchInfo info) {
        return "\u5355\u53f7\u4e3a" + info.getNumber() + "\u6d3e\u8f66\u5355\u5df2\u4f5c\u5e9f";
    }

    private static void sendMessage(Context ctx, String[] ids, String messageStr, String senderStr, String bodyStr, String billid, int billType) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = CarDispatchControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        if (ids == null || ids.length == 0) {
            return;
        }
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", messageStr, locale2);
            message.setLocaleStringHeader("sender", senderStr, locale2);
            if (bodyStr == null) {
                message.setLocaleStringHeader("body", messageStr, locale2);
                continue;
            }
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        String billURL = "";
        switch (billType) {
            case 0: {
                billURL = "/easweb/cp/carm/carDispatchEdit.jsf?operateState=VIEW&billId=" + billid;
                break;
            }
            case 1: {
                billURL = "/easweb/cp/carm/carRequestEdit.jsf?operateState=VIEW&billId=" + billid;
                break;
            }
            default: {
                billURL = "/easweb/cp/carm/carDispatchEdit.jsf?operateState=VIEW&billId=" + billid;
            }
        }
        message.setStringHeader("sourceID", "");
        StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
        sourceIdsSB.append(billURL);
        sourceIdsSB.append(";billID:");
        sourceIdsSB.append(billid);
        message.setStringHeader("sourceIDs", sourceIdsSB.toString());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("bizPackage", "com.kingdee.eas.cp.carm.app");
        message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.carm.app");
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        int n = ids.length;
        for (int i = 0; i < n; ++i) {
            if (PfServerUtils.objectIsNull((Object)ids[i])) continue;
            message.setStringHeader("receiver", ids[i]);
            senderAgent.sendMessage(message);
        }
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private static String getMailPersonStr(Context ctx, ArrayList personList) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            set.add(person.getId().toString());
        }
        if (set.size() == 0) {
            set.add("");
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            person = pc.get(i);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(pc.get(i).getEmail());
        }
        return sb.toString();
    }

    private static String getMailPersonStr(Context ctx, PersonInfo person) throws BOSException {
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pc = ip.getPersonCollection("select email,cell where id = '" + person.getId().toString() + "'");
        if (pc.size() > 0) {
            person = pc.get(0);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) {
                return "";
            }
            return person.getEmail();
        }
        return "";
    }

    private static String getTimeStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        return format.format(date);
    }

    @Override
    protected boolean _checkTime(Context ctx, Timestamp startTime, Timestamp endTime, String carId, String carDispatchDocID) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)carDispatchDocID, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("carInfo", (Object)carId));
        filter.getFilterItems().add(new FilterItemInfo("sendTimePlan", (Object)startTime, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("sendTimePlan", (Object)endTime, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("backTimePlan", (Object)startTime, CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("backTimePlan", (Object)endTime, CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("sendTimePlan", (Object)startTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("backTimePlan", (Object)endTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"3", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and ((#2 and #3) or (#4 and #5) or (#6 and #7)) and #8");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CarDispatchCollection c = this.getCarDispatchCollection(ctx, evi);
        int size = c.size();
        return size <= 0;
    }

    @Override
    protected boolean _abandon(Context ctx, IObjectValue model) throws BOSException {
        CarDispatchInfo info = (CarDispatchInfo)model;
        info.setStatus(DispatchStatus.abandon);
        try {
            this._save(ctx, (IObjectValue)info);
            this.setCarRequestInfoPassAuditStatus(ctx, info, DocStatus.passAudit);
            if (info.getId() != null) {
                HashSet<BOSUuid> billIdSet = new HashSet<BOSUuid>();
                billIdSet.add(info.getId());
                Class<?> cls = null;
                try {
                    cls = Class.forName("com.kingdee.eas.cp.sm.app.SchedulePlanFacadeControllerBean");
                    Object obj = cls.newInstance();
                    Method setConextMethod = cls.getMethod("cancelSchedulePlans", Context.class, Set.class);
                    setConextMethod.invoke(obj, ctx, billIdSet);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("cancelSchedulePlans is ClassNotFoundException error:" + e));
                }
                catch (InstantiationException e) {
                    logger.error((Object)("cancelSchedulePlans is InstantiationException error:" + e));
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)("cancelSchedulePlans is IllegalAccessException error:" + e));
                }
                catch (SecurityException e) {
                    logger.error((Object)("cancelSchedulePlans is SecurityException error:" + e));
                }
                catch (NoSuchMethodException e) {
                    logger.error((Object)("cancelSchedulePlans is NoSuchMethodException error:" + e));
                }
                catch (IllegalArgumentException e) {
                    logger.error((Object)("cancelSchedulePlans is IllegalArgumentException error:" + e));
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)("cancelSchedulePlans is InvocationTargetException error:" + e));
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        CarMessageUtils.abandonSendInform(ctx, (CarDispatchInfo)model);
        return true;
    }

    @Override
    public void _setDispatchedStatus(Context ctx, IObjectValue model) throws BOSException {
        try {
            this.setCarRequestInfoPassAuditStatus(ctx, (CarDispatchInfo)model, DocStatus.dispatched);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private void setCarRequestInfoPassAuditStatus(Context ctx, CarDispatchInfo model, DocStatus status) throws EASBizException, BOSException {
        String bosType;
        String billId = model.getString("id");
        ArrayList srcModels = BotRelationUtil.getSrcObjectIdBySrcType((Context)ctx, (String)billId, (String)(bosType = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)"com.kingdee.eas.cp.carm.app.CarRequest")).getType().toString()));
        if (srcModels != null && srcModels.size() > 0) {
            String carRequestId = (String)srcModels.get(0);
            CarRequestInfo carRequestInfo = CarRequestFactory.getLocalInstance(ctx).getCarRequestInfo((IObjectPK)new ObjectUuidPK(carRequestId));
            carRequestInfo.setStatus(status);
            CarRequestFactory.getLocalInstance(ctx).save((CoreBaseInfo)carRequestInfo);
        }
    }

    @Override
    protected void _addNewOrUpdateSchedulePlan(Context ctx, CarDispatchInfo carDipsatchInfo) throws BOSException {
        HashSet<BOSUuid> personIdsSet = new HashSet<BOSUuid>();
        StringBuffer personName = new StringBuffer();
        if (carDipsatchInfo.getDriver() != null) {
            personIdsSet.add(carDipsatchInfo.getDriver().getId());
        }
        if (carDipsatchInfo.getUserEntry() != null && carDipsatchInfo.getUserEntry().size() > 0) {
            CarDispatchUserEntryCollection userCol = carDipsatchInfo.getUserEntry();
            int length = userCol.size();
            for (int i = 0; i < length; ++i) {
                personIdsSet.add(userCol.get(i).getUser().getId());
                personName.append(userCol.get(i).getUser().getName() + ",");
            }
        }
        if (personName.length() > 1) {
            personName = new StringBuffer(personName.toString().substring(0, personName.length() - 1));
        }
        SmInfo smInfo = new SmInfo();
        String carNo = carDipsatchInfo.getCarInfo() == null ? "" : carDipsatchInfo.getCarInfo().getName();
        String title = carNo + "\uff1a\u524d\u5f80\u201c" + carDipsatchInfo.getDestination() + "\u201d";
        smInfo.setTitle(title);
        smInfo.setEventDate(carDipsatchInfo.getSendTimePlan());
        smInfo.setEventEndDate(carDipsatchInfo.getBackTimePlan());
        smInfo.setScheduleAddress(carDipsatchInfo.getDestination());
        String memo = carDipsatchInfo.getMemo();
        memo = StringUtils.isEmpty((String)memo) || "null".equals(memo) ? "" : memo;
        StringBuffer content = new StringBuffer();
        content.append("\u8f66\u8f86\uff1a" + carNo + "\n");
        content.append("\u76ee\u7684\u5730\uff1a" + carDipsatchInfo.getDestination() + "\n");
        content.append("\u8054\u7cfb\u7535\u8bdd\uff1a" + carDipsatchInfo.getPhone() + "\n");
        content.append("\u7528\u8f66\u4eba\uff1a" + personName.toString() + "\n");
        content.append("\u5907\u6ce8\uff1a" + memo);
        smInfo.setContent(content.toString());
        smInfo.setMobile(false);
        smInfo.setMessage(false);
        smInfo.setMail(false);
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.eas.cp.sm.app.SchedulePlanFacadeControllerBean");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("addNewOrUpdateSchedulePlan", Context.class, SmInfo.class, HashSet.class, BOSUuid.class, String.class, String.class);
            setConextMethod.invoke(obj, ctx, smInfo, personIdsSet, carDipsatchInfo.getId(), "0D666128", "MIDDLE");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is ClassNotFoundException error:" + e));
        }
        catch (InstantiationException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is InstantiationException error:" + e));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is IllegalAccessException error:" + e));
        }
        catch (SecurityException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is SecurityException error:" + e));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is NoSuchMethodException error:" + e));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is IllegalArgumentException error:" + e));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("addNewOrUpdateSchedulePlan is InvocationTargetException error:" + e));
        }
    }
}

