/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.carm.web;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.carm.DocStatus;
import com.kingdee.eas.cp.carm.web.CarmWebUtil;
import com.kingdee.eas.cp.common.json.simple.JSONArray;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class CarmListAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.carm.web.CarmListAction");

    public ActionForward getCarRequestList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        IRowSet iRowSet = CarmWebUtil.getCarRequestIRowSet(ctx);
        if (iRowSet != null) {
            String carmWidth = request.getParameter("carmwidth");
            int divWidth = 453;
            int str_len = 10;
            if (carmWidth != null && carmWidth.trim().length() != 0) {
                try {
                    divWidth = Integer.parseInt(carmWidth);
                }
                catch (Exception e) {
                    divWidth = 453;
                }
            }
            str_len = CarmWebUtil.setWordsLenReq(divWidth) * 2 - 1;
            while (iRowSet.next()) {
                JSONObject jobj = new JSONObject();
                jobj.put((Object)"id", (Object)iRowSet.getString("id"));
                jobj.put((Object)"sendtimeplan", (Object)CarmWebUtil.forMatDate(iRowSet.getDate("sendTimePlan")));
                String retStr = iRowSet.getString("destination");
                jobj.put((Object)"tipsdestination", (Object)retStr);
                if (retStr != null && CarmWebUtil.getCharLength(retStr.toCharArray()) > str_len) {
                    retStr = CarmWebUtil.trim(retStr, str_len) + "...";
                }
                jobj.put((Object)"destination", (Object)retStr);
                DocStatus status = DocStatus.getEnum(iRowSet.getString("status"));
                String stattusName = "";
                if (status != null) {
                    stattusName = DocStatus.getEnum(iRowSet.getString("status")).getAlias();
                }
                jobj.put((Object)"status", (Object)stattusName);
                records.add((Object)jobj);
            }
        }
        reply.put((Object)"carrecords", (Object)records);
        response.setContentType("text/json;charset=utf-8");
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getCarDispatchList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        JSONObject reply = new JSONObject();
        JSONArray records = new JSONArray();
        IRowSet iRowSet = CarmWebUtil.getCarDisatptchIRowSet(ctx);
        if (iRowSet != null) {
            String carmWidth = request.getParameter("carmwidth");
            int divWidth = 453;
            int str_len = 6;
            if (carmWidth != null && carmWidth.trim().length() != 0) {
                try {
                    divWidth = Integer.parseInt(carmWidth);
                }
                catch (Exception e) {
                    divWidth = 453;
                }
            }
            str_len = CarmWebUtil.setWordsLenDispatch(divWidth) * 2 - 1;
            while (iRowSet.next()) {
                JSONObject jobj = new JSONObject();
                jobj.put((Object)"id", (Object)iRowSet.getString("id"));
                jobj.put((Object)"driver", (Object)iRowSet.getString("driver.name"));
                jobj.put((Object)"carname", (Object)iRowSet.getString("carInfo.name"));
                jobj.put((Object)"sendtimeplan", (Object)CarmWebUtil.forMatDate(iRowSet.getDate("sendTimePlan")));
                String retStr = iRowSet.getString("destination");
                jobj.put((Object)"tipsdestination", (Object)retStr);
                if (retStr != null && CarmWebUtil.getCharLength(retStr.toCharArray()) > str_len) {
                    retStr = CarmWebUtil.trim(retStr, str_len) + "...";
                }
                jobj.put((Object)"destination", (Object)retStr);
                records.add((Object)jobj);
            }
        }
        reply.put((Object)"cardispatchrecords", (Object)records);
        response.setContentType("text/json;charset=utf-8");
        response.getWriter().write(reply.toString());
        response.getWriter().flush();
        return null;
    }

    public ActionForward getCarmMenu(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        HashMap carmMapSession = (HashMap)request.getSession().getAttribute("carmMapSession");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (carmMapSession == null || !"true".equals(carmMapSession.get("isUseCarm_permission"))) {
            hashMap.put("isUseCarm_permission", "true");
            hashMap.put("carDataChar", "true");
            hashMap.put("carRequest", "true");
            if (CarmWebUtil.isCarAdmin(ctx)) {
                hashMap.put("carDispatch", "true");
            } else {
                hashMap.put("carDispatch", "false");
            }
            request.getSession().setAttribute("carmMapSession", hashMap);
            request.setAttribute("carmMap", hashMap);
        } else {
            request.setAttribute("carmMap", (Object)carmMapSession);
        }
        return mapping.findForward("carmMenu");
    }
}

