/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ContentManageFactory;
import com.kingdee.eas.cp.eip.cm.ContentStatus;
import com.kingdee.eas.cp.eip.cm.IContentManage;
import com.kingdee.eas.cp.eip.cm.SourceEnum;
import com.kingdee.eas.cp.eip.cm.app.AbstractCMContentControllerBean;
import com.kingdee.eas.cp.eip.cm.web.service.PublishContent;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CMContentControllerBean
extends AbstractCMContentControllerBean {
    static Logger logger = Logger.getLogger((String)CMContentControllerBean.class.getName());

    @Override
    protected void _setStatus(Context ctx, BOSUuid CMID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(CMID);
        CMContentInfo info = (CMContentInfo)this._getValue(ctx, (IObjectPK)pk);
        info.setStatus(ContentStatus.PUBLISH);
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
        try {
            this._sendMobile(ctx, CMID);
        }
        catch (Exception e) {
            logger.error((Object)"\u5185\u5bb9\u53d1\u5e03\u53d1\u9001\u77ed\u4fe1\u5931\u8d25", (Throwable)e);
        }
        PublishContent pInfo = new PublishContent();
        pInfo.addContent(ctx, info);
    }

    @Override
    protected void _post(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CMContentInfo ctInfo = (CMContentInfo)model;
        ctInfo.setStatus(ContentStatus.POST);
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(ctInfo.getId()))) {
            this.update(ctx, (IObjectPK)new ObjectUuidPK(ctInfo.getId()), (CoreBaseInfo)ctInfo);
        } else {
            this.addnew(ctx, (CoreBaseInfo)ctInfo);
        }
    }

    @Override
    protected BOSUuid[] _getAdmin(Context ctx, BOSUuid contentID) throws BOSException, EASBizException {
        BOSUuid[] userIDs = null;
        CMContentInfo ctInfo = (CMContentInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(contentID));
        IContentManage iManage = ContentManageFactory.getLocalInstance(ctx);
        CMColumnInfo columnInfo = iManage.getColumnInfo(ctInfo.getColumnID().toString());
        String roleIds = columnInfo.getAdminRoleIds();
        String[] idArray = null;
        StringBuffer idSql = new StringBuffer();
        if (roleIds != null) {
            idArray = roleIds.split(",");
            for (int i = 0; i < idArray.length; ++i) {
                if (i == 0) {
                    idSql.append("'");
                    idSql.append(idArray[i]);
                    idSql.append("'");
                    continue;
                }
                idSql.append(",");
                idSql.append("'");
                idSql.append(idArray[i]);
                idSql.append("'");
            }
        }
        if (idSql.length() > 0) {
            Object[] params = new Object[]{columnInfo.getCU().getId().toString()};
            String userSql = " select FUserID from T_PM_UserRoleOrg where FOrgID = ? and FRoleID in(" + idSql.toString() + ")";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)userSql, (Object[])params);
            userIDs = new BOSUuid[rowSet.size()];
            int j = 0;
            try {
                while (rowSet.next()) {
                    userIDs[j] = BOSUuid.read((String)rowSet.getString(1));
                    ++j;
                }
            }
            catch (UuidException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        logger.debug((Object)("user ids are:" + userIDs));
        return userIDs;
    }

    @Override
    protected void _sendMobile(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        CMContentInfo info = (CMContentInfo)this._getValue(ctx, (IObjectPK)pk);
        if (info.getStatus().getValue() == 2 && info.isIsSendMobile()) {
            String columnID = info.getColumnID().toString();
            String contentId = info.getId().toString();
            String title = info.getTitle();
            IContentManage iConMan = ContentManageFactory.getLocalInstance(ctx);
            ArrayList list = iConMan.getReadUserIDList(columnID, contentId);
            logger.error((Object)("user list in content manager :" + ((Object)list).toString()));
            MsgUtil.msgGroupSend((Context)ctx, (String)title, (int)0, (boolean)false, (String)"", (List)list, (int)1, null);
        }
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid CMID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(CMID);
        CMContentInfo info = (CMContentInfo)this._getValue(ctx, (IObjectPK)pk);
        if (SourceEnum.CONTRIBTE.equals((Object)info.getSource())) {
            info.setStatus(ContentStatus.EDIT);
        } else {
            info.setStatus(ContentStatus.DRAFT);
        }
        this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CMContentInfo info = this.getCMContentInfo(ctx, pk);
        if (info != null) {
            return info.getTitle();
        }
        return "";
    }
}

