/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.cm.CMColumnFactory;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.CMSubscriptionCollection;
import com.kingdee.eas.cp.eip.cm.CMSubscriptionFactory;
import com.kingdee.eas.cp.eip.cm.CMSubscriptionInfo;
import com.kingdee.eas.cp.eip.cm.ContentStatus;
import com.kingdee.eas.cp.eip.cm.ICMColumn;
import com.kingdee.eas.cp.eip.cm.ICMSubscription;
import com.kingdee.eas.cp.eip.cm.SubscriptionStatusEnum;
import com.kingdee.eas.cp.eip.cm.web.service.PublishContent;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;

public class SubscriptionObserver
implements Observer {
    static Logger logger = Logger.getLogger((String)SubscriptionObserver.class.getName());

    @Override
    public void update(Observable arg0, Object obj) {
        PublishContent pContent = (PublishContent)arg0;
        Context ctx = pContent.ctx;
        CMContentInfo info = (CMContentInfo)obj;
        String title = info.getTitle();
        boolean cuFilter = false;
        String columnCuId = info.getCU().getId().toString();
        try {
            ICMColumn iColumn = CMColumnFactory.getLocalInstance(ctx);
            CMColumnInfo columInfo = iColumn.getCMColumnInfo((IObjectPK)new ObjectUuidPK(info.getColumnID().toString()));
            cuFilter = columInfo.isCuFilter();
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u627e\u680f\u76ee\u51fa\u9519\uff1a" + e.getMessage()));
        }
        logger.info((Object)"\u5f00\u59cb\u4ea7\u751f\u8ba2\u9605");
        long start = System.currentTimeMillis();
        String ctDate = new Timestamp(new Date().getTime()).toString().substring(0, 10) + " 00:00:00";
        Timestamp ctTimestamp = Timestamp.valueOf(ctDate);
        Object[] params = null;
        StringBuffer sqlBf = new StringBuffer();
        if (this.ifSetReadRole(ctx, info.getColumnID().toString())) {
            params = new Object[]{info.getColumnID().toString(), ctTimestamp, ctTimestamp};
            sqlBf.append(" select FID,FKeyword,FAuthor,FCreatorID,FControlUnitID");
            sqlBf.append(" from T_CM_SubcriptionProject");
            sqlBf.append(" where FCreatorID in(");
            sqlBf.append(" select FUserID from T_PM_UserRoleOrg a, T_CM_ColumnReadRight b");
            sqlBf.append(" where a.FRoleID = b.FRoleID and b.FColumnID= ? ");
            sqlBf.append(")  and FIfEffect =1 and FBeginDate <= ? ");
            sqlBf.append(" and FEndDate >= ? ");
        } else {
            params = new Object[]{ctTimestamp, ctTimestamp};
            sqlBf.append(" select FID,FKeyword,FAuthor,FCreatorID,FControlUnitID");
            sqlBf.append(" from T_CM_SubcriptionProject");
            sqlBf.append(" where FIfEffect =1 and FBeginDate <= ?  and FEndDate >= ?");
        }
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBf.toString(), (Object[])params);
            String keyword = null;
            String user = null;
            String cuID = null;
            boolean flag = true;
            CMSubscriptionCollection scol = null;
            boolean existFlag = false;
            if (rowset != null && rowset.size() > 0) {
                ICMColumn iCMColumn = CMColumnFactory.getLocalInstance(ctx);
                CMColumnInfo columnInfo = (CMColumnInfo)iCMColumn.getValue((IObjectPK)new ObjectUuidPK(info.getColumnID()));
                Timestamp timestamp = new Timestamp(new Date().getTime());
                String author = this.getAuthor(ctx, info);
                ICMSubscription iSubscription = CMSubscriptionFactory.getLocalInstance(ctx);
                CMSubscriptionInfo sInfo = null;
                while (rowset.next()) {
                    flag = true;
                    keyword = rowset.getString("FKeyword");
                    user = rowset.getString("FAuthor");
                    cuID = rowset.getString("FControlUnitID");
                    if (!cuFilter && !cuID.equals(columnCuId)) continue;
                    if (keyword != null && keyword.trim().length() > 0) {
                        if (user != null && user.trim().length() > 0 && author.indexOf(user) < 0) {
                            flag = false;
                        }
                        if (title.indexOf(keyword) < 0) {
                            flag = false;
                        }
                    } else {
                        flag = false;
                    }
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("projectID", (Object)rowset.getString("FID")));
                    filter.getFilterItems().add(new FilterItemInfo("author", (Object)author));
                    filter.getFilterItems().add(new FilterItemInfo("objID", (Object)info.getId().toString()));
                    view.setFilter(filter);
                    scol = iSubscription.getCMSubscriptionCollection(view);
                    if (null != scol && scol.size() > 0) {
                        existFlag = true;
                    }
                    if (existFlag) {
                        if (info.getStatus().equals((Object)ContentStatus.PUBLISH) && !flag) {
                            iSubscription.delete((IObjectPK)new ObjectUuidPK(scol.get(0).getId().toString()));
                        }
                        if (!info.getStatus().equals((Object)ContentStatus.HIDDEN)) continue;
                        iSubscription.delete((IObjectPK)new ObjectUuidPK(scol.get(0).getId().toString()));
                        continue;
                    }
                    if (!flag) continue;
                    sInfo = new CMSubscriptionInfo();
                    sInfo.setId(BOSUuid.create((BOSObjectType)sInfo.getBOSType()));
                    sInfo.setTitle(info.getTitle());
                    sInfo.setColumnName(columnInfo.getName());
                    sInfo.setAuthor(author);
                    sInfo.setProjectID(BOSUuid.read((String)rowset.getString("FID")));
                    sInfo.setOwner(BOSUuid.read((String)rowset.getString("FCreatorID")));
                    sInfo.setObjID(BOSUuid.read((String)info.getId().toString()));
                    sInfo.setStatus(SubscriptionStatusEnum.UNREAD);
                    sInfo.setPublishDate(timestamp);
                    iSubscription.addnew(sInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u5f97\u5185\u5bb9\u8ba2\u9605\u65b9\u6848\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
        long end = System.currentTimeMillis();
        long count = (end - start) / 1000L;
        logger.info((Object)("\u8ba2\u9605\u7ed3\u675f\uff0c\u53d1\u5e03\u4e00\u6761\u5185\u5bb9\u4ea7\u751f\u8ba2\u9605\u7ed3\u679c\u6240\u8017\u65f6\u95f4\u4e3a\uff1a" + count + " \u79d2"));
    }

    private String getAuthor(Context ctx, CMContentInfo info) {
        String userid = null;
        String userName = null;
        if (info.getCreator() != null && info.getCreator().getId() != null) {
            userid = info.getCreator().getId().toString();
            try {
                IUser iUser = UserFactory.getLocalInstance((Context)ctx);
                UserInfo uInfo = (UserInfo)iUser.getValue((IObjectPK)new ObjectUuidPK(info.getCreator().getId()));
                userName = uInfo.getName();
            }
            catch (Exception e) {
                logger.error((Object)("\u83b7\u5f97\u5185\u5bb9\u4f5c\u8005\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
            }
        } else {
            userName = ctx.getUserName();
        }
        return userName;
    }

    private boolean ifSetReadRole(Context ctx, String columnId) {
        boolean flag = false;
        StringBuffer sqlBf = new StringBuffer();
        sqlBf.append(" select count(FID)");
        sqlBf.append(" from T_CM_ColumnReadRight");
        sqlBf.append(" where FColumnID = ?");
        Object[] params = new Object[]{columnId};
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBf.toString(), (Object[])params);
            if (rowset.next() && rowset.getInt(1) > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5224\u65ad\u680f\u76ee\u662f\u5426\u8bbe\u7f6e\u9605\u8bfb\u89d2\u8272\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage()));
        }
        return flag;
    }
}

