/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.base.common.fme.ConvertUtil;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.dm.DocumentCollection;
import com.kingdee.eas.cp.eip.cm.CMColorCollection;
import com.kingdee.eas.cp.eip.cm.CMColorFactory;
import com.kingdee.eas.cp.eip.cm.CMColorInfo;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ContentTypeEnum;
import com.kingdee.eas.cp.eip.cm.ICMColor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class CmUtil {
    public static CMColorInfo getUserSkinColor(HttpServletRequest request) {
        CMColorInfo colorInfo = new CMColorInfo();
        String skin = WebContextUtil.getUserSkinPath((HttpServletRequest)request);
        skin = skin.substring(skin.length() - 1, skin.length());
        int initColor = 1;
        try {
            initColor = Integer.parseInt(skin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        switch (initColor) {
            case 1: {
                skin = "blue";
                break;
            }
            case 2: {
                skin = "orange";
                break;
            }
            case 3: {
                skin = "green";
                break;
            }
            case 4: {
                skin = "red";
                break;
            }
            default: {
                skin = "blue";
            }
        }
        try {
            ICMColor cmColor = CMColorFactory.getRemoteInstance();
            CMColorCollection cmCollection = cmColor.getCMColorCollection();
            if (cmCollection != null && cmCollection.size() > 0) {
                for (int i = 0; i < cmCollection.size() && !(colorInfo = cmCollection.get(i)).getNumber().equals(skin); ++i) {
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return colorInfo;
    }

    public static HashMap getReadRecord(HttpServletRequest request, IRowSet rowSet) {
        Context ctxtv = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctxtv);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (userInfo.getPerson() != null && rowSet != null && rowSet.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    columnIdStr.append("'").append(rowSet.getString("id")).append("',");
                }
                while (rowSet.previous()) {
                }
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctxtv, (String)(sqltv = "select fcontentid from t_cm_reader where  freader='" + userInfo.getPerson().getName() + "' and fcontentid in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("fcontentid"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    public static HashMap getDocumentReadRecord(HttpServletRequest request, DocumentCollection docCollections) {
        Context ctxtv = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctxtv);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (docCollections != null && docCollections.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                for (int rows = 0; rows < docCollections.size(); ++rows) {
                    columnIdStr.append("'").append(docCollections.get(rows).getId().toString()).append("',");
                }
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctxtv, (String)(sqltv = "select freaddocumentid from t_dm_docreadnote where  freaderid='" + userInfo.getPerson().getId() + "' and freaddocumentid in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("freaddocumentid"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    public static HashMap getArcmReadRecord(HttpServletRequest request, IRowSet rowSet) {
        Context ctxtv = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctxtv);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (rowSet != null && rowSet.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    columnIdStr.append("'").append(rowSet.getString("id")).append("',");
                }
                while (rowSet.previous()) {
                }
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctxtv, (String)(sqltv = "select FDocId from T_CP_DocRead where  FPersonId='" + userInfo.getPerson().getId().toString() + "'  and FDocId in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("FDocId"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    public static HashMap getOdmReadRecord(HttpServletRequest request, IRowSet rowSet) {
        Context ctxtv = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctxtv);
        String sqltv = "";
        IRowSet rstv = null;
        HashMap<String, String> idMap = new HashMap<String, String>();
        if (rowSet != null && rowSet.size() > 0) {
            StringBuffer columnIdStr = new StringBuffer();
            try {
                while (rowSet.next()) {
                    columnIdStr.append("'").append(rowSet.getString("id")).append("',");
                }
                rowSet.beforeFirst();
                if (columnIdStr.length() > 0 && (rstv = DbUtil.executeQuery((Context)ctxtv, (String)(sqltv = "select FID from CT_ODM_ReceivePerson where CFIsRead='1' and CFReceiverID='" + userInfo.getPerson().getId().toString() + "'  and FID in(" + columnIdStr.substring(0, columnIdStr.length() - 1) + ")"))) != null && rstv.size() > 0) {
                    while (rstv.next()) {
                        idMap.put(rstv.getString("FID"), "true");
                    }
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return idMap;
    }

    public static Set getUserRolePerm(Context ctx, String userId) {
        HashSet<String> set = new HashSet<String>();
        try {
            String selectSql = "select DISTINCT froleid  from T_PM_UserRoleOrg where fuserId= ?";
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new String[]{userId});
            if (rowset != null) {
                while (rowset.next()) {
                    set.add(rowset.getString("froleid"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return set;
    }

    public static FilterInfo getContributeRangFilter(Context ctx, String columnID, String classID, String status, Date beginDate, Date endDate, Boolean inNewPortlet) throws EASBizException, BOSException {
        FilterItemInfo filterItemInfo = null;
        FilterInfo filterInfoRole = new FilterInfo();
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null && ContextUtil.getCurrentAdminUnit((Context)ctx) != null) {
            String maskStr;
            Set rolePermSet;
            int cloumAndClassFilterNum = 0;
            filterItemInfo = new FilterItemInfo("isRoleControl", (Object)new Integer(1), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                filterItemInfo = new FilterItemInfo("CMRolePerson.personId", (Object)currentPerson.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                AdminOrgUnitInfo currentAdmin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(currentPerson.getId());
                if (currentAdmin == null || currentAdmin.isIsSealUp()) {
                    AdminOrgUnitCollection orgUnitCol = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(currentPerson.getId());
                    currentAdmin = null;
                    for (int i = orgUnitCol.size() - 1; i >= 0 && (currentAdmin = orgUnitCol.get(i)).isIsSealUp(); --i) {
                        currentAdmin = null;
                    }
                }
                if (currentAdmin == null) {
                    currentAdmin = ContextUtil.getCurrentAdminUnit((Context)ctx);
                }
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(false), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.adminOrgId", (Object)currentAdmin.getId().toString(), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("CMRoleAdmin.isLeaf", (Object)new Boolean(true), CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                HashSet<String> adminNumber = new HashSet<String>();
                String[] currentNumber = currentAdmin.getLongNumber().split("!");
                String longNumber = "";
                if (currentNumber != null && currentNumber.length > 0) {
                    int size = currentNumber.length;
                    for (int i = 0; i < size; ++i) {
                        longNumber = longNumber + currentNumber[i];
                        adminNumber.add(longNumber);
                        if (i == size - 1) continue;
                        longNumber = longNumber + "!";
                    }
                }
                filterItemInfo = new FilterItemInfo("AdminOrgUnit.longNumber", adminNumber, CompareType.INCLUDE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
            }
            if ((rolePermSet = CmUtil.getUserRolePerm(ctx, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString())).size() == 0) {
                rolePermSet.add(new Integer(0));
            }
            filterItemInfo = new FilterItemInfo("CMRoleRole.roleId", (Object)rolePermSet, CompareType.INCLUDE);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("User.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), CompareType.EQUALS);
            filterInfoRole.getFilterItems().add(filterItemInfo);
            if (null != columnID && !"".equals(columnID)) {
                columnID = columnID.replaceAll(" ", "+");
                filterItemInfo = new FilterItemInfo("columnID", (Object)columnID);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != classID && !"".equals(classID)) {
                filterItemInfo = new FilterItemInfo("classID", (Object)classID, CompareType.INCLUDE);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != status && !"".equals(status)) {
                filterItemInfo = new FilterItemInfo("status", (Object)status);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != beginDate) {
                filterItemInfo = new FilterItemInfo("beginDate", (Object)beginDate, CompareType.LESS_EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != endDate) {
                filterItemInfo = new FilterItemInfo("endDate", (Object)endDate, CompareType.GREATER_EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (null != inNewPortlet) {
                filterItemInfo = new FilterItemInfo("CMCOLUMN.INNEWPORTLET", (Object)inNewPortlet, CompareType.EQUALS);
                filterInfoRole.getFilterItems().add(filterItemInfo);
                ++cloumAndClassFilterNum;
            }
            if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
                maskStr = "#0 and (#1 or ((#2 and #3) or(#4 and #5)) or #6 or #7)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 8);
                }
                filterInfoRole.setMaskString(maskStr);
            } else {
                maskStr = "#0 and (#1 or #2)";
                for (int i = 0; i < cloumAndClassFilterNum; ++i) {
                    maskStr = maskStr + " and #" + (i + 3);
                }
                filterInfoRole.setMaskString(maskStr);
            }
        }
        return filterInfoRole;
    }

    public static boolean converSwf(Context ctx, CMContentInfo info) {
        boolean flag = false;
        if (info == null) {
            return false;
        }
        if (!ContentTypeEnum.WORD.equals((Object)info.getContentType())) {
            return false;
        }
        String flashFileId = info.getId().toString();
        byte[] bodyByte = null;
        try {
            bodyByte = CmUtil.getDocInfoData(ctx, flashFileId);
        }
        catch (Exception e1) {
            System.out.println("getDocInfoDate error :" + e1.getMessage());
        }
        if (bodyByte == null) {
            return false;
        }
        try {
            flashFileId = flashFileId.replaceAll("\\", "");
            flashFileId = flashFileId.replaceAll("/", "");
            flashFileId = URLEncoder.encode(flashFileId, "UTF-8");
            flashFileId = flashFileId.replaceAll("%", "");
        }
        catch (Throwable e) {
            e.printStackTrace();
            flashFileId = flashFileId.replaceAll("\\+", "2B");
            flashFileId = flashFileId.replaceAll("=", "3D");
        }
        String toFileName = flashFileId + ".swf";
        String easHome = System.getProperty("EAS_HOME");
        String dataPath = ConvertUtil.createPath((Date)info.getCreateTime());
        String path = easHome + "/server/deploy/portal.ear/plt_cp.war/resource/" + dataPath;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String toFile = path + toFileName;
        try {
            flag = ConvertUtil.convert((String)"test.doc", (byte[])bodyByte, (String)toFile);
        }
        catch (Exception e) {
            System.out.println("om.kingdee.eas.cp.base.common.fme.ConvertUtil.convert error :" + e.getMessage());
        }
        return flag;
    }

    private static byte[] getDocInfoData(Context ctx, String docId) throws Exception {
        String sql = "select FContent from T_CM_DocumentContent WHERE FID = '" + docId + "'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        Blob blob = null;
        byte[] b = null;
        if (rows.next()) {
            blob = rows.getBlob(1);
            b = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
        }
        return b;
    }
}

