/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.util.image.IImageByteConverter;
import com.kingdee.lightapp.util.image.ImageUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CMNewsAttachmentImageByteConverter
implements IImageByteConverter {
    private Context ctx = null;
    private ComplexAttachmentInfo cai = null;
    private String name = "";
    private String format = "";

    public CMNewsAttachmentImageByteConverter(Context ctx) {
        this.ctx = ctx;
    }

    public void setPath(String path) {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.ctx);
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needSizeInByte();
        cais.needContent();
        cais.needCUName();
        cais.needExtName();
        String attchID = "";
        Pattern p = Pattern.compile("(\\?|&+)(.+?)=([^&]*)");
        Matcher m = p.matcher(path);
        while (m.find()) {
            if (!m.group(2).equalsIgnoreCase("id")) continue;
            attchID = m.group(3);
            break;
        }
        try {
            if (!attchID.equals("") && cais != null) {
                this.cai = asm.getComplexAttachmentInfo(attchID, cais);
                this.format = this.cai.getExtName();
                String uid = StringUtil.encoder((String)attchID);
                if (uid.indexOf("%") > -1) {
                    uid = uid.replaceAll("%", "9");
                }
                this.name = uid + "." + this.format;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public byte[] getByte(String format) {
        byte[] data = null;
        data = this.cai.getContent();
        if (!format.equals(this.format)) {
            data = ImageUtil.convert((byte[])data, (String)format);
        }
        return data;
    }

    public String getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }
}

