/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.cm.xt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.base.xt.AttchmentDTO;
import com.kingdee.eas.cp.base.xt.AttchmentUtil;
import com.kingdee.eas.cp.base.xt.CompressPic;
import com.kingdee.eas.cp.base.xt.HTMLUtil;
import com.kingdee.eas.cp.base.xt.MHTUtil;
import com.kingdee.eas.cp.eip.cm.CMColumnInfo;
import com.kingdee.eas.cp.eip.cm.CMContentInfo;
import com.kingdee.eas.cp.eip.cm.ColumnTypeEnum;
import com.kingdee.eas.cp.eip.cm.xt.CMNewsAdapter;
import com.kingdee.eas.cp.eip.cm.xt.CMNewsImageUtil;
import com.kingdee.eas.cp.eip.de.web.DocumentOperater;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.util.FileUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.UuidException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CMNewsContentUtil {
    public static final String MIDDLE_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String MHT_FILE_NAME = "cmContent.html";
    public static final String IMAGE_FOLDER_NAME = "images";
    private static Context ctx = null;

    private CMNewsContentUtil() {
    }

    public static String getCMContentHTML(CMNewsAdapter adapter, File contentFolder, boolean isNotAuto) {
        ctx = adapter.getContext();
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append(CMNewsContentUtil.buildHTMLHead(adapter));
        html.append(CMNewsContentUtil.buildHTMLBody(adapter, contentFolder, isNotAuto));
        html.append("</html>");
        return html.toString();
    }

    public static String getHTMLContent(CMNewsAdapter adapter) {
        String newsContent = "";
        try {
            DocumentOperater docOp = new DocumentOperater();
            docOp.setContext(adapter.getContext());
            byte[] docBodyContent = docOp.getDocBodyContent(adapter.getID());
            if (docBodyContent != null) {
                newsContent = new String(docBodyContent, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return newsContent;
    }

    public static String getMHTContent(CMNewsAdapter adapter) {
        String newsContent = "";
        String docId = adapter.getID();
        if (!StringUtils.isEmpty((String)docId) && !"null".equalsIgnoreCase(docId)) {
            docId = docId.replaceAll("%2B", "+");
            Object[] params = new Object[]{"mht" + docId};
            String sql = "select FContent from T_CM_DocumentContent WHERE FID = ?";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)adapter.getContext(), (String)sql, (Object[])params);
                Blob blob = null;
                byte[] data = null;
                if (rowSet.next()) {
                    blob = rowSet.getBlob(1);
                    data = blob.getBytes(1L, Integer.valueOf(String.valueOf(blob.length())));
                    File contentFolder = adapter.getContentFolder();
                    MHTUtil.getHtmlFileFromMhtData((byte[])data, (String)(contentFolder + File.separator + MHT_FILE_NAME), (MHTUtil.ResourceSaveModeEnum)MHTUtil.ResourceSaveModeEnum.SaveImageToFile);
                    newsContent = new String(FileUtil.readFile((String)(contentFolder + File.separator + MHT_FILE_NAME)), "gb2312");
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (UuidException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return newsContent;
    }

    private static String buildHTMLHead(CMNewsAdapter adapter) {
        StringBuffer head = new StringBuffer();
        head.append("<head>\n");
        head.append("<title>\u65b0\u95fb\u516c\u544a</title>\n");
        head.append("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\">\n");
        head.append("<meta name=\"viewport\" content=\"width=device-width, minimum-scale=1.0, maximum-scale=1.0\">\n");
        CMColumnInfo columnInfo = adapter.getCMColumnInfo();
        if (ColumnTypeEnum.PIC_GROUP.equals((Object)columnInfo.getColumnType())) {
            head.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"./xt_news_picgroup_detail.css\">\n");
        } else {
            head.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"./xt_news_tinyScreen.css\">\n");
        }
        head.append("</head>\n");
        return head.toString();
    }

    private static String buildHTMLBody(CMNewsAdapter adapter, File contentFolder, boolean isNotAuto) {
        String html = "";
        boolean isHasAtt = false;
        String appid = adapter.getAppId();
        List list = adapter.getAttchmentList();
        if (list != null && list.size() > 0) {
            isHasAtt = true;
        }
        StringBuffer body = new StringBuffer();
        CMColumnInfo columnInfo = adapter.getCMColumnInfo();
        if (ColumnTypeEnum.PIC_GROUP.equals((Object)columnInfo.getColumnType())) {
            return CMNewsContentUtil.buildPicGourpHTMLBody(adapter, contentFolder, isNotAuto);
        }
        body.append("<body>\n");
        body.append("<div class=\"newshtml\"> <div class=\"title\"><h1>" + adapter.getTitle() + "</h1></div>\n");
        body.append("<div class=\"info\"><small>" + new SimpleDateFormat(MIDDLE_DATE_FORMAT).format(adapter.getUpdateTime()) + " " + adapter.getCreator() + "</small></div>\n");
        body.append("<div class=\"content\">\n");
        if (!adapter.getPictureName(false).equals("")) {
            String pictureName = adapter.getPictureName(true);
            CMNewsImageUtil.createImageFile(contentFolder, IMAGE_FOLDER_NAME + File.separator + pictureName, adapter.getPictureData());
            if (adapter.isPicDisplay()) {
                body.append("<img src=\"file://" + contentFolder.getPath() + File.separator + IMAGE_FOLDER_NAME + File.separator + pictureName + "\" border=0 align=\"middle\"><br>");
            }
            String imgPath = contentFolder.getPath() + File.separator + IMAGE_FOLDER_NAME + File.separator;
            boolean isFlag = false;
            try {
                CompressPic pic = new CompressPic();
                pic.setInputDir(imgPath + pictureName);
                pic.setOutputDir(imgPath);
                pic.setOutputFileName("title" + pictureName);
                pic.setWidthAndHeight(150, 150);
                pic.setProportion(true);
                pic.setMin(true);
                isFlag = pic.compressPic();
            }
            catch (Exception e) {
                e.printStackTrace();
                isFlag = false;
            }
            pictureName = isFlag ? "title" + pictureName : pictureName;
            adapter.saveXtImgNameContentInfo(pictureName, isNotAuto);
        }
        if (!isNotAuto) {
            adapter.saveIsConverContentInfo(true);
        }
        String content = adapter.getCMContent();
        if (!adapter.isWord()) {
            content = CMNewsContentUtil.stripContentHTML(content, contentFolder);
        }
        body.append(content);
        body.append("</div></div>\n");
        if (isHasAtt) {
            body.append("<div class=\"tool-box\">\n");
            body.append("<a href=\"#\" class=\"btns-l hide\" ><span class=\"fx-icon\"></span>\u5206\u4eab</a>\n");
            body.append("<a href=\"#\" class=\"btns-r  hide\"><span class=\"on-icon\"></span>\u6536\u85cf</a>\n");
            body.append("<a href=\"#\" class=\"btns clear\"><span class=\"fj-icon\" style=\"color:#333;text-decoration:none;\"></span>\u9644\u4ef6</a>\n");
            body.append("</div>\n");
            int size = list.size();
            body.append("<div class=\"know-list\">\n");
            body.append(" <ul>\n");
            for (int i = 0; i < size; ++i) {
                AttchmentDTO dto = (AttchmentDTO)list.get(i);
                body.append("\t<li>\n");
                body.append("\t\t<div class=\"" + dto.getExtCss() + "\"><span class=\"fileImg\"></span></div>\n");
                body.append("\t\t<div class=\"text-cont\">\n");
                body.append("\t\t\t<div class=\"cont-l\">\n");
                body.append("\t\t\t\t<p class=\"title\">" + dto.getName() + "." + dto.getSimplename() + "</p>\n");
                body.append("\t\t\t\t<p class=\"page\">" + dto.getSize() + "</p>\n");
                body.append("\t\t\t</div>\n");
                body.append("\t\t\t<div class=\"cont-r\">\n");
                body.append("\t\t\t\t<span class=\"add-icon\" onclick=\"_myDownload('" + dto.getId() + "');\"></span>\n");
                body.append("\t\t\t</div>\n");
                body.append("\t\t</div>\n");
                body.append("\t</li>\n");
            }
            body.append(" \t<li><a href=\"javascript:;\" class=\"close-btn\" style=\"color:#0062d2;text-decoration:none;\">\u8fd4\u56de</a></li>\n");
            body.append(" </ul>\n");
            body.append("</div>\n");
        }
        body.append("<script type=\"text/javascript\" src=\"./jquery-1.5.min.js\"></script>\n");
        body.append("<script src=\"http://im.kdweibo.com/pub/js/qingjs.js\"></script>\n");
        body.append("<script type=\"text/javascript\">\n");
        body.append("var _openId='';var _eid='';\n");
        body.append("XuntongJSBridge.call('hideOptionMenu');\n");
        body.append("XuntongJSBridge.call('getPersonInfo',{},\n");
        body.append("\t\t\tfunction(result){\n");
        body.append("\t\t\t\tif(result.data != null){\n");
        body.append("\t\t\t\t\t_openId = result.data.openId;\n");
        body.append("\t\t\t\t\t_eid = result.data.eid;\n");
        body.append("\t\t\t\t\tif(_eid != null && _eid !='' && _openId != null && _openId !=''){\n");
        body.append("\t\t\t\t\t\tvar _url ='http://web20.kingdee.com/webstat/push?eid='+_eid+'&uid='+_openId+'&app=cpnews&action=\u67e5\u770b\u65b0\u95fb';\n");
        body.append("\t\t\t\t\t\t$.ajax({url:_url,type:'POST'});\n");
        body.append("\t\t\t\t\t}\n");
        body.append("\t\t\t \t}\n");
        body.append("\t\t\t }\n");
        body.append(");\n");
        if (isHasAtt) {
            body.append("function _myDownload(id){\n");
            body.append("\tmyDownload(id,_eid,_openId,'" + appid + "');\n");
            body.append("}\n");
        }
        body.append("</script>");
        body.append("<script type=\"text/javascript\" src=\"./attlist.js\"></script>\n");
        body.append("</body>");
        html = CMNewsImageUtil.reduceImageURL(body.toString(), contentFolder, adapter.getContext());
        return html;
    }

    private static String stripContentHTML(String content, File contentFolder) {
        content = HTMLUtil.convertHtmlTagToLowerCase((String)content);
        content = HTMLUtil.stripHtmlComment((String)content);
        content = HTMLUtil.stripHtmlDocumentContent((String)content);
        content = HTMLUtil.stripHtmlFrameContent((String)content);
        content = HTMLUtil.stripHtmlFormContent((String)content);
        content = HTMLUtil.stripHtmlMediaContent((String)content);
        content = HTMLUtil.stripHtmlTableContent((String)content);
        content = HTMLUtil.stripHtmlDocumentTags((String)content);
        content = HTMLUtil.stripHtmlArticleTags((String)content);
        content = HTMLUtil.stripHtmlListTags((String)content);
        content = HTMLUtil.stripHtmlTextTags((String)content);
        XTServiceConfig xTServiceConfig = XTServiceConfig.getInstance();
        String eid = xTServiceConfig.getEidByDbCode(ctx.getAIS());
        String isHreflinkClear = xTServiceConfig.getPubAcctProperty(eid, "XTNews", "data.hreflink.clear", "");
        int hreflinkClear = 0;
        try {
            hreflinkClear = Integer.parseInt(isHreflinkClear);
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (hreflinkClear) {
            case 0: {
                content = HTMLUtil.stripHtmlHrefTag((String)content);
                break;
            }
            case 1: {
                content = HTMLUtil.stripHtmlHrefContent((String)content);
            }
        }
        content = HTMLUtil.stripHtmlWordFormat((String)content);
        content = HTMLUtil.stripHtmlImageAttribute((String)content);
        content = HTMLUtil.stripHtmlBlankLine((String)content);
        content = HTMLUtil.stripHtmlSpace((String)content);
        return content;
    }

    private static String buildPicGourpHTMLBody(CMNewsAdapter adapter, File contentFolder, boolean isNotAuto) {
        CMContentInfo contentInfo = adapter.getCMContentInfo();
        StringBuffer body = new StringBuffer();
        body.append("<body class=\"img-details\">\n");
        body.append("<header class=\"page-swipe\">\n");
        body.append("<div id=\"slider\" class=\"swipe\">\n<div class=\"swipe-wrap\">");
        int imgIndex = 0;
        try {
            String strGroupsSql = "select i.FOrder FOrder,i.FImgId FImgId,i.FDescription FDescription,p.Ftitle Ftitle FROM T_CM_PicGroupImg i,T_CM_Content p WHERE i.FContentId = '" + contentInfo.getId() + "' and p.FID =i.FContentId order by i.FOrder asc";
            IRowSet rowSetGroups = DbUtil.executeQuery((Context)ctx, (String)strGroupsSql);
            ArrayList<String> imgIds = new ArrayList<String>();
            while (rowSetGroups.next()) {
                ++imgIndex;
                body.append("<figure>\n<div class=\"wrap\">\n");
                body.append("<div class=\"image\" style=\"background:url(images/");
                String imgName = AttchmentUtil.getPicGroupAttchment((File)contentFolder, (Context)ctx, (String)rowSetGroups.getString("FImgId"));
                if (imgIndex == 1) {
                    String imgPach = contentFolder.getPath() + File.separator + IMAGE_FOLDER_NAME + File.separator + imgName;
                    adapter.setFirstImg(imgPach, imgName, rowSetGroups.getString("FDescription"));
                }
                body.append(imgName);
                body.append(") center no-repeat;background-size: contain\"></div>\n");
                body.append("<div class=\"img-text\">\n");
                body.append("<h1><span class=\"img-title\">");
                body.append(rowSetGroups.getString("FTitle"));
                body.append("</span><span class=\"f-r\">");
                body.append(imgIndex).append("/").append("#imgNums#");
                body.append("</span></h1>");
                body.append("\n<div class=\"img-cont\">");
                body.append(rowSetGroups.getString("FDescription"));
                body.append("\n</div>\n</div>\n</div>\n</figure>");
                imgIds.add(rowSetGroups.getString("FImgId"));
            }
            if (!isNotAuto) {
                adapter.saveIsConverContentInfo(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        body.append("\n</div>\n</div>");
        body.append("\n</header>");
        body.append("<script type=\"text/javascript\" src=\"./jquery-1.5.min.js\"></script>\n");
        body.append("<script type=\"text/javascript\" src=\"./swipe.js\"></script>\n");
        body.append("<script src=\"http://im.kdweibo.com/pub/js/qingjs.js\"></script>\n");
        body.append("<script type=\"text/javascript\">\n");
        body.append("var _openId='';var _eid='';\n");
        body.append("XuntongJSBridge.call('hideOptionMenu');\n");
        body.append("XuntongJSBridge.call('getPersonInfo',{},\n");
        body.append("\t\t\tfunction(result){\n");
        body.append("\t\t\t\tif(result.data != null){\n");
        body.append("\t\t\t\t\t_openId = result.data.openId;\n");
        body.append("\t\t\t\t\t_eid = result.data.eid;\n");
        body.append("\t\t\t\t\tif(_eid != null && _eid !='' && _openId != null && _openId !=''){\n");
        body.append("\t\t\t\t\t\tvar _url ='http://web20.kingdee.com/webstat/push?eid='+_eid+'&uid='+_openId+'&app=cpnews&action=\u67e5\u770b\u56fe\u7247\u7ec4';\n");
        body.append("\t\t\t\t\t\t$.ajax({url:_url,type:'POST'});\n");
        body.append("\t\t\t\t\t}\n");
        body.append("\t\t\t \t}\n");
        body.append("\t\t\t }\n");
        body.append(");\n");
        body.append("var phHeight=window.screen.height;\n");
        body.append("var phtop=(phHeight-500)/2;\n");
        body.append("if(phHeight>480){$('.page-swipe').css('margin-top',phtop);}else{$('.page-swipe').css('margin-top',30);}\n");
        body.append("var slider = Swipe(document.getElementById('slider'), {continuous: true});\n");
        body.append("</script>");
        body.append("</body>");
        return body.toString().replaceAll("#imgNums#", imgIndex + "");
    }
}

