/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cw.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cw.BillStateEnum;
import com.kingdee.eas.cp.cw.CWBillReplyFactory;
import com.kingdee.eas.cp.cw.CooperativeWorkBillInfo;
import com.kingdee.eas.cp.cw.FlowNodeCollection;
import com.kingdee.eas.cp.cw.FlowNodeFactory;
import com.kingdee.eas.cp.cw.FlowNodeInfo;
import com.kingdee.eas.cp.cw.ICWBillReply;
import com.kingdee.eas.cp.cw.IFlowNode;
import com.kingdee.eas.cp.cw.NodeStateEnum;
import com.kingdee.eas.cp.cw.app.AbstractCooperativeWorkBillControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CooperativeWorkBillControllerBean
extends AbstractCooperativeWorkBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cw.app.CooperativeWorkBillControllerBean");
    private IFlowNode iFlowNode;
    private ICWBillReply iCWBillReply;

    protected void _send(Context ctx, HashSet billIDSet) throws BOSException {
        this.iFlowNode = FlowNodeFactory.getLocalInstance(ctx);
        FlowNodeCollection nodeCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flowSolution.workBill.id", (Object)billIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        nodeCol = this.iFlowNode.getFlowNodeCollection(view);
    }

    protected void _send(Context ctx, FlowNodeCollection nodeCol) throws BOSException {
        this.iFlowNode = FlowNodeFactory.getLocalInstance(ctx);
        CoreBaseCollection updateCol = new CoreBaseCollection();
        if (nodeCol.size() > 0) {
            for (int i = 0; i < nodeCol.size(); ++i) {
                FlowNodeInfo info = nodeCol.get(i);
                if (info.getLevel() == 2) {
                    info.setNodeState(NodeStateEnum.processing);
                }
                if (info.getLevel() == 1) {
                    info.setNodeState(NodeStateEnum.passed);
                }
                updateCol.add((CoreBaseInfo)info);
            }
            try {
                this.iFlowNode.update(updateCol);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    protected void _withdraw(Context ctx, IObjectPK pk, CooperativeWorkBillInfo info) throws BOSException {
        try {
            this.iFlowNode = FlowNodeFactory.getLocalInstance(ctx);
            this.iCWBillReply = CWBillReplyFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("nodeState"));
            selector.add(new SelectorItemInfo("isRead"));
            FlowNodeCollection nodeCol = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("flowSolution.workBill.id", (Object)pk.toString(), CompareType.EQUALS));
            view.setFilter(filter);
            nodeCol = this.iFlowNode.getFlowNodeCollection(view);
            if (nodeCol != null) {
                for (int i = 0; i < nodeCol.size(); ++i) {
                    FlowNodeInfo node = nodeCol.get(i);
                    if (node.getLevel() == 1) {
                        node.setNodeState(NodeStateEnum.processing);
                    } else {
                        node.setNodeState(NodeStateEnum.unpassed);
                        node.setIsRead(false);
                    }
                    this.iFlowNode.updatePartial(node, selector);
                }
            }
            info.setBillState(BillStateEnum.WITHDRAW);
            this.iCWBillReply.delete("where workBill.id = '" + info.getId().toString() + "'");
            SelectorItemCollection billselector = new SelectorItemCollection();
            billselector.add(new SelectorItemInfo("billState"));
            this.updatePartial(ctx, info, billselector);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected boolean _isWithdraw(Context ctx, IObjectPK pk) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billState", (Object)new Integer(2), CompareType.EQUALS));
        try {
            return super._exists(ctx, filter);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean _hasHandled(Context ctx, IObjectPK pk) throws BOSException {
        this.iFlowNode = FlowNodeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flowSolution.workBill.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("nodeState", (Object)"passed", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.NOTEQUALS));
        try {
            return this.iFlowNode.exists(filter);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void _setFinished(Context ctx, IObjectPK pk, CooperativeWorkBillInfo model) throws BOSException {
        this.iFlowNode = FlowNodeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flowSolution.workBill.id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("nodeState", (Object)"passed", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("nodeState", (Object)"stop", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and (#1 and #2)");
        try {
            boolean notAllPassed = this.iFlowNode.exists(filter);
            if (!notAllPassed) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("billState"));
                CooperativeWorkBillInfo info = new CooperativeWorkBillInfo();
                info.setId(model.getId());
                info.setBillState(BillStateEnum.ENDED);
                this.updatePartial(ctx, info, sic);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }
}

