/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cw.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.cw.CooperativeWorkBillInfo;
import com.kingdee.eas.cp.cw.FlowNodeCollection;
import com.kingdee.eas.mobile.IMsgFacade;
import com.kingdee.eas.mobile.MsgFacadeFactory;
import com.kingdee.eas.mobile.SendMessageParamInfo;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.msg.util.MsgUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MessageSendingUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cw.app.MessageSendingUtils");

    public static void sendMsgToHandler(Context ctx, CooperativeWorkBillInfo cwBillInfo, FlowNodeCollection fNodeCollection, String addSign) {
        String item = cwBillInfo.getItem();
        if (addSign != null && addSign.equals("addCont")) {
            item = MessageSendingUtils.addContentTitle(item);
        } else if (addSign != null && addSign.equals("withdraw")) {
            item = MessageSendingUtils.withdrawTitle(item);
        } else if (cwBillInfo != null) {
            Locale locale = SysContext.getSysContext().getLocale();
            item = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cw.CWResource", (String)"CW_MSG", (Locale)locale), item);
        }
        MessageSendingUtils.sendMsgToHandler1(ctx, item, fNodeCollection, cwBillInfo.getId().toString());
    }

    public static void sendMsgToHandler1(Context ctx, String item, FlowNodeCollection fNodeCollection, String billId) {
        if (fNodeCollection != null) {
            ArrayList<String> idList = new ArrayList<String>();
            int size = fNodeCollection.size();
            for (int i = 0; i < size; ++i) {
                idList.add(fNodeCollection.get(i).getHandler().getId().toString());
            }
            List userIdList = new ArrayList();
            if (idList != null) {
                userIdList = MessageSendingUtils.getUserIds(ctx, idList);
            }
            String senderName = ContextUtil.getCurrentUserInfo((Context)ctx).getName();
            if (userIdList != null) {
                MessageSendingUtils.sendMessage(ctx, userIdList, item, senderName, item, billId);
            }
        }
    }

    public static void sendMsgToUrgeHandler(Context ctx, List billIDList, HashMap itemMap, HashMap nodeMap) {
        if (billIDList != null && billIDList.size() > 0) {
            for (int i = 0; i < billIDList.size(); ++i) {
                String item = (String)itemMap.get(billIDList.get(i).toString());
                FlowNodeCollection col = (FlowNodeCollection)((Object)nodeMap.get(billIDList.get(i).toString()));
                MessageSendingUtils.sendMsgToHandler1(ctx, item, col, billIDList.get(i).toString());
            }
        }
    }

    public static List getUserIds(Context ctx, List pIds) {
        ArrayList<String> uIds = new ArrayList<String>();
        if (pIds != null) {
            HashSet idSet = new HashSet();
            int len = pIds.size();
            for (int i = 0; i < len; ++i) {
                idSet.add(pIds.get(i));
            }
            if (idSet.size() != 0) {
                try {
                    IUser iu = UserFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("person", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    view.setSelector(sic);
                    UserCollection coll = iu.getUserCollection(view);
                    if (coll != null) {
                        int len2 = coll.size();
                        for (int i = 0; i < len2; ++i) {
                            uIds.add(coll.get(i).getId().toString());
                        }
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return uIds;
    }

    public static void sendMessage(Context ctx, List idList, String titleStr, String senderName, String bodyStr, String billId) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = MessageSendingUtils.getContextLocales(ctx);
        Locale locale2 = null;
        String userId = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 40);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("bizPackage", "com.kingdee.eas.cp.cw.app");
        message.setStringHeader("realBizPackage", "com.kingdee.eas.cp.cw.app");
        message.setStringHeader("sourceID", "");
        String billURL = "/easweb/cp/cw/workBillReplyEdit.jsf?operateState=VIEW&billId=" + billId;
        message.setStringHeader("sourceID", "");
        StringBuffer sourceIdsSB = new StringBuffer("CPOVMSG::billPassURL:null;billURL:");
        sourceIdsSB.append(billURL);
        sourceIdsSB.append(";billID:");
        sourceIdsSB.append(billId);
        message.setStringHeader("sourceIDs", sourceIdsSB.toString());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", titleStr, locale2);
            message.setLocaleStringHeader("sender", senderName, locale2);
            message.setLocaleStringHeader("body", bodyStr, locale2);
        }
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            userId = (String)idList.get(i);
            message.setStringHeader("receiver", userId);
            senderAgent.sendMessage(message);
        }
    }

    public static void sendMail(Context ctx, FlowNodeCollection nextNodeCol, String mailTitle, String mailBody, String addSign) throws Exception {
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        for (int i = 0; i < nextNodeCol.size(); ++i) {
            list.add(nextNodeCol.get(i).getHandler());
        }
        String to = MessageSendingUtils.getMailPersonStr(ctx, list);
        if (addSign != null && addSign.equals("addCont")) {
            mailTitle = MessageSendingUtils.addContentTitle(mailTitle);
            mailBody = MessageSendingUtils.addContentTitle(mailBody);
        } else if (addSign != null && addSign.equals("withdraw")) {
            mailTitle = MessageSendingUtils.withdrawTitle(mailTitle);
            mailBody = MessageSendingUtils.withdrawTitle(mailBody);
        } else {
            mailTitle = MessageSendingUtils.convertToTitle(mailTitle);
            mailBody = MessageSendingUtils.convertToTitle(mailBody);
        }
        if (to == null || to.length() == 0) {
            return;
        }
        logger.info((Object)"\u748b\u51aa\u6564\u7eef\u8364\u7cba\u9359\u6226\ufffd\u4f80\u5056\u6d60\u8235\u5e34\u9359\uff46\u67df\u5a09\ufffd-MsgUtil.msgMailDerect()-begin");
        MsgUtil.msgMailDerect((Context)ctx, (String)mailTitle, (String)mailBody, (String)to, null, null, null);
        logger.info((Object)"\u748b\u51aa\u6564\u7eef\u8364\u7cba\u9359\u6226\ufffd\u4f80\u5056\u6d60\u8235\u5e34\u9359\uff46\u67df\u5a09\ufffd-MsgUtil.msgMailDerect()-end");
    }

    public static String getMailPersonStr(Context ctx, ArrayList personList) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            set.add(person.getId().toString());
        }
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            person = pc.get(i);
            if (person.getEmail() == null || person.getEmail().trim().length() == 0) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(pc.get(i).getEmail());
        }
        return sb.toString();
    }

    public static void sendSMS(Context ctx, FlowNodeCollection nextNodeCol, String content, String addSign) throws EASBizException, BOSException {
        logger.info((Object)"\u9357\u5fd3\u6093\u5bb8\u30e4\u7d94-\u5a34\u5b2d\u762f\u942d\ue15d\u4fca\u9a9e\u51b2\u5f74\u6769\u70b4\u5e34-\u5a09\u3129\u5674\u93ba\u5871sConnect\u59ab\ufffd\u93cc\u30e8\u7e5b\u93ba\u30e7\u6b91\u93c2\u89c4\u7876");
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        for (int i = 0; i < nextNodeCol.size(); ++i) {
            list.add(nextNodeCol.get(i).getHandler());
        }
        String receiver = MessageSendingUtils.getCellNumberStr(ctx, list);
        if (receiver == null || "".equals(receiver)) {
            return;
        }
        content = addSign != null && addSign.equals("addCont") ? MessageSendingUtils.addContentTitle(content) : (addSign != null && addSign.equals("withdraw") ? MessageSendingUtils.withdrawTitle(content) : MessageSendingUtils.convertToTitle(content));
        SendMessageParamInfo paramInfo = new SendMessageParamInfo();
        paramInfo.setAppendCompanyName(false);
        paramInfo.setAppendNumber(false);
        paramInfo.setAppendPersonName(false);
        paramInfo.setAppendRevert(false);
        paramInfo.setAppendUserName(false);
        paramInfo.setContent(content);
        paramInfo.setReceiver(receiver);
        paramInfo.setCanback(false);
        logger.info((Object)"\u947e\u5cf0\u7df1\u942d\ue15d\u4fca\u93ba\u30e5\u5f5b\u7035\u7845\u8584-IMsgFacade-begin");
        IMsgFacade iMsgFacade = MsgFacadeFactory.getLocalInstance((Context)ctx);
        logger.info((Object)"\u947e\u5cf0\u7df1\u942d\ue15d\u4fca\u93ba\u30e5\u5f5b\u7035\u7845\u8584-IMsgFacade-end");
        logger.info((Object)"\u748b\u51aa\u6564\u7eef\u8364\u7cba\u9359\u6226\ufffd\u4f7a\u716d\u6dc7\u2103\u5e34\u9359\uff46\u67df\u5a09\ufffd-iMsgFacade.sendMsg()-begin");
        iMsgFacade.sendMsg(paramInfo);
        logger.info((Object)"\u748b\u51aa\u6564\u7eef\u8364\u7cba\u9359\u6226\ufffd\u4f7a\u716d\u6dc7\u2103\u5e34\u9359\uff46\u67df\u5a09\ufffd-iMsgFacade.sendMsg()-end");
    }

    public static String convertToTitle(String str) {
        Locale locale = SysContext.getSysContext().getLocale();
        String title = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cw.CWResource", (String)"CW_MSG", (Locale)locale), str);
        return title;
    }

    public static String addContentTitle(String str) {
        Locale locale = SysContext.getSysContext().getLocale();
        String title = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cw.CWResource", (String)"CW_MSG_ADDCONT", (Locale)locale), str);
        return title;
    }

    public static String withdrawTitle(String str) {
        Locale locale = SysContext.getSysContext().getLocale();
        String title = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.cp.cw.CWResource", (String)"CW_MSG_WITHDRAW", (Locale)locale), str);
        return title;
    }

    public static String getCellNumberStr(Context ctx, ArrayList personList) throws BOSException {
        HashSet<String> set = new HashSet<String>();
        PersonInfo person = null;
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            person = (PersonInfo)personList.get(i);
            set.add(person.getId().toString());
        }
        if (set.size() == 0) {
            return "";
        }
        IPerson ip = PersonFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("email"));
        evi.getSelector().add(new SelectorItemInfo("cell"));
        PersonCollection pc = ip.getPersonCollection(evi);
        StringBuffer sb = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        int size2 = pc.size();
        for (int i = 0; i < size2; ++i) {
            person = pc.get(i);
            if (person.getCell() == null || person.getCell().trim().length() == 0) continue;
            map.put(person.getCell(), person.getCell());
        }
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    public static boolean isConnect(Context ctx) {
        ServerCenter serverCenter = ServerCenter.getInstance((Context)ctx);
        boolean isConnect = serverCenter.isConnect();
        return isConnect;
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }
}

