/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.autoupdate.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEConsoleService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryAdminCollection;
import com.kingdee.eas.cp.dm.CategoryAdminInfo;
import com.kingdee.eas.cp.dm.CategoryCollection;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.CategoryPersonCollection;
import com.kingdee.eas.cp.dm.CategoryPersonInfo;
import com.kingdee.eas.cp.dm.CategoryRoleCollection;
import com.kingdee.eas.cp.dm.CategoryRoleInfo;
import com.kingdee.eas.cp.dm.ICategory;
import com.kingdee.eas.cp.dm.app.AbstractCategoryControllerBean;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CategoryControllerBean
extends AbstractCategoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.CategoryControllerBean");
    private static final String TABLENAME = "t_dm_category";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int maxIndex;
        try {
            maxIndex = DmServerService.getMaxMinIndex(ctx, TABLENAME, "findex >= 0", "max");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        CategoryInfo categoryInfo = (CategoryInfo)model;
        categoryInfo.setId(BOSUuid.create((BOSObjectType)categoryInfo.getBOSType()));
        categoryInfo.setIndex(maxIndex + 1);
        categoryInfo.setNumber(this.createUniqueNumber(ctx));
        IFMEConsoleService iFMEConsoleService = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        String pId = null;
        if (categoryInfo.getParent() != null) {
            pId = categoryInfo.getParent().getId().toString();
        }
        iFMEConsoleService.addBusinessDocumentCategory(categoryInfo.getId().toString(), pId, this._getFmePathByDAId(ctx, categoryInfo.getDocArea().getId().toString()));
        IObjectPK pk = super._addnew(ctx, model);
        return pk;
    }

    private synchronized String createUniqueNumber(Context ctx) {
        int currentNumber = 0;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fnumber from t_dm_category where findex >= 0 order by len(fnumber) desc,fnumber desc");
            while (rs.next()) {
                try {
                    String number = rs.getString("fnumber");
                    int numInt = Integer.parseInt(number);
                    currentNumber = numInt + 1;
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(currentNumber);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        if (model.get("subUpdate") != null && ((String)model.get("subUpdate")).equals("0")) {
            if (null == model.get("subCatMap") || ((Map)model.get("subCatMap")).size() == 0) {
                return;
            }
            Map subCatIdMap = (Map)model.get("subCatMap");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("Role.*"));
            sic.add(new SelectorItemInfo("Person.*"));
            sic.add(new SelectorItemInfo("Admin.*"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)("%" + ((CategoryInfo)model).getLongNumber() + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.NOTEQUALS));
            ev.setFilter(filter);
            ev.setSelector(sic);
            CategoryCollection catColl = this.getCategoryCollection(ctx, ev);
            CategoryInfo catInfo = null;
            catInfo = (CategoryInfo)model;
            CategoryRoleCollection catRoleColl = catInfo.getRole();
            CategoryAdminCollection catAdminColl = catInfo.getAdmin();
            CategoryPersonCollection catPersonColl = catInfo.getPerson();
            CategoryRoleInfo catRoleInfo = null;
            CategoryAdminInfo catAdminInfo = null;
            CategoryPersonInfo catPersonInfo = null;
            ObjectUuidPK subPk = null;
            int size = catColl.size();
            for (int i = 0; i < size; ++i) {
                int j;
                catInfo = catColl.get(i);
                if (!subCatIdMap.containsKey(catInfo.getId().toString())) continue;
                catInfo.getRole().clear();
                int count = catRoleColl.size();
                for (j = 0; j < count; ++j) {
                    catRoleInfo = catRoleColl.get(j);
                    catRoleInfo.setId(null);
                    catRoleInfo.setParent(catInfo);
                    catInfo.getRole().add(catRoleInfo);
                }
                catInfo.getPerson().clear();
                count = catPersonColl.size();
                for (j = 0; j < count; ++j) {
                    catPersonInfo = catPersonColl.get(j);
                    catPersonInfo.setId(null);
                    catPersonInfo.setParent(catInfo);
                    catInfo.getPerson().add(catPersonInfo);
                }
                catInfo.getAdmin().clear();
                count = catAdminColl.size();
                for (j = 0; j < count; ++j) {
                    catAdminInfo = catAdminColl.get(j);
                    catAdminInfo.setId(null);
                    catAdminInfo.setParent(catInfo);
                    catInfo.getAdmin().add(catAdminInfo);
                }
                subPk = new ObjectUuidPK(catInfo.getId());
                if (subPk == null) continue;
                this.update(ctx, (IObjectPK)subPk, (CoreBaseInfo)catInfo);
            }
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        this.updateCascadCatState(ctx, ((CategoryInfo)valueInfo).getLongNumber(), 0);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        this.updateCascadCatState(ctx, ((CategoryInfo)valueInfo).getLongNumber(), 1);
    }

    private void updateCascadCatState(Context ctx, String longnumber, int state) throws BOSException {
        String updateSql = "update t_dm_category  set fstate =" + state + " where fstate != 2 and (flongnumber = '" + longnumber + "' or flongnumber like '" + longnumber + "!%')";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    @Override
    protected void _moveDown(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        CategoryInfo info = (CategoryInfo)valueInfo;
        try {
            DmServerService.moveDown(ctx, TABLENAME, info.getIndex(), this.makeWhereExp(info), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get category maxindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _moveUp(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        CategoryInfo info = (CategoryInfo)valueInfo;
        try {
            DmServerService.moveUp(ctx, TABLENAME, info.getIndex(), this.makeWhereExp(info), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get category minindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 0, pkList);
    }

    @Override
    protected void _cancelCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 1, pkList);
    }

    public void doCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        this._cancel(ctx, pkList);
    }

    public void doCancelCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        this._cancelCancel(ctx, pkList);
    }

    public void doMoveDown(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        this._moveDown(ctx, valueInfo);
    }

    public void doMoveUp(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        this._moveUp(ctx, valueInfo);
    }

    private String makeWhereExp(CategoryInfo catInfo) {
        StringBuffer whereExp = new StringBuffer("fstate !=2 ");
        if (catInfo.getParent() != null) {
            whereExp.append(" and fparentid = '").append(catInfo.getParent().getId().toString()).append("'");
        } else {
            whereExp.append(" and fdocareaid = '").append(catInfo.getDocArea().getId().toString()).append("' and fparentid is null ");
        }
        return whereExp.toString();
    }

    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) {
        try {
            CategoryCollection cc;
            TreeBaseInfo sourceTree = (TreeBaseInfo)sourceNode;
            TreeBaseInfo targetTree = (TreeBaseInfo)targetNode;
            ObjectUuidPK sourceTreePK = new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId());
            ObjectUuidPK targetTreePK = null;
            if (targetNode == null) {
                targetTree = null;
            } else {
                targetTreePK = new ObjectUuidPK(((TreeBaseInfo)targetNode).getId());
                targetTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)targetTreePK);
            }
            this.canMove(sourceTree);
            this.canReceive(targetTree);
            if (sourceTree.getLevel() > 1) {
                ObjectUuidPK parentPK = null;
                ICategory ic = CategoryFactory.getLocalInstance(ctx);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filterinfo = new FilterInfo();
                CategoryInfo ci = (CategoryInfo)sourceNode;
                filterinfo.getFilterItems().add(new FilterItemInfo("LongNumber", (Object)ci.getLongNumber().substring(0, ci.getLongNumber().length() - ci.getNumber().length() - 1), CompareType.EQUALS));
                ev.setFilter(filterinfo);
                cc = ic.getCategoryCollection(ev);
                if (cc.size() > 0) {
                    parentPK = new ObjectUuidPK(cc.get(0).getId());
                }
                CategoryInfo parent = CategoryFactory.getLocalInstance(ctx).getCategoryInfo((IObjectPK)parentPK);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTree.getId().toString(), CompareType.NOTEQUALS));
                if (!this._exists(ctx, filter)) {
                    parent.setIsLeaf(true);
                    this._update(ctx, (IObjectPK)parentPK, (IObjectValue)parent);
                }
            }
            sourceTree.innerSetParent(targetTree);
            this._update(ctx, (IObjectPK)sourceTreePK, (IObjectValue)sourceTree);
            if (targetTree != null && targetTree.isIsLeaf()) {
                targetTree.setIsLeaf(false);
                this._update(ctx, (IObjectPK)targetTreePK, (IObjectValue)targetTree);
            }
            String sourceCatId = sourceTree.getId().toString();
            String targetCatId = targetTree.getId().toString();
            this.doMoveCatByFME(ctx, sourceCatId, targetCatId);
            ICategory ic = CategoryFactory.getLocalInstance(ctx);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterinfo = new FilterInfo();
            filterinfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)targetTree.getId().toString(), CompareType.EQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.NOTEQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTree.getId().toString(), CompareType.NOTEQUALS));
            filterinfo.getFilterItems().add(new FilterItemInfo("name", (Object)(sourceTree.getName() + "%"), CompareType.LIKE));
            ev.setFilter(filterinfo);
            cc = ic.getCategoryCollection(ev);
            int num = 1;
            boolean isExistName = true;
            String name = sourceTree.getName();
            String oldname = sourceTree.getName().length() > 77 ? sourceTree.getName().substring(0, 77) : sourceTree.getName();
            String olddisplayname = sourceTree.getDisplayName();
            String olddisplayname1 = sourceTree.getDisplayName(locale_L1);
            String olddisplayname2 = sourceTree.getDisplayName(locale_L2);
            String olddisplayname3 = sourceTree.getDisplayName(locale_L3);
            block5: while (cc.size() > 0 && isExistName) {
                boolean canContinue = true;
                for (int i = 0; i < cc.size(); ++i) {
                    if (!canContinue) continue;
                    isExistName = false;
                    CategoryInfo temp = cc.get(i);
                    if (!temp.getName().equals(name) || temp.getName() == null) continue;
                    sourceTree.setName(oldname + "(" + num + ")");
                    name = sourceTree.getName();
                    if (temp.getDisplayName().equals(sourceTree.getDisplayName()) && temp.getDisplayName() != null) {
                        sourceTree.setDisplayName(olddisplayname + "(" + num + ")");
                    }
                    if (temp.getDisplayName(locale_L1) != null && temp.getDisplayName(locale_L1).equals(sourceTree.getDisplayName(locale_L1))) {
                        sourceTree.setDisplayName(olddisplayname1 + "(" + num + ")", locale_L1);
                    }
                    if (temp.getDisplayName(locale_L2) != null && temp.getDisplayName(locale_L2).equals(sourceTree.getDisplayName(locale_L2))) {
                        sourceTree.setDisplayName(olddisplayname2 + "(" + num + ")", locale_L2);
                    }
                    if (temp.getDisplayName(locale_L3) != null && temp.getDisplayName(locale_L3).equals(sourceTree.getDisplayName(locale_L3))) {
                        sourceTree.setDisplayName(olddisplayname3 + "(" + num + ")", locale_L3);
                    }
                    ++num;
                    isExistName = true;
                    canContinue = false;
                    continue block5;
                }
            }
            CategoryInfo finalCat = (CategoryInfo)sourceTree;
            int maxIndex = 0;
            try {
                StringBuffer selectMaxMinIndexSql = new StringBuffer("SELECT max(fINDEX) as maxIndex from T_DM_Category where findex >=0");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectMaxMinIndexSql.toString());
                if (rs.next()) {
                    maxIndex = rs.getInt("maxIndex");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (maxIndex != finalCat.getIndex()) {
                finalCat.setIndex(maxIndex + 1);
            }
            this._update(ctx, (IObjectPK)sourceTreePK, (IObjectValue)finalCat);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void doMoveCatByFME(Context ctx, String sourceCatId, String targetCatId) throws EASBizException, BOSException {
        IFMEConsoleService iFMEConsoleService = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        ArrayList<String> catIdList = new ArrayList<String>();
        catIdList.add(sourceCatId);
        catIdList.add(targetCatId);
        Map map = this._getFmePathId(ctx, catIdList);
        iFMEConsoleService.moveBusinessCategory((String)map.get(sourceCatId), sourceCatId, (String)map.get(targetCatId), targetCatId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _moveDocTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        TreeBaseInfo oldtree = (TreeBaseInfo)sourceNode;
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId());
        CategoryInfo sourceTree = (CategoryInfo)this._getValue(ctx, (IObjectPK)sourceTreePK);
        String sourceCatId = sourceTree.getId().toString();
        String ftpPathId = this._getFmePathId(ctx, sourceCatId);
        IFMEConsoleService iFMEConsoleService = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        iFMEConsoleService.moveBusinessCategory(ftpPathId, sourceCatId, ftpPathId, null);
        sourceTree.setLevel(1);
        sourceTree.setLongNumber(sourceTree.getNumber());
        sourceTree.setDisplayName(sourceTree.getName());
        sourceTree.setDisplayName(sourceTree.getName(locale_L1), locale_L1);
        sourceTree.setDisplayName(sourceTree.getName(locale_L2), locale_L2);
        sourceTree.setDisplayName(sourceTree.getName(locale_L3), locale_L3);
        CategoryInfo tempca = new CategoryInfo();
        tempca.setId(null);
        sourceTree.setParent(tempca);
        ICategory ic = CategoryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("docarea.id", (Object)sourceTree.getDocArea().getId(), CompareType.EQUALS));
        filterinfo.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1), CompareType.EQUALS));
        filterinfo.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2), CompareType.NOTEQUALS));
        filterinfo.getFilterItems().add(new FilterItemInfo("name", (Object)(sourceTree.getName() + "%"), CompareType.LIKE));
        ev.setFilter(filterinfo);
        CategoryCollection cc = ic.getCategoryCollection(ev);
        int num = 1;
        boolean isExistName = true;
        String name = sourceTree.getName();
        String oldname = sourceTree.getName().length() > 77 ? sourceTree.getName().substring(0, 77) : sourceTree.getName();
        String olddisplayname = sourceTree.getDisplayName();
        String olddisplayname1 = sourceTree.getDisplayName(locale_L1);
        String olddisplayname2 = sourceTree.getDisplayName(locale_L2);
        String olddisplayname3 = sourceTree.getDisplayName(locale_L3);
        block5: while (cc.size() > 0 && isExistName) {
            boolean canContinue = true;
            for (int i = 0; i < cc.size(); ++i) {
                if (!canContinue) continue;
                isExistName = false;
                CategoryInfo temp = cc.get(i);
                if (!temp.getName().equals(name) || temp.getName() == null) continue;
                sourceTree.setName(oldname + "(" + num + ")");
                name = sourceTree.getName();
                if (temp.getDisplayName().equals(sourceTree.getDisplayName()) && temp.getDisplayName() != null) {
                    sourceTree.setDisplayName(olddisplayname + "(" + num + ")");
                }
                if (temp.getDisplayName(locale_L1) != null && temp.getDisplayName(locale_L1).equals(sourceTree.getDisplayName(locale_L1))) {
                    sourceTree.setDisplayName(olddisplayname1 + "(" + num + ")", locale_L1);
                }
                if (temp.getDisplayName(locale_L2) != null && temp.getDisplayName(locale_L2).equals(sourceTree.getDisplayName(locale_L2))) {
                    sourceTree.setDisplayName(olddisplayname2 + "(" + num + ")", locale_L2);
                }
                if (temp.getDisplayName(locale_L3) != null && temp.getDisplayName(locale_L3).equals(sourceTree.getDisplayName(locale_L3))) {
                    sourceTree.setDisplayName(olddisplayname3 + "(" + num + ")", locale_L3);
                }
                ++num;
                isExistName = true;
                canContinue = false;
                continue block5;
            }
        }
        CategoryInfo finalCat = sourceTree;
        int maxIndex = 0;
        try {
            StringBuffer selectMaxMinIndexSql = new StringBuffer("SELECT max(fINDEX) as maxIndex from t_dm_category");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectMaxMinIndexSql.toString());
            if (rs.next()) {
                maxIndex = rs.getInt("maxIndex");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (maxIndex != finalCat.getIndex()) {
            finalCat.setIndex(maxIndex + 1);
        }
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.getDAO(ctx, cn).update((IObjectPK)sourceTreePK, (IObjectValue)finalCat);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        this.updateChildrenByNumberUpdated(ctx, (IObjectValue)sourceTree, oldtree.getLongNumber());
        this.updateChildrenByNameUpdated(ctx, (IObjectValue)sourceTree, oldtree.getDisplayName(), oldtree.getLongNumber());
        this.updateChildrenByNameUpdated(ctx, (IObjectValue)sourceTree, oldtree.getDisplayName(locale_L1), oldtree.getLongNumber(), locale_L1);
        this.updateChildrenByNameUpdated(ctx, (IObjectValue)sourceTree, oldtree.getDisplayName(locale_L2), oldtree.getLongNumber(), locale_L2);
        this.updateChildrenByNameUpdated(ctx, (IObjectValue)sourceTree, oldtree.getDisplayName(locale_L3), oldtree.getLongNumber(), locale_L3);
    }

    @Override
    public Map _getFmePathId(Context ctx, List catIdList) throws EASBizException, BOSException {
        HashMap<String, String> fmePathIdMap = new HashMap<String, String>();
        String sql = "select da.fftpPath, cat.fid from t_dm_category cat inner join t_dm_docarea da on cat.FDocAreaID = da.fid where cat.fid in" + CommonUtils.getStrFromList(catIdList);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                fmePathIdMap.put(rs.getString("fid"), rs.getString("fftpPath"));
            }
        }
        catch (SQLException e) {
            logger.info((Object)"\u83b7\u53d6\u680f\u76ee\u6240\u5c5e\u6587\u6863\u533a\u7684ftp\u8def\u5f84\u9519\u8bef");
            throw new BOSException((Throwable)e);
        }
        return fmePathIdMap;
    }

    @Override
    public String _getFmePathId(Context ctx, String catId) throws EASBizException, BOSException {
        String sql = "select da.fftpPath, cat.fid from t_dm_category cat inner join t_dm_docarea da on cat.FDocAreaID = da.fid where cat.fid = '" + catId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString("fftpPath");
            }
        }
        catch (SQLException e) {
            logger.info((Object)"\u83b7\u53d6\u680f\u76ee\u6240\u5c5e\u6587\u6863\u533a\u7684ftp\u8def\u5f84\u9519\u8bef");
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public String _getFmePathByDAId(Context ctx, String daId) throws EASBizException, BOSException {
        String sql = "select da.fftpPath from t_dm_docarea da where da.fid = '" + daId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return rs.getString("fftpPath");
            }
        }
        catch (SQLException e) {
            logger.info((Object)"\u83b7\u53d6\u680f\u76ee\u6240\u5c5e\u6587\u6863\u533a\u7684ftp\u8def\u5f84\u9519\u8bef");
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void updateChildrenByNumberUpdated(Context ctx, IObjectValue model, String oldLongNumber) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String longNumber = treeBaseInfo.getLongNumber();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp2 = null;
        for (TreeBaseInfo temp2 : collection) {
            String temps = StringUtility.castRegular((String)oldLongNumber);
            temp2.setLongNumber(temp2.getLongNumber().replaceFirst(temps, longNumber));
            this.checkLongNumberLen(ctx, temp2);
            int level = temp2.getLongNumber().split("!").length;
            temp2.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp2 = null;
        for (TreeBaseInfo temp2 : collection) {
            if (oldDisplayName != null) {
                String temps = StringUtility.castRegular((String)oldDisplayName);
                temp2.setDisplayName(temp2.getDisplayName().replaceFirst(temps + "_", displayName + "_"));
            } else {
                temp2.setDisplayName(displayName);
            }
            this.limitDisplayNameLength(temp2);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber, Locale locale) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName(locale);
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem((FilterInfo)filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp2 = null;
        for (TreeBaseInfo temp2 : collection) {
            if (oldDisplayName != null) {
                if (temp2.getDisplayName(locale) != null) {
                    String temps = StringUtility.castRegular((String)oldDisplayName);
                    temp2.setDisplayName(temp2.getDisplayName(locale).replaceFirst(temps + "_", displayName + "_"), locale);
                } else {
                    temp2.setDisplayName(displayName, locale);
                }
            } else {
                temp2.setDisplayName(displayName, locale);
            }
            this.limitDisplayNameLength(temp2);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp2.getId()), (IObjectValue)temp2);
        }
    }

    private void limitDisplayNameLength(TreeBaseInfo tree) {
        String displayName = tree.getDisplayName();
        String[] displayNameVar = StringUtil.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > 80) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName);
            this.limitDisplayNameLength(tree);
        }
    }

    private void checkLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, (CoreBaseInfo)info, "longNumber", ctx.getLocale());
        int len = null == info.getLongNumber() ? -1 : info.getLongNumber().getBytes().length;
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName, Locale locale) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias(locale);
        }
        return alias;
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }
}

