/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DocTemplateAssoShareCollection;
import com.kingdee.eas.cp.dm.DocTemplateAssoShareFactory;
import com.kingdee.eas.cp.dm.DocTemplateAssoShareInfo;
import com.kingdee.eas.cp.dm.DocTemplateCollection;
import com.kingdee.eas.cp.dm.DocTemplateEnum;
import com.kingdee.eas.cp.dm.DocTemplateFactory;
import com.kingdee.eas.cp.dm.DocTemplateInfo;
import com.kingdee.eas.cp.dm.DocTemplateTypeCollection;
import com.kingdee.eas.cp.dm.DocTemplateTypeEnum;
import com.kingdee.eas.cp.dm.DocTemplateTypeFactory;
import com.kingdee.eas.cp.dm.DocTemplateTypeInfo;
import com.kingdee.eas.cp.dm.IDocTemplate;
import com.kingdee.eas.cp.dm.IDocTemplateType;
import com.kingdee.eas.cp.dm.ShareAssoCUCollection;
import com.kingdee.eas.cp.dm.ShareAssoCUInfo;
import com.kingdee.eas.cp.dm.TemplateAddNewEnum;
import com.kingdee.eas.cp.dm.app.AbstractDocTemplateControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DocTemplateControllerBean
extends AbstractDocTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.DocTemplateControllerBean");

    @Override
    protected void _disableDocTempalte(Context ctx, IObjectPK docTemplateId) throws BOSException, EASBizException {
        if (docTemplateId == null) {
            return;
        }
        ArrayList<IObjectPK> ids = new ArrayList<IObjectPK>();
        ids.add(docTemplateId);
        this.changeDocTempalteState(ctx, ids, DocTemplateEnum.DISABLE);
    }

    @Override
    protected void _enableDocTemplate(Context ctx, IObjectPK docTemplateId) throws BOSException, EASBizException {
        if (docTemplateId == null) {
            return;
        }
        ArrayList<IObjectPK> ids = new ArrayList<IObjectPK>();
        ids.add(docTemplateId);
        this.changeDocTempalteState(ctx, ids, DocTemplateEnum.ENABLE);
    }

    @Override
    protected void _dispenseDocTemplate(Context ctx, IObjectCollection cuCols, IObjectPK templateId) throws BOSException, EASBizException {
        if (cuCols != null && cuCols.size() > 0 && templateId != null) {
            try {
                IDocTemplate iDocTemplate = DocTemplateFactory.getLocalInstance(ctx);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("name"));
                selector.add(new SelectorItemInfo("type"));
                selector.add(new SelectorItemInfo("description"));
                selector.add(new SelectorItemInfo("tempType.id"));
                selector.add(new SelectorItemInfo("tempType.name"));
                selector.add(new SelectorItemInfo("tempType.description"));
                selector.add(new SelectorItemInfo("CU.id"));
                DocTemplateInfo sourceTem = iDocTemplate.getDocTemplateInfo(templateId, selector);
                if (sourceTem == null) {
                    return;
                }
                CtrlUnitCollection cuCol = (CtrlUnitCollection)cuCols;
                AttachmentInfo sourceAttach = this.getAttachByBozID(ctx, sourceTem.getId().toString());
                AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                CtrlUnitInfo currentCu = this.getCU(ctx, (ObjectBaseInfo)sourceTem);
                DocTemplateAssoShareInfo shareInfo = new DocTemplateAssoShareInfo();
                shareInfo.setSourceTemplate(sourceTem);
                shareInfo.setOpraType(TemplateAddNewEnum.DISPENSE);
                ShareAssoCUCollection shareCuCols = shareInfo.getShare();
                int n = cuCols.size();
                for (int i = 0; i < n; ++i) {
                    CtrlUnitInfo cuInfo = cuCol.get(i);
                    if (cuInfo.getId().equals((Object)currentCu.getId())) continue;
                    DocTemplateInfo tempInfo = (DocTemplateInfo)ObjectUtils.createCopy((Object)sourceTem);
                    tempInfo.setId(null);
                    tempInfo.setName(this.checkNameDouble(ctx, cuInfo, sourceTem.getName()));
                    tempInfo.setCU(cuInfo);
                    tempInfo.setState(DocTemplateEnum.ENABLE);
                    tempInfo.setNewType(TemplateAddNewEnum.DISPENSE);
                    tempInfo.setUpdated(false);
                    tempInfo.setTempType(this.getTemplateType(ctx, sourceTem.getTempType(), cuInfo));
                    tempInfo.setSourceTemplate(sourceTem.getId().toString());
                    tempInfo.setSourceCU(sourceTem.getCU());
                    IObjectPK tempPk = iDocTemplate.save((CoreBaseInfo)tempInfo);
                    if (sourceAttach != null) {
                        SimpleAttachmentInfo info = new SimpleAttachmentInfo();
                        info.setContent(sourceAttach.getFile());
                        info.setMainName("DMdocBody_" + cuInfo.getNumber());
                        info.setExtName("body");
                        asm.addNewAttachment(ctx, tempPk.toString(), info);
                    }
                    ShareAssoCUInfo shareCuInfo = new ShareAssoCUInfo();
                    shareCuInfo.setShareCU(cuInfo);
                    shareCuInfo.setShareParent(shareInfo);
                    shareCuCols.add(shareCuInfo);
                }
                DocTemplateAssoShareFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)shareInfo);
            }
            catch (Exception e) {
                logger.info((Object)"ERROR:dispenseDocTemplate error!");
                e.printStackTrace();
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("newType"));
        super._delete(ctx, pk);
        this.delTempalteRealtedAtta(ctx, pk);
        this.delAllShareTemlate(ctx, pk.toString());
        DocTemplateAssoShareFactory.getLocalInstance(ctx).delete("select id where sourceTemplate ='" + pk.toString() + "'");
    }

    @Override
    protected void _shareDocTemplate(Context ctx, IObjectCollection cuCols, IObjectPK templateId) throws BOSException, EASBizException {
        DocTemplateAssoShareInfo shareInfo = this.getShareTemplate(ctx, templateId.toString());
        IDocTemplate iDocTemplate = DocTemplateFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("type"));
        selector.add(new SelectorItemInfo("description"));
        selector.add(new SelectorItemInfo("tempType.id"));
        selector.add(new SelectorItemInfo("tempType.name"));
        selector.add(new SelectorItemInfo("tempType.description"));
        selector.add(new SelectorItemInfo("CU.id"));
        DocTemplateInfo sourceTem = iDocTemplate.getDocTemplateInfo(templateId, selector);
        AttachmentInfo relatedAttache = this.getAttachByBozID_onlyId(ctx, templateId.toString());
        if (sourceTem == null) {
            return;
        }
        if (shareInfo != null) {
            ShareAssoCUCollection shareCUs = shareInfo.getShare();
            HashSet<String> hasAddCus = new HashSet<String>();
            HashSet<Integer> delCus = new HashSet<Integer>();
            HashSet<CtrlUnitInfo> addNewCus = new HashSet<CtrlUnitInfo>();
            HashSet<String> delCuInfos = new HashSet<String>();
            int n = shareCUs.size();
            for (int i = 0; i < n; ++i) {
                hasAddCus.add(shareCUs.get(i).getShareCU().getId().toString());
            }
            CtrlUnitCollection cuCol = (CtrlUnitCollection)cuCols;
            int m = cuCol.size();
            for (int j = 0; j < m; ++j) {
                CtrlUnitInfo tempCuInfo = cuCol.get(j);
                String tempID = tempCuInfo.getId().toString();
                if (hasAddCus.contains(tempID)) continue;
                addNewCus.add(tempCuInfo);
            }
            boolean exist = true;
            int index = -1;
            int n2 = shareCUs.size();
            for (int h = 0; h < n2; ++h) {
                exist = true;
                CtrlUnitInfo tempCu = shareCUs.get(h).getShareCU();
                int y = cuCols.size();
                for (int x = 0; x < y; ++x) {
                    if (tempCu.getId().equals((Object)((CtrlUnitCollection)cuCols).get(x).getId())) {
                        exist = true;
                        break;
                    }
                    exist = false;
                }
                if (cuCols.size() <= 0) {
                    exist = false;
                }
                if (exist) continue;
                delCuInfos.add(tempCu.getId().toString());
                delCus.add(new Integer(h));
            }
            if (delCus != null && delCus.size() > 0) {
                Iterator ite = delCus.iterator();
                while (ite.hasNext()) {
                    shareCUs.removeObject((Integer)ite.next());
                }
            }
            if (delCuInfos != null && delCuInfos.size() > 0) {
                this.cancelShareDocTemplate(ctx, delCuInfos, sourceTem, relatedAttache.getId().toString());
            }
            Iterator ite2 = addNewCus.iterator();
            IBoAttchAsso iboAtta = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            while (ite2.hasNext()) {
                CtrlUnitInfo addCuInfo = (CtrlUnitInfo)ite2.next();
                DocTemplateInfo tempInfo = new DocTemplateInfo();
                tempInfo.setId(null);
                tempInfo.setCU(addCuInfo);
                tempInfo.setName(this.checkNameDouble(ctx, addCuInfo, sourceTem.getName()));
                tempInfo.setType(sourceTem.getType());
                tempInfo.setDescription(sourceTem.getDescription());
                tempInfo.setState(DocTemplateEnum.ENABLE);
                tempInfo.setNewType(TemplateAddNewEnum.SHARE);
                tempInfo.setUpdated(false);
                tempInfo.setTempType(this.getTemplateType(ctx, sourceTem.getTempType(), addCuInfo));
                tempInfo.setSourceTemplate(sourceTem.getId().toString());
                tempInfo.setSourceCU(sourceTem.getCU());
                IObjectPK addPk = iDocTemplate.save((CoreBaseInfo)tempInfo);
                BoAttchAssoInfo boAttchAsso = new BoAttchAssoInfo();
                boAttchAsso.setBoID(addPk.toString());
                boAttchAsso.setAttachment(relatedAttache);
                iboAtta.addnew(boAttchAsso);
                ShareAssoCUInfo shareAssoCuInfo = new ShareAssoCUInfo();
                shareAssoCuInfo.setShareCU(addCuInfo);
                shareAssoCuInfo.setShareParent(shareInfo);
                shareCUs.add(shareAssoCuInfo);
            }
            DocTemplateAssoShareFactory.getLocalInstance(ctx).save((CoreBaseInfo)shareInfo);
        } else {
            this.addNewShare(ctx, cuCols, sourceTem);
        }
    }

    protected DocTemplateTypeInfo getTemplateType(Context ctx, DocTemplateTypeInfo billType, CtrlUnitInfo cuInfo) {
        DocTemplateTypeInfo info = null;
        try {
            IDocTemplateType iDocTemp = DocTemplateTypeFactory.getLocalInstance(ctx);
            DocTemplateTypeCollection typeCols = iDocTemp.getDocTemplateTypeCollection("select * where name ='" + billType.getName() + "' and cu.id = '" + cuInfo.getId().toString() + "'");
            if (typeCols.size() > 0) {
                info = typeCols.get(0);
            } else {
                info = new DocTemplateTypeInfo();
                info.setName(billType.getName());
                info.setCU(cuInfo);
                info.setState(DocTemplateTypeEnum.ENABLE);
                info.setDescription(billType.getDescription());
                IObjectPK tempPk = iDocTemp.addnew((CoreBaseInfo)info);
                info.setId(BOSUuid.read((String)tempPk.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)"ERROR:getTemplateType() error");
        }
        return info;
    }

    @Override
    protected void _disableDocTemplate(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        this.changeDocTempalteState(ctx, ids, DocTemplateEnum.DISABLE);
    }

    @Override
    protected void _enableDocTemplate(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return;
        }
        this.changeDocTempalteState(ctx, ids, DocTemplateEnum.ENABLE);
    }

    private void changeDocTempalteState(Context ctx, List ids, DocTemplateEnum stateEnum) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_DM_DocTemplate set FState='");
        sql.append(stateEnum.getValue()).append("'");
        sql.append(" where FState !='");
        sql.append(stateEnum.getValue()).append("'");
        sql.append(" and ( ");
        sql.append(this.getWhereExp("fid", ids));
        sql.append(" ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append(" update T_DM_DocTemplate set FState='");
        sql.append(stateEnum.getValue()).append("'");
        sql.append(" where FState !='");
        sql.append(stateEnum.getValue()).append("'");
        sql.append(" and FNewType='").append("SHARE").append("' ");
        sql.append(" and ( ");
        sql.append(this.getWhereExp("FSourceTemplate", ids));
        sql.append(" ) ");
    }

    private String getWhereExp(String mark, List ids) {
        String str = null;
        int n = ids.size();
        if (n > 0) {
            StringBuffer tempStr = new StringBuffer();
            tempStr.append(mark).append("='").append(ids.get(0)).append("' ");
            for (int i = 1; i < n; ++i) {
                tempStr.append(" or ").append(mark).append("='").append(ids.get(i)).append("' ");
            }
            str = tempStr.toString();
        }
        return str;
    }

    private void delTempalteRealtedAtta(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        HashSet<ObjectUuidPK> set = new HashSet<ObjectUuidPK>();
        for (int i = 0; i < pk.length; ++i) {
            Object tempAttacheId = null;
            String[] ids = asm.getAttachmentIDsByBoID(pk.toString());
            if (ids == null || ids.length <= 0) continue;
            set.add(new ObjectUuidPK(ids[0]));
        }
        if (set.size() > 0) {
            AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK[])((ObjectUuidPK[])set.toArray()));
        }
    }

    private void delTempalteRealtedAtta(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String tempAttacheId = null;
        String[] ids = asm.getAttachmentIDsByBoID(pk.toString());
        if (ids != null && ids.length > 0) {
            tempAttacheId = ids[0];
            AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(tempAttacheId));
        }
    }

    private AttachmentInfo getAttachByBozID(Context ctx, String pk) throws BOSException, EASBizException {
        AttachmentInfo attachInfo = null;
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachs = asm.getAttachmentIDsByBoID(pk);
        if (attachs != null && attachs.length > 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("type"));
            selector.add(new SelectorItemInfo("file"));
            selector.add(new SelectorItemInfo("size"));
            selector.add(new SelectorItemInfo("sizeInByte"));
            selector.add(new SelectorItemInfo("beizhu"));
            attachInfo = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachs[0]), selector);
        }
        return attachInfo;
    }

    private AttachmentInfo getAttachByBozID_onlyId(Context ctx, String pk) throws BOSException, EASBizException {
        AttachmentInfo attachInfo = null;
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachs = asm.getAttachmentIDsByBoID(pk);
        if (attachs != null && attachs.length > 0) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            attachInfo = AttachmentFactory.getLocalInstance((Context)ctx).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachs[0]), selector);
        }
        return attachInfo;
    }

    private DocTemplateAssoShareInfo getShareTemplate(Context ctx, String docTemplateId) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceTemplate", (Object)docTemplateId));
        filter.getFilterItems().add(new FilterItemInfo("opraType", (Object)"SHARE"));
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("opraType"));
        selector.add(new SelectorItemInfo("sourceTemplate.id"));
        selector.add(new SelectorItemInfo("share.id"));
        selector.add(new SelectorItemInfo("share.shareCU.id"));
        selector.add(new SelectorItemInfo("share.shareCU.name"));
        ev.setSelector(selector);
        try {
            DocTemplateAssoShareCollection tempCols = DocTemplateAssoShareFactory.getLocalInstance(ctx).getDocTemplateAssoShareCollection(ev);
            if (tempCols != null && tempCols.size() > 0) {
                return tempCols.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void delShare(Context ctx, IObjectCollection cuCols, DocTemplateInfo sourceTem) {
    }

    private void addNewShare(Context ctx, IObjectCollection cuCols, DocTemplateInfo sourceTem) {
        if (sourceTem == null || cuCols == null || cuCols.size() <= 0) {
            logger.info((Object)"addNewShare: cuCols is null or sourceTem is null");
            return;
        }
        try {
            IDocTemplate iDocTemplate = DocTemplateFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("tempType.id"));
            selector.add(new SelectorItemInfo("tempType.name"));
            CtrlUnitCollection cuCol = (CtrlUnitCollection)cuCols;
            AttachmentInfo sourceAttach = this.getAttachByBozID_onlyId(ctx, sourceTem.getId().toString());
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            DocTemplateAssoShareInfo tempAssoInfo = new DocTemplateAssoShareInfo();
            tempAssoInfo.setSourceTemplate(sourceTem);
            tempAssoInfo.setOpraType(TemplateAddNewEnum.SHARE);
            ShareAssoCUCollection cus = tempAssoInfo.getShare();
            IBoAttchAsso iboAtta = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            int n = cuCols.size();
            for (int i = 0; i < n; ++i) {
                CtrlUnitInfo cuInfo = cuCol.get(i);
                ShareAssoCUInfo shareAssoCuInfo = new ShareAssoCUInfo();
                shareAssoCuInfo.setShareCU(cuInfo);
                shareAssoCuInfo.setShareParent(tempAssoInfo);
                cus.add(shareAssoCuInfo);
                DocTemplateInfo tempInfo = (DocTemplateInfo)ObjectUtils.createCopy((Object)sourceTem);
                tempInfo.setName(this.checkNameDouble(ctx, cuInfo, sourceTem.getName()));
                tempInfo.setId(null);
                tempInfo.setCU(cuInfo);
                tempInfo.setState(DocTemplateEnum.ENABLE);
                tempInfo.setNewType(TemplateAddNewEnum.SHARE);
                tempInfo.setUpdated(false);
                tempInfo.setTempType(this.getTemplateType(ctx, sourceTem.getTempType(), cuInfo));
                tempInfo.setSourceTemplate(sourceTem.getId().toString());
                tempInfo.setSourceCU(sourceTem.getCU());
                IObjectPK tempPk = iDocTemplate.save((CoreBaseInfo)tempInfo);
                BoAttchAssoInfo boAttchAsso = new BoAttchAssoInfo();
                boAttchAsso.setBoID(tempPk.toString());
                boAttchAsso.setAttachment(sourceAttach);
                iboAtta.addnew(boAttchAsso);
            }
            DocTemplateAssoShareFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)tempAssoInfo);
        }
        catch (Exception e) {
            logger.info((Object)"ERROR:dispenseDocTemplate error!");
            e.printStackTrace();
        }
    }

    private String checkNameDouble(Context ctx, CtrlUnitInfo cuInfo, String templateName) throws EASBizException, BOSException {
        String newName;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)templateName));
        if (DocTemplateFactory.getLocalInstance(ctx).exists(filter)) {
            DocTemplateCollection temCols = DocTemplateFactory.getLocalInstance(ctx).getDocTemplateCollection("select name where CU.id='" + cuInfo.getId().toString() + "'");
            newName = this.createNewName(temCols, templateName);
        } else {
            newName = templateName;
        }
        return newName;
    }

    private String createNewName(DocTemplateCollection tempCols, String sourceName) {
        if (tempCols == null || tempCols.size() <= 0) {
            return sourceName;
        }
        String returnName = sourceName;
        String tempName = sourceName;
        boolean isContinue = true;
        int size = tempCols.size();
        int number = 1;
        block0: do {
            for (int i = 0; i < size; ++i) {
                if (tempName.equals(tempCols.get(i).getName())) {
                    tempName = returnName + "(" + number + ")";
                    ++number;
                    isContinue = true;
                    continue block0;
                }
                isContinue = false;
            }
        } while (isContinue);
        return tempName;
    }

    private void cancelShareDocTemplate(Context ctx, Set cuCols, DocTemplateInfo sourceInfo, String attaID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("newType", (Object)"SHARE"));
        StringBuffer cuStr = new StringBuffer();
        cuStr.append("'");
        int i = 0;
        for (String item : cuCols) {
            if (++i == cuCols.size()) {
                cuStr.append(item);
                continue;
            }
            cuStr.append(item).append("','");
        }
        cuStr.append("'");
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuStr.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("sourceTemplate", (Object)sourceInfo.getId().toString()));
        IObjectPK[] delPK = DocTemplateFactory.getLocalInstance(ctx).delete(filter);
        StringBuffer pkStr = new StringBuffer();
        pkStr.append("'");
        for (int k = 0; k < delPK.length; ++k) {
            IObjectPK pk = delPK[k];
            if (i == delPK.length) {
                pkStr.append(pk);
                continue;
            }
            pkStr.append(pk).append("','");
        }
        pkStr.append("'");
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)pkStr.toString(), CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("attachment.id", (Object)attaID));
        IBoAttchAsso iboAtta = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        iboAtta.delete(filter);
    }

    private void delAllShareTemlate(Context ctx, String sourceTemplateID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceTemplate", (Object)sourceTemplateID));
        filter.getFilterItems().add(new FilterItemInfo("newType", (Object)"SHARE"));
        IObjectPK[] pk = DocTemplateFactory.getLocalInstance(ctx).delete(filter);
        this.delTempalteRealtedAtta(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        DocTemplateCollection templateCols = DocTemplateFactory.getLocalInstance(ctx).getDocTemplateCollection("select id,name,type,tempType,description,cu.id,cu.number where sourceTemplate = '" + ((DocTemplateInfo)model).getId().toString() + "' and newType = '" + "SHARE" + "'");
        if (templateCols.size() > 0) {
            AttachmentInfo sourceAttach = this.getAttachByBozID(ctx, pk.toString());
            for (int i = 0; i < templateCols.size(); ++i) {
                DocTemplateInfo templateInfo = templateCols.get(i);
                templateInfo.setName(((DocTemplateInfo)model).getName());
                templateInfo.setType(((DocTemplateInfo)model).getType());
                templateInfo.setDescription(((DocTemplateInfo)model).getDescription());
                AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                String tempAttacheId = null;
                String[] ids = asm.getAttachmentIDsByBoID(templateInfo.getId().toString());
                if (ids != null && ids.length > 0) {
                    tempAttacheId = ids[0];
                    if (sourceAttach != null) {
                        asm.updateAttachmentContent(tempAttacheId, sourceAttach.getFile());
                    }
                }
                super._save(ctx, (IObjectValue)templateInfo);
            }
        }
        return pk;
    }
}

