/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocHistoryCollection;
import com.kingdee.eas.cp.dm.DocHistoryFactory;
import com.kingdee.eas.cp.dm.DocHistoryInfo;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.DocumentCollection;
import com.kingdee.eas.cp.dm.DocumentDistributeFactory;
import com.kingdee.eas.cp.dm.DocumentDistributeInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.DocumentLockFactory;
import com.kingdee.eas.cp.dm.ICategory;
import com.kingdee.eas.cp.dm.IDocHistory;
import com.kingdee.eas.cp.dm.IDocument;
import com.kingdee.eas.cp.dm.IDocumentDistribute;
import com.kingdee.eas.cp.dm.IDocumentLock;
import com.kingdee.eas.cp.dm.SynDocumentMarkFactory;
import com.kingdee.eas.cp.dm.app.AbstractDocumentControllerBean;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DocumentControllerBean
extends AbstractDocumentControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.DocumentControllerBean");
    private static final String TABLENAME = "t_dm_document";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String pubProcess = null;
        CategoryInfo cateInfo = this.getCategoryInfo(ctx, model);
        if (cateInfo != null) {
            pubProcess = cateInfo.getWfPubProcess();
        }
        ((DocumentInfo)model).setWfPubProcess(pubProcess);
        IObjectPK pk = null;
        if (pubProcess != null && !"".equals(pubProcess)) {
            ((DocumentInfo)model).setWfState(DocWfState.INAPPROVE);
            pk = super._submit(ctx, model);
            if (((DocumentInfo)model).isIsArchive() && cateInfo.isIsArchiveProcess() || !((DocumentInfo)model).isIsArchive()) {
                this.publishDocument(ctx, (DocumentInfo)model);
            }
        } else {
            ((DocumentInfo)model).setWfState(DocWfState.PUBLISH);
            ((DocumentInfo)model).setState(DmState.ENABLE);
            ((DocumentInfo)model).setIsHistory(false);
            BOSUuid id = ((DocumentInfo)model).getId();
            IDocument idoc = DocumentFactory.getLocalInstance(ctx);
            this.setDocumentPubState(ctx, (DocumentInfo)model);
            pk = new ObjectUuidPK(((DocumentInfo)model).getId());
        }
        return pk;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int maxIndex;
        try {
            maxIndex = DmServerService.getMaxMinIndex(ctx, TABLENAME, null, "max");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DocumentInfo dmInfo = (DocumentInfo)model;
        dmInfo.setIndex(maxIndex + 1);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)dmInfo);
        if (dmInfo.getSource() == null) {
            dmInfo.setSource(dmInfo);
            super.update(ctx, pk, (CoreBaseInfo)dmInfo);
        }
        this.createDocHistory(ctx, dmInfo);
        return pk;
    }

    private void createDocHistory(Context ctx, DocumentInfo docInfo) throws BOSException, EASBizException {
        if (docInfo.getCategory().getDocArea().getId().toString().equals("22222222-2222-2222-2222-222222222222CCE7AED4")) {
            return;
        }
        DocumentInfo sourceInfo = docInfo.getSource();
        IDocHistory iDocHistory = DocHistoryFactory.getLocalInstance(ctx);
        if (sourceInfo != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("document", (Object)sourceInfo.getId().toString()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("sourceDocument.id"));
            ev.setFilter(filter);
            ev.setSelector(selector);
            DocHistoryCollection docHisCols = iDocHistory.getDocHistoryCollection(ev);
            if (docHisCols != null && docHisCols.size() >= 1) {
                sourceInfo = docHisCols.get(0).getSourceDocument();
                if (sourceInfo == null) {
                    sourceInfo = docInfo.getSource();
                }
            } else {
                logger.info((Object)"get history error!");
            }
        }
        DocHistoryInfo docHistoryInfo = new DocHistoryInfo();
        docHistoryInfo.setDocument(docInfo);
        docHistoryInfo.setSourceDocument(sourceInfo);
        docHistoryInfo.setState(DmState.ENABLE);
        iDocHistory.addnew((CoreBaseInfo)docHistoryInfo);
    }

    @Override
    protected void _cancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)valueInfo;
        documentInfo.setState(DmState.DISABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("fid"));
        selector.add(new SelectorItemInfo("category.wfForbProcess"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)new ObjectUuidPK(documentInfo.getId().toString()), selector);
        String wfForbProcess = docInfo.getCategory().getWfForbProcess();
        if (wfForbProcess != null && !"".equals(wfForbProcess)) {
            this.wfCancel(ctx, docInfo);
        } else {
            documentInfo.setWfState(DocWfState.FORBIDDEN);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(documentInfo.getId()), (CoreBaseInfo)documentInfo);
        }
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)valueInfo;
        documentInfo.setState(DmState.ENABLE);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(documentInfo.getId()), (CoreBaseInfo)documentInfo);
    }

    @Override
    protected void _moveDown(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo info = (DocumentInfo)valueInfo;
        try {
            DmServerService.moveDown(ctx, TABLENAME, info.getIndex(), this.makeDefaultWhereExp(), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get category maxindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _moveUp(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo info = (DocumentInfo)valueInfo;
        try {
            DmServerService.moveUp(ctx, TABLENAME, info.getIndex(), this.makeDefaultWhereExp(), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get category minindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 0, pkList);
    }

    @Override
    protected void _cancelCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 1, pkList);
    }

    @Override
    protected void _borrowDocument(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _delDocument(Context ctx, IObjectPK docID) throws BOSException, EASBizException {
    }

    @Override
    protected void _publishDocument(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _wfCancel(Context ctx, IObjectValue objValue) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)objValue;
        this.update(ctx, (IObjectPK)new ObjectUuidPK(documentInfo.getId()), (CoreBaseInfo)documentInfo);
    }

    @Override
    protected void _cancel(Context ctx, String docID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("fid"));
        selector.add(new SelectorItemInfo("category.wfForbProcess"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)new ObjectUuidPK(docID), selector);
        docInfo.setState(DmState.DISABLE);
        String wfForbProcess = docInfo.getCategory().getWfForbProcess();
        if (wfForbProcess != null && !"".equals(wfForbProcess)) {
            this.wfCancel(ctx, docInfo);
        } else {
            docInfo.setWfState(DocWfState.FORBIDDEN);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
        }
    }

    @Override
    protected void _setAuditingState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setDocumentWfState(ctx, billId, DocWfState.INAPPROVE);
    }

    @Override
    protected void _setDisuseState(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("wfState"));
        selector.add(new SelectorItemInfo("source.id"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)pk, selector);
        this.setDocumentWfState(ctx, billID, DocWfState.ABANDON);
        DocumentInfo sourceInfo = docInfo.getSource();
        this.unlockDocument(ctx, docInfo.getId().toString());
    }

    @Override
    protected void _setForbidState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setDocumentWfState(ctx, billId, DocWfState.FORBIDDEN);
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bizID", (Object)billId));
            SynDocumentMarkFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (Exception e) {
            logger.info((Object)"setForbidState release docLock error!");
            e.printStackTrace();
        }
    }

    @Override
    protected void _setPubState(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.setDocumentPubState(ctx, billID);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setDocumentWfState(ctx, billId, DocWfState.DRAFT);
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setDocumentWfState(ctx, billId, DocWfState.SUBMIT);
    }

    private String makeDefaultWhereExp() {
        StringBuffer whereExp = new StringBuffer();
        whereExp.append(" fstate = ").append(1);
        return whereExp.toString();
    }

    private boolean hasPubProcess(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)valueInfo;
        CategoryInfo cateInfo = documentInfo.getCategory();
        if (cateInfo != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("wfPubProcess"));
            ICategory iCategory = CategoryFactory.getLocalInstance(ctx);
            CategoryInfo tempCategory = iCategory.getCategoryInfo((IObjectPK)new ObjectUuidPK(cateInfo.getId()), selector);
            String wfForbProcess = tempCategory.getWfPubProcess();
            return wfForbProcess != null && !"".equals(wfForbProcess);
        }
        return false;
    }

    private String getPubProcess(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)valueInfo;
        CategoryInfo cateInfo = documentInfo.getCategory();
        if (cateInfo != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("wfPubProcess"));
            selector.add(new SelectorItemInfo("isVerSet"));
            ICategory iCategory = CategoryFactory.getLocalInstance(ctx);
            CategoryInfo tempCategory = iCategory.getCategoryInfo((IObjectPK)new ObjectUuidPK(cateInfo.getId()), selector);
            return tempCategory.getWfPubProcess();
        }
        return null;
    }

    private CategoryInfo getCategoryInfo(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocumentInfo documentInfo = (DocumentInfo)valueInfo;
        CategoryInfo cateInfo = documentInfo.getCategory();
        if (cateInfo != null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("wfPubProcess"));
            selector.add(new SelectorItemInfo("isVerSet"));
            selector.add(new SelectorItemInfo("isArchive"));
            selector.add(new SelectorItemInfo("isArchiveProcess"));
            ICategory iCategory = CategoryFactory.getLocalInstance(ctx);
            CategoryInfo tempCategory = iCategory.getCategoryInfo((IObjectPK)new ObjectUuidPK(cateInfo.getId()), selector);
            return tempCategory;
        }
        return null;
    }

    private void setDocumentWfState(Context ctx, BOSUuid billID, DocWfState state) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("wfState"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)pk, selector);
        this.setDocumentWfState(ctx, docInfo, state);
    }

    private void setDocumentWfState(Context ctx, DocumentInfo docInfo, DocWfState state) throws EASBizException, BOSException {
        if (docInfo != null) {
            IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
            docInfo.setWfState(state);
            iDoc.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
        }
    }

    private void setDocumentPubState(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("wfState"));
        selector.add(new SelectorItemInfo("source.id"));
        selector.add(new SelectorItemInfo("category.id"));
        selector.add(new SelectorItemInfo("category.isVerSet"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)pk, selector);
        if (docInfo != null) {
            this.setDocumentPubState(ctx, docInfo);
        }
    }

    private void setDocumentPubState(Context ctx, DocumentInfo docInfo) throws BOSException, EASBizException {
        if (docInfo != null) {
            DocumentDistributeInfo ddInfo;
            IDocumentDistribute idd;
            docInfo.setWfState(DocWfState.PUBLISH);
            docInfo.setState(DmState.ENABLE);
            docInfo.setIsHistory(false);
            docInfo.setIssueTime(this.getTime());
            IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
            BOSUuid id = docInfo.getId();
            IDocument idoc = DocumentFactory.getLocalInstance(ctx);
            if (id == null || !idoc.exists((IObjectPK)new ObjectUuidPK(id))) {
                idoc.addnew((CoreBaseInfo)docInfo);
            } else {
                iDoc.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
            }
            DocumentInfo sourceInfo = docInfo.getSource();
            this.unlockDocument(ctx, docInfo.getId().toString());
            boolean isFromPersonDoc = false;
            if (docInfo.getWfState().equals((Object)DocWfState.PUBLISH) && (idd = DocumentDistributeFactory.getLocalInstance(ctx)).exists("select id,distributeCount where distributeDoc.id = '" + docInfo.getId().toString() + "'") && (ddInfo = idd.getDocumentDistributeInfo("select id,distributeCount where distributeDoc.id = '" + docInfo.getId().toString() + "'")) != null) {
                ddInfo.setDistributeCount(ddInfo.getDistributeCount() + 1);
                idd.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), ddInfo);
                isFromPersonDoc = true;
            }
            if (!isFromPersonDoc) {
                this.setHistoryDocumentState(ctx, docInfo);
            }
        }
    }

    private void setHistoryDocumentState(Context ctx, DocumentInfo docInfo) throws BOSException, EASBizException {
        IDocHistory iDH = DocHistoryFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("sourceDocument.id"));
        selector.add(new SelectorItemInfo("sourceDocument.wfState"));
        selector.add(new SelectorItemInfo("sourceDocument.state"));
        selector.add(new SelectorItemInfo("sourceDocument.isHistory"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("document.id", (Object)docInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("sourceDocument.id", (Object)docInfo.getId().toString(), CompareType.NOTEQUALS));
        ev.setFilter(filter);
        ev.setSelector(selector);
        DocHistoryCollection hCols = iDH.getDocHistoryCollection(ev);
        if (hCols != null && hCols.size() > 0) {
            SelectorItemCollection updateSelector1 = new SelectorItemCollection();
            updateSelector1.add(new SelectorItemInfo("isHistory"));
            SelectorItemCollection updateSelector2 = new SelectorItemCollection();
            updateSelector2.add(new SelectorItemInfo("isHistory"));
            updateSelector2.add(new SelectorItemInfo("state"));
            IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
            DocHistoryInfo hInfo = hCols.get(0);
            DocumentInfo sourceDoc = hInfo.getSourceDocument();
            CategoryInfo cateInfo = docInfo.getCategory();
            if (DmState.ENABLE.equals((Object)sourceDoc.getState()) && !sourceDoc.isIsHistory()) {
                if (cateInfo.isIsVerSet()) {
                    sourceDoc.setIsHistory(true);
                    iDoc.updatePartial((CoreBaseInfo)sourceDoc, updateSelector1);
                } else {
                    sourceDoc.setState(DmState.DELETE);
                    sourceDoc.setIsHistory(true);
                    iDoc.updatePartial((CoreBaseInfo)sourceDoc, updateSelector2);
                }
            } else {
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(1)));
                filter.getFilterItems().add(new FilterItemInfo("sourceDocument.id", (Object)sourceDoc.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("document.state", (Object)DmState.ENABLE));
                filter.getFilterItems().add(new FilterItemInfo("document.id", (Object)docInfo.getId().toString(), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("document.isHistory", (Object)Boolean.FALSE));
                filter.getFilterItems().add(new FilterItemInfo("document.wfstate", (Object)DocWfState.PUBLISH));
                filter.getFilterItems().add(new FilterItemInfo("document.wfstate", (Object)DocWfState.FORBIDDEN));
                filter.setMaskString(" ( #0 and #1 and #2 and #3 and #4 and ( #5 or #6 ))");
                ev.setFilter(filter);
                DocHistoryCollection tempCols = iDH.getDocHistoryCollection(ev);
                if (tempCols != null) {
                    int n = tempCols.size();
                    for (int i = 0; i < n; ++i) {
                        DocHistoryInfo tempInfo = tempCols.get(i);
                        DocumentInfo tempDocument = tempInfo.getDocument();
                        if (cateInfo.isIsVerSet()) {
                            tempDocument.setIsHistory(true);
                            iDoc.updatePartial((CoreBaseInfo)tempDocument, updateSelector1);
                            continue;
                        }
                        tempDocument.setState(DmState.DELETE);
                        tempDocument.setIsHistory(true);
                        iDoc.updatePartial((CoreBaseInfo)tempDocument, updateSelector2);
                    }
                }
            }
        }
    }

    private DocumentInfo getShowDocument(Context ctx, String sourceId) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceId));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)sourceId));
        filter.getFilterItems().add(new FilterItemInfo("wfState", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)Boolean.FALSE));
        filter.setMaskString(" ( #0 or #1 )and #2 and #3 ");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isHistory"));
        ev.setFilter(filter);
        ev.setSelector(selector);
        DocumentCollection docCols = DocumentFactory.getLocalInstance(ctx).getDocumentCollection(ev);
        if (docCols == null) {
            return null;
        }
        int size = docCols.size();
        if (size <= 0) {
            logger.info((Object)"[In the getShowDocument]: not find source document ");
            return null;
        }
        if (size == 1) {
            return docCols.get(0);
        }
        logger.info((Object)"[In the getShowDocument]: find more source documents, select one ");
        return docCols.get(0);
    }

    private void unlockDocument(Context ctx, String lockDocId) {
        try {
            IDocumentLock idocLock = DocumentLockFactory.getLocalInstance(ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("currentDocID", (Object)lockDocId));
            idocLock.delete(filter);
        }
        catch (Exception e) {
            logger.info((Object)("unlock document error " + e));
        }
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected IObjectPK _dmSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ((DocumentInfo)model).setWfState(DocWfState.PUBLISH);
        ((DocumentInfo)model).setState(DmState.ENABLE);
        ((DocumentInfo)model).setIsHistory(false);
        BOSUuid id = ((DocumentInfo)model).getId();
        IDocument idoc = DocumentFactory.getLocalInstance(ctx);
        this.setDocumentPubState(ctx, (DocumentInfo)model);
        return new ObjectUuidPK(((DocumentInfo)model).getId());
    }

    protected List documentCheck(DocumentInfo docInfo) {
        ArrayList<String> checkResult = new ArrayList<String>();
        if (null == docInfo.getTitle() || "".equals(docInfo.getTitle())) {
            checkResult.add("\u6807\u9898\u4e3a\u7a7a!");
        }
        if (null != docInfo.getTitle() && 128 < docInfo.getTitle().length()) {
            checkResult.add("\u6807\u9898\u957f\u5ea6\u8d85\u8fc7128!");
        }
        if (null == docInfo.getNumber() || "".equals(docInfo.getNumber())) {
            checkResult.add("\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        if (null != docInfo.getNumber() && 44 < docInfo.getNumber().length()) {
            checkResult.add("\u7f16\u53f7\u957f\u5ea6\u8d85\u8fc744!");
        }
        if (docInfo.getDocMarkNumber() != null && 44 < docInfo.getDocMarkNumber().length()) {
            checkResult.add("\u6587\u53f7\u957f\u5ea6\u8d85\u8fc744!");
        }
        if (docInfo.getTag() != null && docInfo.getTag().length() > 128) {
            checkResult.add("\u6807\u7b7e\u957f\u5ea6\u8d85\u8fc7128\uff01");
        }
        if (docInfo.getSummary() != null && 400 < docInfo.getSummary().length()) {
            checkResult.add("\u6458\u8981\u957f\u5ea6\u8d85\u8fc7400!");
        }
        return checkResult;
    }
}

