/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.archive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.ContentTypeEnum;
import com.kingdee.eas.cp.dm.DMArchiveException;
import java.io.Serializable;
import java.sql.Timestamp;

public class ArchiveDocumentParamsInfo
implements Serializable {
    private String number;
    private String docNumber;
    private String title;
    private String categoryId;
    private String version;
    private PersonInfo author;
    private String mark;
    private Timestamp createTime;
    private String description;
    private String moduleName;
    private String tag;
    private boolean isArchive;
    private String bizID;
    private ContentTypeEnum contentType;
    private String summary;
    private boolean canCopy = true;

    public boolean valid(Context ctx) throws EASBizException, BOSException {
        if (this.getCategoryId() == null) {
            throw new DMArchiveException(DMArchiveException.CATEGORY_ID_NULL);
        }
        if (!this.categoryExist(ctx, this.getCategoryId())) {
            throw new DMArchiveException(DMArchiveException.CATEGORY_PATH_NOT_EXIST);
        }
        if (this.getTitle() == null) {
            throw new DMArchiveException(DMArchiveException.SOURCEDOC_NAME_NULL);
        }
        if (this.getContentType() == null) {
            throw new DMArchiveException(DMArchiveException.CONTENT_TYPE_NULL);
        }
        return true;
    }

    private boolean categoryExist(Context ctx, String categoryId) throws EASBizException, BOSException {
        return CategoryFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(categoryId));
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getDocNumber() {
        return this.docNumber;
    }

    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public PersonInfo getAuthor() {
        return this.author;
    }

    public void setAuthor(PersonInfo author) {
        this.author = author;
    }

    public String getMark() {
        return this.mark;
    }

    public void setMark(String mark) {
        this.mark = mark;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public boolean isArchive() {
        return this.isArchive;
    }

    public void setArchive(boolean isArchive) {
        this.isArchive = isArchive;
    }

    public String getBizID() {
        return this.bizID;
    }

    public void setBizID(String bizID) {
        this.bizID = bizID;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean isCanCopy() {
        return this.canCopy;
    }

    public void setCanCopy(boolean canCopy) {
        this.canCopy = canCopy;
    }
}

