/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.archive;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.base.attachment.AttachmentException;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentFtpFacade;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentFtpInfo;
import com.kingdee.eas.base.attachment.ftp.AttachmentUploadClient;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.attachment.util.VariousAttachmentInfoMaker;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.archive.AttacheInterface;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class AttachHandleHttp
implements AttacheInterface {
    Logger logger = Logger.getLogger(this.getClass());

    public String saveAttach(Context ctx, String fileName, String bizId, InputStream stream) throws EASBizException, BOSException, Exception {
        return this.addNewAttachment(ctx, fileName, bizId, stream);
    }

    public String saveAttach(Context ctx, String fileName, String bizId, OutputStream stream) throws EASBizException, BOSException, Exception {
        return this.addNewAttachment(ctx, fileName, bizId, stream);
    }

    private String addNewAttachment(Context ctx, String filename, String bizId, InputStream stream) throws BOSException, EASBizException, Exception {
        SimpleAttachmentInfo sai = this.getSimpleFile(filename, stream);
        return this.addNewAttachment(ctx, bizId, sai);
    }

    private String addNewAttachment(Context ctx, String filename, String bizId, OutputStream stream) throws BOSException, EASBizException, Exception {
        SimpleAttachmentInfo sai = this.getSimpleFile(filename, stream);
        return this.addNewAttachment(ctx, bizId, sai);
    }

    private String addNewAttachment(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
        AttachmentInfo attachmentInfo = VariousAttachmentInfoMaker.makeAppAttachmentInfo((Context)ctx, (IAttachment)iAttachment, (String)boID, (SimpleAttachmentInfo)sai);
        return this.submitAttachment(ctx, iAttachment, attachmentInfo);
    }

    private String submitAttachment(Context ctx, IAttachment iAttachment, AttachmentInfo attachmentInfo) throws BOSException, EASBizException {
        byte[] fileInfo;
        String attchID = "";
        this.logger.info((Object)"AttachHandleHttp::submitAttachment()------11------is invoke!");
        System.out.println("AttachHandleHttp::submitAttachment()----33------is invoke!");
        if (null != attachmentInfo && null == attachmentInfo.getFile()) {
            try {
                byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachmentInfo.getId().toString());
                attachmentInfo.setFile(files);
                this.logger.info((Object)"AttachHandleHttp::submitAttachment()------11------downLoad invoke is ok!");
                System.out.println("AttachHandleHttp::submitAttachment()----33------downLoad invoke is ok!");
            }
            catch (BOSException e) {
                this.logger.error((Object)("AttachHandleHttp::submitAttachment()---downLoad attachmentInfo ,the id = " + attachmentInfo.getId().toString() + " , is fail: "), (Throwable)e);
                e.printStackTrace();
            }
            catch (EASBizException e) {
                this.logger.error((Object)("AttachHandleHttp::submitAttachment()---downLoad attachmentInfo ,the id = " + attachmentInfo.getId().toString() + " , is fail: "), (Throwable)e);
                e.printStackTrace();
            }
        }
        if ((fileInfo = attachmentInfo.getFile()) != null && fileInfo.length > AttachmentFtpInfo.MAX_OF_UPLOAD_LENGTH) {
            this.logger.info((Object)" begin mutl part file upload");
            attachmentInfo.setFile(null);
            attchID = iAttachment.addnew(attachmentInfo).toString();
            try {
                IAttachmentFtpFacade iAttachmentFtpFacade = AttachmentFtpFacadeFactory.getLocalInstance((Context)ctx);
                AttachmentUploadClient fileUpload = new AttachmentUploadClient(iAttachmentFtpFacade);
                fileUpload.uploadFile(attchID, fileInfo);
                this.logger.info((Object)"AttachHandleHttp::submitAttachment()------11------fileUpload.uploadFile invoke is ok!");
                System.out.println("AttachHandleHttp::submitAttachment()----33------fileUpload.uploadFile invoke is ok!");
            }
            catch (BOSException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.error((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.error((Object)"upload file fail:", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                iAttachment.delete((IObjectPK)new ObjectStringPK(attchID));
                this.logger.info((Object)"upload file fail:", (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
        this.logger.info((Object)"AttachHandleHttp::submitAttachment()------11------fileUpload.uploadFile invoke is ok!");
        System.out.println("AttachHandleHttp::submitAttachment()----33------fileUpload.uploadFile invoke is ok!");
        try {
            attchID = iAttachment.addnew(attachmentInfo).toString();
        }
        catch (BOSException e) {
            this.logger.error((Object)"AttachHandleHttp::submitAttachment()-------22----BOSException---iAttachment.addnew(is failed!");
            System.out.println("AttachHandleHttp::submitAttachment()----33----BOSException--iAttachment.addnew(is failed!");
            throw e;
        }
        catch (EASBizException e) {
            this.logger.error((Object)"AttachHandleHttp::submitAttachment()-------22---EASBizException----iAttachment.addnew(is failed!");
            System.out.println("AttachHandleHttp::submitAttachment()----33---EASBizException---iAttachment.addnew(is failed!");
            throw e;
        }
        catch (Exception e) {
            this.logger.error((Object)"AttachHandleHttp::submitAttachment()-------22----Exception---iAttachment.addnew(is failed!");
            System.out.println("AttachHandleHttp::submitAttachment()----33--Exception----iAttachment.addnew(is failed!");
            throw new BOSException(e.getMessage());
        }
        return attchID;
    }

    private SimpleAttachmentInfo getSimpleFile(String filename, InputStream stream) throws BOSException, EASBizException {
        try {
            String fullname = filename;
            String mainname = StringUtil4File.getMainFileName((String)fullname);
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            byte[] content = AttachHandleHttp.getBytesFromFile(stream);
            SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
            sai.setMainName(mainname);
            sai.setExtName(extname);
            sai.setContent(content);
            sai.setIsShared(false);
            return sai;
        }
        catch (Exception fe) {
            fe.printStackTrace();
            throw new AttachmentException(AttachmentException.READFILEERROR);
        }
    }

    private SimpleAttachmentInfo getSimpleFile(String filename, OutputStream stream) throws BOSException, EASBizException {
        try {
            String fullname = filename;
            String mainname = StringUtil4File.getMainFileName((String)fullname);
            String extname = StringUtil4File.getExtendedFileName((String)fullname);
            byte[] content = AttachHandleHttp.getBytesFromFile(stream);
            SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
            sai.setMainName(mainname);
            sai.setExtName(extname);
            sai.setContent(content);
            sai.setIsShared(false);
            return sai;
        }
        catch (Exception fe) {
            fe.printStackTrace();
            throw new AttachmentException(AttachmentException.READFILEERROR);
        }
    }

    private static byte[] getBytesFromFile(OutputStream stream) throws Exception {
        byte[] data = null;
        data = stream instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)stream).toByteArray() : stream.toString().getBytes();
        return data;
    }

    private static byte[] getBytesFromFile(InputStream stream) throws Exception {
        int ch;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        while ((ch = stream.read()) != -1) {
            bytestream.write(ch);
        }
        byte[] imgdata = bytestream.toByteArray();
        bytestream.close();
        return imgdata;
    }

    @Override
    public ServiceResult saveAttach(Context ctx, InputStream[] fileStreams, String[] fileNames, String bizId, FMEParameter fmeParameter) {
        return null;
    }
}

