/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.AbstractCategoryInfo;
import com.kingdee.eas.cp.dm.AbstractDocumentInfo;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DmPermissionUtil {
    public static final String T_DM_CATEGORY = "t_dm_category";
    public static final String T_DM_DIMENSION = "t_dm_dimension";
    public static final String T_DM_DOCAREA = "t_dm_docarea";
    public static final String T_DM_DOCUMENT = "t_dm_document";

    public static String map2SqlInExp(Map dataMap) {
        StringBuffer perId = new StringBuffer();
        String rtnVal = perId.toString();
        if (rtnVal.length() > 0) {
            rtnVal = rtnVal.substring(0, perId.length() - 1);
        }
        return rtnVal;
    }

    public static String combinationPerm(String perm1, String perm2) {
        if (StringUtils.isEmpty((String)perm1)) {
            return perm2;
        }
        if (StringUtils.isEmpty((String)perm2)) {
            return perm1;
        }
        String[] perm1Array = perm1.split(",");
        String[] perm2Array = perm2.split(",");
        HashSet<String> set = new HashSet<String>(Arrays.asList(perm1Array));
        int len = perm2Array.length;
        for (int i = 0; i < len; ++i) {
            if (set.contains(perm2Array[i])) continue;
            set.add(perm2Array[i]);
        }
        Object[] obj = set.toArray();
        StringBuffer sb = new StringBuffer();
        int n = obj.length;
        for (int m = 0; m < n; ++m) {
            sb.append(obj[m].toString()).append(",");
        }
        return sb.toString();
    }

    public static String combinationAdminPerm(String perm1, String perm2) {
        if (StringUtils.isEmpty((String)perm1)) {
            return perm2;
        }
        if (StringUtils.isEmpty((String)perm2)) {
            return perm1;
        }
        String[] perm1Array = perm1.split(",");
        String[] perm2Array = perm2.split(",");
        HashSet<String> diffSet = new HashSet<String>();
        HashSet<String> set1 = new HashSet<String>(Arrays.asList(perm2Array));
        int len = perm2Array.length;
        for (int i = 0; i < len; ++i) {
            if (set1.contains(perm2Array[i])) continue;
            diffSet.add(perm2Array[i]);
        }
        HashSet<String> set2 = new HashSet<String>(Arrays.asList(perm1Array));
        int len2 = perm2Array.length;
        for (int i = 0; i < len2; ++i) {
            if (set2.contains(perm2Array[i])) continue;
            diffSet.add(perm2Array[i]);
        }
        Object[] obj = diffSet.toArray();
        StringBuffer diff = new StringBuffer();
        int n = obj.length;
        for (int m = 0; m < n; ++m) {
            diff.append(obj[m].toString()).append(",");
        }
        return diff.toString();
    }

    public static void setPermissionDataByDocument(String docId, Map perDataMap, Map adminDataMap, Map roleDataMap) {
    }

    public static boolean hasBizPermission(Context ctx, String bizId, String permissionItem) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String bizTableName = "T_DM_CATEGORY";
        Map permssionMap = DmPermissionUtil.getBizPermMap(ctx, perId, userId, bizId, bizTableName);
        Set perssionSet = null;
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = (Set)permssionMap.get(perId + bizId);
        }
        return perssionSet.contains(permissionItem);
    }

    public static Map getBizPermMap(Context ctx, String perId, String userId, String bizId, String bizTableName) {
        HashMap bizPermMap = new HashMap();
        HashSet permSet = new HashSet();
        bizTableName = bizTableName.toLowerCase();
        DmPermissionUtil.getBizPermMapAdmin(ctx, perId, userId, bizId, bizTableName, permSet);
        DmPermissionUtil.getBizPermMapPerson(ctx, perId, userId, bizId, bizTableName, permSet);
        DmPermissionUtil.getBizPermMapRole(ctx, perId, userId, bizId, bizTableName, permSet);
        bizPermMap.put(perId + bizId, permSet);
        return bizPermMap;
    }

    public static Set getBizPermMapAdmin(Context ctx, String perId, String userId, String bizId, String bizTableName, Set permSet) {
        Date a = new Date();
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            DocAreaInfo curInfo;
            Serializable model;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            if (T_DM_CATEGORY.equals(bizTableName)) {
                sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
                model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                curInfo = ((AbstractCategoryInfo)model).getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            } else if (T_DM_DOCAREA.equals(bizTableName)) {
                sic.add(new SelectorItemInfo("CUEntry.includeSub"));
                DocAreaInfo curInfo2 = (DocAreaInfo)DocAreaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                containCU = curInfo2.getCUEntry().get(0) != null ? curInfo2.getCUEntry().get(0).isIncludeSub() : false;
            } else {
                sic.add(new SelectorItemInfo("category.docArea.CUEntry.includeSub"));
                model = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                curInfo = ((AbstractDocumentInfo)model).getCategory().getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DmPermissionUtil.convertLongNumber2Condition(DmPermissionUtil.getAdminLongNumberByPersonID(ctx, perId));
        HashSet<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select  bizadmin.FPermList as personList  from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        if (T_DM_DIMENSION.equals(bizTableName)) {
            selectSql.append("adminorg bizadmin on bizadmin.fparentid = biz.fid \n");
            selectSql.append(" where  bizadmin.fadminorgid  \n");
        } else {
            selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        }
        if (T_DM_CATEGORY.equals(bizTableName) || T_DM_DOCUMENT.equals(bizTableName)) {
            selectSql.append(" where 1=1 ");
            if (T_DM_DOCUMENT.equals(bizTableName)) {
                selectSql.append(" and biz.fisEnablePerm = 1 \n");
            }
            selectSql.append("and (exists (  ");
            selectSql.append("SELECT  subADMIN.FID  ");
            selectSql.append("FROM T_BD_Person AS PERSON   ");
            selectSql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
            selectSql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
            selectSql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
            selectSql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
            selectSql.append("where PERSON.fid = '").append(perId).append("'  ");
            selectSql.append("and subADMIN.fid = bizadmin.FAdminID)  ");
            selectSql.append("or ( bizadmin.FIncludeSub = 1 and exists ( ");
            selectSql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = bizadmin.FAdminID ");
            if (!containCU) {
                selectSql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
            }
            selectSql.append("and fnumber in (").append(adminNum).append(") ");
            selectSql.append("))) ");
            selectSql.append("    AND biz.FID = '");
            selectSql.append(bizId);
            selectSql.append("'  \n");
            selectSql.append("\t  \n");
        } else {
            selectSql.append(" where  bizadmin.fadminid  \n");
            selectSql.append("\t\tin( \n");
            selectSql.append("\t\t\tSELECT  ADMIN.FID \n");
            selectSql.append("\t\t\tFROM T_BD_Person AS PERSON  \n");
            selectSql.append("\t\t\tINNER JOIN T_HR_PersonPosition AS PP  \n");
            selectSql.append("\t\t\tON PERSON.FID = PP.FPersonID  \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_PositionMember AS PM  \n");
            selectSql.append("\t\t\tON PERSON.FID = PM.FPersonID  \n");
            selectSql.append("\t\t\tINNER JOIN T_PM_USER AS PMUSER \n");
            selectSql.append("\t\t\tON PMUSER.FPERSONID = PERSON.FID \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_Position AS POSITION  \n");
            selectSql.append("\t\t\tON PM.FPositionID = POSITION.FID  \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_Admin AS ADMIN  \n");
            selectSql.append("\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
            selectSql.append(userId);
            selectSql.append("' \n");
            selectSql.append("\t\t)  \n");
            selectSql.append(" and biz.fid='" + bizId + "'");
        }
        Date b = new Date();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("personList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            return rtnSet;
        }
        catch (SQLException e) {
            return rtnSet;
        }
        Date c = new Date();
        return rtnSet;
    }

    public static Set getBizPermMapPerson(Context ctx, String perId, String userId, String bizId, String bizTableName, Set permSet) {
        HashSet<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select bizperson.FPermList as adminList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("'\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("adminList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            return rtnSet;
        }
        catch (SQLException e) {
            return rtnSet;
        }
        return rtnSet;
    }

    public static Set getBizPermMapRole(Context ctx, String perId, String userId, String bizId, String bizTableName, Set permSet) {
        HashSet<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select  bizrole.FPermList as roleList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("\t\t bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1 ");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("roleList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            return rtnSet;
        }
        catch (SQLException e) {
            return rtnSet;
        }
        return rtnSet;
    }

    private static String getAdminLongNumberByPersonID(Context ctx, String personId) {
        String result = "";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  subADMIN.FLongNumber as longnumber  FROM T_BD_Person AS PERSON ");
        sql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        sql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        sql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        sql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID ");
        sql.append("where PERSON.fid = '").append(personId).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                result = rs.getString("longnumber");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String convertLongNumber2Condition(String longNumber) {
        StringBuffer adminNum = new StringBuffer();
        if (longNumber != null && !"".equals(longNumber)) {
            String[] nums = StringUtils.split((String)longNumber, (String)"!");
            for (int i = 0; i < nums.length; ++i) {
                adminNum.append("'" + nums[i] + "',");
            }
            String rtnVal = adminNum.toString();
            if (rtnVal.length() > 0) {
                rtnVal = rtnVal.substring(0, adminNum.length() - 1);
            }
            return rtnVal;
        }
        return "''";
    }
}

