/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.SmartFileFacadeFactory;
import com.kingdee.eas.cp.dm.web.SmartUpload;
import com.kingdee.eas.cp.dm.web.SmartUploadException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.ServletException;

public class SmartFile {
    private SmartUpload mParent;
    private int mStartData = 0;
    private int mEndData = 0;
    private int mSize = 0;
    private String mFieldname = "";
    private String mFilename = "";
    private String mFileExt = "";
    private String mFilePathName = "";
    private String mContentType = "";
    private String mContentDisp = "";
    private String mTypeMime = "";
    private String mSubTypeMime = "";
    private boolean mIsMissing = true;
    public static final int SAVEAS_AUTO = 0;
    public static final int SAVEAS_VIRTUAL = 1;
    public static final int SAVEAS_PHYSICAL = 2;

    public void saveAs(String s) throws IOException, SmartUploadException {
        this.saveAs(s, 0);
    }

    public void saveAs(String s, int i) throws IOException, SmartUploadException {
        String s1 = "";
        s1 = this.mParent.getPhysicalPath(s, i);
        if (s1 == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        try {
            File file = new File(s1);
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            fileoutputstream.write(this.mParent.mBinArray, this.mStartData, this.mSize);
            fileoutputstream.close();
        }
        catch (IOException ioexception) {
            throw new SmartUploadException("File can't be saved (1120).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveMhtTODB(Context ctx, String uuid) throws IOException, SmartUploadException {
        boolean result = true;
        Connection con = null;
        Statement ps = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(this.mParent.mBinArray, this.mStartData, this.mSize);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            String sql = "Insert into T_DM_DocumentContent(FContent,FID) values(?,?)";
            if (this.isExistsContent(ctx, uuid)) {
                sql = "update T_DM_DocumentContent set FContent = ? where FID = ?";
            }
            Object[] params = new Object[]{is, uuid};
            SmartFileFacadeFactory.getLocalInstance(ctx).saveMhtTODB(sql, params);
            ((InputStream)is).close();
            os.close();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {}
            }
        }
        return result;
    }

    public void saveTODB(Context ctx, String uuid) throws IOException, SmartUploadException {
        this.saveTODB(ctx, uuid, null);
    }

    public boolean saveTODB(Context ctx, String uuid, String contentType, byte[] fileBody) throws IOException, SmartUploadException {
        boolean result = true;
        if (contentType != null && !"".equals(contentType)) {
            try {
                String sql = "update T_DM_Document set FContentType = ? where FID = ?";
                Object[] params = new Object[]{contentType, uuid};
                SmartFileFacadeFactory.getLocalInstance(ctx).saveTODB(sql, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (fileBody == null) {
                os.write(this.mParent.mBinArray, this.mStartData, this.mSize);
            } else {
                os.write(fileBody);
            }
            String tempAttacheId = null;
            String[] ids = asm.getAttachmentIDsByBoID(uuid);
            if (ids != null && ids.length > 0) {
                tempAttacheId = ids[0];
            }
            if (tempAttacheId != null) {
                IAttachment attach = AttachmentFactory.getLocalInstance((Context)ctx);
                AttachmentInfo attachInfo = attach.getAttachmentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAttacheId)));
                if ("2".equals(contentType)) {
                    attachInfo.setName("DMdocBody_word");
                    attachInfo.setSimpleName("DMdocBody_word");
                    attachInfo.setType(".doc");
                } else {
                    attachInfo.setName("DMdocBody_excel");
                    attachInfo.setSimpleName("DMdocBody_excel");
                    attachInfo.setType(".excel");
                }
                attach.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAttacheId)), attachInfo);
                asm.updateAttachmentContent(tempAttacheId, os.toByteArray());
            } else {
                SimpleAttachmentInfo info = new SimpleAttachmentInfo();
                info.setContent(os.toByteArray());
                info.setMainName("DMdocBody_" + uuid.replaceAll("/", "ll"));
                info.setExtName("b");
                asm.addNewAttachment(ctx, uuid, info);
            }
        }
        catch (EASBizException e) {
            result = false;
            e.printStackTrace();
        }
        catch (BOSException e) {
            result = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    public boolean saveTODB(Context ctx, String uuid, String contentType) throws IOException, SmartUploadException {
        return this.saveTODB(ctx, uuid, contentType, null);
    }

    public boolean save2FtpServer(Context ctx, String businessID, String documentId, byte[] fileBody) {
        IFMEService fmeService = FMEServiceFactory.getServiceInstance((Context)ctx);
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(fileBody));
        ServiceResult sr = fmeService.updateFile(ctx, (InputStream)is, businessID, documentId);
        return sr.isResult();
    }

    public boolean save2FtpServer(Context ctx, String businessID, String documentId) {
        IFMEService fmeService = FMEServiceFactory.getServiceInstance((Context)ctx);
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(this.mParent.mBinArray, this.mStartData, this.mSize));
        ServiceResult sr = fmeService.updateFile(ctx, (InputStream)is, businessID, documentId);
        return sr.isResult();
    }

    public boolean save2FtpServer(Context ctx, String businessID, String documentId, String ntkoSaveMethod) {
        IFMEService fmeService = FMEServiceFactory.getServiceInstance((Context)ctx);
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(this.mParent.mBinArray, this.mStartData, this.mSize));
        ServiceResult sr = fmeService.updateFile(ctx, (InputStream)is, businessID, documentId, this.mSize, ntkoSaveMethod);
        return sr.isResult();
    }

    private boolean isExistsContent(Context ctx, String FID) {
        String sql = "select FID from T_DM_DocumentContent where FID = '" + FID + "' ";
        boolean result = false;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void deleteDocExchange(Context ctx, String FID) {
        String sql = "delete T_DM_DocumentContent where fid = '" + FID + "' ";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fileToField(ResultSet resultset, String s) throws ServletException, IOException, SmartUploadException, SQLException {
        long l = 0L;
        int i = 65536;
        int j = 0;
        int k = this.mStartData;
        if (resultset == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1145).");
        }
        if (s == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1150).");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1155).");
        }
        l = BigInteger.valueOf(this.mSize).divide(BigInteger.valueOf(i)).longValue();
        j = BigInteger.valueOf(this.mSize).mod(BigInteger.valueOf(i)).intValue();
        try {
            int i1 = 1;
            while ((long)i1 < l) {
                resultset.updateBinaryStream(s, (InputStream)new ByteArrayInputStream(this.mParent.mBinArray, k, i), i);
                k = k != 0 ? k : 1;
                k = i1 * i + this.mStartData;
                ++i1;
            }
            if (j > 0) {
                resultset.updateBinaryStream(s, (InputStream)new ByteArrayInputStream(this.mParent.mBinArray, k, j), j);
            }
        }
        catch (SQLException sqlexception) {
            byte[] abyte0 = new byte[this.mSize];
            System.arraycopy(this.mParent.mBinArray, this.mStartData, abyte0, 0, this.mSize);
            resultset.updateBytes(s, abyte0);
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file in the DataBase (1130).");
        }
    }

    public boolean isMissing() {
        return this.mIsMissing;
    }

    public String getFieldName() {
        return this.mFieldname;
    }

    public String getFileName() {
        return this.mFilename;
    }

    public String getFilePathName() {
        return this.mFilePathName;
    }

    public String getFileExt() {
        return this.mFileExt;
    }

    public String getContentType() {
        return this.mContentType;
    }

    public String getContentDisp() {
        return this.mContentDisp;
    }

    public String getContentString() {
        String s = new String(this.mParent.mBinArray, this.mStartData, this.mSize);
        return s;
    }

    public String getTypeMIME() throws IOException {
        return this.mTypeMime;
    }

    public String getSubTypeMIME() {
        return this.mSubTypeMime;
    }

    public int getSize() {
        return this.mSize;
    }

    protected int getStartData() {
        return this.mStartData;
    }

    protected int getEndData() {
        return this.mEndData;
    }

    protected void setParent(SmartUpload smartupload) {
        this.mParent = smartupload;
    }

    protected void setStartData(int i) {
        this.mStartData = i;
    }

    protected void setEndData(int i) {
        this.mEndData = i;
    }

    protected void setSize(int i) {
        this.mSize = i;
    }

    protected void setIsMissing(boolean flag) {
        this.mIsMissing = flag;
    }

    protected void setFieldName(String s) {
        this.mFieldname = s;
    }

    protected void setFileName(String s) {
        this.mFilename = s;
    }

    protected void setFilePathName(String s) {
        this.mFilePathName = s;
    }

    protected void setFileExt(String s) {
        this.mFileExt = s;
    }

    protected void setContentType(String s) {
        this.mContentType = s;
    }

    protected void setContentDisp(String s) {
        this.mContentDisp = s;
    }

    protected void setTypeMIME(String s) {
        this.mTypeMime = s;
    }

    protected void setSubTypeMIME(String s) {
        this.mSubTypeMime = s;
    }

    public byte getBinaryData(int i) {
        if (this.mStartData + i > this.mEndData) {
            throw new ArrayIndexOutOfBoundsException("Index Out of range (1115).");
        }
        if (this.mStartData + i <= this.mEndData) {
            return this.mParent.mBinArray[this.mStartData + i];
        }
        return 0;
    }
}

