/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.dm.CategoryAdminCollection;
import com.kingdee.eas.cp.dm.CategoryAdminInfo;
import com.kingdee.eas.cp.dm.CategoryCollection;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.CategoryPersonCollection;
import com.kingdee.eas.cp.dm.CategoryPersonInfo;
import com.kingdee.eas.cp.dm.CategoryRoleCollection;
import com.kingdee.eas.cp.dm.CategoryRoleInfo;
import com.kingdee.eas.cp.dm.DocAreaAdminNewCollection;
import com.kingdee.eas.cp.dm.DocAreaAdminNewInfo;
import com.kingdee.eas.cp.dm.DocAreaNewFactory;
import com.kingdee.eas.cp.dm.DocAreaNewInfo;
import com.kingdee.eas.cp.dm.DocAreaPersonNewCollection;
import com.kingdee.eas.cp.dm.DocAreaPersonNewInfo;
import com.kingdee.eas.cp.dm.DocAreaRoleNewCollection;
import com.kingdee.eas.cp.dm.DocAreaRoleNewInfo;
import com.kingdee.eas.cp.dm.PermSourceEnum;
import com.kingdee.eas.cp.dm.web.service.DmPermissionServiceNewHelper;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnifyPermissionHelper {
    public void setPermissionDataByArea(DocAreaNewInfo docAreaNewInfo, Map<String, String> perDataMap, Map<String, String> adminDataMap, Map<String, String> roleDataMap, Map<String, String> includeSubMap) {
        Object tempMap = null;
        DocAreaAdminNewCollection daAdminColl = docAreaNewInfo.getAdmin();
        int size = daAdminColl.size();
        for (int i = 0; i < size; ++i) {
            DocAreaAdminNewInfo docAreaAdminInfo = daAdminColl.get(i);
            adminDataMap.put(docAreaAdminInfo.getAdmin().getId().toString(), docAreaAdminInfo.getPermList());
            includeSubMap.put(docAreaAdminInfo.getAdmin().getId().toString(), String.valueOf(docAreaAdminInfo.isIncludeSub()));
        }
        DocAreaRoleNewCollection daRoleColl = docAreaNewInfo.getRole();
        int size2 = daRoleColl.size();
        for (int i = 0; i < size2; ++i) {
            DocAreaRoleNewInfo docAreaRoleInfo = daRoleColl.get(i);
            roleDataMap.put(docAreaRoleInfo.getRole().getId().toString(), docAreaRoleInfo.getPermList());
        }
        DocAreaPersonNewCollection daPersonColl = docAreaNewInfo.getPerson();
        int size3 = daPersonColl.size();
        for (int i = 0; i < size3; ++i) {
            DocAreaPersonNewInfo docAreaPersonInfo = daPersonColl.get(i);
            perDataMap.put(docAreaPersonInfo.getPerson().getId().toString(), docAreaPersonInfo.getPermList());
        }
        Object s = null;
    }

    public void setPermissionDataByCategory(CategoryInfo categoryInfo, Map<String, String> perDataMap, Map<String, String> adminDataMap, Map<String, String> roleDataMap, Map<String, String> includeSubMap) {
        CategoryAdminCollection adminColl = categoryInfo.getAdmin();
        int size = adminColl.size();
        for (int i = 0; i < size; ++i) {
            CategoryAdminInfo categoryAdminInfo = adminColl.get(i);
            adminDataMap.put(categoryAdminInfo.getAdmin().getId().toString(), categoryAdminInfo.getPermList());
            includeSubMap.put(categoryAdminInfo.getAdmin().getId().toString(), String.valueOf(categoryAdminInfo.isIncludeSub()));
        }
        CategoryRoleCollection roleColl = categoryInfo.getRole();
        int size2 = roleColl.size();
        for (int i = 0; i < size2; ++i) {
            CategoryRoleInfo categoryRoleInfo = roleColl.get(i);
            roleDataMap.put(categoryRoleInfo.getRole().getId().toString(), categoryRoleInfo.getPermList());
        }
        CategoryPersonCollection personColl = categoryInfo.getPerson();
        int size3 = personColl.size();
        for (int i = 0; i < size3; ++i) {
            CategoryPersonInfo categoryPersonInfo = personColl.get(i);
            perDataMap.put(categoryPersonInfo.getPerson().getId().toString(), categoryPersonInfo.getPermList());
        }
    }

    public SelectorItemCollection getDocAreaNewSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("role.role.id");
        sic.add("role.role.name");
        sic.add("role.role.number");
        sic.add("role.permList");
        sic.add("person.person.id");
        sic.add("person.person.name");
        sic.add("person.person.number");
        sic.add("person.permList");
        sic.add("admin.admin.id");
        sic.add("admin.admin.name");
        sic.add("admin.admin.number");
        sic.add("admin.permList");
        sic.add("admin.permListDiff");
        sic.add("admin.includeSub");
        return sic;
    }

    public SelectorItemCollection getDocCategorySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("Role.role.id");
        sic.add("Role.role.name");
        sic.add("Role.role.number");
        sic.add("Role.permList");
        sic.add("Role.permListDiff");
        sic.add("Person.person.id");
        sic.add("Person.person.name");
        sic.add("Person.person.number");
        sic.add("Person.permList");
        sic.add("Person.permListDiff");
        sic.add("Admin.admin.id");
        sic.add("Admin.admin.name");
        sic.add("Admin.admin.number");
        sic.add("Admin.permList");
        sic.add("Admin.permListDiff");
        sic.add("Admin.includeSub");
        return sic;
    }

    public void updateCategoryPermModel(Context ctx, HashMap<String, String> perDataMap, HashMap<String, String> adminDataMap, HashMap<String, String> roleDataMap, String categoryId, Map<String, String> includeSubMap) {
        CategoryPersonInfo categoryPersonInfo = null;
        CategoryRoleInfo categoryRoleInfo = null;
        CategoryAdminInfo categoryAdminInfo = null;
        PersonInfo perInfo = null;
        AdminOrgUnitInfo adminInfo = null;
        RoleInfo roleInfo = null;
        CategoryInfo categoryInfo = null;
        try {
            categoryInfo = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(categoryId), this.getDocCategorySelectors());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, String> docAreaMap = this.getDocAreaPermByCat(ctx, categoryId).get(0);
        Map<String, String> catMap = this.getSubPermCatIdMap(ctx, categoryInfo.getId().toString());
        if (catMap.size() > 0) {
            categoryInfo.put("subCatMap", catMap);
            categoryInfo.put("subUpdate", includeSubMap.get("subUpdate"));
        }
        Iterator<String> iter = perDataMap.keySet().iterator();
        String key = null;
        categoryInfo.getPerson().clear();
        while (iter.hasNext()) {
            categoryPersonInfo = new CategoryPersonInfo();
            key = iter.next();
            if (StringUtils.isEmpty((String)perDataMap.get(key))) continue;
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)key));
            categoryPersonInfo.setPerson(perInfo);
            categoryPersonInfo.setPermList(perDataMap.get(key));
            if (docAreaMap.containsKey(key)) {
                categoryPersonInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryPersonInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            categoryInfo.getPerson().add(categoryPersonInfo);
        }
        iter = adminDataMap.keySet().iterator();
        key = null;
        categoryInfo.getAdmin().clear();
        while (iter.hasNext()) {
            categoryAdminInfo = new CategoryAdminInfo();
            key = iter.next();
            if (StringUtils.isEmpty((String)adminDataMap.get(key))) continue;
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)key));
            categoryAdminInfo.setAdmin(adminInfo);
            categoryAdminInfo.setPermList(adminDataMap.get(key));
            categoryAdminInfo.setIncludeSub(new Boolean(includeSubMap.get(key)));
            if (docAreaMap.containsKey(key)) {
                categoryAdminInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryAdminInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            categoryInfo.getAdmin().add(categoryAdminInfo);
        }
        iter = roleDataMap.keySet().iterator();
        key = null;
        categoryInfo.getRole().clear();
        while (iter.hasNext()) {
            categoryRoleInfo = new CategoryRoleInfo();
            key = iter.next();
            if (StringUtils.isEmpty((String)roleDataMap.get(key))) continue;
            roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)key));
            categoryRoleInfo.setRole(roleInfo);
            categoryRoleInfo.setPermList(roleDataMap.get(key));
            if (docAreaMap.containsKey(key)) {
                categoryRoleInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryRoleInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            categoryInfo.getRole().add(categoryRoleInfo);
        }
        try {
            CategoryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(categoryId), (CoreBaseInfo)categoryInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDocAreaNewPermModel(Context ctx, HashMap<String, String> perDataMap, HashMap<String, String> adminDataMap, HashMap<String, String> roleDataMap, String docAreaId, Map<String, String> includeSubMap) {
        DocAreaNewInfo docAreaNewInfo = null;
        try {
            DocAreaPersonNewInfo docAreaPersonInfo = null;
            DocAreaRoleNewInfo docAreaRoleInfo = null;
            DocAreaAdminNewInfo docAreaAdminInfo = null;
            PersonInfo perInfo = null;
            AdminOrgUnitInfo adminInfo = null;
            RoleInfo roleInfo = null;
            Iterator<String> iter = perDataMap.keySet().iterator();
            String key = null;
            docAreaNewInfo = (DocAreaNewInfo)DocAreaNewFactory.getLocalInstance(ctx).getValue("where docArea = '" + docAreaId + "'");
            docAreaNewInfo = (DocAreaNewInfo)DocAreaNewFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(docAreaNewInfo.getId()), this.getDocAreaNewSelectors());
            docAreaNewInfo.getPerson().clear();
            while (iter.hasNext()) {
                docAreaPersonInfo = new DocAreaPersonNewInfo();
                key = iter.next();
                perInfo = new PersonInfo();
                perInfo.setId(BOSUuid.read((String)key));
                docAreaPersonInfo.setPerson(perInfo);
                docAreaPersonInfo.setPermList(perDataMap.get(key));
                docAreaNewInfo.getPerson().add(docAreaPersonInfo);
            }
            iter = adminDataMap.keySet().iterator();
            key = null;
            docAreaNewInfo.getAdmin().clear();
            while (iter.hasNext()) {
                docAreaAdminInfo = new DocAreaAdminNewInfo();
                key = iter.next();
                docAreaAdminInfo.setPermList(adminDataMap.get(key));
                docAreaAdminInfo.setIncludeSub(new Boolean(includeSubMap.get(key)));
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)key));
                docAreaAdminInfo.setAdmin(adminInfo);
                docAreaNewInfo.getAdmin().add(docAreaAdminInfo);
            }
            iter = roleDataMap.keySet().iterator();
            key = null;
            docAreaNewInfo.getRole().clear();
            while (iter.hasNext()) {
                docAreaRoleInfo = new DocAreaRoleNewInfo();
                key = iter.next();
                roleInfo = new RoleInfo();
                roleInfo.setId(BOSUuid.read((String)key));
                docAreaRoleInfo.setRole(roleInfo);
                docAreaRoleInfo.setPermList(roleDataMap.get(key));
                docAreaNewInfo.getRole().add(docAreaRoleInfo);
            }
            DocAreaNewFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(docAreaNewInfo.getId()), (CoreBaseInfo)docAreaNewInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Map<String, String>> getDocAreaPermByCat(Context ctx, String categoryId) {
        ArrayList<Map<String, String>> docAreaList = new ArrayList<Map<String, String>>();
        HashMap<String, String> docAreaPermMap = new HashMap<String, String>();
        HashMap<String, String> docAreaIncludeSubMap = new HashMap<String, String>();
        try {
            CategoryInfo categoryInfo = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue("select docArea where id='" + categoryId + "'");
            String docAreaId = categoryInfo.getDocArea().getId().toString();
            DocAreaNewInfo areaNewInfo = DocAreaNewFactory.getLocalInstance(ctx).getDocAreaNewInfo("where docArea = '" + docAreaId + "'");
            if (null != areaNewInfo) {
                areaNewInfo = DocAreaNewFactory.getLocalInstance(ctx).getDocAreaNewInfo((IObjectPK)new ObjectUuidPK(areaNewInfo.getId()), this.getDocAreaNewSelectors());
                HashMap<String, String> tempPerDataMap = new HashMap<String, String>();
                HashMap<String, String> tempAdminDataMap = new HashMap<String, String>();
                HashMap<String, String> tempRoleDataMap = new HashMap<String, String>();
                HashMap<String, String> includeSubMap = new HashMap<String, String>();
                this.setPermissionDataByArea(areaNewInfo, tempPerDataMap, tempAdminDataMap, tempRoleDataMap, includeSubMap);
                docAreaPermMap.putAll(tempPerDataMap);
                docAreaPermMap.putAll(tempAdminDataMap);
                docAreaPermMap.putAll(tempRoleDataMap);
                docAreaIncludeSubMap.putAll(includeSubMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        docAreaList.add(docAreaPermMap);
        docAreaList.add(docAreaIncludeSubMap);
        return docAreaList;
    }

    public Map<String, String> getSubPermCatIdMap(Context ctx, String categoryId) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> docAreaIdList = new ArrayList<String>();
        CategoryInfo catInfo = null;
        try {
            catInfo = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue("select id,longNumber,docArea  where id='" + categoryId + "'");
            CategoryCollection cols = CategoryFactory.getLocalInstance(ctx).getCategoryCollection("select id where longNumber like '%" + catInfo.getLongNumber() + "!%' and state != 2");
            if (null == cols || cols.size() == 0) {
                return map;
            }
            docAreaIdList.add(catInfo.getDocArea().getId().toString());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            HashSet<String> perMissionSet = new HashSet<String>();
            perMissionSet.add("1");
            Map<String, Set<String>> map4 = DmPermissionServiceNewHelper.getInstance().getHasPermDocAreaIdSet(ctx, perId, userId, perMissionSet, new HashSet<String>(docAreaIdList), "t_dm_docarea");
            Map<String, Set<String>> map2 = PermissionUtil.getHasPermCatIdMap(ctx, perMissionSet, new HashSet<String>(docAreaIdList), "t_dm_category");
            HashSet catIdSet = new HashSet();
            Iterator<String> it = map2.keySet().iterator();
            while (it.hasNext()) {
                catIdSet.addAll(map2.get(it.next()));
            }
            it = map4.keySet().iterator();
            while (it.hasNext()) {
                catIdSet.addAll(map4.get(it.next()));
            }
            int j = cols.size();
            for (int i = 0; i < j; ++i) {
                if (!catIdSet.contains(cols.get(i).getId().toString())) continue;
                map.put(cols.get(i).getId().toString(), cols.get(i).getId().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

