/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEConsoleService;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.ArchiveCtrlUnitInfo;
import com.kingdee.eas.cp.dm.ArchiveModuleInfo;
import com.kingdee.eas.cp.dm.AttachSet;
import com.kingdee.eas.cp.dm.AttachUnitEnum;
import com.kingdee.eas.cp.dm.CatArchiveModuleInfo;
import com.kingdee.eas.cp.dm.Category;
import com.kingdee.eas.cp.dm.CategoryAdminInfo;
import com.kingdee.eas.cp.dm.CategoryCollection;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.CategoryPersonInfo;
import com.kingdee.eas.cp.dm.CategoryRoleInfo;
import com.kingdee.eas.cp.dm.CommentIndexSet;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocArea;
import com.kingdee.eas.cp.dm.DocAreaAdminInfo;
import com.kingdee.eas.cp.dm.DocAreaCUEntryInfo;
import com.kingdee.eas.cp.dm.DocAreaCollection;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.DocAreaPersonInfo;
import com.kingdee.eas.cp.dm.DocAreaRoleInfo;
import com.kingdee.eas.cp.dm.DocManageParametersSet;
import com.kingdee.eas.cp.dm.DocManageParametersSetFactory;
import com.kingdee.eas.cp.dm.DocManageParametersSetInfo;
import com.kingdee.eas.cp.dm.DocTemplateInfo;
import com.kingdee.eas.cp.dm.ICategory;
import com.kingdee.eas.cp.dm.PermSourceEnum;
import com.kingdee.eas.cp.dm.app.DmProcessService;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.cp.dm.app.ProcessInfo;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.cp.dm.web.UnifyPermissionHelper;
import com.kingdee.eas.cp.dm.web.dto.ColumnF7DTO;
import com.kingdee.eas.cp.dm.web.dto.ColumnInfoDTO;
import com.kingdee.eas.cp.dm.web.dto.ColumnParamsDTO;
import com.kingdee.eas.cp.dm.web.dto.CtrlUnitInfoDTO;
import com.kingdee.eas.cp.dm.web.dto.PermInfoDTO;
import com.kingdee.eas.cp.dm.web.service.DmColumnPermissionService;
import com.kingdee.eas.cp.dm.web.service.DmLeftTreeBeanService;
import com.kingdee.eas.cp.dm.web.util.DmCommonUtils;
import com.kingdee.eas.cp.dm.web.util.PermFromDBUtil;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DmColumnManagerService {
    private static final Logger logger = Logger.getLogger(DmColumnManagerService.class);
    private List<String> keyList;
    private Map<String, List<TreeBaseInfo>> tempMap;
    private Map<String, List<TreeBaseInfo>> permTreeMap;
    private boolean permTreeFlag = false;

    public DmColumnManagerService(List<String> keyList) {
        this.keyList = keyList;
    }

    public Object[] getChildren(Context ctx, String id) {
        String key = null;
        if ("DM_ROOT".equals(id)) {
            if (this.keyList != null && this.keyList.size() > 0) {
                try {
                    return DocAreaFactory.getLocalInstance(ctx).getDocAreaCollection("select id,name,number,index,state where id in" + CommonUtils.getStrFromList(this.keyList) + " order by index desc").toArray();
                }
                catch (BOSException e) {
                    logger.info((Object)"\u83b7\u53d6\u6587\u6863\u533a\u96c6\u5408\u5931\u8d25\uff01");
                    e.printStackTrace();
                    return null;
                }
            }
            return null;
        }
        return this.handleEmptyKey(ctx, id, key);
    }

    public CategoryCollection createMapTreeData(Context ctx, ColumnParamsDTO culumnParamsDto) {
        ArrayList<String> docAreaIdList = new ArrayList<String>();
        if (culumnParamsDto.getAreaId() != null && culumnParamsDto.getAreaId().length() > 0) {
            docAreaIdList.add(culumnParamsDto.getAreaId());
            return this.createMapTreeData(ctx, docAreaIdList, culumnParamsDto);
        }
        return null;
    }

    public IRowSet findAdminCatoryTree(Context ctx, String areaId, ColumnParamsDTO columnParamsDto) {
        return this.excuteColumnSql(ctx, this.getAdminSqlStr(ctx, areaId, columnParamsDto).toString());
    }

    public IRowSet excuteColumnSql(Context ctx, String sql) {
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public IRowSet findColumnTreeData(Context ctx, String areaId, ColumnParamsDTO columnParamDto, boolean returnDisableFlag) {
        try {
            boolean isCategoryAdmin = PermissionUtil.checkHasPermission(ctx, "1", areaId, "t_dm_docarea");
            if (isCategoryAdmin) {
                return this.findAdminCatoryTree(ctx, areaId, columnParamDto);
            }
            return this.findCatoryTree(ctx, areaId, columnParamDto, returnDisableFlag);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public IRowSet findCatoryTree(Context ctx, String areaId, ColumnParamsDTO columnParamsDto, boolean returnDisableFlag) {
        Set<String> catSet = DmColumnPermissionService.getHasPermCatIdSet(ctx, areaId);
        return this.findCatoryTree(ctx, catSet, returnDisableFlag, areaId, columnParamsDto);
    }

    private IRowSet findCatoryTree(Context ctx, Set<String> bizIdSet, boolean returnDisableFlag, String areaId, ColumnParamsDTO columnParamsDto) {
        Object[] ay = bizIdSet.toArray();
        StringBuilder sbIds = new StringBuilder();
        for (int i = 0; i < ay.length; ++i) {
            sbIds.append("'").append(ay[i]).append("',");
        }
        String ids = sbIds.toString();
        ids = ids.length() > 0 ? ids.substring(0, ids.length() - 1) : "''";
        StringBuilder sb = new StringBuilder();
        Locale locale = ctx.getLocale();
        sb.append("select fid,fname_").append(locale).append(" fname,fnumber,flongnumber,fstate,flevel,findex,FPARENTID  from T_DM_CATEGORY ").append(" as paz where exists(select biz.flongnumber from T_DM_CATEGORY biz where biz.fid in (").append(ids).append(") and substring(biz.flongnumber,1,length(paz.flongnumber)) = paz.flongnumber) ").append("and fstate != 2 and fdocAreaId = '").append(areaId).append("'");
        if (Integer.parseInt(columnParamsDto.getSlevel()) > 1) {
            sb.append(" and flongnumber like '").append(columnParamsDto.getLongNum()).append("!%'");
        }
        sb.append(" order by findex");
        return this.excuteColumnSql(ctx, sb.toString());
    }

    private StringBuilder getAdminSqlStr(Context ctx, String areaId, ColumnParamsDTO columnParamsDto) {
        StringBuilder oql = new StringBuilder();
        Locale locale = ctx.getLocale();
        oql.append("select fid,fname_").append(locale).append(" fname,fnumber,flongnumber,fstate,flevel,findex,FPARENTID from T_DM_CATEGORY where (");
        oql.append("fdocAreaid='").append(areaId).append("'");
        oql.append(" and fstate != 2 ) ");
        if (Integer.parseInt(columnParamsDto.getSlevel()) > 1) {
            oql.append(" and flongnumber like '").append(columnParamsDto.getLongNum()).append("!%'");
        }
        oql.append(" order by findex");
        return oql;
    }

    public CategoryCollection createMapTreeData(Context ctx, List<String> docAreaIdList, ColumnParamsDTO culumnParamsDto) {
        StringBuilder oql = null;
        if (docAreaIdList == null || docAreaIdList.size() <= 0) {
            return null;
        }
        oql = this.getOqlStr(ctx, docAreaIdList, culumnParamsDto);
        try {
            return CategoryFactory.getLocalInstance(ctx).getCategoryCollection(oql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CategoryCollection getPermCloumnTreeData(Context ctx, ColumnParamsDTO columnParamDto) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(this.buildPermCloumnTreeDataFilter(ctx, columnParamDto));
        try {
            return CategoryFactory.getLocalInstance(ctx).getCategoryCollection(entityViewInfo);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    private FilterInfo buildPermCloumnTreeDataFilter(Context ctx, ColumnParamsDTO columnParamDto) {
        Set<String> PermCatIdSet = null;
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("3");
        String areaId = columnParamDto.getAreaId();
        String columnId = columnParamDto.getId();
        FilterInfo filterAdmin = new FilterInfo();
        if (columnId != null && !columnId.equals(areaId)) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, areaId, "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docArea.id", (Object)areaId, CompareType.EQUALS));
            filterAdmin.getFilterItems().add(new FilterItemInfo("parent.id", (Object)columnId));
        } else {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, areaId, "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docarea.id", (Object)areaId, CompareType.EQUALS));
            filterAdmin.getFilterItems().add(new FilterItemInfo("parent.id", null));
            filterAdmin.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
        }
        return filterAdmin;
    }

    public StringBuilder getOqlStr(Context ctx, List<String> docAreaIdList, ColumnParamsDTO columnParamsDto) {
        StringBuilder oql = new StringBuilder();
        oql.append("select id,name,number,longnumber,state,level,index,docArea.id,parent.id,creator.id where (");
        oql.append(DmColumnPermissionService.getPemissionCat(ctx, docAreaIdList));
        oql.append(" and state != 2 ");
        if (Integer.parseInt(columnParamsDto.getSlevel()) > 1) {
            oql.append(") and longnumber like '").append(columnParamsDto.getLongNum()).append("!%'");
        } else {
            oql.append(") ");
        }
        oql.append(" order by index");
        return oql;
    }

    private Object[] handleEmptyKey(Context ctx, Object userData, String key) {
        if (userData == null) {
            return new Object[]{"ROOT"};
        }
        if (this.tempMap.get(key) != null) {
            if (this.permTreeFlag) {
                List<TreeBaseInfo> treeList = this.tempMap.get(key);
                LinkedList<TreeBaseInfo> resultList = new LinkedList<TreeBaseInfo>();
                block3: for (TreeBaseInfo baseInfo : treeList) {
                    if (this.containsKey(baseInfo.getId().toString())) {
                        resultList.add(baseInfo);
                        continue;
                    }
                    Iterator<String> iter = null;
                    for (String tempkey : this.permTreeMap.keySet()) {
                        if (!tempkey.equals(baseInfo.getLongNumber()) && !tempkey.startsWith(baseInfo.getLongNumber())) continue;
                        resultList.add(baseInfo);
                        continue block3;
                    }
                }
                return resultList.toArray();
            }
            return this.tempMap.get(key).toArray();
        }
        try {
            if (StringUtils.isEmpty((String)key)) {
                return null;
            }
            if (userData instanceof CategoryInfo || userData instanceof DocAreaInfo) {
                return null;
            }
            return new Object[]{DocAreaFactory.getLocalInstance(ctx).getDocAreaInfo("select id,name,number,state where id ='" + key.substring(4) + "'")};
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getHref(Object userData) {
        return null;
    }

    public String getHrefTarget(Object userData) {
        return null;
    }

    public String getIcon(Object userData) {
        if (userData != null) {
            if (userData instanceof DocAreaInfo) {
                if ("22222222-2222-2222-2222-222222222222CCE7AED4".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_myindividual.gif";
                }
                if ("MelW/dHHTYOlHlNhgLZyRMNdkBQ=".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_myspace.gif";
                }
                if ("33333333-3333-3333-3333-333333333333CCE7AED4".equals(((DocAreaInfo)userData).getId().toString())) {
                    return "resources/image/tree_share.gif";
                }
                return "resources/image/docArea.gif";
            }
            if (userData instanceof CategoryInfo) {
                String catId = ((CategoryInfo)userData).getId().toString();
                if ("wZxsk5DbTK2xj0F9sAl/n8NdkBQ=".equals(catId)) {
                    return "resources/image/tree_myputout.gif";
                }
                if ("R8+LZe0FRBam4nGMFLckacNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myauditing.gif";
                }
                if ("ol7h/gioRX2/D4oOLU1cUsNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myrecommend.gif";
                }
                if ("MirOKDKL9ECnz0xqo7IajsNdkBQ=".equals(catId)) {
                    return "resources/image/tree_myborrow.gif";
                }
                return "resources/image/category.gif";
            }
            return "resources/image/tree_folder.gif";
        }
        return "resources/image/tree_folder.gif";
    }

    private boolean containsKey(String key) {
        if (this.permTreeMap.containsKey(key)) {
            return true;
        }
        Iterator<String> iter = null;
        for (String tempkey : this.permTreeMap.keySet()) {
            List<TreeBaseInfo> treeList = this.permTreeMap.get(tempkey);
            if (treeList == null) continue;
            for (TreeBaseInfo treeBaseInfo : treeList) {
                CategoryInfo categoryInfo;
                if (!(treeBaseInfo instanceof CategoryInfo) || !(categoryInfo = (CategoryInfo)treeBaseInfo).getId().toString().equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    public String getText(Object userData) {
        if (userData instanceof TreeBaseInfo) {
            if (userData instanceof CategoryInfo) {
                if (((CategoryInfo)userData).getState() == DmState.ENABLE) {
                    CategoryInfo categoryInfo;
                    String key;
                    if (this.permTreeFlag && !this.containsKey(key = (categoryInfo = (CategoryInfo)userData).getId().toString())) {
                        return "<span style=\"color:gray\">" + this.getTextName(userData) + "</span>";
                    }
                    return this.getTextName(userData);
                }
                return "<span style=\"color:gray\">" + this.getTextName(userData) + "</span>";
            }
            return this.getTextName(userData);
        }
        if (userData instanceof DocAreaInfo) {
            String daID = ((DocAreaInfo)userData).getId().toString();
            if (((DocAreaInfo)userData).getState() == DmState.ENABLE || "22222222-2222-2222-2222-222222222222CCE7AED4".equals(daID) || "MelW/dHHTYOlHlNhgLZyRMNdkBQ=".equals(daID) || "33333333-3333-3333-3333-333333333333CCE7AED4".equals(daID)) {
                return "<span style=\"font-weight:bold;\">" + this.getTextStr(userData) + "</span>";
            }
            return "<span style=\"color:gray; font-weight:bold;\">" + this.getTextStr(userData) + "</span>";
        }
        return this.getTextStr(userData);
    }

    private String getTextStr(Object userData) {
        return userData.toString().length() > 12 ? userData.toString().substring(0, 10) + "..." : userData.toString();
    }

    private String getTextName(Object userData) {
        String name = ((TreeBaseInfo)userData).getName();
        return name.length() > 12 ? name.substring(0, 10) + "..." : name;
    }

    public boolean isCascade(Object userData) {
        return false;
    }

    public Boolean isChecked(Object userData) {
        return null;
    }

    public boolean isExpanded(Context ctx, String id) {
        Boolean isLeaf = false;
        Object[] o = this.getChildren(ctx, id);
        isLeaf = o == null || o.length == 0;
        return isLeaf;
    }

    public String getId(Object arg0) {
        if (arg0 == null) {
            logger.info((Object)"tree id error ,id is null");
            return "dm_error";
        }
        if (arg0 instanceof DocAreaInfo) {
            return "DA_" + ((DocAreaInfo)arg0).getIndex();
        }
        if (arg0 instanceof CategoryInfo) {
            if (((CategoryInfo)arg0).getNumber() != null) {
                return "Cat_" + ((CategoryInfo)arg0).getNumber();
            }
            logger.info((Object)"Error: category number is null");
            return "Cat_" + ((CategoryInfo)arg0).getIndex();
        }
        if (arg0 instanceof String) {
            if ("ROOT".equals((String)arg0)) {
                return "DM_ROOT";
            }
            logger.info((Object)"tree id ERROR");
            return "DM_TREE_ERROR";
        }
        logger.info((Object)"tree id ERROR");
        return "DM_TREE_ERROR";
    }

    public boolean saveRootInfo(Context ctx, String enterpriseDocName) {
        boolean result = false;
        try {
            DocManageParametersSetInfo info = this.getEnterpriseDocName(ctx);
            Timestamp tempTime = DmCommonUtils.getTime();
            info.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            info.setLastUpdateTime(tempTime);
            info.setCU(ContextUtil.getCurrentUserInfo((Context)ctx).getCU());
            info.setEnterpriseDocName(enterpriseDocName);
            DocManageParametersSet service = new DocManageParametersSet(ctx);
            service.save((CoreBaseInfo)info);
            result = true;
        }
        catch (Exception e) {
            logger.error((Object)"saveRootInfo error===", (Throwable)e);
        }
        return result;
    }

    public DocManageParametersSetInfo getEnterpriseDocName(Context context) {
        String oql = "select id,isShowMyDocSpace,isOpenMyDocSpace,isOpenEnterpriseDoc,isOpenALevelEnterpriseDoc,enterpriseDocName where id='nDz0XDd6SnKFCh82gWEx7BgOPPE='";
        try {
            return DocManageParametersSetFactory.getLocalInstance(context).getDocManageParametersSetInfo(oql);
        }
        catch (EASBizException e) {
            logger.warn((Object)"getDocManageParametersSetInfo  error!", (Throwable)e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            logger.warn((Object)"getDocManageParametersSetInfo  error!", (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    public DocAreaInfo findDocAreaInfoByAreaId(Context ctx, String areaId) {
        DocArea docAreaService = new DocArea(ctx);
        DocAreaInfo area = null;
        try {
            area = StringUtil.isEmpty((String)areaId) ? new DocAreaInfo() : docAreaService.getDocAreaInfo((IObjectPK)new ObjectUuidPK(areaId));
        }
        catch (Exception e) {
            logger.error((Object)"findDocAreaInfoByAreaId error===", (Throwable)e);
        }
        return area;
    }

    public List<PermInfoDTO> findPermPerson(Context ctx, DocAreaInfo docAreaInfo, String areaId) {
        String perId = null;
        if (StringUtil.isEmpty((String)areaId)) {
            perId = "'" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "'";
        }
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docAreaInfo != null && docAreaInfo.getPerson().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docAreaInfo.getPerson().size(); ++i) {
                DocAreaPersonInfo info = docAreaInfo.getPerson().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getPerson().getId().toString()).append("'");
                permList.put(info.getPerson().getId().toString(), info.getPermList());
            }
            perId = perIds.toString();
        }
        return PermFromDBUtil.getPermPersonFromDb(ctx, perId, permList);
    }

    public List<PermInfoDTO> findColPermPerson(Context ctx, CategoryInfo ci, String columnId) {
        String perId = null;
        if (StringUtil.isEmpty((String)columnId)) {
            perId = "'" + ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString() + "'";
        }
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        ci.getPerson().get(0);
        if (ci != null && ci.getPerson().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < ci.getPerson().size(); ++i) {
                CategoryPersonInfo info = ci.getPerson().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getPerson().getId().toString()).append("'");
                permList.put(info.getPerson().getId().toString(), info.getPermList());
            }
            perId = perIds.toString();
        }
        return PermFromDBUtil.getPermPersonFromDb(ctx, perId, permList);
    }

    public List<PermInfoDTO> findPermOrg(Context ctx, DocAreaInfo docAreaInfo) {
        String orgId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docAreaInfo != null && docAreaInfo.getAdmin().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docAreaInfo.getAdmin().size(); ++i) {
                DocAreaAdminInfo info = docAreaInfo.getAdmin().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getAdmin().getId().toString()).append("'");
                permList.put(info.getAdmin().getId().toString(), info.getPermList());
            }
            orgId = perIds.toString();
        }
        return PermFromDBUtil.getPermOrgFromDb(ctx, orgId, permList);
    }

    public List<PermInfoDTO> findColPermOrg(Context ctx, CategoryInfo ci) {
        String orgId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (ci != null && ci.getAdmin().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < ci.getAdmin().size(); ++i) {
                CategoryAdminInfo info = ci.getAdmin().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getAdmin().getId().toString()).append("'");
                permList.put(info.getAdmin().getId().toString(), info.getPermList());
            }
            orgId = perIds.toString();
        }
        return PermFromDBUtil.getPermOrgFromDb(ctx, orgId, permList);
    }

    public List<PermInfoDTO> findPermRole(Context ctx, DocAreaInfo docAreaInfo) {
        String roleId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docAreaInfo != null && docAreaInfo.getRole().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docAreaInfo.getRole().size(); ++i) {
                DocAreaRoleInfo info = docAreaInfo.getRole().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getRole().getId().toString()).append("'");
                permList.put(info.getRole().getId().toString(), info.getPermList());
            }
            roleId = perIds.toString();
        }
        return PermFromDBUtil.getPermRoleFromDb(ctx, roleId, permList);
    }

    public List<PermInfoDTO> findColPermRole(Context ctx, CategoryInfo ci) {
        String roleId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (ci != null && ci.getRole().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < ci.getRole().size(); ++i) {
                CategoryRoleInfo info = ci.getRole().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getRole().getId().toString()).append("'");
                permList.put(info.getRole().getId().toString(), info.getPermList());
            }
            roleId = perIds.toString();
        }
        return PermFromDBUtil.getPermRoleFromDb(ctx, roleId, permList);
    }

    public CtrlUnitInfoDTO findCuInfo(Context ctx, DocAreaInfo docAreaInfo) {
        String cuId = "";
        CtrlUnitInfoDTO cuInfoDto = new CtrlUnitInfoDTO();
        StringBuilder perIds = new StringBuilder(100);
        if (docAreaInfo != null && docAreaInfo.getCUEntry().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docAreaInfo.getCUEntry().size(); ++i) {
                DocAreaCUEntryInfo info = docAreaInfo.getCUEntry().get(i);
                if (info == null) continue;
                cuId = "'" + info.getCu().getId().toString() + "'";
                if (!info.isIncludeSub()) continue;
                cuInfoDto.setIsSub("true");
            }
        }
        if (cuId.length() > 0) {
            StringBuilder sql = new StringBuilder("select fid as ");
            sql.append("id").append(", fname_l2 as ").append("name").append(" from T_ORG_CtrlUnit where fid in(").append(cuId).append(")");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    cuInfoDto.setId(rs.getString("id"));
                    cuInfoDto.setName(rs.getString("name"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"findCuInfo error===", (Throwable)e);
            }
        } else {
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            cuInfoDto.setId(cuInfo.getId().toString());
            cuInfoDto.setName(cuInfo.getName());
        }
        return cuInfoDto;
    }

    public DocAreaInfo saveDocAreaInfo(Context ctx, DocAreaInfo newDocAreaInfo, String personMapStr, String orgMapStr, String roleMapStr, String cuId, String isSub) {
        DocAreaInfo info = null;
        try {
            if (newDocAreaInfo.getId() != null) {
                info = this.findDocAreaInfoByAreaId(ctx, newDocAreaInfo.getId().toString());
            } else {
                info = new DocAreaInfo();
                info.setState(DmState.ENABLE);
            }
            info.setName(newDocAreaInfo.getName());
            info.setFtpPath(newDocAreaInfo.getFtpPath());
            info.setDescription(newDocAreaInfo.getDescription());
            info = this.setPerson(info, personMapStr);
            info = this.setOrg(info, orgMapStr);
            info = this.setRole(info, roleMapStr);
            info = this.setCu(info, cuId, isSub);
            DocArea docAreaService = new DocArea(ctx);
            docAreaService.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            logger.error((Object)"saveDocAreaInfo error ===", (Throwable)e);
            try {
                throw new Exception(e);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return info;
    }

    private DocAreaInfo setPerson(DocAreaInfo info, String personMapStr) throws JSONException {
        info.getPerson().clear();
        JSONObject personMap = new JSONObject(personMapStr);
        DocAreaPersonInfo docAreaPersonInfo = null;
        Iterator iter = personMap.keys();
        PersonInfo perInfo = null;
        String key = null;
        while (iter.hasNext()) {
            docAreaPersonInfo = new DocAreaPersonInfo();
            key = (String)iter.next();
            String permColumn = (String)personMap.get(key);
            if (!"1".equals(permColumn)) continue;
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)key));
            docAreaPersonInfo.setPerson(perInfo);
            docAreaPersonInfo.setPermList((String)personMap.get(key));
            info.getPerson().add(docAreaPersonInfo);
        }
        return info;
    }

    private DocAreaInfo setOrg(DocAreaInfo info, String orgMapStr) throws JSONException {
        info.getAdmin().clear();
        JSONObject orgMap = new JSONObject(orgMapStr);
        Iterator iter = orgMap.keys();
        String key = null;
        while (iter.hasNext()) {
            DocAreaAdminInfo docAreaAdminInfo = new DocAreaAdminInfo();
            key = (String)iter.next();
            String permColumn = (String)orgMap.get(key);
            if (!"1".equals(permColumn)) continue;
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)key));
            docAreaAdminInfo.setAdmin(adminInfo);
            docAreaAdminInfo.setPermList((String)orgMap.get(key));
            info.getAdmin().add(docAreaAdminInfo);
        }
        return info;
    }

    private DocAreaInfo setRole(DocAreaInfo info, String roleMapStr) throws JSONException {
        info.getRole().clear();
        JSONObject roleMap = new JSONObject(roleMapStr);
        Iterator iter = roleMap.keys();
        String key = null;
        while (iter.hasNext()) {
            DocAreaRoleInfo docAreaRoleInfo = new DocAreaRoleInfo();
            key = (String)iter.next();
            String permColumn = (String)roleMap.get(key);
            if (!"1".equals(permColumn)) continue;
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)key));
            docAreaRoleInfo.setRole(roleInfo);
            docAreaRoleInfo.setPermList((String)roleMap.get(key));
            info.getRole().add(docAreaRoleInfo);
        }
        return info;
    }

    private DocAreaInfo setCu(DocAreaInfo info, String cuId, String isSub) {
        try {
            info.getCUEntry().clear();
            CtrlUnitInfo cuInfo = new CtrlUnitInfo();
            cuInfo.setId(BOSUuid.read((String)cuId));
            DocAreaCUEntryInfo docAreaCUEntryInfo = new DocAreaCUEntryInfo();
            docAreaCUEntryInfo.setCu(cuInfo);
            docAreaCUEntryInfo.setIncludeSub("on".equals(isSub));
            info.getCUEntry().add(docAreaCUEntryInfo);
        }
        catch (Exception e) {
            logger.error((Object)"saveDocAreaInfo setCu error ===", (Throwable)e);
        }
        return info;
    }

    public String testFptConnection(Context ctx, String pathid) {
        String result = "";
        IFMEConsoleService service = FMEServiceFactory.getConsoleServiceInstance((Context)ctx);
        try {
            String[] linkResult = service.checkFtpLinks(pathid);
            result = "0".equals(linkResult[0]) ? "1" : "\u8fde\u63a5\u5931\u8d25\uff1a" + linkResult[1] + "";
        }
        catch (BOSException e) {
            result = "\u8fde\u63a5\u5931\u8d25\uff01";
            e.printStackTrace();
        }
        return result;
    }

    public boolean isExist(Context ctx, DocAreaInfo curModel) {
        try {
            DocArea docAreaService = new DocArea(ctx);
            if (curModel.getId() != null) {
                return docAreaService.exists("select * where state != 2 and name = '" + curModel.getName() + "' and id !='" + curModel.getId().toString() + "' ");
            }
            return docAreaService.exists("select * where state != 2 and name = '" + curModel.getName() + "'");
        }
        catch (Exception e) {
            logger.info((Object)"isExist error!");
            return true;
        }
    }

    public boolean disAbledDocArea(Context ctx, String areaId) throws EASBizException, BOSException {
        boolean result = false;
        DocArea docAreaService = new DocArea(ctx);
        DocAreaInfo info = this.findDocAreaInfoByAreaId(ctx, areaId);
        docAreaService.cancel(info);
        result = true;
        return result;
    }

    public boolean enableDocArea(Context ctx, String areaId) throws EASBizException, BOSException {
        boolean result = false;
        DocArea docAreaService = new DocArea(ctx);
        DocAreaInfo info = this.findDocAreaInfoByAreaId(ctx, areaId);
        docAreaService.cancelCancel(info);
        result = true;
        return result;
    }

    public boolean setColumnState(Context ctx, String columnId, String state) throws EASBizException, BOSException {
        boolean result = false;
        Category service = new Category(ctx);
        CategoryInfo info = this.findCategoryInfoById(ctx, columnId, null, null);
        if ("enable".equals(state)) {
            service.cancelCancel(info);
        } else {
            service.cancel(info);
        }
        result = true;
        return result;
    }

    public String deleteDocArea(Context ctx, String areaId) throws EASBizException, BOSException, SQLException {
        DocArea docAreaService = new DocArea(ctx);
        DocAreaInfo info = this.findDocAreaInfoByAreaId(ctx, areaId);
        String resultCode = this.verifyDeleteModel(ctx, info);
        if ("success".equals(resultCode)) {
            docAreaService.deleteDocArea((IObjectPK)new ObjectUuidPK(areaId));
        }
        return resultCode;
    }

    private String verifyDeleteModel(Context ctx, DocAreaInfo info) throws BOSException, SQLException {
        String result = "success";
        if (0 != info.getState().getValue()) {
            return "enableArea";
        }
        String sql = "select fid from t_dm_category where fstate != 2 and fdocareaid = '" + info.getId().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return "haveSubInfo";
        }
        return result;
    }

    public String deleteColumn(Context ctx, String columnId) throws Exception {
        CategoryInfo info = this.findCategoryInfoById(ctx, columnId, null, null);
        String resultCode = this.verifyDeleteColumn(ctx, info);
        if ("success".equals(resultCode)) {
            ArrayList<String> selectedRowIdList = new ArrayList<String>();
            selectedRowIdList.add(columnId);
            DmServerService.changeVOStateBySql(ctx, "t_dm_category", 2, selectedRowIdList);
        }
        return resultCode;
    }

    private String verifyDeleteColumn(Context ctx, CategoryInfo info) throws Exception {
        if (0 != info.getState().getValue()) {
            return "enableColumn";
        }
        String sql = "select fid from t_dm_category where fstate != 2 and fparentid = '" + info.getId().toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return "hasSubColumn";
        }
        sql = "select fid from t_dm_document where fstate != 2 and fisHistory = 0 and fcategoryid = '" + info.getId().toString() + "'";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return "hasContent";
        }
        return "success";
    }

    public CategoryInfo findCategoryInfoById(Context ctx, String columnId, String areaId, String pId) throws EASBizException, BOSException {
        CategoryInfo info = null;
        if (columnId != null && columnId.length() > 0) {
            info = CategoryFactory.getLocalInstance(ctx).getCategoryInfo((IObjectPK)new ObjectUuidPK(columnId), this.getSelectors());
        } else {
            info = new CategoryInfo();
            DocAreaInfo daInfo = this.findDocAreaInfoByAreaId(ctx, areaId);
            info.setDocArea(daInfo);
            if (!StringUtil.isEmpty((String)pId)) {
                CategoryInfo parent = CategoryFactory.getLocalInstance(ctx).getCategoryInfo((IObjectPK)new ObjectUuidPK(pId), this.getSelectors());
                if (parent != null) {
                    info.setParent(parent);
                    info.setIsVerSet(parent.isIsVerSet());
                    info.setCU(parent.getCU());
                    info.setIsShowAuthorDeptCom(parent.isIsShowAuthorDeptCom());
                    info.setIsShowCreatorDeptCom(parent.isIsShowCreatorDeptCom());
                    info.setAttachSizes(parent.getAttachSizes());
                    info.setAttachUnit(parent.getAttachUnit());
                    info.setAttachTypes(parent.getAttachTypes());
                    info.setAttachSet(parent.getAttachSet());
                    info.setCanCopy(parent.isCanCopy());
                    info.setCanDownload(parent.isCanDownload());
                    info.setIsPrintAttach(parent.isIsPrintAttach());
                    info.setCanEdit(parent.isCanEdit());
                    info.setIsAnonymous(parent.isIsAnonymous());
                    info.setWfPubProcess(parent.getWfPubProcess());
                    info.setWfForbProcess(parent.getWfForbProcess());
                    info.setCommentIndexSet(parent.getCommentIndexSet());
                }
            } else {
                info.setAttachSizes(10);
                info.setIsShowAuthorDeptCom(true);
                info.setIsShowCreatorDeptCom(true);
                info.setCanCopy(true);
                info.setCanDownload(true);
                info.setIsPrintAttach(true);
                info.setCanEdit(true);
            }
        }
        return info;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("template.id");
        sic.add("template.name");
        sic.add("parent.id");
        sic.add("parent.name");
        sic.add("Role.role.id");
        sic.add("Role.role.name");
        sic.add("Role.role.number");
        sic.add("Role.permList");
        sic.add("Role.permListDiff");
        sic.add("Person.person.id");
        sic.add("Person.person.name");
        sic.add("Person.person.number");
        sic.add("Person.permList");
        sic.add("Person.permListDiff");
        sic.add("Admin.admin.id");
        sic.add("Admin.admin.name");
        sic.add("Admin.admin.number");
        sic.add("Admin.permList");
        sic.add("Admin.permListDiff");
        sic.add("Admin.includeSub");
        sic.add("archiveCtrlUnit.cu.id");
        sic.add("archiveCtrlUnit.cu.name");
        sic.add("archiveCtrlUnit.cu.number");
        sic.add("catArchiveModule.archiveModule.id");
        sic.add("catArchiveModule.archiveModule.name");
        sic.add("catArchiveModule.archiveModule.number");
        sic.add("DocArea.ftpPath");
        return sic;
    }

    public ProcessInfo[] loadPubProcessList(Context ctx) throws WfException, BOSException {
        return DmProcessService.getPubProcessInfo(ctx);
    }

    public ProcessInfo[] loadForbProcessList(Context ctx) throws WfException, BOSException {
        return DmProcessService.getForbidProcessInfo(ctx);
    }

    public ProcessInfo[] loadBorrowProcessList(Context ctx) throws WfException, BOSException {
        return DmProcessService.getBorrowProcessInfo(ctx);
    }

    public boolean checkColumnName(Context ctx, ColumnInfoDTO colDto) {
        boolean isExist = false;
        try {
            ICategory ic = CategoryFactory.getLocalInstance(ctx);
            CategoryInfo dataBaseInfo = this.findCategoryInfoById(ctx, colDto.getId(), colDto.getDaId(), null);
            CategoryInfo parent = dataBaseInfo.getParent();
            try {
                if (!StringUtil.isEmpty((String)colDto.getpId())) {
                    parent = this.findCategoryInfoById(ctx, colDto.getpId(), colDto.getDaId(), null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("name", (Object)colDto.getName(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("docarea.id", (Object)colDto.getDaId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)(colDto.getId().equals("") ? null : colDto.getId()), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)dataBaseInfo.getLongNumber(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
            if (parent != null) {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parent.getId(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)"1", CompareType.EQUALS));
            }
            filter.setMaskString("#0 and #1 and #2 and #3 and #4 and #5");
            if (ic.exists(filter)) {
                isExist = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return isExist;
    }

    public CategoryInfo saveColumnInfo(Context ctx, ColumnInfoDTO ciDto, String personMapStr, String orgMapStr, String roleMapStr, String includeSubMapStr, String cuIdStr, String archiveModuleStr) throws Exception {
        CategoryInfo info = null;
        if (ciDto.getId() != null && ciDto.getId().length() > 0) {
            info = this.findCategoryInfoById(ctx, ciDto.getId().toString(), null, null);
        } else {
            info = new CategoryInfo();
            info.setState(DmState.ENABLE);
            if (!StringUtil.isEmpty((String)ciDto.getpId())) {
                CategoryInfo parent = new CategoryInfo();
                parent.setId(BOSUuid.read((String)ciDto.getpId()));
                info.setParent(parent);
            }
        }
        info = this.setColumnBasicInfo(info, ciDto);
        UnifyPermissionHelper permHelper = new UnifyPermissionHelper();
        String infoId = null;
        if (info.getId() != null) {
            infoId = info.getId().toString();
        }
        Map<String, String> docAreaMap = permHelper.getDocAreaPermByCat(ctx, infoId).get(0);
        info = this.setCatPerson(info, personMapStr, docAreaMap);
        info = this.setCatOrg(info, orgMapStr, includeSubMapStr, docAreaMap);
        info = this.setCatRole(info, roleMapStr, docAreaMap);
        info = this.setArchiveCtrl(info, ciDto);
        Category service = new Category(ctx);
        service.save((CoreBaseInfo)info);
        if ("true".equals(ciDto.getHasChangePerm())) {
            this.syncColumnPerm(ctx, info, personMapStr, orgMapStr, roleMapStr, includeSubMapStr, docAreaMap);
        }
        return info;
    }

    private CategoryInfo setColumnBasicInfo(CategoryInfo info, ColumnInfoDTO ciDto) {
        DocAreaInfo daInfo = new DocAreaInfo();
        daInfo.setId(BOSUuid.read((String)ciDto.getDaId()));
        info.setDocArea(daInfo);
        info.setName(ciDto.getName());
        info.setIsShowCreatorDeptCom(this.transferCheckBoxToBoolean(ciDto.getIsShowCreatorDeptCom()));
        info.setIsShowAuthorDeptCom(this.transferCheckBoxToBoolean(ciDto.getIsShowAuthorDeptCom()));
        info.setIsVerSet(this.transferStringToBoolean(ciDto.getIsVerSet()));
        if (ciDto.getTemplate() != null && ciDto.getTemplate().length() > 0) {
            DocTemplateInfo templateInfo = new DocTemplateInfo();
            templateInfo.setId(BOSUuid.read((String)ciDto.getTemplate()));
            info.setTemplate(templateInfo);
        } else {
            info.setTemplate(null);
        }
        info.setCanReSelectTemplate(this.transferCheckBoxToBoolean(ciDto.getCanReSelectTemplate()));
        info.setAttachSizes(Integer.parseInt(ciDto.getAttachSizes()));
        info.setAttachUnit("G".equals(ciDto.getAttachUnit()) ? AttachUnitEnum.G : AttachUnitEnum.M);
        if ("1".equals(ciDto.getAttachSetItems())) {
            info.setAttachSet(AttachSet.FORBID);
        } else {
            info.setAttachSet(AttachSet.ALLOW);
        }
        info.setAttachTypes(ciDto.getAttachTypes());
        info.setWfBorrowProcess(ciDto.getWfBorrowProcess());
        info.setWfForbProcess(ciDto.getWfForbProcess());
        info.setWfPubProcess(ciDto.getWfPubProcess());
        info.setBorrowDays(Integer.parseInt(ciDto.getBorrowDays()));
        if ("1".equals(ciDto.getCommentIndexSet())) {
            info.setCommentIndexSet(CommentIndexSet.DESC);
        } else {
            info.setCommentIndexSet(CommentIndexSet.ASC);
        }
        info.setIsAnonymous(this.transferCheckBoxToBoolean(ciDto.getIsAnonymous()));
        info.setIsArchive(this.transferCheckBoxToBoolean(ciDto.getIsArchive()));
        info.setIsArchiveProcess(true);
        info.setCanCopy(this.transferCheckBoxToBoolean(ciDto.getCanCopy()));
        info.setCanDownload(this.transferCheckBoxToBoolean(ciDto.getCanDownload()));
        info.setIsPrintAttach(this.transferCheckBoxToBoolean(ciDto.getCanPrint()));
        info.setCanEdit(this.transferCheckBoxToBoolean(ciDto.getCanEdit()));
        info.setDescription(ciDto.getDescript());
        return info;
    }

    private CategoryInfo setCatPerson(CategoryInfo info, String personMapStr, Map docAreaMap) throws JSONException {
        info.getPerson().clear();
        JSONObject personMap = new JSONObject(personMapStr);
        CategoryPersonInfo categoryPersonInfo = null;
        Iterator iter = personMap.keys();
        PersonInfo perInfo = null;
        String key = null;
        while (iter.hasNext()) {
            categoryPersonInfo = new CategoryPersonInfo();
            key = (String)iter.next();
            String permColumn = (String)personMap.get(key);
            if ("".equals(permColumn)) continue;
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)key));
            categoryPersonInfo.setPerson(perInfo);
            categoryPersonInfo.setPermList((String)personMap.get(key));
            if (docAreaMap.containsKey(key)) {
                categoryPersonInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryPersonInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            info.getPerson().add(categoryPersonInfo);
        }
        return info;
    }

    private CategoryInfo setCatOrg(CategoryInfo info, String orgMapStr, String includeSubMapStr, Map docAreaMap) throws JSONException {
        info.getAdmin().clear();
        JSONObject orgMap = new JSONObject(orgMapStr);
        CategoryAdminInfo categoryAdminInfo = null;
        Iterator iter = orgMap.keys();
        String key = null;
        while (iter.hasNext()) {
            categoryAdminInfo = new CategoryAdminInfo();
            key = (String)iter.next();
            String permColumn = (String)orgMap.get(key);
            if ("".equals(permColumn)) continue;
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)key));
            categoryAdminInfo.setAdmin(adminInfo);
            categoryAdminInfo.setPermList((String)orgMap.get(key));
            if (docAreaMap.containsKey(key)) {
                categoryAdminInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryAdminInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            info.getAdmin().add(categoryAdminInfo);
        }
        return info;
    }

    private CategoryInfo setCatRole(CategoryInfo info, String roleMapStr, Map docAreaMap) throws JSONException {
        info.getRole().clear();
        JSONObject roleMap = new JSONObject(roleMapStr);
        Iterator iter = roleMap.keys();
        String key = null;
        while (iter.hasNext()) {
            CategoryRoleInfo categoryRoleInfo = new CategoryRoleInfo();
            key = (String)iter.next();
            String permColumn = (String)roleMap.get(key);
            if ("".equals(permColumn)) continue;
            RoleInfo roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)key));
            categoryRoleInfo.setRole(roleInfo);
            categoryRoleInfo.setPermList((String)roleMap.get(key));
            if (docAreaMap.containsKey(key)) {
                categoryRoleInfo.setPermFrom(PermSourceEnum.FROM_DOCAREA);
            } else {
                categoryRoleInfo.setPermFrom(PermSourceEnum.FROM_SELF_CAT);
            }
            info.getRole().add(categoryRoleInfo);
        }
        return info;
    }

    private void syncColumnPerm(Context ctx, CategoryInfo info, String personMapStr, String orgMapStr, String roleMapStr, String includeSubMapStr, Map docAreaMap) {
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
            ev.setFilter(filterInfo);
            CategoryCollection catCol = CategoryFactory.getLocalInstance(ctx).getCategoryCollection(ev);
            for (int i = 0; i < catCol.size(); ++i) {
                CategoryInfo catInfo = catCol.get(i);
                if (catInfo == null) continue;
                this.setCatPerson(catInfo, personMapStr, docAreaMap);
                this.setCatOrg(catInfo, orgMapStr, includeSubMapStr, docAreaMap);
                this.setCatRole(catInfo, roleMapStr, docAreaMap);
                Category service = new Category(ctx);
                service.save((CoreBaseInfo)catInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("syncColumnPerm load sub category error ==" + e.getMessage()));
        }
        catch (JSONException je) {
            logger.error((Object)("sync perm json error ==" + je.getMessage()));
        }
        catch (EASBizException ee) {
            logger.error((Object)("sync perm savePerm error ==" + ee.getMessage()));
        }
    }

    private boolean transferCheckBoxToBoolean(String checkedValue) {
        return "on".equals(checkedValue);
    }

    private boolean transferStringToBoolean(String str) {
        return "1".equals(str);
    }

    private CategoryInfo setArchiveCtrl(CategoryInfo catInfo, ColumnInfoDTO ciDto) {
        Object info;
        CoreBaseInfo item;
        int i;
        catInfo.getArchiveCtrlUnit().clear();
        if (catInfo.isIsArchive() && ciDto.getCtrlUnitList() != null) {
            String[] ctrlUnitList = ciDto.getCtrlUnitList().split(",");
            for (i = 0; i < ctrlUnitList.length; ++i) {
                if (StringUtil.isEmpty((String)ctrlUnitList[i])) continue;
                item = new ArchiveCtrlUnitInfo();
                info = new CtrlUnitInfo();
                info.setId(BOSUuid.read((String)ctrlUnitList[i]));
                item.setCu((CtrlUnitInfo)info);
                catInfo.getArchiveCtrlUnit().add((ArchiveCtrlUnitInfo)item);
            }
        }
        catInfo.getCatArchiveModule().clear();
        if (catInfo.isIsArchive() && ciDto.getArchiveModuleList() != null) {
            String[] archiveModuleList = ciDto.getArchiveModuleList().split(",");
            for (i = 0; i < archiveModuleList.length; ++i) {
                if (StringUtil.isEmpty((String)archiveModuleList[i])) continue;
                item = new CatArchiveModuleInfo();
                info = new ArchiveModuleInfo();
                info.setId(BOSUuid.read((String)archiveModuleList[i]));
                item.setArchiveModule((ArchiveModuleInfo)info);
                catInfo.getCatArchiveModule().add((CatArchiveModuleInfo)item);
            }
        }
        return catInfo;
    }

    public List<String> getPermEnabledDocAreaIdList(Context ctx) {
        ArrayList<String> curDocAreaIdList = new ArrayList<String>();
        List<DocAreaInfo> docAreaList = this.getPermEnabledDocAreaList(ctx);
        if (null != docAreaList && docAreaList.size() > 0) {
            for (int i = 0; i < docAreaList.size(); ++i) {
                curDocAreaIdList.add(docAreaList.get(i).getId().toString());
            }
        }
        return curDocAreaIdList;
    }

    public List<DocAreaInfo> getPermEnabledDocAreaList(Context ctx) {
        ArrayList<DocAreaInfo> permDocAreaIdList = new ArrayList<DocAreaInfo>();
        try {
            CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String extSql = this.getCUIncludeSub(ctx, ctrlInfo);
            StringBuffer sql = new StringBuffer();
            sql.append("select area.fid as id,area.fname_l2 as name,area.fstate as state,ctrl.fname_l2 as cuName  from t_dm_docarea as area");
            sql.append(" inner join t_dm_docareacuentry as entry on area.fid=entry.fparentid inner join ");
            sql.append(" t_org_ctrlunit as ctrl on ctrl.fid=entry.fcuid ");
            sql.append(" where area.fstate=1 and (ctrl.fid='" + ctrlInfo.getId().toString() + "'");
            if (!StringUtils.isEmpty((String)extSql)) {
                sql.append("or (ctrl.fid in (" + extSql + ") and entry.fincludesub=1 ) ");
            }
            sql.append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                DocAreaInfo areaInfo = new DocAreaInfo();
                areaInfo.put("id", rs.getString("id"));
                areaInfo.put("cu.name", rs.getString("cuName"));
                areaInfo.put("state", rs.getInt("state"));
                areaInfo.put("name", rs.getString("name"));
                permDocAreaIdList.add(areaInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permDocAreaIdList;
    }

    private String getCUIncludeSub(Context ctx, CtrlUnitInfo personCUInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct(ctrl.fid) as id,ctrl.fname_l2 as name,ctrl.flevel as flevel,ctrl.flongnumber as longnumber  from t_dm_docarea as area");
        sql.append(" inner join t_dm_docareacuentry as entry on area.fid=entry.fparentid inner join ");
        sql.append(" t_org_ctrlunit as ctrl on ctrl.fid=entry.fcuid ");
        sql.append(" where area.fstate<>2 and entry.fincludesub=1 ");
        ArrayList<CtrlUnitInfo> ctrlList = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ctrlList = new ArrayList<CtrlUnitInfo>(rs.size());
            CtrlUnitInfo ctrlInfo = null;
            while (rs.next()) {
                ctrlInfo = new CtrlUnitInfo();
                ctrlInfo.put("id", (Object)rs.getString("id"));
                ctrlInfo.put("name", (Object)rs.getString("name"));
                ctrlInfo.put("level", (Object)rs.getInt("flevel"));
                ctrlInfo.put("longnumber", (Object)rs.getString("longnumber"));
                ctrlList.add(ctrlInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String personCULNumber = personCUInfo.getLongNumber();
        String cuLNumber = null;
        StringBuffer cuIdSql = new StringBuffer();
        for (int i = 0; i < ctrlList.size(); ++i) {
            cuLNumber = ((CtrlUnitInfo)ctrlList.get(i)).getLongNumber();
            if (personCUInfo.getLevel() <= (Integer)((CtrlUnitInfo)ctrlList.get(i)).get("level") || personCULNumber.indexOf(cuLNumber) <= -1) continue;
            cuIdSql.append("'").append(((CtrlUnitInfo)ctrlList.get(i)).getId().toString()).append("'").append(",");
        }
        return cuIdSql.length() == 0 ? cuIdSql.toString() : cuIdSql.toString().substring(0, cuIdSql.toString().length() - 1);
    }

    public String getOperaMenuItems(HttpServletRequest request, Context ctx, Object obj, Boolean isArea) {
        List<String> items = null;
        if (isArea.booleanValue()) {
            boolean isCategoryAdmin;
            String curDocAreaId;
            boolean isDocAreaAdmin = PermissionUtil.isTopCatUser(request, ctx);
            if (obj instanceof CategoryInfo) {
                curDocAreaId = ((CategoryInfo)obj).getDocArea().getId().toString();
                isCategoryAdmin = false;
                try {
                    isCategoryAdmin = PermissionUtil.checkHasPermission(ctx, "1", ((CategoryInfo)obj).getId().toString(), "t_dm_category");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                isCategoryAdmin = isCategoryAdmin || this.dmCheckCategoryPermission(ctx, curDocAreaId);
                items = DmLeftTreeBeanService.getInstance().getMenuItems4Cat((CategoryInfo)obj, ctx, isDocAreaAdmin, isCategoryAdmin);
            } else if (obj instanceof DocAreaInfo) {
                curDocAreaId = ((DocAreaInfo)obj).getId().toString();
                isCategoryAdmin = this.dmCheckCategoryPermission(ctx, curDocAreaId);
                items = DmLeftTreeBeanService.getInstance().getMenuItems4DA((DocAreaInfo)obj, isDocAreaAdmin, isCategoryAdmin);
            }
        } else if (obj instanceof DimensionInfo) {
            items = DmLeftTreeBeanService.getInstance().getMenuItems4Dim(request, ctx, (DimensionInfo)obj);
        }
        String operBtn = "";
        for (String btn : items) {
            operBtn = operBtn + btn + ",";
        }
        if (operBtn.length() > 0) {
            operBtn = operBtn.substring(0, operBtn.length() - 1);
        }
        return operBtn;
    }

    private boolean dmCheckCategoryPermission(Context ctx, String curDocAreaId) {
        try {
            return PermissionUtil.checkHasPermission(ctx, "1", curDocAreaId, "t_dm_docarea");
        }
        catch (BOSException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveAreaSortList(HttpServletRequest request, Context ctx, String areaIds, String pId) throws Exception {
        boolean result = false;
        List<String> areaIdList = DmLeftTreeBeanService.getInstance().getDefaultDocAreaIdList2(request, ctx);
        DocAreaCollection cols = DocAreaFactory.getLocalInstance(ctx).getDocAreaCollection("select id,name,number,index,state where id in" + CommonUtils.getStrFromList(areaIdList) + " order by index ");
        CoreBaseCollection colls = new CoreBaseCollection();
        int maxIndex = cols.size();
        String[] strs = areaIds.split(",");
        for (int j = 0; j < strs.length; ++j) {
            for (int i = 0; i < cols.size(); ++i) {
                DocAreaInfo area = cols.get(i);
                if (area.getId().toString().equals(strs[j])) {
                    area.setIndex(maxIndex - j);
                    continue;
                }
                colls.add((CoreBaseInfo)area);
            }
        }
        DocArea docAreaService = new DocArea(ctx);
        docAreaService.save(colls);
        result = true;
        return result;
    }

    public boolean saveColumnSort(Context ctx, String columnIds, ColumnParamsDTO columnParamDto) throws Exception {
        boolean result = false;
        CategoryCollection catColl = this.createMapTreeData(ctx, columnParamDto);
        CoreBaseCollection colls = new CoreBaseCollection();
        String[] strs = columnIds.split(",");
        for (int j = 0; j < strs.length; ++j) {
            for (int i = 0; i < catColl.size(); ++i) {
                CategoryInfo catInfo = catColl.get(i);
                if (catInfo.getId().toString().equals(strs[j])) {
                    catInfo.setIndex(j + 1);
                    continue;
                }
                colls.add((CoreBaseInfo)catInfo);
            }
        }
        Category service = new Category(ctx);
        service.save(colls);
        return result;
    }

    public boolean moveInNode(Context ctx, String sourceId, String targetId, String parentType) throws Exception {
        CategoryInfo sourceNode = this.findCategoryInfoById(ctx, sourceId, null, null);
        if ("area".equals(parentType)) {
            DocAreaInfo targetDocNode = this.findDocAreaInfoByAreaId(ctx, targetId);
            CategoryFactory.getLocalInstance(ctx).moveDocTreeNode(sourceNode, targetDocNode);
        } else {
            CategoryInfo targetNode = this.findCategoryInfoById(ctx, targetId, null, null);
            CategoryFactory.getLocalInstance(ctx).moveTreeNode(sourceNode, targetNode);
        }
        return true;
    }

    public boolean moveInParentNode(Context ctx, String sourceId, String targetId, String parentType, String moveType, ColumnParamsDTO columnParamDto, String ids) throws Exception {
        boolean result = false;
        boolean moveInResult = this.moveInNode(ctx, sourceId, columnParamDto.getId(), parentType);
        if (moveInResult) {
            this.saveColumnSort(ctx, ids, columnParamDto);
            result = true;
        }
        return result;
    }

    public PagingResult<ColumnF7DTO> loadDistributeColumn(Context ctx, ColumnF7DTO param, PagingParam pagingParam) {
        PagingResult pagingResult = new PagingResult();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        Set<String> PermCatIdSet = null;
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("3");
        FilterInfo filterAdmin = new FilterInfo();
        String type = param.getType();
        if (type.equals("column")) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, param.getAreaId(), "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docArea.id", (Object)param.getAreaId(), CompareType.EQUALS));
            if (param.getShowSub().equals("true")) {
                filterAdmin.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(param.getLongNum() + "%"), CompareType.LIKE));
            } else {
                filterAdmin.getFilterItems().add(new FilterItemInfo("id", (Object)param.getId()));
            }
        } else if (type.equals("area")) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, param.getId(), "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docarea.id", (Object)param.getId(), CompareType.EQUALS));
            if (!param.getShowSub().equals("true")) {
                filterAdmin.getFilterItems().add(new FilterItemInfo("parent.id", null));
                filterAdmin.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
            }
        } else {
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata"));
        }
        if (param.getName() != null && param.getName().length() > 0) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + param.getName() + "%"), CompareType.LIKE));
        }
        try {
            String sql;
            entityViewInfo.setFilter(filterAdmin);
            SorterItemCollection sorter = entityViewInfo.getSorter();
            if (sorter != null) {
                sorter.clear();
            } else {
                sorter = new SorterItemCollection();
            }
            SorterItemInfo sort = new SorterItemInfo("name");
            sort.setSortType(SortType.DESCEND);
            sorter.add(sort);
            entityViewInfo.setSorter(sorter);
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app", "CategoryQuery");
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            String countSql = sql = exec.getSQL();
            if (sql.indexOf("ORDER BY") > 0) {
                countSql = sql.substring(0, sql.indexOf("ORDER BY"));
            }
            if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
                total = countRowSet.getInt(1);
            }
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<ColumnF7DTO> list = new ArrayList<ColumnF7DTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    ColumnF7DTO ct = new ColumnF7DTO();
                    ct.setId(rowSet.getString("id"));
                    ct.setName(rowSet.getString("name"));
                    ct.setCode(rowSet.getString("number"));
                    ct.setAreaId(rowSet.getString("docArea.id"));
                    ct.setAttachSizes(String.valueOf(rowSet.getInt("attachSizes")));
                    list.add(ct);
                }
            }
            pagingResult.setPagingParam(pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pagingResult;
    }

    public PagingResult<ColumnF7DTO> loadSetPortletColumn(Context ctx, ColumnF7DTO param, PagingParam pagingParam) {
        PagingResult pagingResult = new PagingResult();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        Set<String> PermCatIdSet = null;
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("4");
        FilterInfo filterAdmin = new FilterInfo();
        String type = param.getType();
        if (type.equals("column")) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, param.getAreaId(), "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docArea.id", (Object)param.getAreaId(), CompareType.EQUALS));
            if (param.getShowSub().equals("true")) {
                filterAdmin.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(param.getLongNum() + "%"), CompareType.LIKE));
            } else {
                filterAdmin.getFilterItems().add(new FilterItemInfo("id", (Object)param.getId()));
            }
        } else if (type.equals("area")) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            PermCatIdSet = PermissionUtil.getHasPermCatIdSet(ctx, perMissionSet, param.getId(), "t_dm_category");
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", PermCatIdSet == null ? "" : PermCatIdSet, CompareType.INCLUDE));
            filterAdmin.getFilterItems().add(new FilterItemInfo("docarea.id", (Object)param.getId(), CompareType.EQUALS));
            if (!param.getShowSub().equals("true")) {
                filterAdmin.getFilterItems().add(new FilterItemInfo("parent.id", null));
                filterAdmin.getFilterItems().add(new FilterItemInfo("level", (Object)1, CompareType.EQUALS));
            }
        } else {
            filterAdmin.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata"));
        }
        if (param.getName() != null && param.getName().length() > 0) {
            filterAdmin.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + param.getName() + "%"), CompareType.LIKE));
        }
        try {
            String sql;
            entityViewInfo.setFilter(filterAdmin);
            SorterItemCollection sorter = entityViewInfo.getSorter();
            if (sorter != null) {
                sorter.clear();
            } else {
                sorter = new SorterItemCollection();
            }
            SorterItemInfo sort = new SorterItemInfo("name");
            sort.setSortType(SortType.DESCEND);
            sorter.add(sort);
            entityViewInfo.setSorter(sorter);
            MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app", "CategoryQuery");
            exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
            String countSql = sql = exec.getSQL();
            if (sql.indexOf("ORDER BY") > 0) {
                countSql = sql.substring(0, sql.indexOf("ORDER BY"));
            }
            if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
                total = countRowSet.getInt(1);
            }
            rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
            ArrayList<ColumnF7DTO> list = new ArrayList<ColumnF7DTO>();
            if (rowSet != null) {
                while (rowSet.next()) {
                    ColumnF7DTO ct = new ColumnF7DTO();
                    ct.setId(rowSet.getString("id"));
                    ct.setName(rowSet.getString("name"));
                    ct.setCode(rowSet.getString("number"));
                    ct.setAreaId(rowSet.getString("docArea.id"));
                    ct.setAttachSizes(String.valueOf(rowSet.getInt("attachSizes")));
                    list.add(ct);
                }
            }
            pagingResult.setPagingParam(pagingParam);
            pagingResult.setTotalCount(total);
            pagingResult.setRecords(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pagingResult;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public String getCls(Object arg0) {
        return null;
    }

    public String getIconCls(Object arg0) {
        return null;
    }

    public String getQtip(Object arg0) {
        return null;
    }

    public boolean isDisabled(Object arg0) {
        return false;
    }

    public boolean isLeaf(Context ctx, String id) {
        Boolean isLeaf = false;
        Object[] o = this.getChildren(ctx, id);
        isLeaf = o == null || o.length == 0;
        return isLeaf;
    }

    public boolean isSingleClickExpand(Object arg0) {
        return false;
    }

    public Map<String, List<TreeBaseInfo>> getPermTreeMap() {
        return this.permTreeMap;
    }

    public void setPermTreeMap(Map<String, List<TreeBaseInfo>> permTreeMap) {
        this.permTreeMap = permTreeMap;
    }

    public boolean isPermTreeFlag() {
        return this.permTreeFlag;
    }

    public void setPermTreeFlag(boolean permTreeFlag) {
        this.permTreeFlag = permTreeFlag;
    }
}

