/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.web.dto.ContentListDTO;
import com.kingdee.eas.cp.eip.pc.ProcCatalogException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DmDocumentFlowDaoImp {
    private static final Logger LOGGER = Logger.getLogger(DmDocumentFlowDaoImp.class);
    public static final String TODO = "todo";
    private static final String AUDITING = "\u5904\u7406\u4e2d";
    public static final String FINISHED = "finished";
    public static final String ALL = "all";
    private static DmDocumentFlowDaoImp dmDocFlowDaoImp;
    private static final String MYRECEIVE = "myReceive";
    private static final String MYSEND = "mySend";

    public List<ContentListDTO> getDocumentProcessByUserAndLanaguage(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) throws BOSException, EASBizException {
        String strSql = null;
        if (TODO.equals(auditingState)) {
            strSql = this.getTodoProcessSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        } else if (FINISHED.equals(auditingState)) {
            strSql = this.getFinishedProcessSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        }
        LOGGER.debug((Object)("===strSql===getProcess====" + strSql));
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
            for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                ContentListDTO ct = new ContentListDTO();
                ct.setId(rowSet.getString("docid"));
                ct.setAssinId(rowSet.getString("assignid"));
                ct.setBizId(rowSet.getString("bizid"));
                ct.setTitle(rowSet.getString("title"));
                ct.setAuthorName(rowSet.getString("docauthor"));
                ct.setColumnName(rowSet.getString("categoryname"));
                ct.setAreaName(rowSet.getString("docareaname"));
                if (TODO.equals(auditingState)) {
                    ct.setState(this.getReadState(rowSet.getString("status"), auditingState));
                    ct.setDistbuteTime(rowSet.getString("accepttime"));
                } else if (FINISHED.equals(auditingState)) {
                    ct.setState("\u5df2\u53d1\u5e03");
                    ct.setDistbuteTime(rowSet.getString("accepttime"));
                }
                list.add(ct);
            }
        }
        catch (Exception sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    public List<ContentListDTO> getMySharedList(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) throws BOSException, EASBizException {
        String strSql = null;
        if (MYRECEIVE.equals(auditingState)) {
            strSql = this.getReceiveProcessSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        } else if (MYSEND.equals(auditingState)) {
            strSql = this.getSendProcessSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        }
        System.out.println("===strSql===getMySharedList====" + strSql);
        LOGGER.debug((Object)("===strSql===getMySharedList====" + strSql));
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
            for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                ContentListDTO ct = new ContentListDTO();
                ct.setId(rowSet.getString("docId"));
                ct.setTitle(rowSet.getString("docTitle"));
                ct.setAuthorName(rowSet.getString("author"));
                ct.setCreateTime(rowSet.getString("docCreateTime"));
                ct.setSendPerson(rowSet.getString("sendPerson"));
                ct.setSendTime(rowSet.getString("sendTime"));
                if (MYSEND.equals(auditingState)) {
                    ct.setDocrId(rowSet.getString("docrId"));
                    ct.setReceivePerson(this.getReceivePerson(ct.getId(), ctx, rowSet.getString("docrId")));
                }
                if (MYRECEIVE.equals(auditingState)) {
                    ct.setDocreId(rowSet.getString("docreId"));
                }
                list.add(ct);
            }
        }
        catch (Exception sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    private String getReceivePerson(String docId, Context ctx, String docrId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct user3.FName_L2 sendPersion");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId and");
        sb.append(" doc.FID='").append(docId).append("' and docr.fstate=1 and user2.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("' and docr.fid='").append(docrId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String sendPersons = "";
        while (rowSet.next()) {
            sendPersons = sendPersons + rowSet.getString("sendPersion") + ",";
        }
        return sendPersons;
    }

    private String getReceiveProcessSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct top ").append(pageNumber).append(" doc.FID docId,doc.FTitle docTitle,user1.FName_L2 author,doc.FCreateTime docCreateTime,user2.FName_L2 sendPerson,docr.FCreateTime sendTime,docre.FID docreId");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docre.fstate=1 and user3.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("'");
        sb.append(" and docr.FID not in (");
        sb.append("select distinct top ").append(pageNumber * (pageCount - 1));
        sb.append(" docr.FID");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docre.fstate=1 and user3.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("')");
        sb.append(" order by docr.FCreateTime desc");
        return sb.toString();
    }

    private String getSendProcessSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select distinct top ").append(pageNumber).append(" doc.FID docId,doc.FTitle docTitle,user1.FName_L2 author,doc.FCreateTime docCreateTime,user2.FName_L2 sendPerson,docr.FCreateTime sendTime,docr.FID docrId");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docr.fstate=1 and user2.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("'");
        sb.append(" and docr.FID not in (");
        sb.append("select distinct top ").append(pageNumber * (pageCount - 1));
        sb.append(" docr.FID");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docr.fstate=1 and user2.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("')");
        sb.append(" order by docr.FCreateTime desc");
        return sb.toString();
    }

    public int getProcessCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        int count = 0;
        if (TODO.equals(auditingState)) {
            count = this.getTotoProcessCount(ctx, language, auditingState, condition);
        } else if (FINISHED.equals(auditingState)) {
            count = this.getFinishProcessCount(ctx, language, auditingState, condition);
        }
        return count;
    }

    public int getMySharedCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        int count = 0;
        if (MYRECEIVE.equals(auditingState)) {
            count = this.getReceiveProcessCount(ctx, language, auditingState, condition);
        } else if (MYSEND.equals(auditingState)) {
            count = this.getSendProcessCount(ctx, language, auditingState, condition);
        }
        return count;
    }

    public int getReceiveProcessCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM from");
        sb.append(" (select distinct doc.FID docId,doc.FTitle docTitle,user1.FName_L2 author,doc.FCreateTime docCreateTime,user2.FName_L2 sendPerson,docr.FCreateTime sendTime,docre.FID docreId");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docre.fstate=1 and user3.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("') t");
        LOGGER.debug((Object)("===getReceiveProcessCount====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    public int getSendProcessCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM from");
        sb.append(" (select distinct doc.FID docId,doc.FTitle docTitle,user1.FName_L2 author,doc.FCreateTime docCreateTime,user2.FName_L2 sendPerson,docr.FCreateTime sendTime,docr.FID docrId");
        sb.append(" from T_DM_Document doc,t_dm_documentrecommend docr,t_dm_documentrecommendentry docre,T_PM_User user1,T_PM_User user2,T_PM_User user3");
        sb.append(" where doc.FAuthorID=user1.FPersonId and doc.FID=docr.FDocID and docr.FPersonID=user2.FPersonId and docr.FID=docre.FParentID and docre.FPersonID=user3.FPersonId");
        if (condition != null) {
            sb.append(" and doc.FTitle like '%").append(condition).append("%'");
        }
        sb.append(" and docr.fstate=1 and user2.FID='");
        sb.append(ctx.getCaller().toString());
        sb.append("') t");
        LOGGER.debug((Object)("===getSendProcessCount====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    public int getFinishProcessCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM");
        sb.append(" from");
        sb.append(" (");
        sb.append("   (select a.fassignid assignid, a.fbizobjid docid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
        sb.append("   a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("   union");
        sb.append("   (select a.fassignid assignid, a.fbizobjid docid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
        sb.append("   a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("  ) t");
        LOGGER.debug((Object)("===countSql===getProcess====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    public int getTotoProcessCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM");
        sb.append(" from");
        sb.append(" (");
        sb.append("   (select a.fassignid assignid, a.fbizobjid docid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
        sb.append("   b.fstatus status, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("   union");
        sb.append("   (select a.fassignid assignid, a.fbizobjid docid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
        sb.append("   b.fstatus status, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("  ) t");
        LOGGER.debug((Object)("===countSql===getProcess====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    private String getTodoProcessSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top ").append(pageNumber).append(" t.*");
        sb.append(" from");
        sb.append(" (");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
        sb.append("   b.fstatus status, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
        sb.append("   i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h, t_pm_user i");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("   union");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
        sb.append("   b.fstatus status, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
        sb.append("   i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g, t_dm_docarea h, t_pm_user i");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("  ) t");
        if (pageCount != 1) {
            sb.append(" where");
            sb.append(" t.assignid not in (select top ").append((pageCount - 1) * pageNumber).append(" t.assignid");
            sb.append("                   from");
            sb.append("                   (");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
            sb.append("                     b.fstatus status, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
            sb.append("                     i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
            sb.append("                     from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h, t_pm_user i");
            sb.append("                     where a.fassignid = b.fassignid and a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
            sb.append("                     and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
            sb.append("                     and c.fstate <> ").append(2);
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(")");
            sb.append("                     union");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fcreatedtime accepttime, a.flaststatetime laststatetime, b.fsender_").append(language.toString()).append(" sender,");
            sb.append("                     b.fstatus status, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
            sb.append("                     i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
            sb.append("                     from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g, t_dm_docarea h, t_pm_user i");
            sb.append("                     where a.fassignid = b.fassignid and a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
            sb.append("                     and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
            sb.append("                     and c.fstate <> ").append(2);
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(")");
            sb.append("                   ) t order by").append(this.getSortSqlByAuditingState(auditingState));
            sb.append("                   )");
        }
        sb.append(" order by").append(this.getSortSqlByAuditingState(auditingState));
        return sb.toString();
    }

    private String getFinishedProcessSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top ").append(pageNumber).append(" t.*");
        sb.append(" from");
        sb.append(" (");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
        sb.append("   a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
        sb.append("   i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fissuetime issuetime,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h, t_pm_user i");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("   union");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
        sb.append("   a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
        sb.append("   i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fissuetime issuetime,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g, t_dm_docarea h, t_pm_user i");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
        sb.append("   and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(")");
        sb.append("  ) t");
        if (pageCount != 1) {
            sb.append(" where");
            sb.append(" t.assignid not in (select top ").append((pageCount - 1) * pageNumber).append(" t.assignid");
            sb.append("                   from");
            sb.append("                   (");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
            sb.append("                     a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
            sb.append("                     i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fissuetime issuetime,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
            sb.append("                     from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h, t_pm_user i");
            sb.append("                     where a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
            sb.append("                     and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
            sb.append("                     and c.fstate <> ").append(2);
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(")");
            sb.append("                     union");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime accepttime, a.flaststatetime laststatetime,");
            sb.append("                     a.fstate status, a.finitiatorname_").append(language.toString()).append(" sender, c.fid docid, c.ftitle doctitle, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor,");
            sb.append("                     i.fname_").append(language.toString()).append(" creator, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fissuetime issuetime,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname");
            sb.append("                     from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_documentborrow e, t_dm_category g, t_dm_docarea h, t_pm_user i");
            sb.append("                     where a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and a.fpersonuserid = '").append(ctx.getCaller().toString()).append("'");
            sb.append("                     and a.fbizobjid = e.fid and c.fauthorid = d.fid and c.fid = e.fdocumentid and c.fcategoryid = g.fid and g.fdocareaid = h.fid and c.fcreatorid = i.fid");
            sb.append("                     and c.fstate <> ").append(2);
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(")");
            sb.append("                   ) t order by").append(this.getSortSqlByAuditingState(auditingState));
            sb.append("                   )");
        }
        sb.append(" order by").append(this.getSortSqlByAuditingState(auditingState));
        return sb.toString();
    }

    public void setAssignRead(Context ctx, String assignId) {
        StringBuilder sb = new StringBuilder();
        sb.append("update T_BAS_AssignRead");
        sb.append(" set fstatus = 10");
        sb.append(" where FASSIGNID = '").append(assignId).append("'");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private String getSortSqlByAuditingState(String auditingState) {
        StringBuilder sb = new StringBuilder();
        sb.append(" t.accepttime");
        sb.append(" desc");
        return sb.toString();
    }

    private String getSortSqlByAuditingState(String auditingState, String lastUpdaterTime) {
        StringBuilder sb = new StringBuilder();
        if (FINISHED.equals(auditingState)) {
            sb.append(" t.accepttime desc, t.endtime desc");
        } else {
            sb.append(" t.accepttime desc");
        }
        return sb.toString();
    }

    private String getSqlByCondition(Locale language, String condition) {
        if (null != condition && !"".equals(condition.trim())) {
            StringBuilder sb = new StringBuilder();
            sb.append(" and (c.ftitle like '%").append(condition).append("%'");
            sb.append(" or c.fdocMarkNumber like '%").append(condition).append("%'");
            sb.append(" or c.fsummary like '%").append(condition).append("%'");
            sb.append(" or c.ftag like '%").append(condition).append("%'");
            sb.append(" or d.fname_").append(language.toString()).append(" like '%").append(condition).append("%')");
            return sb.toString();
        }
        return "";
    }

    private String getSqlByAuditingState(String auditingState) {
        StringBuilder sb = new StringBuilder();
        if (TODO.equals(auditingState)) {
            sb.append(" and (a.FSTATE=").append(1);
            sb.append(" or a.FSTATE=").append(2);
            sb.append(" or a.FSTATE=").append(32).append(")");
        } else if (FINISHED.equals(auditingState)) {
            sb.append(" and (a.FSTATE=").append(4);
            sb.append(" or a.FSTATE=").append(16);
            sb.append(" or a.FSTATE=").append(8).append(")");
        } else if (ALL.equals(auditingState)) {
            sb.append("");
        } else {
            sb.append(" and a.FSTATE=0");
        }
        return sb.toString();
    }

    private String getReadState(String readState, String auditingState) {
        if (TODO.equals(auditingState)) {
            if ("10".equals(readState)) {
                return "\u5df2\u8bfb";
            }
            return "\u672a\u8bfb";
        }
        if (FINISHED.equals(auditingState)) {
            try {
                return WfAssignmentState.getEnum((int)Integer.parseInt(readState)).getAlias();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "\u672a\u5b8c\u6210";
            }
        }
        return "";
    }

    private DmState getDmState(int state) {
        if (0 == state) {
            return DmState.DISABLE;
        }
        if (1 == state) {
            return DmState.ENABLE;
        }
        if (2 == state) {
            return DmState.DELETE;
        }
        return null;
    }

    public int getProcessMyPutoutCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        int count = 0;
        if (TODO.equals(auditingState)) {
            count = this.getTotoProcessMyPutoutCount(ctx, language, auditingState, condition);
        } else if (FINISHED.equals(auditingState)) {
            count = this.getFinishProcessMyPutoutCount(ctx, language, auditingState, condition);
        }
        return count;
    }

    public int getFinishProcessMyPutoutCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fcreatorid = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
        sb.append("   and c.fstate <> ").append(2).append(" and c.fwfstate in (3,4,5)");
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null));
        LOGGER.debug((Object)("===countSql===getProcess====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    public int getTotoProcessMyPutoutCount(Context ctx, Locale language, String auditingState, String condition) throws ProcCatalogException {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) NUM");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fCreatePersonID = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null));
        sb.append(" and a.fassignid = (select max(fassignid) from t_wfr_assign where fbizobjid = c.fid) ");
        LOGGER.debug((Object)("===countSql===getProcess====" + sb.toString()));
        int count = 0;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt("NUM");
            }
        }
        catch (Exception sqlException) {
            LOGGER.info((Object)("sqlException.getMessage(): " + sqlException.getMessage()));
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return count;
    }

    public ArrayList getDocumentProcessMyPutoutByUserAndLanaguage(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) throws BOSException, EASBizException {
        String strSql = null;
        if (TODO.equals(auditingState)) {
            strSql = this.getTodoProcessMyPutoutSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        } else if (FINISHED.equals(auditingState)) {
            strSql = this.getFinishedProcessMyPutoutSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        }
        LOGGER.debug((Object)("===strSql===getProcess====" + strSql));
        ArrayList list = new ArrayList();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
            for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rowSet.getString("assignid"));
                map.put("bizId", rowSet.getString("bizid"));
                map.put("docId", rowSet.getString("docid"));
                map.put("title", rowSet.getString("doctitle"));
                map.put("docauthor", rowSet.getString("docauthor"));
                map.put("categoryName", rowSet.getString("categoryname"));
                map.put("docAreaName", rowSet.getString("docareaname"));
                map.put("attach", rowSet.getString("attach"));
                if (TODO.equals(auditingState)) {
                    map.put("currentPerson", rowSet.getObject("currentperson"));
                    map.put("createTime", rowSet.getString("accepttime"));
                    map.put("commentCount", rowSet.getObject("commentCount") == null ? "0" : rowSet.getObject("commentCount"));
                } else if (FINISHED.equals(auditingState)) {
                    map.put("createTime", rowSet.getString("doccreatetime"));
                    map.put("issueTime", rowSet.getString("accepttime"));
                    map.put("endTime", rowSet.getString("endtime"));
                    map.put("state", rowSet.getString("state"));
                    map.put("readCount", rowSet.getString("readcount") == null ? "0" : rowSet.getString("readcount"));
                    map.put("recommendCount", rowSet.getString("recommendCount") == null ? "0" : rowSet.getString("recommendCount"));
                    map.put("category.id", rowSet.getString("categoryid"));
                    map.put("createPerson.id", rowSet.getString("createpersonid"));
                    map.put("wfState", (Object)DocWfState.getEnum(rowSet.getInt("state")));
                    map.put("category.state", (Object)DmState.getEnum(rowSet.getInt("catstate")));
                }
                list.add(map);
            }
        }
        catch (Exception sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    public List<ContentListDTO> getDoProcessMyPutoutByUser(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) throws BOSException, EASBizException {
        String strSql = null;
        if (TODO.equals(auditingState)) {
            strSql = this.getTodoProcessMyPutoutSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        } else if (FINISHED.equals(auditingState)) {
            strSql = this.getFinishedProcessMyPutoutSql(ctx, language, pageCount, pageNumber, auditingState, condition);
        }
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)strSql);
            for (int i = 0; i < pageNumber && rowSet.next(); ++i) {
                ContentListDTO ct = new ContentListDTO();
                ct.setId(rowSet.getString("docid"));
                ct.setAssinId(rowSet.getString("assignid"));
                ct.setBizId(rowSet.getString("bizid"));
                ct.setTitle(rowSet.getString("doctitle"));
                ct.setAuthorName(rowSet.getString("docauthor"));
                ct.setColumnName(rowSet.getString("categoryname"));
                ct.setAreaName(rowSet.getString("docareaname"));
                if (TODO.equals(auditingState)) {
                    ct.setState("\u5ba1\u6838\u4e2d");
                    ct.setDistbuteTime(rowSet.getString("accepttime"));
                } else if (FINISHED.equals(auditingState)) {
                    // empty if block
                }
                list.add(ct);
            }
        }
        catch (Exception sqlException) {
            throw new ProcCatalogException(ProcCatalogException.ERROR_GET_PROCESS, (Throwable)sqlException);
        }
        return list;
    }

    private String getTodoProcessMyPutoutSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top ").append(pageNumber).append(" t.*");
        sb.append(" from");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fpersonusername_").append(language.toString()).append(" currentperson,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname,");
        sb.append("   c.fid docid, c.ftitle doctitle, c.fcreatetime accepttime, c.fcommentcount commentCount, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
        sb.append("   from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
        sb.append("   where a.fassignid = b.fassignid and a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fCreatePersonID = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
        sb.append("   and c.fstate <> ").append(2);
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(") t");
        if (pageCount != 1) {
            sb.append(" where");
            sb.append(" t.assignid not in (select top ").append((pageCount - 1) * pageNumber).append(" t.assignid");
            sb.append("                   from");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fpersonusername_").append(language.toString()).append(" currentperson,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, h.fname_").append(language.toString()).append(" docareaname,");
            sb.append("                     c.fid docid, c.ftitle doctitle, c.fcreatetime accepttime, c.fcommentcount commentCount, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor");
            sb.append("                     from t_wfr_assign a, t_bas_assignread b, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
            sb.append("                     where a.fassignid = b.fassignid and a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fCreatePersonID = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()).append("'");
            sb.append("                     and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
            sb.append("                     and c.fstate <> ").append(2);
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(") t");
            sb.append("                   order by").append(this.getSortSqlByAuditingState(auditingState));
            sb.append("                   )");
            sb.append(" and ");
        } else {
            sb.append(" where ");
        }
        sb.append(" t.assignid = (select max(fassignid) from t_wfr_assign where fbizobjid = t.docid)");
        sb.append(" order by").append(this.getSortSqlByAuditingState(auditingState));
        return sb.toString();
    }

    private String getFinishedProcessMyPutoutSql(Context ctx, Locale language, int pageCount, int pageNumber, String auditingState, String condition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select top ").append(pageNumber).append(" t.*");
        sb.append(" from");
        sb.append("   (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime endtime,");
        sb.append("\t  g.fname_").append(language.toString()).append(" categoryname, g.fid categoryid, g.fstate catstate, h.fname_").append(language.toString()).append(" docareaname,");
        sb.append("   c.fid docid, c.fcreatepersonid createpersonid, c.ftitle doctitle, c.fcreatetime doccreatetime, c.fissuetime accepttime, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor, c.fwfstate state, c.freadcount readcount, c.frecommendCount recommendCount");
        sb.append("   from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
        sb.append("   where a.fissendmsg = 1");
        sb.append("   and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fcreatorid = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sb.append("   and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
        sb.append("   and c.fstate <> ").append(2).append(" and c.fwfstate in (3,4,5)");
        sb.append("   ").append(this.getSqlByAuditingState(auditingState));
        sb.append("   ").append(this.getSqlByCondition(language, condition, null)).append(") t");
        if (pageCount != 1) {
            sb.append(" where");
            sb.append(" t.assignid not in (select top ").append((pageCount - 1) * pageNumber).append(" t.assignid");
            sb.append("                   from");
            sb.append("                     (select a.fassignid assignid, a.fbizobjid bizid, a.fsubject_").append(language.toString()).append(" title, a.fendtime endtime,");
            sb.append("\t                    g.fname_").append(language.toString()).append(" categoryname, g.fid categoryid, g.fstate catstate, h.fname_").append(language.toString()).append(" docareaname,");
            sb.append("                     c.fid docid, c.fcreatepersonid createpersonid, c.ftitle doctitle, c.fcreatetime doccreatetime, c.fissuetime accepttime, case when c.fdisplayattachnumber > 0 then concat(concat(concat(convert(varchar, c.fdisplayattachnumber), '('), c.fdisplayattachsize), ')') else '' end attach, c.fdocmarknumber docnumber, c.fsummary docsummary, c.ftag doctag, d.fname_").append(language.toString()).append(" docauthor, c.fwfstate state, c.freadcount readcount");
            sb.append("                     from t_wfr_assigndetail a, t_dm_document c, t_bd_person d, t_dm_category g, t_dm_docarea h");
            sb.append("                     where a.fissendmsg = 1");
            sb.append("                     and a.fbillentity like 'com.kingdee.eas.cp.dm%' and c.fcreatorid = '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
            sb.append("                     and a.fbizobjid = c.fid and c.fauthorid = d.fid and c.fcategoryid = g.fid and g.fdocareaid = h.fid");
            sb.append("                     and c.fstate <> ").append(2).append(" and c.fwfstate in (3,4,5)");
            sb.append("                     ").append(this.getSqlByAuditingState(auditingState));
            sb.append("                     ").append(this.getSqlByCondition(language, condition, null)).append(") t");
            sb.append("                   order by").append(this.getSortSqlByAuditingState(auditingState, null));
            sb.append("                   )");
        }
        sb.append(" order by").append(this.getSortSqlByAuditingState(auditingState, null));
        return sb.toString();
    }

    private String getSqlByCondition(Locale language, String condition, String cat) {
        if (null != condition && !"".equals(condition.trim())) {
            StringBuilder sb = new StringBuilder();
            sb.append(" and (c.ftitle like '%").append(condition).append("%'");
            sb.append(" or c.fdocMarkNumber like '%").append(condition).append("%'");
            sb.append(" or c.fsummary like '%").append(condition).append("%'");
            sb.append(" or c.ftag like '%").append(condition).append("%'");
            sb.append(" or d.fname_").append(language.toString()).append(" like '%").append(condition).append("%'");
            sb.append(" or g.fname_").append(language.toString()).append(" like '%").append(condition).append("%')");
            return sb.toString();
        }
        return "";
    }

    public static DmDocumentFlowDaoImp getInstance() {
        return null == dmDocFlowDaoImp ? new DmDocumentFlowDaoImp() : dmDocFlowDaoImp;
    }
}

