/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.web.service.DefaultDmPermissionService;
import com.kingdee.eas.cp.dm.web.util.CommonUtils;
import com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo;
import com.kingdee.eas.cp.dm.web.util.RequestUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class PermissionUtil {
    public static Logger logger = Logger.getLogger(PermissionUtil.class);
    public static final String T_DM_CATEGORY = "t_dm_category";
    public static final String T_DM_DIMENSION = "t_dm_dimension";
    public static final String T_DM_DOCAREA = "t_dm_docarea";
    public static final String T_DM_DOCUMENT = "t_dm_document";
    private static Map<String, Set<String>> permissionCache = null;
    private static Context servletCtx;
    private static List dmPermListCache;

    public static void generateCurrentUserPermission(HttpServletRequest request, Context ctx) {
        Boolean isTopCatUser = false;
        Boolean isTopDimUser = false;
        try {
            isTopCatUser = DefaultDmPermissionService.getInstance().hasTopCatPermission(ctx);
            isTopDimUser = DefaultDmPermissionService.getInstance().hasTopDimPermission(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        RequestUtil.setSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isTopCatUser", isTopCatUser);
        RequestUtil.setSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isTopDimUser", isTopDimUser);
    }

    public static Boolean isTopCatUser(HttpServletRequest request, Context ctx) {
        Boolean o = (Boolean)RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isTopCatUser");
        return null == o ? Boolean.FALSE : o;
    }

    public static Boolean isTopDimUser(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isTopDimUser");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerTempleteType(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerTempleteType");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerTempleteManage(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerTempleteManage");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerTag(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerTag");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerPortletAddNew(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerPortletAddNew");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerPortletUpdate(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerPortletUpdate");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerPortletDelete(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerPortletDelete");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerPortletCancelCancel(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerPortletCancelCancel");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerPortletCancel(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerPortletCancel");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerAttachmentSet(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerAttachmentSet");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerDocManageParametersSet(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerDocManageParametersSet");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static Boolean isPerDocReadHis(HttpServletRequest request, Context ctx) {
        Object o = RequestUtil.getSessionValue(request, PermissionUtil.getCurrentUserIdentity(ctx) + "_" + "isPerDocReadHis");
        return null == o ? Boolean.FALSE : (Boolean)o;
    }

    public static boolean hasPermissionByPermissionItem(HttpServletRequest request, Context ctx, String permissionItem) {
        logger.info((Object)("hasPermissionByPermissionItem()---------------------innnnnnnnnnnnnn:" + permissionItem));
        boolean hasFunctionPermission = false;
        String key = "hasPermissionByPermissionItem_" + permissionItem + "_" + PermissionUtil.getCurrentUserId(ctx) + "_" + PermissionUtil.getCurrentPersonId(ctx);
        Object obj = RequestUtil.getSessionValue(request, key);
        if (obj == null) {
            try {
                BOSUuid userObj = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
                BOSUuid orgObj = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId();
                ObjectUuidPK userPK = new ObjectUuidPK(userObj);
                ObjectUuidPK orgPK = new ObjectUuidPK(orgObj);
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                hasFunctionPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, permissionItem);
                logger.info((Object)("hasPermissionByPermissionItem()-----------hasFunctionPermission:" + hasFunctionPermission));
                RequestUtil.setSessionValue(request, key, new Boolean(hasFunctionPermission));
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            hasFunctionPermission = (Boolean)obj;
        }
        return hasFunctionPermission;
    }

    public static Map<String, Set<String>> getHasPermCatIdMap(Context ctx, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        Map<String, Set<String>> rtnMap = DefaultDmPermissionService.getInstance().getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName);
        return rtnMap;
    }

    public static Map<String, Set<String>> getLeftTreeCatIdMap(Context ctx, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        Map<String, Set<String>> rtnMap = new HashMap<String, Set<String>>();
        try {
            rtnMap = DefaultDmPermissionService.getInstance().getLeftTreeCatIdMap(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rtnMap;
    }

    public static Map<String, Set<String>> getHasPermCatIdMap(HttpServletRequest req, Context ctx, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        String userId = PermissionUtil.getCurrentUserId(req);
        String perId = PermissionUtil.getCurrentPersonId(req);
        String key = "getHasPermCatIdMap_" + userId + "_" + perId + "_" + bizIdSet;
        Map<String, Set<String>> rtnMap = null;
        rtnMap = DefaultDmPermissionService.getInstance().getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName);
        return rtnMap;
    }

    public static Set<String> getHasPermCatIdSet(Context ctx, Set<String> operStrNumSet, String bizId, String bizTableName) {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        Set<String> rtnSet = null;
        rtnSet = DefaultDmPermissionService.getInstance().getHasPermCatIdSet(ctx, perId, userId, operStrNumSet, bizId, bizTableName);
        return rtnSet;
    }

    public static boolean hasLv1DimPermission(HttpServletRequest request, DimensionInfo dimInfo) throws BOSException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String key = "hasLv1DimPermission_" + dimInfo.getId().toString();
        boolean rtnVal = false;
        rtnVal = DefaultDmPermissionService.getInstance().hasLv1DimPermission(ctx, dimInfo);
        return rtnVal;
    }

    public static Map<String, Set<String>> getHasPermDimIdMap(Context ctx, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) throws BOSException {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        String key = "getHasPermCatIdMap_" + userId + "_" + perId + "_" + bizIdSet;
        Map<String, Set<String>> rtnMap = null;
        rtnMap = DefaultDmPermissionService.getInstance().getHasPermDimIdMap(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, new int[]{1});
        return rtnMap;
    }

    public static boolean checkHasPermission(Context ctx, String operStr, String bizId, String bizTableName) throws BOSException {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        String key = "checkHasPermission_" + userId + "_" + perId + "_" + bizId;
        boolean rtnVal = false;
        if (T_DM_CATEGORY.equals(bizTableName)) {
            Set<String> permSet = DefaultDmPermissionService.getPermByPersonID(ctx, perId, bizId, bizTableName);
            rtnVal = permSet.contains(operStr);
        } else {
            rtnVal = DefaultDmPermissionService.getInstance().checkHasPermission(ctx, perId, userId, operStr, bizId, bizTableName);
        }
        return rtnVal;
    }

    public static boolean checkSpecialDocPermission(Context ctx, String operStr, String docId) {
        boolean rtnVal = false;
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        Set<String> documentPermSet = DefaultDmPermissionService.getPermByPersonID(ctx, perId, docId, T_DM_DOCUMENT);
        if (documentPermSet.contains("20") || documentPermSet.contains("8") || documentPermSet.contains("13")) {
            documentPermSet.add("4");
        }
        rtnVal = documentPermSet.contains(operStr);
        return rtnVal;
    }

    public static boolean hasSpecialDocInCategory(Context ctx, String catId) {
        boolean rtnVal = false;
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        String userId = PermissionUtil.getCurrentUserId(ctx);
        rtnVal = DefaultDmPermissionService.hasSpecialPermDocInCategory(ctx, perId, userId, catId, null);
        return rtnVal;
    }

    public static boolean hasSpecialDocPermissions(Context ctx, String docId) {
        boolean rtnVal = false;
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        Set<String> documentPermSet = DefaultDmPermissionService.getPermByPersonID(ctx, perId, docId, T_DM_DOCUMENT);
        rtnVal = !documentPermSet.isEmpty();
        return rtnVal;
    }

    public static boolean checkHasPermission(Context ctx, Set<String> operStrNumSet, String bizId, String bizTableName) throws BOSException {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        boolean rtnVal = false;
        Iterator<String> iter = operStrNumSet.iterator();
        String operStrNumStr = "";
        while (iter.hasNext()) {
            String perMission = iter.next();
            operStrNumStr = operStrNumStr + perMission + ",";
        }
        if (operStrNumStr.endsWith(",")) {
            operStrNumStr = operStrNumStr.substring(0, operStrNumStr.length() - 1);
        }
        rtnVal = DefaultDmPermissionService.getInstance().checkHasPermission(ctx, perId, userId, operStrNumStr, bizId, bizTableName);
        return rtnVal;
    }

    public static Map<String, Set<String>> getBizPermMap(Context ctx, String bizId, String bizTableName) {
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        String key = "getBizPermMap_" + userId + "_" + perId + "_" + bizId;
        Map<String, Set<String>> rtnMap = null;
        rtnMap = DefaultDmPermissionService.getInstance().getBizPermMap(ctx, perId, userId, bizId, bizTableName);
        return rtnMap;
    }

    public static String getCurrentUserIdentity(Context ctx) {
        return PermissionUtil.getCurrentUserId(ctx) + "_" + PermissionUtil.getCurrentPersonId(ctx);
    }

    public static String getCurrentPersonId(Context ctx) {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String rtnVal = "";
        if (personInfo != null) {
            rtnVal = personInfo.getId().toString();
        }
        return rtnVal;
    }

    public static String getCurrentPersonId(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        String rtnVal = "";
        if (personInfo != null) {
            rtnVal = personInfo.getId().toString();
        }
        return rtnVal;
    }

    public static String getCurrentUserId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String rtnVal = "";
        if (userInfo != null) {
            rtnVal = userInfo.getId().toString();
        }
        return rtnVal;
    }

    public static String getCurrentUserId(HttpServletRequest request) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String rtnVal = "";
        if (userInfo != null) {
            rtnVal = userInfo.getId().toString();
        }
        return rtnVal;
    }

    public static Context getServletCtx() {
        return servletCtx;
    }

    public static void setServletCtx(Context servletCtx) {
        PermissionUtil.servletCtx = servletCtx;
    }

    public static boolean hasBizPermission(Context ctx, String bizId, String permissionItem) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String bizTableName = T_DM_CATEGORY;
        Map<String, Set<String>> permssionMap = PermissionUtil.getBizPermMap(ctx, bizId, bizTableName);
        Set<String> perssionSet = null;
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = permssionMap.get(perId + bizId);
        }
        return perssionSet.contains(permissionItem);
    }

    public static boolean hasSpecialPermOrCategoryPerm(Context ctx, String docId, String categoryId, String docPermItem, String catePermItem) {
        DocumentInfo documentModel = null;
        try {
            documentModel = DocumentFactory.getLocalInstance(ctx).getDocumentInfo((IObjectPK)new ObjectUuidPK(docId));
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashSet<String> specialPermSet = new HashSet<String>();
        specialPermSet.add("4");
        specialPermSet.add("20");
        specialPermSet.add("5");
        specialPermSet.add("8");
        boolean rtnVal = false;
        if (documentModel != null && documentModel.isIsEnablePerm() && DocWfState.PUBLISH.equals((Object)documentModel.getWfState()) && specialPermSet.contains(docPermItem)) {
            rtnVal = PermissionUtil.checkSpecialDocPermission(ctx, docPermItem, docId);
        }
        if (documentModel != null && !documentModel.isIsEnablePerm() && !rtnVal) {
            rtnVal = PermissionUtil.hasBizPermission(ctx, categoryId, catePermItem);
        }
        return rtnVal;
    }

    public static boolean hasManagementPerm(String bizId) {
        return false;
    }

    public static void initPermListCache(Context ctx) {
        String personId = CommonUtils.getPersonId(ctx);
        StringBuffer getAllAdminSql = new StringBuffer();
        getAllAdminSql.append("select ADMINP.fname_l2,ADMINP.flongnumber,ADMINP.fnumber,person.fname_l2,person.fid  \n");
        getAllAdminSql.append("FROM T_BD_PERSON PERSON \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID \n");
        getAllAdminSql.append("LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID \n");
        getAllAdminSql.append("where PERSON.fid='");
        getAllAdminSql.append(personId);
        getAllAdminSql.append("'");
        Set rtnSet = PermissionUtil.getAllAdminSqlMethd(ctx, getAllAdminSql);
        ArrayList<String> adminNumList = null;
        if (null != rtnSet && rtnSet.size() > 0) {
            adminNumList = new ArrayList<String>(rtnSet.size());
            for (String number : rtnSet) {
                adminNumList.add(number);
            }
        }
        DefaultDmPermissionService dservice = DefaultDmPermissionService.getInstance();
        StringBuffer sb = dservice.getAllPermByPersonSql(personId, adminNumList);
        List list = dservice.getDmPermListCacheBySql(ctx, sb);
        PermissionUtil.setDmPermListCache(list);
    }

    public static Set getAllAdminSqlMethd(Context ctx, StringBuffer getAllAdminSql) {
        HashSet<String> rtnSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getAllAdminSql.toString());
            while (rs.next()) {
                String adminLongNum = rs.getString("flongnumber");
                if (null == adminLongNum || "".equals(adminLongNum)) continue;
                String[] as = adminLongNum.split("!");
                int len = as.length;
                for (int i = 0; i < len; ++i) {
                    rtnSet.add(as[i]);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtnSet;
    }

    public static void clearDirtyPermData(Context ctx) {
        DefaultDmPermissionService.getInstance().clearDirtyPermData(ctx);
    }

    public static List getDmPermListCache() {
        return dmPermListCache;
    }

    public static void setDmPermListCache(List dmPermListCache) {
        PermissionUtil.dmPermListCache = dmPermListCache;
    }

    public static void clearDmPermListCache() {
        PermissionUtil.setDmPermListCache(null);
    }

    public static String getPermissionByDocIds(Context ctx, String docIds) {
        String permissionStr = "";
        if (null == docIds || "".equals(docIds)) {
            return permissionStr;
        }
        List list = PermissionUtil.getDmPermListCache();
        if (null == list || list.size() == 0) {
            return permissionStr;
        }
        String perm = null;
        ArrayList<String> permSet = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            DmPermCacheInfo doc = (DmPermCacheInfo)list.get(i);
            String string = perm = null != doc.getPermList() ? doc.getPermList() : "";
            if (null == doc.getDocID() || !docIds.contains(doc.getDocID())) continue;
            permSet.add(perm);
        }
        if (docIds.split(",").length != permSet.size()) {
            return "";
        }
        if (permSet.size() == 0) {
            permissionStr = "";
        } else if (permSet.size() == 1) {
            permissionStr = (String)permSet.get(0);
        } else {
            String tempPerm = (String)permSet.get(0);
            String[] hasPermStr = tempPerm.split(",");
            for (int i = 0; i < hasPermStr.length; ++i) {
                int findCount = 0;
                block2: for (int j = 1; j < permSet.size(); ++j) {
                    String[] temp;
                    for (String s : temp = ((String)permSet.get(j)).split(",")) {
                        if (!s.equals(hasPermStr[i])) continue;
                        ++findCount;
                        continue block2;
                    }
                }
                if (findCount != permSet.size() - 1) continue;
                permissionStr = permissionStr + hasPermStr[i] + ",";
            }
            if (permissionStr.length() > 0) {
                permissionStr = permissionStr.substring(0, permissionStr.length() - 1);
            }
        }
        return permissionStr;
    }
}

