/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.cp.eps.IScene;
import com.kingdee.eas.cp.eps.SceneCollection;
import com.kingdee.eas.cp.eps.SceneFactory;
import com.kingdee.eas.cp.eps.SceneInfo;
import com.kingdee.eas.cp.eps.SceneParameterInfo;
import com.kingdee.eas.cp.eps.SceneTypeInfo;
import com.kingdee.eas.cp.eps.app.AbstractSceneWordFacadeControllerBean;
import com.kingdee.eas.cp.eps.utils.EPSUtils;
import com.kingdee.eas.cp.eps.utils.WorkflowApplication;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SceneWordFacadeControllerBean
extends AbstractSceneWordFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eps.app.SceneWordFacadeControllerBean");

    protected boolean _refreshScene(Context ctx) throws BOSException {
        this.refreshPersonName(ctx);
        this.refreshFlowNameWithBill(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_EPS_SceneParameters ");
        sql.append("where not exists ( ");
        sql.append("\tselect fid from t_eps_scene where t_eps_scene.fid = T_EPS_SceneParameters.fparentid) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return true;
    }

    private void refreshPersonName(Context ctx) throws BOSException {
        this.deleteSceneByType(ctx, EPSUtils.sceneType_person);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_eps_scene(FID,FNAME_L2,FSceneTypeID,FKey1,FKey2,FPluginClass) ");
        sql.append("select dbo.newbosid('37CE2A9D'),FNAME_L2,'egsx6koknEqhsa9SA0iNp/l1l3c=',ffullnamepingyin,fsimplenamepingyin,'com.kingdee.eas.cp.eps.scene.AdrScene' from (");
        sql.append("select distinct \"PERSON\".FNAME_L2 ,ffullnamepingyin,fsimplenamepingyin ");
        sql.append("from t_bd_person \"PERSON\" ");
        sql.append("LEFT OUTER JOIN T_HR_BDEmployeeType AS \"EMPTYPE\" ");
        sql.append("ON \"PERSON\".FEmployeeTypeID = \"EMPTYPE\".FID ");
        sql.append("WHERE \"EMPTYPE\".FinService NOT IN (0, 2, 3) AND \"PERSON\".FDeletedStatus = 1 ) t");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.deleteSceneByType(ctx, EPSUtils.sceneType_personalAdr);
        sql = new StringBuffer();
        sql.append("insert into t_eps_scene(FID,FNAME_L2,FSceneTypeID,FKey1,FKey2,FPluginClass) ");
        sql.append("select dbo.newbosid('37CE2A9D'),FNAME_L2,'" + EPSUtils.sceneType_personalAdr + "',ffullnamepingyin,fsimplenamepingyin,'com.kingdee.eas.cp.eps.scene.AdrScene' from (");
        sql.append("select distinct \"PERSON\".FNAME_L2 ,ffullnamepingyin,fsimplenamepingyin ");
        sql.append("from t_adr_contact \"PERSON\" where not exists (select scene.fid from t_eps_scene scene where scene.fname_l2 = \"PERSON\".FNAME_L2 ) ) t ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void refreshFlowNameWithBill(Context ctx) throws BOSException {
        this.deleteSceneByType(ctx, EPSUtils.sceneType_flowName);
        this._refreshFlow4Normal(ctx);
        this._refreshFlow4DynWeb(ctx);
    }

    private void _refreshFlow4Normal(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select procdef.fname_l2 as fname, ");
        sql.append("procdef.fprocdefid as procdefid , procdef.fmd5hash as fmd5hash ,procdef.fpackagename as packagename ");
        sql.append("from t_wfr_procdef procdef,(select fprocdefid,max(finnerversion) finnerversion ");
        sql.append("  from t_wfr_procdef group by fprocdefid) m ");
        sql.append("where procdef.fprocdefid = m.fprocdefid  ");
        sql.append("and procdef.finnerversion = m.finnerversion ");
        sql.append("and procdef.fpackagename like 'com.kingdee.eas.cp%' ");
        sql.append("and procdef.fpackagename not like 'com.kingdee.eas.cp.wfm%' ");
        sql.append("and procdef.fpackagename not like 'com.kingdee.eas.cp.odm%' ");
        sql.append("order by  procdef.fprocdefid ");
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String formid = "";
            boolean isDyn = false;
            while (rs.next()) {
                formid = "";
                isDyn = false;
                try {
                    BOSObjectType[] bosTypes = ((EnactmentService)wfService).getRelatedEntityTypes(rs.getString("procdefid"));
                    if ((bosTypes == null || bosTypes.length < 1) && "com.kingdee.eas.cp.wp".indexOf(rs.getString("packagename")) > -1) {
                        if (rs.getString("fname").indexOf("\u5de5\u4f5c\u8ba1\u5212") > -1) {
                            bosTypes = new BOSObjectType[]{BOSObjectType.create((String)"BB5BF100")};
                            formid = "ONwynakIRLuOhibkCBjaVZp+rpI=";
                        } else if (rs.getString("fname").indexOf("\u76ee\u6807\u8d23\u4efb\u4e66") > -1) {
                            bosTypes = new BOSObjectType[]{BOSObjectType.create((String)"0E200A90")};
                            formid = "jTsG5z41QsC1OLqaj8Alnpp+rpI=";
                        } else if (rs.getString("fname").indexOf("\u6307\u4ee4\u5355") > -1) {
                            bosTypes = new BOSObjectType[]{BOSObjectType.create((String)"F3721D58")};
                            formid = "rIBYCJ6+RSyMOASOFTHtxZp+rpI=";
                        }
                        isDyn = true;
                    }
                    if (bosTypes == null || bosTypes.length <= 0) continue;
                    EntityObjectInfo eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bosTypes[0]);
                    SceneInfo si = new SceneInfo();
                    SceneTypeInfo sceneType = new SceneTypeInfo();
                    sceneType.setId(BOSUuid.read((String)EPSUtils.sceneType_flowName));
                    si.setSceneType(sceneType);
                    si.setName(eoi.getAlias() + "(" + rs.getString("fname") + ")", new Locale("L2"));
                    si.setPluginClass(EPSUtils.flow_class);
                    String tempid = BOSUuid.create((BOSObjectType)bosTypes[0]).toString();
                    SceneParameterInfo sp = new SceneParameterInfo();
                    sp.setName("billID");
                    sp.setValue(tempid.substring(23));
                    SceneParameterInfo sp1 = new SceneParameterInfo();
                    sp1.setName("canEdit");
                    sp1.setValue(EPSUtils.canEdit(rs.getString("packagename")) ? "1" : "0");
                    SceneParameterInfo sp2 = new SceneParameterInfo();
                    sp2.setName("bosType");
                    sp2.setValue(bosTypes[0].toString());
                    SceneParameterInfo sp3 = new SceneParameterInfo();
                    sp3.setName("procdefID");
                    sp3.setValue(rs.getString("procdefid"));
                    SceneParameterInfo sp4 = new SceneParameterInfo();
                    sp4.setName("url");
                    if ("F3B7A431".equals(bosTypes[0].toString())) {
                        sp4.setValue("/cp/dm/categoryAddnewDocF7.jsf?fromSrc=outer");
                    } else if (isDyn) {
                        sp4.setValue("/servlet/BillServlet");
                    } else {
                        sp4.setValue(WorkflowApplication.getURL(ctx, bosTypes[0].toString()));
                    }
                    si.getParameters().add(sp);
                    si.getParameters().add(sp1);
                    si.getParameters().add(sp2);
                    si.getParameters().add(sp3);
                    si.getParameters().add(sp4);
                    if (!StringUtils.isEmpty((String)formid)) {
                        SceneParameterInfo sp5 = new SceneParameterInfo();
                        sp5.setName("formid");
                        sp5.setValue(formid);
                        si.getParameters().add(sp5);
                    }
                    try {
                        ProcessDef pd = wfService.getProcessDefByDefineHashValue(rs.getString("fmd5hash"));
                        if (!StringUtils.isEmpty((String)pd.getProcessHeader().getDescription(ctx.getLocale()))) {
                            si.setDescription(pd.getProcessHeader().getDescription(ctx.getLocale()));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    si.setKey1(eoi.getAlias().toLowerCase());
                    si.setKey2(rs.getString("fname").toLowerCase());
                    try {
                        SceneFactory.getLocalInstance(ctx).save((CoreBaseInfo)si);
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void _refreshFlow4DynWeb(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select form.fid as formid,form.fbostype as bostype, ");
        sql.append("temp.fid as templateid,temp.fname_l2 as billname, temp.fdescription_l2 as description, ");
        sql.append("flowdef.fprocdefid as procdefid, flowdef.fname_l2 as flowname , flowdef.fmd5hash as fmd5hash ");
        sql.append("from t_bas_template temp,t_bas_templateworkflow tempflow,t_bas_form form,( ");
        sql.append("select procdef.fname_l2, ");
        sql.append("procdef.fprocdefid, procdef.fmd5hash as fmd5hash ");
        sql.append("from t_wfr_procdef procdef,(select fprocdefid,max(finnerversion) finnerversion ");
        sql.append("  from t_wfr_procdef group by fprocdefid) m ");
        sql.append("where procdef.fprocdefid = m.fprocdefid  ");
        sql.append("and procdef.finnerversion = m.finnerversion) flowdef ");
        sql.append("where temp.fid = tempflow.fparentid   ");
        sql.append(" and tempflow.fflowid = flowdef.fprocdefid ");
        sql.append("and form.fid = temp.fformid ");
        IEnactmentService wfService = EnactmentServiceProxy.getEnacementService((Context)ctx);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                SceneInfo si = new SceneInfo();
                SceneTypeInfo sceneType = new SceneTypeInfo();
                sceneType.setId(BOSUuid.read((String)EPSUtils.sceneType_flowName));
                si.setSceneType(sceneType);
                si.setName(rs.getString("billname") + "(" + rs.getString("flowname") + ")");
                si.setPluginClass(EPSUtils.flow_class);
                String tempid = BOSUuid.create((String)rs.getString("bostype")).toString();
                SceneParameterInfo sp = new SceneParameterInfo();
                sp.setName("billID");
                sp.setValue(tempid.substring(23));
                SceneParameterInfo sp1 = new SceneParameterInfo();
                sp1.setName("canEdit");
                sp1.setValue("1");
                SceneParameterInfo sp2 = new SceneParameterInfo();
                sp2.setName("bosType");
                sp2.setValue(rs.getString("bostype"));
                SceneParameterInfo sp3 = new SceneParameterInfo();
                sp3.setName("procdefID");
                sp3.setValue(rs.getString("procdefid"));
                SceneParameterInfo sp4 = new SceneParameterInfo();
                sp4.setName("formid");
                sp4.setValue(rs.getString("formid"));
                SceneParameterInfo sp5 = new SceneParameterInfo();
                sp5.setName("templateid");
                sp5.setValue(rs.getString("templateid"));
                SceneParameterInfo sp6 = new SceneParameterInfo();
                sp6.setName("url");
                String url = WorkflowApplication.getURL(ctx, rs.getString("bostype"));
                logger.info((Object)("******url******" + url));
                sp6.setValue(url);
                si.getParameters().add(sp);
                si.getParameters().add(sp1);
                si.getParameters().add(sp2);
                si.getParameters().add(sp3);
                si.getParameters().add(sp4);
                si.getParameters().add(sp5);
                si.getParameters().add(sp6);
                if (!StringUtils.isEmpty((String)rs.getString("description"))) {
                    si.setDescription(rs.getString("description"));
                }
                try {
                    ProcessDef pd = wfService.getProcessDefByDefineHashValue(rs.getString("fmd5hash"));
                    if (!StringUtils.isEmpty((String)pd.getProcessHeader().getDescription(ctx.getLocale()))) {
                        si.setDescription(pd.getProcessHeader().getDescription(ctx.getLocale()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                si.setKey1(rs.getString("billname").toLowerCase());
                si.setKey2(rs.getString("flowname").toLowerCase());
                try {
                    SceneFactory.getLocalInstance(ctx).save((CoreBaseInfo)si);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void refreshFlowName(Context ctx) throws BOSException {
        this.deleteSceneByType(ctx, EPSUtils.sceneType_flowName);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_eps_scene(FID,FNAME_L2,FSimpleName,FSceneTypeID,FNumber,FPluginClass) ");
        sql.append("select dbo.newbosid('37CE2A9D'),procdef.fname_l2, ");
        sql.append("procdef.fprocdefid,'UhGjxiSv1UKIlnqjYYpo3vl1l3c=','','com.kingdee.eas.cp.eps.scene.WorkflowScene' ");
        sql.append("from t_wfr_procdef procdef,(select fprocdefid,max(finnerversion) finnerversion ");
        sql.append("  from t_wfr_procdef group by fprocdefid) m ");
        sql.append("where procdef.fprocdefid = m.fprocdefid  ");
        sql.append("and procdef.finnerversion = m.finnerversion ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into T_EPS_SceneParameters(FID,FSeq,FParentID,FName,FValue) ");
        sql.append("select dbo.newbosid('797C498C'),1,sc.fid,'procdefID',sc.FSimpleName ");
        sql.append("from t_eps_scene sc ");
        sql.append("where FSceneTypeID = 'UhGjxiSv1UKIlnqjYYpo3vl1l3c=' ");
        sql.append("and not exists ( ");
        sql.append("\tselect fid from T_EPS_SceneParameters ");
        sql.append("    where fparentid = sc.fid ");
        sql.append("    and fname = 'procdefID'\t) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void refreshBillName(Context ctx) throws BOSException {
        this.deleteSceneByType(ctx, EPSUtils.sceneType_billName);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into t_eps_scene(FID,FNAME_L2,FSimpleName,FSceneTypeID,FNumber,FPluginClass) ");
        sql.append("select dbo.newbosid('37CE2A9D'),tp.fname_l2, ");
        sql.append("fm.fbostype,'2fXSkaQF4k+MKQbtvNKV+vl1l3c=', ");
        sql.append("'','com.kingdee.eas.cp.eps.scene.WorkflowScene' ");
        sql.append("from t_bas_template tp,t_bas_form fm ");
        sql.append("where tp.fformid = fm.fid ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into T_EPS_SceneParameters(FID,FSeq,FParentID,FName,FValue) ");
        sql.append("select dbo.newbosid('797C498C'),1,sc.fid,'billID',substring(dbo.newbosid(sc.FSimpleName ),23,6) ");
        sql.append("from t_eps_scene sc ");
        sql.append("where FSceneTypeID = '2fXSkaQF4k+MKQbtvNKV+vl1l3c=' ");
        sql.append("and not exists ( ");
        sql.append("\tselect fid from T_EPS_SceneParameters  ");
        sql.append("    where fparentid = sc.fid  ");
        sql.append("    and fname = 'billID') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into T_EPS_SceneParameters(FID,FSeq,FParentID,FName,FValue) ");
        sql.append("select dbo.newbosid('797C498C'),1,sc.fid,'bosType',sc.FSimpleName ");
        sql.append("from t_eps_scene sc ");
        sql.append("where FSceneTypeID = '2fXSkaQF4k+MKQbtvNKV+vl1l3c=' ");
        sql.append("and not exists ( ");
        sql.append("\tselect fid from T_EPS_SceneParameters  ");
        sql.append("    where fparentid = sc.fid  ");
        sql.append("    and fname = 'bosType') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.refreshCpBill(ctx);
    }

    private void deleteSceneByType(Context ctx, String sceneType) throws BOSException {
        DbUtil.execute((Context)ctx, (String)EPSUtils.delete_scene_by_type, (Object[])new Object[]{sceneType});
    }

    private void refreshCpBill(Context ctx) {
        IBriefViewTreeNode vtn = SubSystemUtils.getSubSystemByName((Context)ctx, (String)"com_kingdee_eas_base_botp", (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY});
        SceneCollection sc = new SceneCollection();
        this.convertBill2Scene(vtn, sc);
        int size = sc.size();
        for (int n = 0; n < size; ++n) {
            try {
                IScene service = SceneFactory.getLocalInstance(ctx);
                service.save((CoreBaseInfo)sc.get(n));
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    private void convertBill2Scene(IBriefViewTreeNode vtn, SceneCollection sc) {
        if (vtn == null || vtn.getPackageName() == null) {
            return;
        }
        if (vtn.getPackageName().indexOf(EPSUtils.CP_PACKAGE) < 0 && EPSUtils.CP_PACKAGE.indexOf(vtn.getPackageName()) < 0) {
            return;
        }
        if (vtn.getPackageName().indexOf("com.kingdee.eas.cp.wfm") > -1 || vtn.getPackageName().indexOf("com.kingdee.eas.cp.odm") > -1) {
            return;
        }
        if (vtn.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) {
            int size = vtn.getChildCount();
            for (int n = 0; n < size; ++n) {
                this.convertBill2Scene((IBriefViewTreeNode)vtn.getChildAt(n), sc);
            }
        } else if (vtn.getMetaDataType().equals((Object)MetaDataTypeList.ENTITY)) {
            sc.add(this.convertTreeNode2Scene(vtn));
        }
    }

    private SceneInfo convertTreeNode2Scene(IBriefViewTreeNode vtn) {
        SceneInfo si = new SceneInfo();
        SceneTypeInfo sceneType = new SceneTypeInfo();
        sceneType.setId(BOSUuid.read((String)EPSUtils.sceneType_billName));
        si.setSceneType(sceneType);
        si.setName(vtn.getAlias());
        si.setPluginClass(EPSUtils.flow_class);
        String tempid = BOSUuid.create((BOSObjectType)vtn.getBOType()).toString();
        SceneParameterInfo sp = new SceneParameterInfo();
        sp.setName("billID");
        sp.setValue(tempid.substring(23));
        SceneParameterInfo sp2 = new SceneParameterInfo();
        sp2.setName("bosType");
        sp2.setValue(vtn.getBOType().toString());
        si.getParameters().add(sp);
        si.getParameters().add(sp2);
        return si;
    }
}

