/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.cp.eps.ModuleInfo;
import com.kingdee.eas.cp.eps.app.BusinessDocument;
import com.kingdee.eas.cp.eps.plugin.IModulePlugin;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Time;
import org.apache.log4j.Logger;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;

public abstract class AbstractModulePlugin
implements IModulePlugin {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.eps.plugin.AbstractModulePlugin");
    protected Context ctx;
    protected String moduleNumber;
    protected String indexPath;
    protected String queryName;
    protected String queryPackage;
    protected Time lastUpdateTime;
    protected Time lastRebuildTime;

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setModule(ModuleInfo module) {
        this.lastUpdateTime = module.getLastRefreshTime();
        this.lastRebuildTime = module.getLastRebuildTime();
        this.moduleNumber = module.getNumber();
    }

    public String getModuleNumber() {
        return this.moduleNumber;
    }

    public void setModuleNumber(String moduleNumber) {
        this.moduleNumber = moduleNumber;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public String getQueryPackage() {
        return this.queryPackage;
    }

    public void setQueryPackage(String queryPackage) {
        this.queryPackage = queryPackage;
    }

    public abstract BusinessDocument getBusinessDocument(IRowSet var1);

    public IRowSet getData() {
        return this.getData(false);
    }

    public IRowSet getUpdateData() {
        return this.getData(true);
    }

    public IRowSet getData(boolean isUpdate) {
        try {
            IQueryExecutor executor = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)new MetaDataPK(this.queryPackage, this.queryName));
            EntityViewInfo entityViewInfo = this.getEntityView(isUpdate);
            if (entityViewInfo != null) {
                executor.setObjectView(entityViewInfo);
            }
            IRowSet rs = executor.executeQuery();
            return rs;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected EntityViewInfo getEntityView(boolean isUpdate) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (isUpdate && this.lastUpdateTime != null) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo("lastUpdateTime", (Object)this.lastUpdateTime, CompareType.GREATER_EQUALS);
            filterInfo.getFilterItems().add(filterItemInfo);
            entityViewInfo.setFilter(filterInfo);
            SorterItemInfo item = new SorterItemInfo("lastUpdateTime");
            entityViewInfo.getSorter().add(item);
        }
        return entityViewInfo;
    }

    public void setContex(Context ctx) {
        this.ctx = ctx;
    }

    public abstract String getURL(String var1);

    public abstract boolean hasPermission(String var1);

    public String parseToString(InputStream stream) {
        String result = "";
        try {
            TikaConfig tc = TikaConfig.getDefaultConfig();
            Tika tika = new Tika(tc);
            result = tika.parseToString(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String parseToString(File file) {
        String result = "";
        if (file == null) {
            return result;
        }
        try {
            TikaConfig tc = TikaConfig.getDefaultConfig();
            Tika tika = new Tika(tc);
            result = tika.parseToString(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TikaException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public BoAttchAssoCollection getAttach(String bizID) {
        IBoAttchAsso boAtt = null;
        BoAttchAssoCollection cols = null;
        if (!StringUtils.isEmpty((String)bizID)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("boID"));
            sic.add(new SelectorItemInfo("attachment.id"));
            sic.add(new SelectorItemInfo("attachment.name"));
            sic.add(new SelectorItemInfo("attachment.type"));
            sic.add(new SelectorItemInfo("attachment.file"));
            sic.add(new SelectorItemInfo("attachment.simpleName"));
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("boID", (Object)bizID, CompareType.EQUALS));
            filter.setMaskString(" #0 ");
            ev.setFilter(filter);
            ev.setSelector(sic);
            try {
                boAtt = BoAttchAssoFactory.getLocalInstance((Context)this.ctx);
                cols = boAtt.getBoAttchAssoCollection(ev);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cols;
    }
}

