/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.search;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.cp.eps.search.AbstractSearcher;
import com.kingdee.eas.cp.eps.search.SearchParameters;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AdrSearcher
extends AbstractSearcher {
    private static final String queryPackage = "com.kingdee.eas.cp.eps.app";
    private static final String queryName = "PersonInfoAdminQuery";

    public List getAllData(SearchParameters sp) {
        List result = super.getAllData(sp);
        result.addAll(this.getPersonal(sp));
        return result;
    }

    private List getPersonal(SearchParameters sp) {
        LinkedList<Map> pageList = new LinkedList<Map>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getPersonalSql());
            if (rs != null) {
                this.totalCount += rs.size();
                while (rs.next()) {
                    pageList.add(this.getPersonalResult(rs));
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pageList;
    }

    protected Map getPersonalResult(IRowSet rowSet) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("id", rowSet.getString("fid"));
            result.put("dtype", "adr");
            result.put("persontype", "person");
            result.put("name", rowSet.getString("fname"));
            result.put("position", rowSet.getString("fplace"));
            result.put("orgdisplayname", rowSet.getString("fcompany"));
            result.put("orgname", rowSet.getString("typename"));
            result.put("orgnumber", rowSet.getString("typeid"));
            result.put("cell", rowSet.getString("fmobliephone"));
            result.put("officePhone", rowSet.getString("fofficephone"));
            result.put("email", rowSet.getString("femail"));
            result.put("url", this.getPersonalUrl(rowSet));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String getPersonalUrl(IRowSet rowSet) {
        try {
            return "/easweb/cp/adr/viewAdrList.jsf?form=cpportal&viewID=" + URLEncoder.encode(rowSet.getString("fid"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getPersonalSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" ");
        sql.append("select ct.fid,ct.fsex,ct.fcompany,ct.fplace,ct.fofficephone,adrtype.fname_l2 as typename,ct.fadrtypeid as typeid, ");
        sql.append("case  when fsimplenamepingyin is null then N'0' else fsimplenamepingyin end as fakesort ,");
        sql.append("ct.fmobliephone,ct.femail,ct.fname_l2 as fname from t_adr_contact ct ");
        sql.append("left outer join T_ADR_ADRTYPE adrtype on ct.fadrtypeid = adrtype.fid ");
        sql.append("where ( ct.fname_l2 like '%" + this.queryKey + "%' ");
        sql.append("or ct.fcompany like '%" + this.queryKey + "%' ");
        sql.append("or ct.fplace like '%" + this.queryKey + "%' ");
        sql.append("or ct.fofficephone like '%" + this.queryKey + "%' ");
        sql.append("or ct.fmobliephone like '%" + this.queryKey + "%' ");
        sql.append("or ct.femail like '%" + this.queryKey + "%' ");
        sql.append("or ct.fsimplenamepingyin like '%" + this.queryKey + "%' )");
        if (this.sp != null && !StringUtils.isEmpty((String)this.sp.getOrg())) {
            if ("null".equals(this.sp.getOrg())) {
                sql.append(" and ct.fadrtypeid is null ");
            } else {
                sql.append(" and ct.fadrtypeid = '" + this.sp.getOrg() + "' ");
            }
        }
        sql.append("and ( ( ct.fuserid = '" + ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString() + "') ");
        sql.append("or exists ( ");
        sql.append("   select adrtype.fid from T_ADR_ADRTYPE adrtype where adrtype.fid = ct.fadrtypeid  ");
        sql.append("   and fpublicflg = 'allshare'   ) ");
        sql.append("or exists ( ");
        sql.append("   select adr4p.fid from T_ADR_ADRTYPE4PERSON adr4p where adr4p.fadrtypeid = ct.fadrtypeid  ");
        sql.append("   and adr4p.fpersonid = '" + ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString() + "'  ) ");
        sql.append("or exists ( ");
        sql.append("   select adr4a.fid from T_ADR_ADRTYPE4ADMIN adr4a where adr4a.fadrtypeid = ct.fadrtypeid  ");
        sql.append("   and adr4a.fadminid = '" + ContextUtil.getCurrentAdminUnit((Context)this.ctx).getId().toString() + "'  )) ");
        sql.append("order by fakesort, ct.fname_l2 ");
        return sql.toString();
    }

    protected IMetaDataPK getQueryPK() {
        return new MetaDataPK(queryPackage, queryName);
    }

    protected Map getRowResult(IRowSet rowSet) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            result.put("id", rowSet.getString("ID"));
            result.put("dtype", "adr");
            result.put("persontype", "company");
            result.put("name", rowSet.getString("NAME"));
            result.put("position", rowSet.getString("POSITION.NAME"));
            result.put("orgdisplayname", rowSet.getString("admin.displayName"));
            result.put("orgname", rowSet.getString("admin.name"));
            result.put("orgnumber", rowSet.getString("admin.name"));
            result.put("cell", rowSet.getString("cell"));
            result.put("officePhone", rowSet.getString("OFFICEPHONE"));
            result.put("email", rowSet.getString("email"));
            result.put("url", this.getUrl(rowSet));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String getUrl(IRowSet rowSet) {
        try {
            return "/easweb/cp/adr/commonAdrList.jsf?viewID=" + URLEncoder.encode(rowSet.getString("ID"), "utf-8") + "&cuID=" + URLEncoder.encode(rowSet.getString("CU.ID"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public FilterInfo getFilterInfo() {
        StringBuffer sb = new StringBuffer("");
        sb.append("((");
        sb.append("name");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey + "");
        sb.append("%");
        sb.append("'");
        sb.append(" ");
        sb.append("or");
        sb.append(" ");
        sb.append("fullNamePingYin");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey.toLowerCase() + "");
        sb.append("%");
        sb.append("'");
        sb.append(" ");
        sb.append("or");
        sb.append(" ");
        sb.append("simpleNamePingYin");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey.toLowerCase() + "");
        sb.append("%");
        sb.append("'");
        sb.append(")");
        if (sb.toString().length() > 0) {
            sb.append(" or");
        }
        sb.append(" (( pcm.officePhone like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(" or ( pcm.homePhone like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(" or ( pcm.mobile like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(" or ( pcm.backupMobile like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(" or ( pcm.backupOfficePhone like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(" or ( pcm.backupHomePhone like ");
        sb.append(" '%" + this.queryKey + "%' )");
        sb.append(")");
        if (sb.toString().length() > 0) {
            sb.append(" or");
        }
        sb.append("(( pcm.email like ");
        sb.append("'%");
        sb.append("" + this.queryKey + "");
        sb.append("%'");
        sb.append(" )");
        sb.append("or ( pcm.backupEMail like");
        sb.append("'%");
        sb.append("" + this.queryKey + "");
        sb.append("%'");
        sb.append(" ))");
        System.out.println("--");
        System.out.println(sb.toString());
        System.out.println("::");
        if (sb.toString().length() > 0) {
            sb.append(" or");
        }
        sb.append(" position.name");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey + "");
        sb.append("%");
        sb.append("'");
        if (sb.toString().length() > 0) {
            sb.append(" or");
        }
        sb.append(" number");
        sb.append(" ");
        sb.append("like");
        sb.append(" ");
        sb.append("'");
        sb.append("%");
        sb.append("" + this.queryKey + "");
        sb.append("%");
        sb.append("'");
        sb.append(")  ");
        if (this.sp != null && !StringUtils.isEmpty((String)this.sp.getOrg())) {
            sb.append(" and ADMIN.NAME = '" + this.sp.getOrg() + "' ");
        }
        String as = sb.toString();
        FilterInfo filterInfo = null;
        try {
            filterInfo = new FilterInfo(as);
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        return filterInfo;
    }
}

