/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class EPSUtils {
    public static String CONFIG_EXCEPTION = "CONFIG_EXCEPTION";
    public static String sceneType_flowState = "Amk3GeG94kKqPMlfQAkxzPl1l3c=";
    public static String sceneType_flowName = "UhGjxiSv1UKIlnqjYYpo3vl1l3c=";
    public static String sceneType_person = "egsx6koknEqhsa9SA0iNp/l1l3c=";
    public static String sceneType_billName = "2fXSkaQF4k+MKQbtvNKV+vl1l3c=";
    public static String sceneType_personalAdr = "egsx6koknEqhsb0SA0iNp/l1l3c=";
    public static String CP_PACKAGE = "com.kingdee.eas.cp";
    public static String flow_class = "com.kingdee.eas.cp.eps.scene.WorkflowScene";
    public static String delete_scene_by_type = "delete from t_eps_scene where FSceneTypeID = ? ";
    public static final int DB_TYPE_SQLSERVER = 0;
    public static final int DB_TYPE_ORACLE = 2;
    public static final int DB_TYPE_DB2 = 1;

    public static boolean canEdit(String bizPackage) {
        boolean result = false;
        if (!StringUtils.isEmpty((String)bizPackage) && (bizPackage.startsWith("com.kingdee.eas.cp.bc") || bizPackage.startsWith("com.kingdee.eas.cp.arcm") || bizPackage.startsWith("com.kingdee.eas.cp.carm") || bizPackage.startsWith("com.kingdee.eas.cp.mrm") || bizPackage.startsWith("com.kingdee.eas.cp.wp") || bizPackage.startsWith("com.kingdee.eas.cp.wfm") || bizPackage.startsWith("com.kingdee.eas.cp.odm") || bizPackage.startsWith("com.kingdee.eas.cp.cpmm"))) {
            result = true;
        }
        return result;
    }

    public static String getModuleName(String bizPackage) {
        String moduleName = "";
        if (!StringUtils.isEmpty((String)bizPackage)) {
            if (bizPackage.startsWith("com.kingdee.eas.cp.bc")) {
                moduleName = "\u8d39\u7528\u62a5\u9500";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.eip.cm")) {
                moduleName = "\u5185\u5bb9\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.arcm")) {
                moduleName = "\u516c\u6587\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.carm")) {
                moduleName = "\u8f66\u8f86\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.mrm")) {
                moduleName = "\u4f1a\u8bae\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.wp")) {
                moduleName = "\u5de5\u4f5c\u8ba1\u5212";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.adr")) {
                moduleName = "\u901a\u8baf\u5f55";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.dm")) {
                moduleName = "\u6587\u6863\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.ap")) {
                moduleName = "\u884c\u653f\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.wfm")) {
                moduleName = "\u6d41\u7a0b\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.ov")) {
                moduleName = "\u7f51\u7edc\u8c03\u67e5";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.base")) {
                moduleName = "\u534f\u540c\u57fa\u7840";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.pem")) {
                moduleName = "\u4fe1\u4eff\u7ba1\u7406";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.odm")) {
                moduleName = "\u7535\u5b50\u516c\u6587";
            } else if (bizPackage.startsWith("com.kingdee.eas.cp.cpmm")) {
                moduleName = "\u7269\u54c1\u7ba1\u7406";
            }
        }
        return moduleName;
    }

    public static String getIndexDbPath(String dbCenterName, String moduleNumber) {
        try {
            StringBuffer bf = new StringBuffer();
            bf.append(System.getProperty("EAS_HOME"));
            bf.append(CtrlUtil.File.FILE_SEPARATOR);
            bf.append("server");
            bf.append(CtrlUtil.File.FILE_SEPARATOR);
            bf.append("properties");
            bf.append(CtrlUtil.File.FILE_SEPARATOR);
            bf.append("workspace");
            bf.append(CtrlUtil.File.FILE_SEPARATOR);
            bf.append("cp");
            bf.append(CtrlUtil.File.FILE_SEPARATOR);
            bf.append("index");
            String baseIndexFold = bf.toString();
            String dbCenterIndexFold = baseIndexFold + CtrlUtil.File.FILE_SEPARATOR + dbCenterName + CtrlUtil.File.FILE_SEPARATOR + moduleNumber;
            return dbCenterIndexFold;
        }
        catch (Exception e0) {
            return "/home/index/cp" + CtrlUtil.File.FILE_SEPARATOR + dbCenterName + CtrlUtil.File.FILE_SEPARATOR + moduleNumber;
        }
    }

    public static int getDbType(Context ctx) {
        int dbType = -1;
        if (ctx != null) {
            DataCenterManager dc = new DataCenterManager(ctx);
            ArrayList dcInfos = dc.getDCList();
            String dcNumber = ctx.getAIS();
            int size = dcInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!((DCInfo)dcInfos.get(i)).getNumber().equals(dcNumber)) continue;
                switch (((DCInfo)dcInfos.get(i)).getDBType()) {
                    case 0: {
                        dbType = 0;
                        break;
                    }
                    case 2: {
                        dbType = 2;
                        break;
                    }
                    case 1: {
                        dbType = 1;
                    }
                }
                break;
            }
        }
        return dbType;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException(CONFIG_EXCEPTION, (Throwable)exc);
        }
        try {
            statement = conn.createStatement();
            if (EPSUtils.getDbType(ctx) == 2) {
                try {
                    statement.execute("/*dialect*/alter session set nls_sort = SCHINESE_PINYIN_M");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }
}

