/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.utils;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.ui.UIObjectCtrl;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.store.util.StoreUtils;
import com.kingdee.util.StringUtils;
import java.util.Map;
import org.apache.log4j.Logger;

public class WorkflowApplication {
    private static Logger logger = Logger.getLogger((String)WorkflowApplication.class.getName());

    public static String getURL(Context ctx, String bosType) {
        String url = "";
        try {
            String[] dynamicEditUrl;
            String tempid = BOSUuid.create((String)bosType).toString();
            url = StoreUtils.getWebUIurl((String)tempid, (Context)ctx);
            if (StringUtils.isEmpty((String)url)) {
                url = WorkflowApplication._getURL(ctx, bosType);
            }
            if ((dynamicEditUrl = WorkflowApplication.getDynamicEditURLByBillId(ctx, bosType)) != null && dynamicEditUrl.length == 2) {
                url = dynamicEditUrl[0];
            }
            if (StringUtils.isEmpty((String)url)) {
                url = "/servlet/BillServlet";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public static String[] getDynamicEditURLByBillId(Context ctx, String bosType) {
        BOSObjectType type = BOSObjectType.create((String)bosType);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        if (vo != null) {
            String v = vo.getExtendedProperty("isDynamic");
            String editpk = vo.getExtendedProperty("webEditUI");
            if ("true".equalsIgnoreCase(v)) {
                return new String[]{"/servlet/BillServlet", editpk};
            }
        }
        return null;
    }

    private static String _getURL(Context ctx, String bosType) {
        String result = "";
        BOSObjectType type = BOSObjectType.create((String)bosType);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        String className = vo.getExtendedProperty("editUI");
        try {
            if (className != null) {
                String name = className.substring(className.lastIndexOf(".") + 1, className.length());
                UIObjectCtrl ctrl = new UIObjectCtrl(ctx);
                String bizPackgeName = className.substring(0, className.lastIndexOf("."));
                MetaDataPK metaPK = new MetaDataPK(bizPackgeName, name);
                UIObjectInfo ui = ctrl.getValue((IMetaDataPK)metaPK);
                Map map = ui.getExtendedProperties();
                if (map != null && map.size() > 0 && StringUtils.isEmpty((String)(result = (String)map.get("url")))) {
                    logger.warn((Object)("UI " + className + "URL"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("getURL failed!" + className), (Throwable)e);
        }
        return result;
    }
}

