/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.fts.FtsException;
import com.kingdee.eas.cp.eip.fts.FullTextSearchResourceFacadeFactory;
import com.kingdee.eas.cp.eip.fts.FullTextSearchResourceFactory;
import com.kingdee.eas.cp.eip.fts.FullTextSearchResourceInfo;
import com.kingdee.eas.cp.eip.fts.IFullTextSearchResource;
import com.kingdee.eas.cp.eip.fts.IFullTextSearchResourceFacade;
import com.kingdee.eas.cp.eip.fts.app.IndexManager;
import com.kingdee.eas.cp.eip.fts.business.BusinessResource;
import com.kingdee.eas.cp.eip.fts.utils.FtsContext;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class BusinessIndexManager {
    protected final Logger log = Logger.getLogger(this.getClass());
    private List businessResources = new ArrayList();
    private Context context;
    private boolean isRebulidIndex = false;
    private static Object lock = new Object();
    private static boolean isLock = false;

    public BusinessIndexManager(Context context, boolean flag) throws EASBizException, BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException, ParserConfigurationException, SAXException, IOException {
        this.context = context;
        this.init(context, flag);
        this.isRebulidIndex = flag;
    }

    private void init(Context context, boolean flag) throws BOSException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        IFullTextSearchResource iFullTextSearchResource = FullTextSearchResourceFactory.getLocalInstance(context);
        this.log.debug((Object)"%%%%%%%%new init fts.............");
        if (!flag) {
            CoreBaseCollection resourceCollection = iFullTextSearchResource.getCollection();
            if (resourceCollection.size() > 0) {
                Iterator iterator = resourceCollection.iterator();
                while (iterator.hasNext()) {
                    FullTextSearchResourceInfo resourceInfo = (FullTextSearchResourceInfo)iterator.next();
                    if (Utils.NOTINDEX.equals(resourceInfo.getIsDel())) continue;
                    BusinessResource businessResource = null;
                    try {
                        this.log.debug((Object)("begin get class,the classname is:" + resourceInfo.getClassname()));
                        businessResource = (BusinessResource)Class.forName(resourceInfo.getClassname()).newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        this.log.error((Object)"\u7039\u70b5\u5e47\u7eeb\u8bb3\u7b09\u701b\u6a3a\u6e6a\u951b\u5c7c\u7b09\u9473\u85c9\u7f13\u7ed4\u5b2a\ue1ee\u6434\u65c2\u6b91\u7ef1\u3220\u7d29", (Throwable)e);
                    }
                    if (businessResource == null) continue;
                    businessResource.setUuid(resourceInfo.getId());
                    businessResource.setLastRunTime(resourceInfo.getLastRunTime());
                    BOSObjectType obj = null;
                    if (resourceInfo.getType() != null) {
                        obj = resourceInfo.getBOSType();
                    }
                    businessResource.setBosType(obj);
                    this.businessResources.add(businessResource);
                    this.log.debug((Object)("%%%%%%%%fts begin.............,businessResource:" + businessResource));
                }
            }
        } else {
            IFullTextSearchResourceFacade facade = FullTextSearchResourceFacadeFactory.getLocalInstance(context);
            facade.init();
            this.businessResources = new ArrayList();
            this.init(context, false);
        }
    }

    public List getBusinessResources() {
        return this.businessResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexBusinessResources() throws EASBizException {
        if (isLock) {
            throw new FtsException(FtsException.HASINDEXING);
        }
        Object object = lock;
        synchronized (object) {
            try {
                isLock = true;
                List list = this.getBusinessResources();
                this.log.debug((Object)("%%%%%%%%new update index.............,List:" + list));
                IndexManager indexManager = new IndexManager();
                if (this.isRebulidIndex) {
                    String dbCenterIndexFold = Utils.getIndexDbPath(this.getDbCenterName());
                    indexManager.initIndexWriter(dbCenterIndexFold);
                    this.log.debug((Object)("%%%%%%%%new update index.............,dbCenterIndexFold:" + dbCenterIndexFold));
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    BusinessResource businessResource = (BusinessResource)iterator.next();
                    FtsContext ftCtx = new FtsContext();
                    ftCtx.addResource(businessResource);
                    this.log.debug((Object)("%%%%%%%%new update index.............,businessResource:" + businessResource));
                    while (ftCtx.hasResource()) {
                        businessResource = ftCtx.consumeResource();
                        List datas = businessResource.getData(this.context, ftCtx);
                        if (datas == null || datas.size() == 0) continue;
                        this.log.debug((Object)("%%%%%%%%new update index.............,datas size" + datas.size()));
                        try {
                            Timestamp timeStamp = new Timestamp(System.currentTimeMillis());
                            indexManager.indexBusinessData(datas, this.getDbCenterName());
                            businessResource.updateLastRunTime(this.context, timeStamp);
                        }
                        catch (IOException e) {
                            this.log.error((Object)"\u7ef1\u3220\u7d29\u93c1\u7248\u5d41\u9350\u6b0f\u53c6\u6fb6\u8fab\u89e6!");
                        }
                        catch (EASBizException e) {
                            this.log.warn((Object)"\u6dc7\ue1bd\u657c\u6769\u612f\ue511\u93c3\u5815\u68ff\u9351\u6d2a\u654a!");
                        }
                        catch (BOSException e) {
                            this.log.warn((Object)"\u6dc7\ue1bd\u657c\u6769\u612f\ue511\u93c3\u5815\u68ff\u9351\u6d2a\u654a");
                        }
                    }
                }
                indexManager.optimize(this.getDbCenterName());
            }
            catch (Exception e) {
                this.log.error((Object)"", (Throwable)e);
            }
            finally {
                isLock = false;
            }
        }
    }

    private String getDbCenterName() {
        return this.context.getAIS();
    }
}

