/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.app;

import com.kingdee.eas.cp.eip.fts.app.DocumentFragment;
import com.kingdee.eas.cp.eip.fts.app.FragmentQueue;
import com.kingdee.eas.cp.eip.fts.app.I_TermHighlighter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.analysis.Token;
import org.apache.lucene1.analysis.TokenStream;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.search.BooleanClause;
import org.apache.lucene1.search.BooleanQuery;
import org.apache.lucene1.search.PhraseQuery;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.TermQuery;

public final class HighlightFinder {
    private Analyzer m_analyzer;
    private I_TermHighlighter m_highlighter;
    private Query m_query;
    private HashSet m_terms = new HashSet();
    private int score;

    public HighlightFinder(I_TermHighlighter highlighter, Query query, Analyzer analyzer) throws IOException {
        this.m_highlighter = highlighter;
        this.m_query = query;
        this.m_analyzer = analyzer;
        HighlightFinder.getTerms(this.m_query, this.m_terms, false);
    }

    public static void getTerms(Query query, HashSet terms, boolean prohibited) throws IOException {
        if (query instanceof BooleanQuery) {
            HighlightFinder.getTermsFromBooleanQuery((BooleanQuery)query, terms, prohibited);
        } else if (query instanceof PhraseQuery) {
            HighlightFinder.getTermsFromPhraseQuery((PhraseQuery)query, terms);
        } else if (query instanceof TermQuery) {
            HighlightFinder.getTermsFromTermQuery((TermQuery)query, terms);
        }
    }

    private static void getTermsFromBooleanQuery(BooleanQuery query, HashSet terms, boolean prohibited) throws IOException {
        BooleanClause[] queryClauses = query.getClauses();
        for (int i = 0; i < queryClauses.length; ++i) {
            if (!prohibited && queryClauses[i].prohibited) continue;
            HighlightFinder.getTerms(queryClauses[i].query, terms, prohibited);
        }
    }

    private static void getTermsFromPhraseQuery(PhraseQuery query, HashSet terms) {
        Term[] queryTerms = query.getTerms();
        for (int i = 0; i < queryTerms.length; ++i) {
            terms.add(HighlightFinder.getTermsFromTerm(queryTerms[i]));
        }
    }

    private static String getTermsFromTerm(Term term) {
        return term.text().toLowerCase();
    }

    private static void getTermsFromTermQuery(TermQuery query, HashSet terms) {
        terms.add(HighlightFinder.getTermsFromTerm(query.getTerm()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBestFragments(String text, int fragmentSize, int maxNumFragments) throws IOException {
        String[] stringArray;
        block16: {
            StringBuffer newText = new StringBuffer();
            TokenStream stream = null;
            ArrayList<DocumentFragment> docFrags = new ArrayList<DocumentFragment>();
            DocumentFragment currentFrag = new DocumentFragment(newText.length(), docFrags.size());
            docFrags.add(currentFrag);
            FragmentQueue fragQueue = new FragmentQueue(maxNumFragments + 1);
            try {
                Token token;
                int lastEndOffset = 0;
                int len = 0;
                stream = this.m_analyzer.tokenStream(null, new StringReader(text));
                while ((token = stream.next()) != null) {
                    int startOffset = token.startOffset();
                    int endOffset = token.endOffset();
                    String tokenText = text.substring(startOffset, endOffset);
                    if (startOffset > lastEndOffset) {
                        newText.append(" ");
                    }
                    if (this.m_terms.contains(token.termText())) {
                        newText.append(this.m_highlighter.highlightTerm(tokenText));
                        len += this.m_highlighter.highlightLength();
                        currentFrag.addTerm(token.termText());
                    } else if (tokenText.length() > fragmentSize / 2) {
                        newText.append(tokenText.substring(0, fragmentSize / 2));
                        newText.append(" ");
                    } else {
                        newText.append(tokenText);
                    }
                    if (newText.length() >= len + fragmentSize * (docFrags.size() + 1)) {
                        currentFrag.m_textEndPos = newText.length();
                        currentFrag = new DocumentFragment(newText.length(), docFrags.size());
                        docFrags.add(currentFrag);
                    }
                    lastEndOffset = endOffset;
                }
                if (lastEndOffset < text.length()) {
                    newText.append(text.substring(lastEndOffset));
                }
                currentFrag.m_textEndPos = newText.length();
                int minScore = 0;
                int maxScore = 0;
                Iterator i = docFrags.iterator();
                while (i.hasNext()) {
                    currentFrag = (DocumentFragment)i.next();
                    if (currentFrag.getScore() > maxScore) {
                        maxScore = currentFrag.getScore();
                    }
                    if (currentFrag.getScore() < minScore) continue;
                    fragQueue.put(currentFrag);
                    if (fragQueue.size() <= maxNumFragments) continue;
                    fragQueue.pop();
                    minScore = ((DocumentFragment)fragQueue.top()).getScore();
                }
                this.setScore(maxScore);
                String[] fragText = new String[fragQueue.size()];
                for (int i2 = fragText.length - 1; i2 >= 0; --i2) {
                    DocumentFragment frag = (DocumentFragment)fragQueue.pop();
                    fragText[i2] = newText.substring(frag.m_textStartPos, frag.m_textEndPos);
                }
                stringArray = fragText;
                Object var21_21 = null;
                if (stream == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var21_22 = null;
                    if (stream == null) break block17;
                    try {
                        stream.close();
                    }
                    catch (Exception e) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return stringArray;
    }

    public String getBestFragments(String text, int fragmentSize, int maxNumFragments, String separator) throws IOException {
        String[] sections = this.getBestFragments(text, fragmentSize, maxNumFragments);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sections.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(sections[i]);
        }
        return result.toString();
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }
}

