/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.app;

import com.kingdee.eas.cp.eip.fts.app.Search;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.lucene1.search.Sort;

public class SearchParameters {
    private boolean m_calculateCategories;
    private List m_categories;
    private List m_fields;
    private String m_query;
    private Sort m_sort;

    public SearchParameters() {
    }

    public SearchParameters(String query, List fields, List categories, boolean calculateCategories, Sort sort) {
        this.m_query = query;
        this.m_fields = fields;
        this.m_categories = categories;
        this.m_calculateCategories = calculateCategories;
        this.m_sort = sort;
    }

    public SearchParameters(String query, List fields, List categories) {
        this.m_query = query;
        this.m_fields = fields;
        this.m_categories = categories;
        this.m_calculateCategories = false;
        this.m_sort = null;
    }

    public boolean isCalculateCategories() {
        return this.m_calculateCategories;
    }

    public List getCategories() {
        return this.m_categories;
    }

    public List getFields() {
        return this.m_fields;
    }

    public String getQuery() {
        return this.m_query;
    }

    public Sort getSort() {
        return this.m_sort;
    }

    public SearchParameters restrict(SearchParameters restriction) {
        StringBuffer query = new StringBuffer(256);
        if (this.getQuery() != null) {
            query.append("+(");
            query.append(this.getQuery());
            query.append(")");
        }
        if (restriction.getQuery() != null) {
            query.append(" +(");
            query.append(restriction.getQuery());
            query.append(")");
        }
        List fields = null;
        fields = this.m_fields != null && this.m_fields.size() > 0 ? (restriction.getFields() != null && restriction.getFields().size() > 0 ? ListUtils.intersection((List)this.m_fields, (List)restriction.getFields()) : this.m_fields) : restriction.getFields();
        List categories = null;
        categories = this.m_categories != null && this.m_categories.size() > 0 ? (restriction.getCategories() != null && restriction.getCategories().size() > 0 ? ListUtils.intersection((List)this.m_categories, (List)restriction.getCategories()) : this.m_categories) : restriction.getCategories();
        return new SearchParameters(query.toString(), fields, categories, this.m_calculateCategories, this.m_sort);
    }

    public String toString() {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("query:[");
        result.append(this.m_query);
        result.append("] ");
        if (this.m_fields != null && this.m_fields.size() > 0) {
            result.append("fields:[");
            for (i = 0; i < this.m_fields.size(); ++i) {
                result.append(this.m_fields.get(i));
                if (i + 1 >= this.m_fields.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_categories != null && this.m_categories.size() > 0) {
            result.append("categories:[");
            for (i = 0; i < this.m_categories.size(); ++i) {
                result.append(this.m_categories.get(i));
                if (i + 1 >= this.m_categories.size()) continue;
                result.append(", ");
            }
            result.append("] ");
        }
        if (this.m_calculateCategories) {
            result.append("calculate-categories ");
        }
        result.append("sort:[");
        if (this.m_sort == Search.SORT_DEFAULT) {
            result.append("default");
        } else if (this.m_sort == Search.SORT_TITLE) {
            result.append("title");
        } else if (this.m_sort == Search.SORT_DATE_CREATED) {
            result.append("createTime");
        } else if (this.m_sort == Search.SORT_DATE_LASTMODIFIED) {
            result.append("lastUpdateTime");
        } else {
            result.append("unknown");
        }
        result.append("]");
        return result.toString();
    }

    public void setM_calculateCategories(boolean categories) {
        this.m_calculateCategories = categories;
    }

    public void setM_categories(List m_categories) {
        this.m_categories = m_categories;
    }

    public void setM_fields(List m_fields) {
        this.m_fields = m_fields;
    }

    public void setM_query(String m_query) {
        this.m_query = m_query;
    }

    public void setM_sort(Sort m_sort) {
        this.m_sort = m_sort;
    }
}

