/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.documents;

import com.kingdee.eas.cp.eip.fts.documents.I_ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;

public abstract class A_TextExtractor
implements I_TextExtractor {
    protected byte[] m_inputBuffer;

    public I_ExtractionResult extractText(byte[] content) throws Exception {
        return this.extractText(content, null);
    }

    public I_ExtractionResult extractText(byte[] content, String encoding) throws Exception {
        this.m_inputBuffer = content;
        return this.extractText(new ByteArrayInputStream(content), encoding);
    }

    public I_ExtractionResult extractText(InputStream in) throws Exception {
        return this.extractText(in, null);
    }

    public I_ExtractionResult extractText(InputStream in, String encoding) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        int c = 0;
        try {
            while ((c = in.read()) >= 0) {
                out.write(c);
            }
        }
        catch (IOException e) {
        }
        return this.extractText(out.toByteArray(), encoding);
    }

    public InputStream getStreamCopy(InputStream in) throws IOException {
        if (this.m_inputBuffer != null) {
            return new ByteArrayInputStream(this.m_inputBuffer);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        int c = 0;
        while ((c = in.read()) >= 0) {
            out.write(c);
        }
        this.m_inputBuffer = out.toByteArray();
        return new ByteArrayInputStream(this.m_inputBuffer);
    }

    protected String removeControlChars(String content) {
        if (StringUtils.isBlank((String)content)) {
            return "";
        }
        char[] chars = content.toCharArray();
        StringBuffer result = new StringBuffer(chars.length);
        boolean wasUnwanted = false;
        block4: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            int type = Character.getType(ch);
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: 
                case 12: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 26: 
                case 29: 
                case 30: {
                    result.append(ch);
                    wasUnwanted = false;
                    continue block4;
                }
                case 13: {
                    result.append('\n');
                    wasUnwanted = true;
                    continue block4;
                }
                default: {
                    if (wasUnwanted) continue block4;
                    result.append('\n');
                    wasUnwanted = true;
                }
            }
        }
        return result.toString();
    }
}

