/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.fts.documents;

import com.kingdee.eas.cp.eip.fts.documents.A_TextExtractorMsOfficeBase;
import com.kingdee.eas.cp.eip.fts.documents.ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_ExtractionResult;
import com.kingdee.eas.cp.eip.fts.documents.I_TextExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.poi1.hssf.usermodel.HSSFCell;
import org.apache.poi1.hssf.usermodel.HSSFRow;
import org.apache.poi1.hssf.usermodel.HSSFSheet;
import org.apache.poi1.hssf.usermodel.HSSFWorkbook;

public class ExtractorMsExcel
extends A_TextExtractorMsOfficeBase {
    private static final ExtractorMsExcel INSTANCE = new ExtractorMsExcel();

    private ExtractorMsExcel() {
    }

    public static I_TextExtractor getExtractor() {
        return INSTANCE;
    }

    public I_ExtractionResult extractText(InputStream in, String encoding) throws Exception {
        String result = this.extractTableContent(this.getStreamCopy(in));
        result = this.removeControlChars(result);
        return new ExtractionResult(result);
    }

    protected String extractTableContent(InputStream in) throws IOException {
        HSSFWorkbook excelWb = new HSSFWorkbook(in);
        StringBuffer result = new StringBuffer(4096);
        int numberOfSheets = excelWb.getNumberOfSheets();
        for (int i = 0; i < numberOfSheets; ++i) {
            HSSFSheet sheet = excelWb.getSheetAt(i);
            int numberOfRows = sheet.getPhysicalNumberOfRows();
            if (numberOfRows <= 0) continue;
            if (StringUtils.isNotEmpty((String)excelWb.getSheetName(i))) {
                if (i > 0) {
                    result.append("\n\n");
                }
                result.append(excelWb.getSheetName(i).trim());
                result.append(":\n\n");
            }
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                HSSFRow row = (HSSFRow)rowIt.next();
                if (row == null) continue;
                boolean hasContent = false;
                Iterator it = row.cellIterator();
                while (it.hasNext()) {
                    HSSFCell cell = (HSSFCell)it.next();
                    String text = null;
                    try {
                        switch (cell.getCellType()) {
                            case 3: 
                            case 5: {
                                break;
                            }
                            case 0: {
                                text = Double.toString(cell.getNumericCellValue());
                                break;
                            }
                            case 4: {
                                text = Boolean.toString(cell.getBooleanCellValue());
                                break;
                            }
                            default: {
                                text = cell.getStringCellValue();
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!StringUtils.isNotEmpty(text)) continue;
                    result.append(text.trim());
                    result.append(' ');
                    hasContent = true;
                }
                if (!hasContent) continue;
                result.append('\n');
            }
        }
        return result.toString();
    }
}

