/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.analysis.standard;

import java.io.Reader;
import java.util.Set;
import org.apache.lucene1.analysis.Analyzer;
import org.apache.lucene1.analysis.LowerCaseFilter;
import org.apache.lucene1.analysis.StopAnalyzer;
import org.apache.lucene1.analysis.StopFilter;
import org.apache.lucene1.analysis.TokenStream;
import org.apache.lucene1.analysis.standard.StandardFilter;
import org.apache.lucene1.analysis.standard.StandardTokenizer;

public class StandardAnalyzer
extends Analyzer {
    private Set stopSet;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;

    public StandardAnalyzer() {
        this(STOP_WORDS);
    }

    public StandardAnalyzer(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet(stopWords);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new StandardTokenizer(reader);
        result = new StandardFilter(result);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopSet);
        return result;
    }
}

