/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene1.search;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.lucene1.document.Document;
import org.apache.lucene1.index.Term;
import org.apache.lucene1.search.Explanation;
import org.apache.lucene1.search.Filter;
import org.apache.lucene1.search.HitCollector;
import org.apache.lucene1.search.IndexSearcher;
import org.apache.lucene1.search.Query;
import org.apache.lucene1.search.Searchable;
import org.apache.lucene1.search.Sort;
import org.apache.lucene1.search.TopDocs;
import org.apache.lucene1.search.TopFieldDocs;

public class RemoteSearchable
extends UnicastRemoteObject
implements Searchable {
    private Searchable local;

    public RemoteSearchable(Searchable local) throws RemoteException {
        this.local = local;
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        this.local.search(query, filter, results);
    }

    public void close() throws IOException {
        this.local.close();
    }

    public int docFreq(Term term) throws IOException {
        return this.local.docFreq(term);
    }

    public int maxDoc() throws IOException {
        return this.local.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.local.search(query, filter, n);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.local.search(query, filter, n, sort);
    }

    public Document doc(int i) throws IOException {
        return this.local.doc(i);
    }

    public Query rewrite(Query original) throws IOException {
        return this.local.rewrite(original);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.local.explain(query, doc);
    }

    public static void main(String[] args) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        IndexSearcher local = new IndexSearcher(args[0]);
        RemoteSearchable impl = new RemoteSearchable(local);
        Naming.rebind("//localhost/Searchable", impl);
    }
}

